/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.util;

import java.util.ArrayList;

public class ArgsParser {
    private String[] _args;
    private String _shortOpts;
    private String[] _longOpts;
    private String _longOpt;
    private ArrayList<String> _optList;
    private ArrayList<String> _valList;
    private ArrayList<String> _argList;

    public ArgsParser(String[] args, String shortOpts) throws OptionException {
        this._args = args;
        this._shortOpts = shortOpts;
        this._longOpts = new String[0];
        this.init();
    }

    public ArgsParser(String[] args, String shortOpts, String[] longOpts) throws OptionException {
        this._args = args;
        this._shortOpts = shortOpts;
        this._longOpts = longOpts;
        this.init();
    }

    public String[] getOptions() {
        return ArgsParser.getStrings(this._optList);
    }

    public String[] getValues() {
        return ArgsParser.getStrings(this._valList);
    }

    public String[] getOtherArgs() {
        return ArgsParser.getStrings(this._argList);
    }

    public static boolean toBoolean(String s) throws OptionException {
        if ((s = s.toLowerCase()).equals("true")) {
            return true;
        }
        if (s.equals("false")) {
            return false;
        }
        throw new OptionException("the value " + s + " is not a valid boolean");
    }

    public static double toDouble(String s) throws OptionException {
        try {
            return Double.valueOf(s);
        }
        catch (NumberFormatException e) {
            throw new OptionException("the value " + s + " is not a valid double");
        }
    }

    public static float toFloat(String s) throws OptionException {
        try {
            return Float.valueOf(s).floatValue();
        }
        catch (NumberFormatException e) {
            throw new OptionException("the value " + s + " is not a valid float");
        }
    }

    public static int toInt(String s) throws OptionException {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            throw new OptionException("the value " + s + " is not a valid int");
        }
    }

    public static long toLong(String s) throws OptionException {
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            throw new OptionException("the value " + s + " is not a valid long");
        }
    }

    private void init() throws OptionException {
        String arg;
        int n = this._args.length;
        this._optList = new ArrayList(n);
        this._valList = new ArrayList(n);
        this._argList = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this._argList.add(this._args[i]);
        }
        while (!this._argList.isEmpty() && (arg = this._argList.get(0)).charAt(0) == '-' && !arg.equals("-")) {
            this._argList.remove(0);
            if (arg.equals("--")) break;
            if (arg.charAt(1) == '-') {
                this.doLongOption(arg);
                continue;
            }
            this.doShortOption(arg);
        }
    }

    private void doShortOption(String arg) throws OptionException {
        String argString = arg.substring(1);
        while (!argString.equals("")) {
            char opt = argString.charAt(0);
            argString = argString.substring(1);
            String val = "";
            if (this.shortOptionHasValue(opt)) {
                if (argString.equals("")) {
                    if (this._argList.isEmpty()) {
                        throw new OptionException("option -" + opt + " requires a value");
                    }
                    argString = this._argList.remove(0);
                }
                val = argString;
                argString = "";
            }
            this._optList.add("-" + opt);
            this._valList.add(val);
        }
    }

    private boolean shortOptionHasValue(char opt) throws OptionException {
        for (int i = 0; i < this._shortOpts.length(); ++i) {
            if (opt != this._shortOpts.charAt(i) || opt == ':') continue;
            return i + 1 < this._shortOpts.length() && this._shortOpts.charAt(i + 1) == ':';
        }
        throw new OptionException("option -" + opt + " not recognized");
    }

    private void doLongOption(String arg) throws OptionException {
        String argString;
        String opt = argString = arg.substring(2);
        String val = null;
        int i = argString.indexOf(61);
        if (i >= 0) {
            opt = argString.substring(0, i);
            val = i + 1 < argString.length() ? argString.substring(i + 1) : "";
        }
        boolean hasValue = this.longOptionHasValue(opt);
        opt = this._longOpt;
        if (hasValue) {
            if (val == null) {
                if (this._argList.isEmpty()) {
                    throw new OptionException("option --" + opt + " requires a value");
                }
                val = this._argList.remove(0);
            }
        } else if (val != null) {
            throw new OptionException("option --" + opt + " must not have a value");
        }
        this._optList.add("--" + opt);
        this._valList.add(val);
    }

    private boolean longOptionHasValue(String opt) throws OptionException {
        int lenOpt = opt.length();
        for (int i = 0; i < this._longOpts.length; ++i) {
            String x;
            String longOpt = this._longOpts[i];
            int lenLongOpt = longOpt.length();
            if (lenOpt > lenLongOpt || !(x = longOpt.substring(0, lenOpt)).equals(opt)) continue;
            String y = longOpt.substring(lenOpt, longOpt.length());
            if (!y.equals("") && !y.equals("=") && i + 1 < this._longOpts.length && opt.equals(this._longOpts[i + 1].substring(0, lenOpt))) {
                throw new OptionException("option --" + opt + " not a unique prefix");
            }
            int last = longOpt.length() - 1;
            if (longOpt.charAt(last) == '=') {
                this._longOpt = longOpt.substring(0, last);
                return true;
            }
            this._longOpt = longOpt;
            return false;
        }
        throw new OptionException("option --" + opt + " not recognized");
    }

    private static String[] getStrings(ArrayList<String> list) {
        int n = list.size();
        String[] a = new String[n];
        for (int i = 0; i < n; ++i) {
            a[i] = list.get(i);
        }
        return a;
    }

    public static class OptionException
    extends Exception {
        private OptionException(String msg) {
            super(msg);
        }
    }
}

