/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.sgl;

import edu.mines.jtk.ogl.Gl;
import edu.mines.jtk.sgl.AxesOrientation;
import edu.mines.jtk.sgl.BoundingSphere;
import edu.mines.jtk.sgl.CullContext;
import edu.mines.jtk.sgl.DrawContext;
import edu.mines.jtk.sgl.DrawList;
import edu.mines.jtk.sgl.Matrix44;
import edu.mines.jtk.sgl.Point3;
import edu.mines.jtk.sgl.Tuple3;
import edu.mines.jtk.sgl.Vector3;
import edu.mines.jtk.sgl.View;
import edu.mines.jtk.sgl.ViewCanvas;
import edu.mines.jtk.sgl.World;
import edu.mines.jtk.util.Stopwatch;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;

public class OrbitView
extends View {
    private double _scale;
    private Vector3 _translate;
    private double _azimuth;
    private double _elevation;
    private double _esd;
    private Projection _projection = Projection.PERSPECTIVE;
    private BoundingSphere _worldSphere = null;
    private Matrix44 _worldToUnitSphere;
    private Matrix44 _unitSphereToView;
    private Stopwatch _stopwatch;
    private int _ndraw;

    public OrbitView() {
        this.init();
    }

    public OrbitView(World world) {
        super(world);
        this.init();
        this.updateTransforms();
    }

    public void reset() {
        this.init();
        this.updateView();
    }

    public void setWorldSphere(BoundingSphere worldSphere) {
        this._worldSphere = worldSphere;
        this.updateView();
    }

    public BoundingSphere getWorldSphere() {
        return new BoundingSphere(this._worldSphere);
    }

    public void setProjection(Projection projection) {
        if (this._projection == projection) {
            return;
        }
        this._projection = projection;
        this.updateView();
    }

    public Projection getProjection() {
        return this._projection;
    }

    public void setAzimuth(double azimuth) {
        if (this._azimuth == azimuth) {
            return;
        }
        this._azimuth = azimuth;
        this.updateView();
    }

    public double getAzimuth() {
        return this._azimuth;
    }

    public void setElevation(double elevation) {
        if (this._elevation == elevation) {
            return;
        }
        this._elevation = elevation;
        this.updateView();
    }

    public double getElevation() {
        return this._elevation;
    }

    public void setAzimuthAndElevation(double azimuth, double elevation) {
        if (this._azimuth == azimuth && this._elevation == elevation) {
            return;
        }
        this._azimuth = azimuth;
        this._elevation = elevation;
        this.updateView();
    }

    public void setScale(double scale) {
        if (this._scale == scale) {
            return;
        }
        this._scale = scale;
        this.updateView();
    }

    public double getScale() {
        return this._scale;
    }

    public void setTranslate(Vector3 translate) {
        if (this._translate.equals(translate)) {
            return;
        }
        this._translate = new Vector3(translate);
        this.updateView();
    }

    public Vector3 getTranslate() {
        return new Vector3(this._translate);
    }

    public Matrix44 getWorldToUnitSphere() {
        return new Matrix44(this._worldToUnitSphere);
    }

    public Matrix44 getUnitSphereToView() {
        return new Matrix44(this._unitSphereToView);
    }

    public void setEyeToScreenDistance(double esd) {
        this._esd = esd;
    }

    @Override
    protected void updateTransforms(ViewCanvas canvas) {
        double distance;
        Matrix44 viewToCube;
        double r;
        int w = canvas.getWidth();
        int h = canvas.getHeight();
        if (w == 0 || h == 0) {
            return;
        }
        double ss = this._esd;
        if (ss <= 0.0) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            double xs = screenSize.width;
            double ys = screenSize.height;
            ss = Math.sqrt(xs * xs + ys * ys);
        }
        Matrix44 cubeToPixel = Matrix44.identity();
        cubeToPixel.timesEquals(Matrix44.translate(0.5 * (double)w, 0.5 * (double)h, 0.5));
        cubeToPixel.timesEquals(Matrix44.scale(0.5 * (double)w, -0.5 * (double)h, 0.5));
        canvas.setCubeToPixel(cubeToPixel);
        double maxscale = 3.0;
        if (this._projection == Projection.PERSPECTIVE) {
            r = 1.0;
            double e = ss;
            double m = Math.min(w, h);
            double a = 2.0 * Math.atan(m / (2.0 * e));
            double d = r / Math.sin(a / 2.0);
            double fovy = 2.0 * Math.atan((double)h / (2.0 * e)) * 180.0 / Math.PI;
            double aspect = (double)w / (double)h;
            double znear = Math.max(d - maxscale * r, 0.1);
            double zfar = Math.max(d + maxscale * r, 100.0 * znear);
            viewToCube = Matrix44.perspective(fovy, aspect, znear, zfar);
            distance = d;
        } else {
            r = 1.0;
            double m = Math.min(w, h);
            double d = maxscale * r;
            double right = (double)w / m;
            double left = -right;
            double top = (double)h / m;
            double bottom = -top;
            double znear = 0.0;
            double zfar = 2.0 * maxscale * r;
            viewToCube = Matrix44.ortho(left, right, bottom, top, znear, zfar);
            distance = d;
        }
        canvas.setViewToCube(viewToCube);
        this._unitSphereToView = Matrix44.identity();
        this._unitSphereToView.timesEquals(Matrix44.translate(0.0, 0.0, -distance));
        this._unitSphereToView.timesEquals(Matrix44.rotateX(this._elevation));
        this._unitSphereToView.timesEquals(Matrix44.rotateY(-this._azimuth));
        this._unitSphereToView.timesEquals(Matrix44.scale(this._scale, this._scale, this._scale));
        this._unitSphereToView.timesEquals(Matrix44.translate(this._translate));
        Tuple3 as = this.getAxesScale();
        AxesOrientation ao = this.getAxesOrientation();
        this._worldToUnitSphere = Matrix44.identity();
        World world = this.getWorld();
        if (world != null) {
            BoundingSphere ws;
            if (this._worldSphere == null) {
                this._worldSphere = world.getBoundingSphere(true);
            }
            Point3 c = !(ws = this._worldSphere).isEmpty() ? ws.getCenter() : new Point3();
            double tx = -c.x;
            double ty = -c.y;
            double tz = -c.z;
            double r2 = !ws.isEmpty() ? ws.getRadius() : 1.0;
            double s = r2 > 0.0 ? 1.0 / r2 : 1.0;
            double sx = s * as.x;
            double sy = s * as.y;
            double sz = s * as.z;
            if (ao == AxesOrientation.XRIGHT_YUP_ZOUT) {
                this._worldToUnitSphere.timesEquals(Matrix44.identity());
            } else if (ao == AxesOrientation.XRIGHT_YOUT_ZDOWN) {
                this._worldToUnitSphere.timesEquals(Matrix44.rotateX(90.0));
            } else if (ao == AxesOrientation.XRIGHT_YIN_ZDOWN) {
                this._worldToUnitSphere.timesEquals(Matrix44.rotateX(90.0));
                sy = -sy;
            } else if (ao == AxesOrientation.XOUT_YRIGHT_ZUP) {
                this._worldToUnitSphere.timesEquals(Matrix44.rotateY(-90.0));
                this._worldToUnitSphere.timesEquals(Matrix44.rotateX(-90.0));
            } else if (ao == AxesOrientation.XDOWN_YRIGHT_ZOUT) {
                this._worldToUnitSphere.timesEquals(Matrix44.rotateZ(-90.0));
            } else if (ao == AxesOrientation.XUP_YLEFT_ZOUT) {
                this._worldToUnitSphere.timesEquals(Matrix44.rotateZ(90.0));
            } else if (ao == AxesOrientation.XUP_YRIGHT_ZOUT) {
                this._worldToUnitSphere.timesEquals(Matrix44.rotateZ(90.0));
                sy = -sy;
            }
            this._worldToUnitSphere.timesEquals(Matrix44.scale(sx, sy, sz));
            this._worldToUnitSphere.timesEquals(Matrix44.translate(tx, ty, tz));
        }
        this.setWorldToView(this._unitSphereToView.times(this._worldToUnitSphere));
    }

    @Override
    protected void draw(ViewCanvas canvas) {
        Color c = canvas.getBackground();
        float r = (float)c.getRed() / 255.0f;
        float g = (float)c.getGreen() / 255.0f;
        float b = (float)c.getBlue() / 255.0f;
        Gl.glClearColor(r, g, b, 0.0f);
        Gl.glClear(16640);
        Gl.glEnable(3042);
        Gl.glBlendFunc(770, 771);
        Gl.glEnable(2848);
        Gl.glEnable(2832);
        Gl.glHint(3154, 4354);
        Gl.glHint(3153, 4354);
        Gl.glEnable(2977);
        Gl.glEnable(2929);
        World world = this.getWorld();
        if (world == null) {
            return;
        }
        int w = canvas.getWidth();
        int h = canvas.getHeight();
        Gl.glViewport(0, 0, w, h);
        Matrix44 viewToCube = canvas.getViewToCube();
        Gl.glMatrixMode(5889);
        Gl.glLoadMatrixd(viewToCube.m, 0);
        Gl.glMatrixMode(5888);
        Gl.glLoadIdentity();
        float[] lightPosition = new float[]{-0.1f, -0.1f, 1.0f, 0.0f};
        Gl.glLightfv(16384, 4611, lightPosition, 0);
        Gl.glEnable(16384);
        Matrix44 worldToView = this.getWorldToView();
        Gl.glLoadMatrixd(worldToView.m, 0);
        CullContext cc = new CullContext(canvas);
        world.cullApply(cc);
        DrawList dl = cc.getDrawList();
        DrawContext dc = new DrawContext(canvas);
        dl.draw(dc);
        ++this._ndraw;
        if (this._stopwatch.time() > 2.0) {
            this._stopwatch.stop();
            this._ndraw = 0;
            this._stopwatch.restart();
        }
    }

    private void init() {
        this._scale = 1.0;
        this._translate = new Vector3(0.0, 0.0, 0.0);
        this._azimuth = 40.0;
        this._elevation = 25.0;
        this._projection = Projection.PERSPECTIVE;
        this._ndraw = 0;
        this._stopwatch = new Stopwatch();
        this._stopwatch.start();
    }

    private void updateView() {
        this.updateTransforms();
        this.repaint();
    }

    private static void trace(String s) {
        System.out.println(s);
    }

    public static enum Projection {
        PERSPECTIVE,
        ORTHOGRAPHIC;

    }
}

