/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.lapack;

import edu.mines.jtk.lapack.DMatrix;
import edu.mines.jtk.lapack.LapackInfo;
import edu.mines.jtk.util.ArrayMath;
import org.netlib.lapack.LAPACK;
import org.netlib.util.intW;

public class DMatrixSvd {
    private static final LAPACK _lapack = LAPACK.getInstance();
    int _m;
    int _n;
    int _mn;
    double[] _s;
    double[] _u;
    double[] _vt;

    public DMatrixSvd(DMatrix a) {
        double[] aa = a.getPackedColumns();
        this._m = a.getM();
        this._n = a.getN();
        this._mn = ArrayMath.min(this._m, this._n);
        this._s = new double[this._mn];
        this._u = new double[this._m * this._mn];
        this._vt = new double[this._mn * this._n];
        double[] work = new double[1];
        LapackInfo li = new LapackInfo();
        _lapack.dgesvd("S", "S", this._m, this._n, aa, this._m, this._s, this._u, this._m, this._vt, this._mn, work, -1, (intW)li);
        li.check("dgesvd");
        int lwork = (int)work[0];
        work = new double[lwork];
        _lapack.dgesvd("S", "S", this._m, this._n, aa, this._m, this._s, this._u, this._m, this._vt, this._mn, work, lwork, (intW)li);
        li.check("dgesvd");
    }

    public DMatrix getU() {
        return new DMatrix(this._m, this._mn, ArrayMath.copy(this._u));
    }

    public DMatrix getS() {
        return DMatrix.diagonal(this._s);
    }

    public double[] getSingularValues() {
        return ArrayMath.copy(this._s);
    }

    public DMatrix getV() {
        return new DMatrix(this._mn, this._n, this._vt).transpose();
    }

    public DMatrix getVTranspose() {
        return new DMatrix(this._mn, this._n, ArrayMath.copy(this._vt));
    }

    public double norm2() {
        return this._s[0];
    }

    public double cond() {
        return this._s[0] / this._s[this._mn - 1];
    }

    public int rank() {
        double eps = ArrayMath.ulp(1.0);
        double tol = (double)ArrayMath.max(this._m, this._n) * this._s[0] * eps;
        int r = 0;
        for (int i = 0; i < this._mn; ++i) {
            if (!(this._s[i] > tol)) continue;
            ++r;
        }
        return r;
    }
}

