/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.dsp.BandPassFilter;
import edu.mines.jtk.dsp.LocalDiffusionKernel;
import edu.mines.jtk.dsp.Tensors2;
import edu.mines.jtk.dsp.Tensors3;
import edu.mines.jtk.util.ArrayMath;
import edu.mines.jtk.util.Parallel;
import java.util.logging.Logger;

public class LocalSmoothingFilter {
    private static final boolean PARALLEL = true;
    private static Logger log = Logger.getLogger(LocalSmoothingFilter.class.getName());
    private float _small;
    private int _niter;
    private boolean _pc;
    private LocalDiffusionKernel _ldk;
    private BandPassFilter _lpf;
    private double _kmax;

    public LocalSmoothingFilter() {
        this(0.01, 100);
    }

    public LocalSmoothingFilter(double small, int niter) {
        this._small = (float)small;
        this._niter = niter;
        this._ldk = new LocalDiffusionKernel(LocalDiffusionKernel.Stencil.D22);
    }

    public LocalSmoothingFilter(double small, int niter, LocalDiffusionKernel ldk) {
        this._small = (float)small;
        this._niter = niter;
        this._ldk = ldk;
    }

    public void setPreconditioner(boolean pc) {
        this._pc = pc;
    }

    public void apply(float c, float[] x, float[] y) {
        this.apply(c, null, x, y);
    }

    public void apply(float c, float[] s, float[] x, float[] y) {
        int i1;
        int i12;
        int n1 = x.length;
        float[] e = new float[n1 + 1];
        if (s != null) {
            c = -0.5f * c;
            for (i12 = 1; i12 < n1; ++i12) {
                e[i12] = c * (s[i12] + s[i12 - 1]);
            }
        } else {
            c = -c;
            for (i12 = 1; i12 < n1; ++i12) {
                e[i12] = c;
            }
        }
        float[] w = e;
        float t = 1.0f - e[0] - e[1];
        y[0] = x[0] / t;
        for (i1 = 1; i1 < n1; ++i1) {
            float di = 1.0f - e[i1] - e[i1 + 1];
            float ei = e[i1];
            w[i1] = ei / t;
            t = di - ei * w[i1];
            y[i1] = (x[i1] - ei * y[i1 - 1]) / t;
        }
        for (i1 = n1 - 1; i1 > 0; --i1) {
            int n = i1 - 1;
            y[n] = y[n] - w[i1] * y[i1];
        }
    }

    public void apply(float[][] x, float[][] y) {
        this.apply(null, 1.0f, (float[][])null, x, y);
    }

    public void apply(float c, float[][] x, float[][] y) {
        this.apply(null, c, (float[][])null, x, y);
    }

    public void apply(float c, float[][] s, float[][] x, float[][] y) {
        this.apply(null, c, s, x, y);
    }

    public void apply(Tensors2 d, float[][] x, float[][] y) {
        this.apply(d, 1.0f, (float[][])null, x, y);
    }

    public void apply(Tensors2 d, float c, float[][] x, float[][] y) {
        this.apply(d, c, (float[][])null, x, y);
    }

    public void apply(Tensors2 d, float c, float[][] s, float[][] x, float[][] y) {
        A2 a = new A2(this._ldk, d, c, s);
        LocalSmoothingFilter.scopy(x, y);
        if (this._pc) {
            M2 m = new M2(d, c, s, x);
            this.solve(a, m, x, y);
        } else {
            this.solve(a, x, y);
        }
    }

    public void apply(float[][][] x, float[][][] y) {
        this.apply(null, 1.0f, (float[][][])null, x, y);
    }

    public void apply(float c, float[][][] x, float[][][] y) {
        this.apply(null, c, (float[][][])null, x, y);
    }

    public void apply(float c, float[][][] s, float[][][] x, float[][][] y) {
        this.apply(null, c, s, x, y);
    }

    public void apply(Tensors3 d, float[][][] x, float[][][] y) {
        this.apply(d, 1.0f, (float[][][])null, x, y);
    }

    public void apply(Tensors3 d, float c, float[][][] x, float[][][] y) {
        this.apply(d, c, (float[][][])null, x, y);
    }

    public void apply(Tensors3 d, float c, float[][][] s, float[][][] x, float[][][] y) {
        A3 a = new A3(this._ldk, d, c, s);
        LocalSmoothingFilter.scopy(x, y);
        if (this._pc) {
            M3 m = new M3(d, c, s, x);
            this.solve(a, m, x, y);
        } else {
            this.solve(a, x, y);
        }
    }

    public void applySmoothS(float[][] x, float[][] y) {
        LocalSmoothingFilter.smoothS(x, y);
    }

    public void applySmoothS(float[][][] x, float[][][] y) {
        LocalSmoothingFilter.smoothS(x, y);
    }

    public void applySmoothL(double kmax, float[][] x, float[][] y) {
        this.smoothL(kmax, x, y);
    }

    public void applySmoothL(double kmax, float[][][] x, float[][][] y) {
        this.smoothL(kmax, x, y);
    }

    private void smoothL(double kmax, float[][] x, float[][] y) {
        this.ensureLowpassFilter(kmax);
        this._lpf.apply(x, y);
    }

    private void smoothL(double kmax, float[][][] x, float[][][] y) {
        this.ensureLowpassFilter(kmax);
        this._lpf.apply(x, y);
    }

    private void ensureLowpassFilter(double kmax) {
        if (this._lpf == null || this._kmax != kmax) {
            this._kmax = kmax;
            double kdelta = 0.5 - kmax;
            double kupper = kmax + 0.5 * kdelta;
            this._lpf = new BandPassFilter(0.0, kupper, kdelta, 0.01);
            this._lpf.setExtrapolation(BandPassFilter.Extrapolation.ZERO_SLOPE);
            this._lpf.setFilterCaching(false);
        }
    }

    private static void smoothS(float[][] x, float[][] y) {
        int n1 = x[0].length;
        int n2 = x.length;
        int n1m = n1 - 1;
        int n2m = n2 - 1;
        float[][] t = new float[3][n1];
        LocalSmoothingFilter.scopy(x[0], t[0]);
        LocalSmoothingFilter.scopy(x[0], t[1]);
        for (int i2 = 0; i2 < n2; ++i2) {
            int i2m = i2 > 0 ? i2 - 1 : 0;
            int i2p = i2 < n2m ? i2 + 1 : n2m;
            int j2m = i2m % 3;
            int j2 = i2 % 3;
            int j2p = i2p % 3;
            LocalSmoothingFilter.scopy(x[i2p], t[j2p]);
            float[] x2m = t[j2m];
            float[] x2p = t[j2p];
            float[] x20 = t[j2];
            float[] y2 = y[i2];
            for (int i1 = 0; i1 < n1; ++i1) {
                int i1m = i1 > 0 ? i1 - 1 : 0;
                int i1p = i1 < n1m ? i1 + 1 : n1m;
                y2[i1] = 0.25f * x20[i1] + 0.125f * (x20[i1m] + x20[i1p] + x2m[i1] + x2p[i1]) + 0.0625f * (x2m[i1m] + x2m[i1p] + x2p[i1m] + x2p[i1p]);
            }
        }
    }

    private static void smoothS(float[][][] x, float[][][] y) {
        int n1 = x[0][0].length;
        int n2 = x[0].length;
        int n3 = x.length;
        int n1m = n1 - 1;
        int n2m = n2 - 1;
        int n3m = n3 - 1;
        float[][][] t = new float[3][n2][n1];
        LocalSmoothingFilter.scopy(x[0], t[0]);
        LocalSmoothingFilter.scopy(x[0], t[1]);
        for (int i3 = 0; i3 < n3; ++i3) {
            int i3m = i3 > 0 ? i3 - 1 : 0;
            int i3p = i3 < n3m ? i3 + 1 : n3m;
            int j3m = i3m % 3;
            int j3 = i3 % 3;
            int j3p = i3p % 3;
            LocalSmoothingFilter.scopy(x[i3p], t[j3p]);
            float[][] x3m = t[j3m];
            float[][] x3p = t[j3p];
            float[][] x30 = t[j3];
            float[][] y30 = y[i3];
            for (int i2 = 0; i2 < n2; ++i2) {
                int i2m = i2 > 0 ? i2 - 1 : 0;
                int i2p = i2 < n2m ? i2 + 1 : n2m;
                float[] x3m2m = x3m[i2m];
                float[] x3m20 = x3m[i2];
                float[] x3m2p = x3m[i2p];
                float[] x302m = x30[i2m];
                float[] x3020 = x30[i2];
                float[] x302p = x30[i2p];
                float[] x3p2m = x3p[i2m];
                float[] x3p20 = x3p[i2];
                float[] x3p2p = x3p[i2p];
                float[] y3020 = y30[i2];
                for (int i1 = 0; i1 < n1; ++i1) {
                    int i1m = i1 > 0 ? i1 - 1 : 0;
                    int i1p = i1 < n1m ? i1 + 1 : n1m;
                    y3020[i1] = 0.125f * x3020[i1] + 0.0625f * (x3020[i1m] + x3020[i1p] + x302m[i1] + x302p[i1] + x3m20[i1] + x3p20[i1]) + 0.03125f * (x3m20[i1m] + x3m20[i1p] + x3m2m[i1] + x3m2p[i1] + x302m[i1m] + x302m[i1p] + x302p[i1m] + x302p[i1p] + x3p20[i1m] + x3p20[i1p] + x3p2m[i1] + x3p2p[i1]) + 0.015625f * (x3m2m[i1m] + x3m2m[i1p] + x3m2p[i1m] + x3m2p[i1p] + x3p2m[i1m] + x3p2m[i1p] + x3p2p[i1m] + x3p2p[i1p]);
                }
            }
        }
    }

    private void solve(Operator2 a, float[][] b, float[][] x) {
        int iter;
        float rnorm;
        int n1 = b[0].length;
        int n2 = b.length;
        float[][] d = new float[n2][n1];
        float[][] q = new float[n2][n1];
        float[][] r = new float[n2][n1];
        LocalSmoothingFilter.scopy(b, r);
        a.apply(x, q);
        LocalSmoothingFilter.saxpy(-1.0f, q, r);
        LocalSmoothingFilter.scopy(r, d);
        float delta = LocalSmoothingFilter.sdot(r, r);
        float bnorm = ArrayMath.sqrt(LocalSmoothingFilter.sdot(b, b));
        float rnormBegin = rnorm = ArrayMath.sqrt(delta);
        float rnormSmall = bnorm * this._small;
        log.fine("solve: bnorm=" + bnorm + " rnorm=" + rnorm);
        for (iter = 0; iter < this._niter && rnorm > rnormSmall; ++iter) {
            log.finer("  iter=" + iter + " rnorm=" + rnorm + " ratio=" + rnorm / rnormBegin);
            a.apply(d, q);
            float dq = LocalSmoothingFilter.sdot(d, q);
            float alpha = delta / dq;
            LocalSmoothingFilter.saxpy(alpha, d, x);
            LocalSmoothingFilter.saxpy(-alpha, q, r);
            float deltaOld = delta;
            delta = LocalSmoothingFilter.sdot(r, r);
            float beta = delta / deltaOld;
            LocalSmoothingFilter.sxpay(beta, r, d);
            rnorm = ArrayMath.sqrt(delta);
        }
        log.fine("  iter=" + iter + " rnorm=" + rnorm + " ratio=" + rnorm / rnormBegin);
    }

    private void solve(Operator3 a, float[][][] b, float[][][] x) {
        int iter;
        float rnorm;
        int n1 = b[0][0].length;
        int n2 = b[0].length;
        int n3 = b.length;
        float[][][] d = new float[n3][n2][n1];
        float[][][] q = new float[n3][n2][n1];
        float[][][] r = new float[n3][n2][n1];
        LocalSmoothingFilter.scopy(b, r);
        a.apply(x, q);
        LocalSmoothingFilter.saxpy(-1.0f, q, r);
        LocalSmoothingFilter.scopy(r, d);
        float delta = LocalSmoothingFilter.sdot(r, r);
        float bnorm = ArrayMath.sqrt(LocalSmoothingFilter.sdot(b, b));
        float rnormBegin = rnorm = ArrayMath.sqrt(delta);
        float rnormSmall = bnorm * this._small;
        log.fine("solve: bnorm=" + bnorm + " rnorm=" + rnorm);
        for (iter = 0; iter < this._niter && rnorm > rnormSmall; ++iter) {
            log.finer("  iter=" + iter + " rnorm=" + rnorm + " ratio=" + rnorm / rnormBegin);
            a.apply(d, q);
            float dq = LocalSmoothingFilter.sdot(d, q);
            float alpha = delta / dq;
            LocalSmoothingFilter.saxpy(alpha, d, x);
            if (iter % 100 < 99) {
                LocalSmoothingFilter.saxpy(-alpha, q, r);
            } else {
                LocalSmoothingFilter.scopy(b, r);
                a.apply(x, q);
                LocalSmoothingFilter.saxpy(-1.0f, q, r);
            }
            float deltaOld = delta;
            delta = LocalSmoothingFilter.sdot(r, r);
            float beta = delta / deltaOld;
            LocalSmoothingFilter.sxpay(beta, r, d);
            rnorm = ArrayMath.sqrt(delta);
        }
        log.fine("  iter=" + iter + " rnorm=" + rnorm + " ratio=" + rnorm / rnormBegin);
    }

    private void solve(Operator2 a, Operator2 m, float[][] b, float[][] x) {
        int iter;
        float rnorm;
        int n1 = b[0].length;
        int n2 = b.length;
        float[][] d = new float[n2][n1];
        float[][] q = new float[n2][n1];
        float[][] r = new float[n2][n1];
        float[][] s = new float[n2][n1];
        LocalSmoothingFilter.scopy(b, r);
        a.apply(x, q);
        LocalSmoothingFilter.saxpy(-1.0f, q, r);
        float bnorm = ArrayMath.sqrt(LocalSmoothingFilter.sdot(b, b));
        float rnormBegin = rnorm = ArrayMath.sqrt(LocalSmoothingFilter.sdot(r, r));
        float rnormSmall = bnorm * this._small;
        m.apply(r, s);
        LocalSmoothingFilter.scopy(s, d);
        float delta = LocalSmoothingFilter.sdot(r, s);
        log.fine("msolve: bnorm=" + bnorm + " rnorm=" + rnorm);
        for (iter = 0; iter < this._niter && rnorm > rnormSmall; ++iter) {
            log.finer("  iter=" + iter + " rnorm=" + rnorm + " ratio=" + rnorm / rnormBegin);
            a.apply(d, q);
            float alpha = delta / LocalSmoothingFilter.sdot(d, q);
            LocalSmoothingFilter.saxpy(alpha, d, x);
            LocalSmoothingFilter.saxpy(-alpha, q, r);
            m.apply(r, s);
            float deltaOld = delta;
            delta = LocalSmoothingFilter.sdot(r, s);
            float beta = delta / deltaOld;
            LocalSmoothingFilter.sxpay(beta, s, d);
            rnorm = ArrayMath.sqrt(LocalSmoothingFilter.sdot(r, r));
        }
        log.fine("  iter=" + iter + " rnorm=" + rnorm + " ratio=" + rnorm / rnormBegin);
    }

    private void solve(Operator3 a, Operator3 m, float[][][] b, float[][][] x) {
        int iter;
        float rnorm;
        int n1 = b[0][0].length;
        int n2 = b[0].length;
        int n3 = b.length;
        float[][][] d = new float[n3][n2][n1];
        float[][][] q = new float[n3][n2][n1];
        float[][][] r = new float[n3][n2][n1];
        float[][][] s = new float[n3][n2][n1];
        LocalSmoothingFilter.scopy(b, r);
        a.apply(x, q);
        LocalSmoothingFilter.saxpy(-1.0f, q, r);
        float bnorm = ArrayMath.sqrt(LocalSmoothingFilter.sdot(b, b));
        float rnormBegin = rnorm = ArrayMath.sqrt(LocalSmoothingFilter.sdot(r, r));
        float rnormSmall = bnorm * this._small;
        m.apply(r, s);
        LocalSmoothingFilter.scopy(s, d);
        float delta = LocalSmoothingFilter.sdot(r, s);
        log.fine("msolve: bnorm=" + bnorm + " rnorm=" + rnorm);
        for (iter = 0; iter < this._niter && rnorm > rnormSmall; ++iter) {
            log.finer("  iter=" + iter + " rnorm=" + rnorm + " ratio=" + rnorm / rnormBegin);
            a.apply(d, q);
            float alpha = delta / LocalSmoothingFilter.sdot(d, q);
            LocalSmoothingFilter.saxpy(alpha, d, x);
            if (iter % 100 < 99) {
                LocalSmoothingFilter.saxpy(-alpha, q, r);
            } else {
                LocalSmoothingFilter.scopy(b, r);
                a.apply(x, q);
                LocalSmoothingFilter.saxpy(-1.0f, q, r);
            }
            m.apply(r, s);
            float deltaOld = delta;
            delta = LocalSmoothingFilter.sdot(r, s);
            float beta = delta / deltaOld;
            LocalSmoothingFilter.sxpay(beta, s, d);
            rnorm = ArrayMath.sqrt(LocalSmoothingFilter.sdot(r, r));
        }
        log.fine("  iter=" + iter + " rnorm=" + rnorm + " ratio=" + rnorm / rnormBegin);
    }

    private static void szero(float[] x) {
        ArrayMath.zero(x);
    }

    private static void szero(float[][] x) {
        ArrayMath.zero(x);
    }

    private static void szero(final float[][][] x) {
        int n3 = x.length;
        Parallel.loop(n3, new Parallel.LoopInt(){

            @Override
            public void compute(int i3) {
                LocalSmoothingFilter.szero(x[i3]);
            }
        });
    }

    private static void scopy(float[] x, float[] y) {
        ArrayMath.copy(x, y);
    }

    private static void scopy(float[][] x, float[][] y) {
        ArrayMath.copy(x, y);
    }

    private static void scopy(final float[][][] x, final float[][][] y) {
        int n3 = x.length;
        Parallel.loop(n3, new Parallel.LoopInt(){

            @Override
            public void compute(int i3) {
                LocalSmoothingFilter.scopy(x[i3], y[i3]);
            }
        });
    }

    private static float sdot(float[][] x, float[][] y) {
        int n1 = x[0].length;
        int n2 = x.length;
        float d = 0.0f;
        for (int i2 = 0; i2 < n2; ++i2) {
            float[] x2 = x[i2];
            float[] y2 = y[i2];
            for (int i1 = 0; i1 < n1; ++i1) {
                d += x2[i1] * y2[i1];
            }
        }
        return d;
    }

    private static float sdot(final float[][][] x, final float[][][] y) {
        int n3 = x.length;
        final float[] d3 = new float[n3];
        Parallel.loop(n3, new Parallel.LoopInt(){

            @Override
            public void compute(int i3) {
                d3[i3] = LocalSmoothingFilter.sdot(x[i3], y[i3]);
            }
        });
        float d = 0.0f;
        for (int i3 = 0; i3 < n3; ++i3) {
            d += d3[i3];
        }
        return d;
    }

    private static void saxpy(float a, float[][] x, float[][] y) {
        int n1 = x[0].length;
        int n2 = x.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            float[] x2 = x[i2];
            float[] y2 = y[i2];
            for (int i1 = 0; i1 < n1; ++i1) {
                int n = i1;
                y2[n] = y2[n] + a * x2[i1];
            }
        }
    }

    private static void saxpy(final float a, final float[][][] x, final float[][][] y) {
        int n3 = x.length;
        Parallel.loop(n3, new Parallel.LoopInt(){

            @Override
            public void compute(int i3) {
                LocalSmoothingFilter.saxpy(a, x[i3], y[i3]);
            }
        });
    }

    private static void sxpay(float a, float[][] x, float[][] y) {
        int n1 = x[0].length;
        int n2 = x.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            float[] x2 = x[i2];
            float[] y2 = y[i2];
            for (int i1 = 0; i1 < n1; ++i1) {
                y2[i1] = a * y2[i1] + x2[i1];
            }
        }
    }

    private static void sxpay(final float a, final float[][][] x, final float[][][] y) {
        int n3 = x.length;
        Parallel.loop(n3, new Parallel.LoopInt(){

            @Override
            public void compute(int i3) {
                LocalSmoothingFilter.sxpay(a, x[i3], y[i3]);
            }
        });
    }

    private static void sxy(float[][] x, float[][] y, float[][] z) {
        int n1 = x[0].length;
        int n2 = x.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            float[] x2 = x[i2];
            float[] y2 = y[i2];
            float[] z2 = z[i2];
            for (int i1 = 0; i1 < n1; ++i1) {
                z2[i1] = x2[i1] * y2[i1];
            }
        }
    }

    private static void sxy(final float[][][] x, final float[][][] y, final float[][][] z) {
        int n3 = x.length;
        Parallel.loop(n3, new Parallel.LoopInt(){

            @Override
            public void compute(int i3) {
                LocalSmoothingFilter.sxy(x[i3], y[i3], z[i3]);
            }
        });
    }

    private static class M3
    implements Operator3 {
        private float[][][] _p;

        M3(Tensors3 d, float c, float[][][] s, float[][][] x) {
            int n1 = x[0][0].length;
            int n2 = x[0].length;
            int n3 = x.length;
            this._p = ArrayMath.fillfloat(1.0f, n1, n2, n3);
            c *= 0.0625f;
            float[] di = new float[6];
            int i3 = 1;
            int m3 = 0;
            while (i3 < n3) {
                int i2 = 1;
                int m2 = 0;
                while (i2 < n2) {
                    int i1 = 1;
                    int m1 = 0;
                    while (i1 < n1) {
                        float csi;
                        float si = s != null ? s[i3][i2][i1] : 1.0f;
                        float d11 = csi = c * si;
                        float d12 = 0.0f;
                        float d13 = 0.0f;
                        float d22 = csi;
                        float d23 = 0.0f;
                        float d33 = csi;
                        if (d != null) {
                            d.getTensor(i1, i2, i3, di);
                            d11 = di[0] * csi;
                            d12 = di[1] * csi;
                            d13 = di[2] * csi;
                            d22 = di[3] * csi;
                            d23 = di[4] * csi;
                            d33 = di[5] * csi;
                        }
                        float[] fArray = this._p[i3][i2];
                        int n = i1;
                        fArray[n] = fArray[n] + (d11 + d12 + d13 + (d12 + d22 + d23) + (d13 + d23 + d33));
                        float[] fArray2 = this._p[m3][m2];
                        int n4 = m1;
                        fArray2[n4] = fArray2[n4] + (d11 + d12 + d13 + (d12 + d22 + d23) + (d13 + d23 + d33));
                        float[] fArray3 = this._p[i3][m2];
                        int n5 = i1;
                        fArray3[n5] = fArray3[n5] + (d11 - d12 + d13 + (-d12 + d22 - d23) + (d13 - d23 + d33));
                        float[] fArray4 = this._p[m3][i2];
                        int n6 = m1;
                        fArray4[n6] = fArray4[n6] + (d11 - d12 + d13 + (-d12 + d22 - d23) + (d13 - d23 + d33));
                        float[] fArray5 = this._p[m3][i2];
                        int n7 = i1;
                        fArray5[n7] = fArray5[n7] + (d11 + d12 - d13 + (d12 + d22 - d23) + (-d13 - d23 + d33));
                        float[] fArray6 = this._p[i3][m2];
                        int n8 = m1;
                        fArray6[n8] = fArray6[n8] + (d11 + d12 - d13 + (d12 + d22 - d23) + (-d13 - d23 + d33));
                        float[] fArray7 = this._p[m3][m2];
                        int n9 = i1++;
                        fArray7[n9] = fArray7[n9] + (d11 - d12 - d13 + (-d12 + d22 + d23) + (-d13 + d23 + d33));
                        float[] fArray8 = this._p[i3][i2];
                        int n10 = m1++;
                        fArray8[n10] = fArray8[n10] + (d11 - d12 - d13 + (-d12 + d22 + d23) + (-d13 + d23 + d33));
                    }
                    ++i2;
                    ++m2;
                }
                ++i3;
                ++m3;
            }
            ArrayMath.div(1.0f, this._p, this._p);
        }

        @Override
        public void apply(float[][][] x, float[][][] y) {
            LocalSmoothingFilter.sxy(this._p, x, y);
        }
    }

    private static class A3
    implements Operator3 {
        private LocalDiffusionKernel _ldk;
        private Tensors3 _d;
        private float _c;
        private float[][][] _s;

        A3(LocalDiffusionKernel ldk, Tensors3 d, float c, float[][][] s) {
            this._ldk = ldk;
            this._d = d;
            this._c = c;
            this._s = s;
        }

        @Override
        public void apply(float[][][] x, float[][][] y) {
            LocalSmoothingFilter.scopy(x, y);
            this._ldk.apply(this._d, this._c, this._s, x, y);
        }
    }

    private static class M2
    implements Operator2 {
        private float[][] _p;

        M2(Tensors2 d, float c, float[][] s, float[][] x) {
            int n1 = x[0].length;
            int n2 = x.length;
            this._p = ArrayMath.fillfloat(1.0f, n1, n2);
            c *= 0.25f;
            float[] di = new float[3];
            int i2 = 1;
            int m2 = 0;
            while (i2 < n2) {
                int i1 = 1;
                int m1 = 0;
                while (i1 < n1) {
                    float csi;
                    float si = s != null ? s[i2][i1] : 1.0f;
                    float d11 = csi = c * si;
                    float d12 = 0.0f;
                    float d22 = csi;
                    if (d != null) {
                        d.getTensor(i1, i2, di);
                        d11 = di[0] * csi;
                        d12 = di[1] * csi;
                        d22 = di[2] * csi;
                    }
                    float[] fArray = this._p[i2];
                    int n = i1;
                    fArray[n] = fArray[n] + (d11 + d12 + (d12 + d22));
                    float[] fArray2 = this._p[m2];
                    int n3 = m1;
                    fArray2[n3] = fArray2[n3] + (d11 + d12 + (d12 + d22));
                    float[] fArray3 = this._p[i2];
                    int n4 = m1++;
                    fArray3[n4] = fArray3[n4] + (d11 - d12 + (-d12 + d22));
                    float[] fArray4 = this._p[m2];
                    int n5 = i1++;
                    fArray4[n5] = fArray4[n5] + (d11 - d12 + (-d12 + d22));
                }
                ++i2;
                ++m2;
            }
            ArrayMath.div(1.0f, this._p, this._p);
        }

        @Override
        public void apply(float[][] x, float[][] y) {
            LocalSmoothingFilter.sxy(this._p, x, y);
        }
    }

    private static class A2
    implements Operator2 {
        private LocalDiffusionKernel _ldk;
        private Tensors2 _d;
        private float _c;
        private float[][] _s;

        A2(LocalDiffusionKernel ldk, Tensors2 d, float c, float[][] s) {
            this._ldk = ldk;
            this._d = d;
            this._c = c;
            this._s = s;
        }

        @Override
        public void apply(float[][] x, float[][] y) {
            LocalSmoothingFilter.scopy(x, y);
            this._ldk.apply(this._d, this._c, this._s, x, y);
        }
    }

    private static interface Operator3 {
        public void apply(float[][][] var1, float[][][] var2);
    }

    private static interface Operator2 {
        public void apply(float[][] var1, float[][] var2);
    }
}

