/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ui.swing.updater;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import net.imagej.ui.swing.updater.ConflictDialog;
import net.imagej.ui.swing.updater.SwingAuthenticator;
import net.imagej.ui.swing.updater.SwingTools;
import net.imagej.ui.swing.updater.SwingUserInterface;
import net.imagej.ui.swing.updater.UpdaterFrame;
import net.imagej.ui.swing.updater.ViewOptions;
import net.imagej.updater.FileObject;
import net.imagej.updater.FilesCollection;
import net.imagej.updater.Installer;
import net.imagej.updater.UpdaterUI;
import net.imagej.updater.UploaderService;
import net.imagej.updater.util.AvailableSites;
import net.imagej.updater.util.Progress;
import net.imagej.updater.util.UpdateCanceledException;
import net.imagej.updater.util.UpdaterUserInterface;
import net.imagej.updater.util.UpdaterUtil;
import org.scijava.app.StatusService;
import org.scijava.command.CommandService;
import org.scijava.event.ContextDisposingEvent;
import org.scijava.event.EventHandler;
import org.scijava.log.LogService;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.util.AppUtils;

@Plugin(type=UpdaterUI.class, menu={@Menu(label="Help"), @Menu(label="Update...")})
public class ImageJUpdater
implements UpdaterUI {
    private UpdaterFrame main;
    @Parameter
    private StatusService statusService;
    @Parameter
    private LogService log;
    @Parameter
    private UploaderService uploaderService;
    @Parameter
    private CommandService commandService;
    private static final String UPDATER_UPDATING_THREAD_NAME = "Updating the Updater itself!";

    public void run() {
        if (ImageJUpdater.errorIfDebian()) {
            return;
        }
        if (this.log == null) {
            this.log = UpdaterUtil.getLogService();
        }
        if (ImageJUpdater.errorIfNetworkInaccessible(this.log)) {
            return;
        }
        String imagejDirProperty = System.getProperty("imagej.dir");
        File imagejRoot = imagejDirProperty != null ? new File(imagejDirProperty) : AppUtils.getBaseDirectory((String)"ij.dir", FilesCollection.class, (String)"updater");
        final FilesCollection files = new FilesCollection(imagejRoot);
        AvailableSites.initializeAndAddSites((FilesCollection)files, (LogService)this.log);
        UpdaterUserInterface.set((UpdaterUserInterface)new SwingUserInterface(this.log, this.statusService));
        if (!this.areWeUpdatingTheUpdater() && new File(imagejRoot, "update").exists()) {
            if (!UpdaterUserInterface.get().promptYesNo("It is suggested that you restart ImageJ, then continue the update.\nAlternately, you can attempt to continue the upgrade without\nrestarting, but ImageJ might crash.\n\nDo you want to try it?", "Restart required to finalize update")) {
                return;
            }
            try {
                new Installer(files, null).moveUpdatedIntoPlace();
            }
            catch (IOException e) {
                this.log.debug((Throwable)e);
                UpdaterUserInterface.get().error("Could not move files into place: " + e);
                return;
            }
        }
        UpdaterUtil.useSystemProxies();
        Authenticator.setDefault(new SwingAuthenticator());
        SwingTools.invokeOnEDT(new Runnable(){

            @Override
            public void run() {
                ImageJUpdater.this.main = new UpdaterFrame(ImageJUpdater.this.log, ImageJUpdater.this.uploaderService, files);
            }
        });
        this.main.setEasyMode(true);
        Progress progress = this.main.getProgress("Starting up...");
        try {
            List conflicts;
            String warnings = files.downloadIndexAndChecksum(progress);
            this.main.checkWritable();
            this.main.addCustomViewOptions();
            if (!warnings.equals("")) {
                this.main.warn(warnings);
            }
            if ((conflicts = files.getConflicts()) != null && conflicts.size() > 0 && !new ConflictDialog(this.main, "Conflicting versions"){
                private static final long serialVersionUID = 1L;

                @Override
                protected void updateConflictList() {
                    this.conflictList = conflicts;
                }
            }.resolve()) {
                return;
            }
        }
        catch (UpdateCanceledException e) {
            this.main.error("Canceled");
            return;
        }
        catch (Exception e) {
            this.log.error((Throwable)e);
            String message = e instanceof UnknownHostException ? "Failed to lookup host " + e.getMessage() : "There was an error reading the cached metadata: " + e;
            this.main.error(message);
            return;
        }
        if (!this.areWeUpdatingTheUpdater() && Installer.isTheUpdaterUpdateable((FilesCollection)files, (CommandService)this.commandService)) {
            try {
                Installer.updateTheUpdater((FilesCollection)files, (Progress)this.main.getProgress("Installing the updater..."), (CommandService)this.commandService);
            }
            catch (UpdateCanceledException e) {
                this.main.error("Canceled");
                return;
            }
            catch (IOException e) {
                this.main.error("Installer failed: " + e);
                return;
            }
            ArrayList<URL> classPath = new ArrayList<URL>();
            for (FileObject component : Installer.getUpdaterFiles((FilesCollection)files, (CommandService)this.commandService, (boolean)false)) {
                File updated = files.prefixUpdate(component.getFilename(false));
                if (updated.exists()) {
                    try {
                        classPath.add(updated.toURI().toURL());
                        continue;
                    }
                    catch (MalformedURLException e) {
                        this.log.error((Throwable)e);
                    }
                }
                String name = component.getLocalFilename(false);
                File file = files.prefix(name);
                try {
                    classPath.add(file.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    this.log.error((Throwable)e);
                }
            }
            try {
                this.log.info((Object)"Trying to install and execute the new updater");
                URL[] urls = classPath.toArray(new URL[classPath.size()]);
                URLClassLoader remoteClassLoader = new URLClassLoader(urls, this.getClass().getClassLoader().getParent());
                Class<?> runnable = remoteClassLoader.loadClass(ImageJUpdater.class.getName());
                Thread thread = new Thread((Runnable)runnable.newInstance());
                thread.setName(UPDATER_UPDATING_THREAD_NAME);
                thread.start();
                thread.join();
                return;
            }
            catch (Throwable t) {
                this.log.error(t);
                this.main.info("Please restart ImageJ and call Help>Update to continue with the update");
                return;
            }
        }
        try {
            String missingUploaders = this.main.files.protocolsMissingUploaders(this.main.getUploaderService(), this.main.getProgress(null));
            if (missingUploaders != null) {
                this.main.warn(missingUploaders);
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        this.main.setLocationRelativeTo(null);
        this.main.setVisible(true);
        this.main.requestFocus();
        files.markForUpdate(false);
        this.main.setViewOption(ViewOptions.Option.UPDATEABLE);
        if (files.hasForcableUpdates()) {
            this.main.warn("There are locally modified files!");
            if (files.hasUploadableSites() && !files.hasChanges()) {
                this.main.setViewOption(ViewOptions.Option.LOCALLY_MODIFIED);
                this.main.setEasyMode(false);
            }
        } else if (!files.hasChanges()) {
            this.main.info("Your ImageJ is up to date!");
        }
        this.main.updateFilesTable();
    }

    @EventHandler
    private void onEvent(ContextDisposingEvent e) {
        if (this.main != null && this.main.isDisplayable()) {
            this.main.dispose();
        }
    }

    protected boolean overwriteWithUpdated(FilesCollection files, FileObject file) {
        File downloaded = files.prefix("update/" + file.filename);
        if (!downloaded.exists()) {
            return true;
        }
        File jar = files.prefix(file.filename);
        if (!jar.delete() && !ImageJUpdater.moveOutOfTheWay(jar)) {
            return false;
        }
        if (!downloaded.renameTo(jar)) {
            return false;
        }
        do {
            if ((downloaded = downloaded.getParentFile()) == null) {
                return true;
            }
            String[] list = downloaded.list();
            if (list == null || list.length <= 0) continue;
            return true;
        } while (downloaded.delete());
        return false;
    }

    public static boolean isDebian() {
        String debianProperty = System.getProperty("fiji.debian");
        return debianProperty != null && debianProperty.equals("true");
    }

    public static boolean errorIfDebian() {
        if (ImageJUpdater.isDebian()) {
            String message = "You are using the Debian packaged version of ImageJ.\n";
            message = message + "You should update ImageJ with your system's usual package manager instead.";
            UpdaterUserInterface.get().error(message);
            return true;
        }
        return false;
    }

    public static boolean errorIfNetworkInaccessible(LogService log) {
        try {
            ImageJUpdater.testNetworkConnection();
        }
        catch (IOException | SecurityException exc) {
            if (log != null) {
                log.error((Throwable)exc);
            }
            String message = "Cannot connect to the Internet.\nDo you have a network connection?\nAre your proxy settings correct?";
            UpdaterUserInterface.get().error("Cannot connect to the Internet.\nDo you have a network connection?\nAre your proxy settings correct?");
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testNetworkConnection() throws IOException {
        boolean followRedirects = HttpURLConnection.getFollowRedirects();
        try {
            HttpURLConnection.setFollowRedirects(false);
            URL url = new URL("http://imagej.net/");
            URLConnection urlConn = url.openConnection();
            if (!(urlConn instanceof HttpURLConnection)) {
                throw new IOException("Unexpected connection type: " + urlConn.getClass().getName());
            }
            HttpURLConnection httpConn = (HttpURLConnection)urlConn;
            int code = httpConn.getResponseCode();
            if (code != 301) {
                throw new IOException("Unexpected response code: " + code);
            }
            String message = httpConn.getResponseMessage();
            if (!"Moved Permanently".equals(message)) {
                throw new IOException("Unexpected response message: " + message);
            }
            long length = httpConn.getContentLengthLong();
            if (length < 250L || length > 500L) {
                throw new IOException("Unexpected response length: " + length);
            }
            byte[] content = new byte[(int)length];
            try (DataInputStream din = new DataInputStream(httpConn.getInputStream());){
                din.readFully(content);
            }
            String s = new String(content, "UTF-8");
            if (!s.matches("(?s).*<html>.*<head>.*<title>301 Moved Permanently</title>.*</head>.*<body>.*<h1>Moved Permanently</h1>.*<a href=\"http://imagej.net/Welcome\">.*</body></html>.*")) {
                throw new IOException("Unexpected response:\n" + s);
            }
        }
        finally {
            if (followRedirects != HttpURLConnection.getFollowRedirects()) {
                HttpURLConnection.setFollowRedirects(followRedirects);
            }
        }
    }

    protected static boolean moveOutOfTheWay(File file) {
        File backup;
        block2: {
            if (!file.exists()) {
                return true;
            }
            backup = new File(file.getParentFile(), file.getName() + ".old");
            if (!backup.exists() || backup.delete()) break block2;
            int i = 2;
            while ((backup = new File(file.getParentFile(), file.getName() + ".old" + 2)).exists()) {
            }
        }
        return file.renameTo(backup);
    }

    private boolean areWeUpdatingTheUpdater() {
        return UPDATER_UPDATING_THREAD_NAME.equals(Thread.currentThread().getName());
    }

    public static void main(String[] args) {
        new ImageJUpdater().run();
    }
}

