/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.display;

import java.util.ArrayList;
import net.imagej.display.DataView;
import net.imagej.display.ImageDisplay;
import net.imagej.display.OverlayService;
import net.imagej.display.OverlayView;
import org.scijava.command.Command;
import org.scijava.command.ContextCommand;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menu={@Menu(label="Image", weight=2.0, mnemonic=105), @Menu(label="Overlay"), @Menu(label="Remove Overlay", weight=3.0)}, attrs={@Attr(name="no-legacy")})
public class RemoveOverlay
extends ContextCommand {
    @Parameter(required=true)
    private OverlayService oService;
    @Parameter(required=true)
    private ImageDisplay display;

    public void setImageDisplay(ImageDisplay disp) {
        this.display = disp;
    }

    public ImageDisplay getImageDisplay() {
        return this.display;
    }

    public void run() {
        ArrayList views = new ArrayList(this.display);
        for (DataView view : views) {
            if (!view.isSelected() || !(view instanceof OverlayView)) continue;
            OverlayView overlayView = (OverlayView)view;
            this.oService.removeOverlay(overlayView.getData());
        }
    }
}

