/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Closure;
import java.lang.ref.WeakReference;
import org.jruby.Ruby;
import org.jruby.RubyNumeric;
import org.jruby.RubyProc;
import org.jruby.ext.ffi.ArrayMemoryIO;
import org.jruby.ext.ffi.CallbackInfo;
import org.jruby.ext.ffi.MappedType;
import org.jruby.ext.ffi.MemoryIO;
import org.jruby.ext.ffi.Platform;
import org.jruby.ext.ffi.Pointer;
import org.jruby.ext.ffi.Struct;
import org.jruby.ext.ffi.StructByValue;
import org.jruby.ext.ffi.Type;
import org.jruby.ext.ffi.Util;
import org.jruby.ext.ffi.jffi.BoundedNativeMemoryIO;
import org.jruby.ext.ffi.jffi.CodeMemoryIO;
import org.jruby.ext.ffi.jffi.FFIUtil;
import org.jruby.ext.ffi.jffi.Factory;
import org.jruby.ext.ffi.jffi.Function;
import org.jruby.ext.ffi.jffi.NativeFunctionInfo;
import org.jruby.ext.ffi.jffi.NativeMemoryIO;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.FunctionalCachingCallSite;

final class NativeClosureProxy
implements Closure {
    private static final int LONG_SIZE = Platform.getPlatform().longSize();
    protected final Ruby runtime;
    protected final NativeFunctionInfo closureInfo;
    private final WeakReference<Object> proc;
    private final CallSite callSite;

    NativeClosureProxy(Ruby runtime, NativeFunctionInfo closureInfo, Object proc2) {
        this(runtime, closureInfo, proc2, new FunctionalCachingCallSite("call"));
    }

    NativeClosureProxy(Ruby runtime, NativeFunctionInfo closureInfo, Object proc2, CallSite callSite) {
        this.runtime = runtime;
        this.closureInfo = closureInfo;
        this.proc = new WeakReference<Object>(proc2);
        this.callSite = callSite;
    }

    public void invoke(Closure.Buffer buffer) {
        Object recv2 = this.proc.get();
        if (recv2 == null) {
            buffer.setIntReturn(0);
            return;
        }
        this.invoke(buffer, recv2);
    }

    protected final void invoke(Closure.Buffer buffer, Object recv2) {
        ThreadContext context = this.runtime.getCurrentContext();
        IRubyObject[] params2 = new IRubyObject[this.closureInfo.parameterTypes.length];
        for (int i2 = 0; i2 < params2.length; ++i2) {
            params2[i2] = NativeClosureProxy.fromNative(this.runtime, this.closureInfo.parameterTypes[i2], buffer, i2);
        }
        IRubyObject retVal = recv2 instanceof Block ? ((Block)recv2).call(context, params2) : this.callSite.call(context, (IRubyObject)recv2, (IRubyObject)recv2, params2);
        NativeClosureProxy.setReturnValue(this.runtime, this.closureInfo.returnType, buffer, retVal);
    }

    private static final long longValue(IRubyObject value2) {
        if (value2 instanceof RubyNumeric) {
            return ((RubyNumeric)value2).getLongValue();
        }
        if (value2.isNil()) {
            return 0L;
        }
        return 0L;
    }

    private static final long addressValue(IRubyObject value2) {
        if (value2 instanceof RubyNumeric) {
            return ((RubyNumeric)value2).getLongValue();
        }
        if (value2 instanceof Pointer) {
            return ((Pointer)value2).getAddress();
        }
        if (value2.isNil()) {
            return 0L;
        }
        return 0L;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final void setReturnValue(Ruby runtime, Type type2, Closure.Buffer buffer, IRubyObject value2) {
        if (type2 instanceof Type.Builtin) {
            switch (type2.getNativeType()) {
                case VOID: {
                    return;
                }
                case CHAR: {
                    buffer.setByteReturn((byte)NativeClosureProxy.longValue(value2));
                    return;
                }
                case UCHAR: {
                    buffer.setByteReturn((byte)NativeClosureProxy.longValue(value2));
                    return;
                }
                case SHORT: {
                    buffer.setShortReturn((short)NativeClosureProxy.longValue(value2));
                    return;
                }
                case USHORT: {
                    buffer.setShortReturn((short)NativeClosureProxy.longValue(value2));
                    return;
                }
                case INT: {
                    buffer.setIntReturn((int)NativeClosureProxy.longValue(value2));
                    return;
                }
                case UINT: {
                    buffer.setIntReturn((int)NativeClosureProxy.longValue(value2));
                    return;
                }
                case LONG_LONG: {
                    buffer.setLongReturn(Util.int64Value(value2));
                    return;
                }
                case ULONG_LONG: {
                    buffer.setLongReturn(Util.uint64Value(value2));
                    return;
                }
                case LONG: {
                    if (LONG_SIZE == 32) {
                        buffer.setIntReturn((int)NativeClosureProxy.longValue(value2));
                        return;
                    }
                    buffer.setLongReturn(Util.int64Value(value2));
                    return;
                }
                case ULONG: {
                    if (LONG_SIZE == 32) {
                        buffer.setIntReturn((int)NativeClosureProxy.longValue(value2));
                        return;
                    }
                    buffer.setLongReturn(Util.uint64Value(value2));
                    return;
                }
                case FLOAT: {
                    buffer.setFloatReturn((float)RubyNumeric.num2dbl(value2));
                    return;
                }
                case DOUBLE: {
                    buffer.setDoubleReturn(RubyNumeric.num2dbl(value2));
                    return;
                }
                case POINTER: {
                    buffer.setAddressReturn(NativeClosureProxy.addressValue(value2));
                    return;
                }
                case BOOL: {
                    buffer.setIntReturn(value2.isTrue() ? 1 : 0);
                    return;
                }
            }
            return;
        }
        if (type2 instanceof CallbackInfo) {
            if (!(value2 instanceof RubyProc) && !value2.respondsTo("call")) {
                buffer.setAddressReturn(0L);
                throw runtime.newTypeError("invalid callback return value, expected Proc or callable object");
            }
            Pointer cb = Factory.getInstance().getCallbackManager().getCallback(runtime, (CallbackInfo)type2, value2);
            buffer.setAddressReturn(NativeClosureProxy.addressValue(cb));
            return;
        }
        if (type2 instanceof StructByValue) {
            if (!(value2 instanceof Struct)) {
                if (!value2.isNil()) throw runtime.newTypeError(value2, runtime.getFFI().structClass);
                buffer.setStructReturn(new byte[type2.getNativeSize()], 0);
                return;
            }
            Struct s2 = (Struct)value2;
            MemoryIO memory = s2.getMemory().getMemoryIO();
            if (memory.isDirect()) {
                long address2 = memory.address();
                if (address2 != 0L) {
                    buffer.setStructReturn(address2);
                    return;
                }
                buffer.setStructReturn(new byte[type2.getNativeSize()], 0);
                return;
            }
            if (!(memory instanceof ArrayMemoryIO)) throw runtime.newRuntimeError("struct return value has illegal backing memory");
            ArrayMemoryIO arrayMemory = (ArrayMemoryIO)memory;
            if (arrayMemory.arrayLength() < type2.getNativeSize()) {
                throw runtime.newRuntimeError("size of struct returned from callback too small");
            }
            buffer.setStructReturn(arrayMemory.array(), arrayMemory.arrayOffset());
            return;
        }
        if (type2 instanceof MappedType) {
            MappedType mappedType = (MappedType)type2;
            NativeClosureProxy.setReturnValue(runtime, mappedType.getRealType(), buffer, mappedType.toNative(runtime.getCurrentContext(), value2));
            return;
        }
        buffer.setLongReturn(0L);
        throw runtime.newRuntimeError("unsupported return type from struct: " + type2);
    }

    private static final IRubyObject fromNative(Ruby runtime, Type type2, Closure.Buffer buffer, int index2) {
        if (type2 instanceof Type.Builtin) {
            switch (type2.getNativeType()) {
                case VOID: {
                    return runtime.getNil();
                }
                case CHAR: {
                    return Util.newSigned8(runtime, buffer.getByte(index2));
                }
                case UCHAR: {
                    return Util.newUnsigned8(runtime, buffer.getByte(index2));
                }
                case SHORT: {
                    return Util.newSigned16(runtime, buffer.getShort(index2));
                }
                case USHORT: {
                    return Util.newUnsigned16(runtime, buffer.getShort(index2));
                }
                case INT: {
                    return Util.newSigned32(runtime, buffer.getInt(index2));
                }
                case UINT: {
                    return Util.newUnsigned32(runtime, buffer.getInt(index2));
                }
                case LONG_LONG: {
                    return Util.newSigned64(runtime, buffer.getLong(index2));
                }
                case ULONG_LONG: {
                    return Util.newUnsigned64(runtime, buffer.getLong(index2));
                }
                case LONG: {
                    return LONG_SIZE == 32 ? Util.newSigned32(runtime, buffer.getInt(index2)) : Util.newSigned64(runtime, buffer.getLong(index2));
                }
                case ULONG: {
                    return LONG_SIZE == 32 ? Util.newUnsigned32(runtime, buffer.getInt(index2)) : Util.newUnsigned64(runtime, buffer.getLong(index2));
                }
                case FLOAT: {
                    return runtime.newFloat(buffer.getFloat(index2));
                }
                case DOUBLE: {
                    return runtime.newFloat(buffer.getDouble(index2));
                }
                case POINTER: {
                    return new Pointer(runtime, NativeMemoryIO.wrap(runtime, buffer.getAddress(index2)));
                }
                case STRING: 
                case TRANSIENT_STRING: {
                    return NativeClosureProxy.getStringParameter(runtime, buffer, index2);
                }
                case BOOL: {
                    return runtime.newBoolean(buffer.getByte(index2) != 0);
                }
            }
            throw runtime.newTypeError("invalid callback parameter type " + type2);
        }
        if (type2 instanceof CallbackInfo) {
            CallbackInfo cbInfo = (CallbackInfo)type2;
            long address2 = buffer.getAddress(index2);
            return address2 != 0L ? new Function(runtime, cbInfo.getMetaClass(), new CodeMemoryIO(runtime, address2), cbInfo.getReturnType(), cbInfo.getParameterTypes(), cbInfo.isStdcall() ? CallingConvention.STDCALL : CallingConvention.DEFAULT, runtime.getNil(), false) : runtime.getNil();
        }
        if (type2 instanceof StructByValue) {
            StructByValue sbv = (StructByValue)type2;
            long address3 = buffer.getStruct(index2);
            MemoryIO memory = address3 != 0L ? new BoundedNativeMemoryIO(runtime, address3, type2.getNativeSize()) : runtime.getFFI().getNullMemoryIO();
            return sbv.getStructClass().newInstance(runtime.getCurrentContext(), new IRubyObject[]{new Pointer(runtime, memory)}, Block.NULL_BLOCK);
        }
        if (type2 instanceof MappedType) {
            MappedType mappedType = (MappedType)type2;
            return mappedType.fromNative(runtime.getCurrentContext(), NativeClosureProxy.fromNative(runtime, mappedType.getRealType(), buffer, index2));
        }
        throw runtime.newTypeError("unsupported callback parameter type: " + type2);
    }

    private static final IRubyObject getStringParameter(Ruby runtime, Closure.Buffer buffer, int index2) {
        return FFIUtil.getString(runtime, buffer.getAddress(index2));
    }
}

