/*
 * Decompiled with CFR 0.152.
 */
package io.scif.io;

import io.scif.io.CBZip2InputStream;
import io.scif.io.HandleException;
import io.scif.io.IStreamAccess;
import io.scif.io.StreamHandle;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import org.scijava.Context;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=IStreamAccess.class)
public class BZip2Handle
extends StreamHandle {
    @Parameter
    private LogService log;

    public BZip2Handle() {
    }

    public BZip2Handle(Context context) {
        super(context);
    }

    public BZip2Handle(Context context, String file) throws IOException {
        super(context);
        this.setFile(file);
    }

    @Override
    public boolean isConstructable(String file) throws IOException {
        if (!file.toLowerCase().endsWith(".bz2")) {
            return false;
        }
        FileInputStream s = new FileInputStream(file);
        byte[] b = new byte[2];
        s.read(b);
        s.close();
        return new String(b, "UTF-8").equals("BZ");
    }

    @Override
    public void resetStream() throws IOException {
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(this.getFile()), 0x100000);
        int skipped = 0;
        while (skipped < 2) {
            skipped = (int)((long)skipped + bis.skip(2 - skipped));
        }
        this.setStream(new DataInputStream(new CBZip2InputStream(bis, this.log)));
    }

    @Override
    public void setFile(String file) throws IOException {
        int skip;
        super.setFile(file);
        if (!this.isConstructable(file)) {
            throw new HandleException(file + " is not a BZip2 file.");
        }
        this.resetStream();
        int length = 0;
        while ((skip = this.getStream().skipBytes(1024)) > 0) {
            length += skip;
        }
        this.setLength(length);
        this.resetStream();
    }
}

