/*
 * Decompiled with CFR 0.152.
 */
package io.scif.img.cell;

import io.scif.AbstractSCIFIOPlugin;
import io.scif.img.cell.SCIFIOCell;
import io.scif.img.cell.SCIFIOCellCache;
import io.scif.img.cell.cache.CacheService;
import io.scif.refs.CleaningRef;
import io.scif.refs.RefProvider;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=RefProvider.class)
public class SCIFIOCellCacheCleaningProvider
extends AbstractSCIFIOPlugin
implements RefProvider {
    @Override
    public boolean handles(Object referent, Object ... params) {
        boolean handles = SCIFIOCellCache.class.isAssignableFrom(referent.getClass());
        handles = handles && (params == null || params.length == 0);
        return handles;
    }

    @Override
    public Reference makeRef(Object referent, ReferenceQueue queue, Object ... params) {
        SCIFIOCellCacheCleaner ref = new SCIFIOCellCacheCleaner(referent, queue);
        this.getContext().inject((Object)ref);
        return ref;
    }

    public static class SCIFIOCellCacheCleaner
    extends PhantomReference<SCIFIOCellCache>
    implements CleaningRef {
        @Parameter
        private CacheService<SCIFIOCell<?>> cacheService;
        private final String cacheId;

        public SCIFIOCellCacheCleaner(Object cache, ReferenceQueue queue) {
            super((SCIFIOCellCache)cache, queue);
            this.cacheId = ((SCIFIOCellCache)cache).getCacheId();
        }

        @Override
        public void cleanup() {
            this.cacheService.clearCache(this.cacheId);
            this.clear();
        }
    }
}

