/*
 * Decompiled with CFR 0.152.
 */
package io.scif.gui;

import io.scif.BufferedImagePlane;
import io.scif.FormatException;
import io.scif.Plane;
import io.scif.Reader;
import io.scif.SCIFIOService;
import io.scif.Writer;
import io.scif.gui.AWTImageTools;
import io.scif.gui.GUIService;
import io.scif.services.FormatService;
import io.scif.services.InitializeService;
import io.scif.util.FormatTools;
import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.ProgressMonitor;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.scijava.Context;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.service.SciJavaService;

public class ImageViewer
extends JFrame
implements ActionListener,
ChangeListener,
KeyListener,
MouseMotionListener,
Runnable,
WindowListener {
    @Parameter
    private Context context;
    @Parameter
    private LogService logService;
    @Parameter
    private FormatService formatService;
    @Parameter
    private InitializeService initializeService;
    @Parameter
    private GUIService guiService;
    private static final String TITLE = "SCIFIO Viewer";
    private static final char ANIMATION_KEY = ' ';
    private Reader myReader;
    private Writer myWriter;
    private final JPanel pane;
    private final ImageIcon icon;
    private final JLabel iconLabel;
    private final JPanel sliderPanel;
    private final JSlider nSlider;
    private final JLabel probeLabel;
    private final JMenuItem fileView;
    private final JMenuItem fileSave;
    private String filename;
    private BufferedImage[] images;
    private boolean anim = false;
    private int fps = 10;
    private boolean canCloseReader = true;
    private final StringBuffer sb = new StringBuffer();

    public ImageViewer(Context context) {
        super(TITLE);
        context.inject((Object)this);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(this);
        this.pane = new JPanel();
        this.pane.setLayout(new BorderLayout());
        this.setContentPane(this.pane);
        this.setSize(350, 350);
        this.sliderPanel = new JPanel();
        this.sliderPanel.setVisible(false);
        this.sliderPanel.setBorder(new EmptyBorder(5, 3, 5, 3));
        this.sliderPanel.setLayout(new BoxLayout(this.sliderPanel, 1));
        this.pane.add("South", this.sliderPanel);
        JPanel nPanel = new JPanel();
        nPanel.setLayout(new BoxLayout(nPanel, 0));
        this.sliderPanel.add(nPanel);
        this.sliderPanel.add(Box.createVerticalStrut(2));
        this.nSlider = new JSlider(1, 1);
        this.nSlider.setEnabled(false);
        this.nSlider.addChangeListener(this);
        nPanel.add(new JLabel("N"));
        nPanel.add(Box.createHorizontalStrut(3));
        nPanel.add(this.nSlider);
        JPanel ztcPanel = new JPanel();
        ztcPanel.setLayout(new BoxLayout(ztcPanel, 0));
        this.sliderPanel.add(ztcPanel);
        BufferedImage dummy = AWTImageTools.makeImage(new byte[1][1], 1, 1, false);
        this.icon = new ImageIcon(dummy);
        this.iconLabel = new JLabel(this.icon, 2);
        this.iconLabel.setVerticalAlignment(1);
        this.pane.add(new JScrollPane(this.iconLabel));
        this.probeLabel = new JLabel(" ");
        this.probeLabel.setHorizontalAlignment(0);
        this.probeLabel.setBorder(new BevelBorder(0));
        this.pane.add("North", this.probeLabel);
        this.iconLabel.addMouseMotionListener(this);
        JMenuBar menubar = new JMenuBar();
        JMenu file = new JMenu("File");
        file.setMnemonic('f');
        menubar.add(file);
        JMenuItem fileOpen = new JMenuItem("Open...");
        fileOpen.setMnemonic('o');
        fileOpen.setActionCommand("open");
        fileOpen.addActionListener(this);
        file.add(fileOpen);
        this.fileSave = new JMenuItem("Save...");
        this.fileSave.setMnemonic('s');
        this.fileSave.setEnabled(false);
        this.fileSave.setActionCommand("save");
        this.fileSave.addActionListener(this);
        file.add(this.fileSave);
        this.fileView = new JMenuItem("View Metadata...");
        JMenuItem fileExit = new JMenuItem("Exit");
        fileExit.setMnemonic('x');
        fileExit.setActionCommand("exit");
        fileExit.addActionListener(this);
        file.add(fileExit);
        JMenu options = new JMenu("Options");
        options.setMnemonic('p');
        menubar.add(options);
        JMenuItem optionsFPS = new JMenuItem("Frames per Second...");
        optionsFPS.setMnemonic('f');
        optionsFPS.setActionCommand("fps");
        optionsFPS.addActionListener(this);
        options.add(optionsFPS);
        JMenu help = new JMenu("Help");
        help.setMnemonic('h');
        menubar.add(help);
        JMenuItem helpAbout = new JMenuItem("About...");
        helpAbout.setMnemonic('a');
        helpAbout.setActionCommand("about");
        helpAbout.addActionListener(this);
        help.add(helpAbout);
        this.nSlider.addKeyListener(this);
    }

    public ImageViewer(Context context, boolean canCloseReader) {
        this(context);
        this.canCloseReader = canCloseReader;
    }

    public void open(String id) {
        this.wait(true);
        try {
            this.canCloseReader = true;
            this.myReader = this.initializeService.initializeReader(id);
            long planeCount = this.myReader.getMetadata().get(0).getPlaneCount();
            ProgressMonitor progress = new ProgressMonitor(this, "Reading " + id, null, 0, 1);
            progress.setProgress(1);
            BufferedImage[] img = new BufferedImage[(int)planeCount];
            for (long planeIndex = 0L; planeIndex < planeCount && !progress.isCanceled(); ++planeIndex) {
                Plane plane = this.myReader.openPlane(0, planeIndex);
                img[(int)planeIndex] = AWTImageTools.openImage(plane, this.myReader, 0);
            }
            progress.setProgress(2);
            this.setImages(this.myReader, img);
            this.myReader.close(true);
        }
        catch (FormatException exc) {
            this.logService.info((Object)"", (Throwable)exc);
            this.wait(false);
            return;
        }
        catch (IOException exc) {
            this.logService.info((Object)"", (Throwable)exc);
            this.wait(false);
            return;
        }
        this.wait(false);
    }

    public void save(String id) {
        if (this.images == null) {
            return;
        }
        this.wait(true);
        try {
            this.myWriter.setDest(id);
            boolean stack = this.myWriter.canDoStacks();
            ProgressMonitor progress = new ProgressMonitor(this, "Saving " + id, null, 0, stack ? this.images.length : 1);
            if (stack) {
                for (int i = 0; i < this.images.length; ++i) {
                    progress.setProgress(i);
                    boolean canceled = progress.isCanceled();
                    this.myWriter.savePlane(0, i, this.getPlane(this.images[i]));
                    if (canceled) break;
                }
                progress.setProgress(this.images.length);
            } else {
                this.myWriter.savePlane(0, 0L, this.getPlane(this.getImage()));
                progress.setProgress(1);
            }
            this.myWriter.close();
        }
        catch (FormatException exc) {
            this.logService.info((Object)"", (Throwable)exc);
        }
        catch (IOException exc) {
            this.logService.info((Object)"", (Throwable)exc);
        }
        this.wait(false);
    }

    public void setImages(BufferedImage[] img) {
        this.setImages(null, img);
    }

    public void setImages(Reader reader, BufferedImage[] img) {
        String format;
        this.filename = reader == null ? null : reader.getCurrentFile();
        this.myReader = reader;
        this.images = img;
        this.fileView.setEnabled(true);
        this.fileSave.setEnabled(true);
        this.nSlider.removeChangeListener(this);
        this.nSlider.setValue(1);
        this.nSlider.setMaximum(this.images.length);
        this.nSlider.setEnabled(this.images.length > 1);
        this.nSlider.addChangeListener(this);
        this.sliderPanel.setVisible(this.images.length > 1);
        this.updateLabel(-1, -1);
        this.sb.setLength(0);
        if (this.filename != null) {
            this.sb.append(reader.getCurrentFile());
            this.sb.append(" ");
        }
        String string = format = reader == null ? null : reader.getFormat().getFormatName();
        if (format != null) {
            this.sb.append("(");
            this.sb.append(format);
            this.sb.append(")");
            this.sb.append(" ");
        }
        if (this.filename != null || format != null) {
            this.sb.append("- ");
        }
        this.sb.append(TITLE);
        this.setTitle(this.sb.toString());
        if (this.images != null) {
            this.icon.setImage(this.images[0]);
        }
        this.pack();
    }

    public BufferedImage getImage() {
        int ndx = this.getPlaneIndex();
        return this.images == null || ndx >= this.images.length ? null : this.images[ndx];
    }

    public Plane getPlane(BufferedImage image) {
        BufferedImagePlane plane = new BufferedImagePlane(this.context);
        plane.setData(image);
        return plane;
    }

    public int getPlaneIndex() {
        return this.nSlider.getValue() - 1;
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        new Thread(this).start();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if ("open".equals(cmd)) {
            File file;
            this.wait(true);
            JFileChooser chooser = this.guiService.buildFileChooser(this.formatService.getAllFormats());
            this.wait(false);
            int rval = chooser.showOpenDialog(this);
            if (rval == 0 && (file = chooser.getSelectedFile()) != null) {
                this.open(file.getAbsolutePath(), this.myReader);
            }
        } else if ("save".equals(cmd)) {
            this.wait(true);
            JFileChooser chooser = this.guiService.buildFileChooser(this.formatService.getOutputFormats());
            this.wait(false);
            int rval = chooser.showSaveDialog(this);
            if (rval == 0) {
                if (this.myWriter != null) {
                    try {
                        this.myWriter.close();
                    }
                    catch (IOException e1) {
                        this.logService.error((Throwable)e1);
                    }
                }
                File file = chooser.getSelectedFile();
                try {
                    this.myWriter = this.initializeService.initializeWriter(this.myReader.getMetadata(), file.getAbsolutePath());
                }
                catch (FormatException e1) {
                    this.logService.error((Object)e);
                }
                catch (IOException e1) {
                    this.logService.error((Object)e);
                }
                if (file != null) {
                    this.save(file.getAbsolutePath(), this.myWriter);
                }
            }
        } else if ("exit".equals(cmd)) {
            this.dispose();
        } else if ("fps".equals(cmd)) {
            this.setDefaultCloseOperation(3);
            String result = JOptionPane.showInputDialog(this, "Animate using space bar. How many frames per second?", "" + this.fps);
            try {
                this.fps = Integer.parseInt(result);
            }
            catch (NumberFormatException exc) {
                this.logService.debug((Object)("Could not parse fps " + this.fps), (Throwable)exc);
            }
        } else if ("about".equals(cmd)) {
            this.setDefaultCloseOperation(3);
            String msg = "<html>SCIFIO core for reading and converting file formats.<br>Copyright (C) 2005 - 2013 Open Microscopy Environment:<ul><li>Board of Regents of the University of Wisconsin-Madison</li><li>Glencoe Software, Inc.</li><li>University of Dundee</li></ul><br><br>See <a href=\"http://loci.wisc.edu/software/scifio\">http://loci.wisc.edu/software/scifio</a><br>for help with using SCIFIO.";
            JOptionPane.showMessageDialog(null, "<html>SCIFIO core for reading and converting file formats.<br>Copyright (C) 2005 - 2013 Open Microscopy Environment:<ul><li>Board of Regents of the University of Wisconsin-Madison</li><li>Glencoe Software, Inc.</li><li>University of Dundee</li></ul><br><br>See <a href=\"http://loci.wisc.edu/software/scifio\">http://loci.wisc.edu/software/scifio</a><br>for help with using SCIFIO.", "SCIFIO", 1);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        boolean outOfBounds = false;
        this.updateLabel(-1, -1);
        BufferedImage image = this.getImage();
        if (image == null) {
            this.iconLabel.setIcon(null);
            this.iconLabel.setText("No image plane");
        } else {
            this.icon.setImage(image);
            this.iconLabel.setIcon(this.icon);
            this.iconLabel.setText(null);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyChar() == ' ') {
            this.anim = !this.anim;
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.updateLabel(e.getX(), e.getY());
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.updateLabel(e.getX(), e.getY());
    }

    @Override
    public void run() {
        while (this.isVisible()) {
            try {
                Thread.sleep(1000 / this.fps);
            }
            catch (InterruptedException exc) {
                this.logService.debug((Object)"", (Throwable)exc);
            }
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
        try {
            if (this.myWriter != null) {
                this.myWriter.close();
            }
            if (this.canCloseReader && this.myReader != null) {
                this.myReader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void updateLabel(int x, int y) {
        int h;
        BufferedImage image;
        if (this.images == null) {
            return;
        }
        int ndx = this.getPlaneIndex();
        this.sb.setLength(0);
        if (this.images.length > 1) {
            this.sb.append("N=");
            this.sb.append(ndx + 1);
            this.sb.append("/");
            this.sb.append(this.images.length);
        }
        int w = (image = this.images[ndx]) == null ? -1 : image.getWidth();
        int n = h = image == null ? -1 : image.getHeight();
        if (x >= w) {
            x = w - 1;
        }
        if (y >= h) {
            y = h - 1;
        }
        if (x >= 0 && y >= 0) {
            if (this.images.length > 1) {
                this.sb.append("; ");
            }
            this.sb.append("X=");
            this.sb.append(x);
            if (w > 0) {
                this.sb.append("/");
                this.sb.append(w);
            }
            this.sb.append("; Y=");
            this.sb.append(y);
            if (h > 0) {
                this.sb.append("/");
                this.sb.append(h);
            }
            if (image != null) {
                WritableRaster r = image.getRaster();
                double[] pix = r.getPixel(x, y, (double[])null);
                this.sb.append("; value");
                this.sb.append(pix.length > 1 ? "s=(" : "=");
                for (int i = 0; i < pix.length; ++i) {
                    if (i > 0) {
                        this.sb.append(", ");
                    }
                    this.sb.append(pix[i]);
                }
                if (pix.length > 1) {
                    this.sb.append(")");
                }
                this.sb.append("; type=");
                int pixelType = AWTImageTools.getPixelType(image);
                this.sb.append(FormatTools.getPixelTypeString(pixelType));
            }
        }
        this.sb.append(" ");
        this.probeLabel.setText(this.sb.toString());
    }

    protected void wait(boolean wait) {
        this.setCursor(wait ? Cursor.getPredefinedCursor(3) : null);
    }

    protected void open(final String id, final Reader r) {
        new Thread("ImageViewer-Opener"){

            @Override
            public void run() {
                try {
                    ImageViewer.this.myReader.close();
                }
                catch (IOException exc) {
                    ImageViewer.this.logService.info((Object)"", (Throwable)exc);
                }
                ImageViewer.this.myReader = r;
                ImageViewer.this.open(id);
            }
        }.start();
    }

    protected void save(final String id, final Writer w) {
        new Thread("ImageViewer-Saver"){

            @Override
            public void run() {
                try {
                    ImageViewer.this.myWriter.close();
                }
                catch (IOException exc) {
                    ImageViewer.this.logService.info((Object)"", (Throwable)exc);
                }
                ImageViewer.this.myWriter = w;
                ImageViewer.this.save(id);
            }
        }.start();
    }

    public static void main(String[] args) {
        ImageViewer viewer = new ImageViewer(new Context(new Class[]{SCIFIOService.class, SciJavaService.class}));
        viewer.setVisible(true);
        if (args.length > 0) {
            viewer.open(args[0]);
        }
    }
}

