/*
 * Decompiled with CFR 0.152.
 */
package io.scif.formats;

import io.scif.AbstractFormat;
import io.scif.AbstractMetadata;
import io.scif.AbstractParser;
import io.scif.ByteArrayPlane;
import io.scif.ByteArrayReader;
import io.scif.Format;
import io.scif.FormatException;
import io.scif.ImageMetadata;
import io.scif.codec.JPEGTileDecoder;
import io.scif.config.SCIFIOConfig;
import io.scif.io.RandomAccessInputStream;
import io.scif.util.FormatTools;
import java.io.IOException;
import net.imagej.axis.Axes;
import org.scijava.plugin.Plugin;

@Plugin(type=Format.class, name="Tile JPEG", priority=-100.0)
public class JPEGTileFormat
extends AbstractFormat {
    @Override
    protected String[] makeSuffixArray() {
        return new String[]{"jpg", "jpeg"};
    }

    public static class Reader
    extends ByteArrayReader<Metadata> {
        @Override
        protected String[] createDomainArray() {
            return new String[]{"Graphics"};
        }

        @Override
        public ByteArrayPlane openPlane(int imageIndex, long planeIndex, ByteArrayPlane plane, long[] planeMin, long[] planeMax, SCIFIOConfig config) throws FormatException, IOException {
            Metadata meta = (Metadata)this.getMetadata();
            byte[] buf = plane.getBytes();
            int xAxis = meta.get(imageIndex).getAxisIndex(Axes.X);
            int yAxis = meta.get(imageIndex).getAxisIndex(Axes.Y);
            int x = (int)planeMin[xAxis];
            int y = (int)planeMin[yAxis];
            int w = (int)planeMax[xAxis];
            int h = (int)planeMax[yAxis];
            FormatTools.checkPlaneForReading(meta, imageIndex, planeIndex, buf.length, planeMin, planeMax);
            int c = (int)meta.get(imageIndex).getAxisLength(Axes.CHANNEL);
            for (int ty = y; ty < y + h; ++ty) {
                byte[] scanline = meta.getDecoder().getScanline(ty);
                if (scanline == null) {
                    meta.getDecoder().initialize(this.getStream().getFileName(), 0);
                    scanline = meta.getDecoder().getScanline(ty);
                }
                System.arraycopy(scanline, c * x, buf, (ty - y) * c * w, c * w);
            }
            return plane;
        }
    }

    public static class Parser
    extends AbstractParser<Metadata> {
        @Override
        protected void typedParse(RandomAccessInputStream stream, Metadata meta, SCIFIOConfig config) throws IOException, FormatException {
            JPEGTileDecoder decoder = new JPEGTileDecoder(this.getContext());
            meta.setDecoder(decoder);
            decoder.initialize(this.getSource(), 0, 1);
        }
    }

    public static class Metadata
    extends AbstractMetadata {
        private JPEGTileDecoder decoder;

        public JPEGTileDecoder getDecoder() {
            return this.decoder;
        }

        public void setDecoder(JPEGTileDecoder decoder) {
            this.decoder = decoder;
        }

        @Override
        public void populateImageMetadata() {
            this.createImageMetadata(1);
            ImageMetadata iMeta = this.get(0);
            iMeta.setAxisTypes(Axes.CHANNEL, Axes.X, Axes.Y);
            iMeta.setPlanarAxisCount(3);
            iMeta.setLittleEndian(false);
            iMeta.setAxisLength(Axes.X, (long)this.decoder.getWidth());
            iMeta.setAxisLength(Axes.Y, (long)this.decoder.getHeight());
            iMeta.setAxisLength(Axes.CHANNEL, (long)this.decoder.getScanline(0).length / iMeta.getAxisLength(Axes.X));
            iMeta.setPixelType(1);
            iMeta.setMetadataComplete(true);
            iMeta.setIndexed(false);
        }

        @Override
        public void close(boolean fileOnly) throws IOException {
            if (!fileOnly) {
                if (this.decoder != null) {
                    this.decoder.close();
                }
                this.decoder = null;
            }
            super.close(fileOnly);
        }
    }
}

