/*
 * Decompiled with CFR 0.152.
 */
package io.scif.formats;

import io.scif.AbstractChecker;
import io.scif.AbstractFormat;
import io.scif.AbstractMetadata;
import io.scif.AbstractParser;
import io.scif.ByteArrayPlane;
import io.scif.ByteArrayReader;
import io.scif.FilePattern;
import io.scif.Format;
import io.scif.FormatException;
import io.scif.HasColorTable;
import io.scif.ImageMetadata;
import io.scif.MetadataLevel;
import io.scif.UnsupportedCompressionException;
import io.scif.codec.AbstractCodec;
import io.scif.codec.CodecOptions;
import io.scif.codec.CodecService;
import io.scif.codec.JPEG2000Codec;
import io.scif.codec.JPEGCodec;
import io.scif.codec.PackbitsCodec;
import io.scif.config.SCIFIOConfig;
import io.scif.filters.ReaderFilter;
import io.scif.formats.dicom.DICOMDictionary;
import io.scif.io.Location;
import io.scif.io.RandomAccessInputStream;
import io.scif.services.InitializeService;
import io.scif.util.FormatTools;
import java.io.IOException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import net.imagej.axis.Axes;
import net.imglib2.display.ColorTable;
import net.imglib2.display.ColorTable16;
import net.imglib2.display.ColorTable8;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.util.Bytes;
import org.scijava.util.DigestUtils;

@Plugin(type=Format.class, name="DICOM")
public class DICOMFormat
extends AbstractFormat {
    public static final String DICOM_MAGIC_STRING = "DICM";
    private static final DICOMDictionary TYPES = new DICOMDictionary();

    @Override
    protected String[] makeSuffixArray() {
        return new String[]{"dic", "dcm", "dicom", "jp2", "j2ki", "j2kr", "raw", "ima"};
    }

    public static class DICOMTag {
        private int elementLength = 0;
        private int tagValue;
        private int vr = 0;
        private boolean inSequence = false;
        private int location = 0;
        private boolean littleEndian;

        public int getLocation() {
            return this.location;
        }

        public void setLocation(int location) {
            this.location = location;
        }

        public void addLocation(int offset) {
            this.location += offset;
        }

        public int getVR() {
            return this.vr;
        }

        public void setVR(int vr) {
            this.vr = vr;
        }

        public int getElementLength() {
            return this.elementLength;
        }

        public void setElementLength(int elementLength) {
            this.elementLength = elementLength;
        }

        public void incrementElementLength() {
            ++this.elementLength;
        }

        public int get() {
            return this.tagValue;
        }

        public void setTagValue(int tagValue) {
            this.tagValue = tagValue;
        }

        public boolean isInSequence() {
            return this.inSequence;
        }

        public void setInSequence(boolean inSequence) {
            this.inSequence = inSequence;
        }

        public boolean isLittleEndian() {
            return this.littleEndian;
        }

        public void setLittleEndian(boolean littleEndian) {
            this.littleEndian = littleEndian;
        }
    }

    private static class DICOMUtils {
        private static final int AE = 16709;
        private static final int AS = 16723;
        private static final int AT = 16724;
        private static final int CS = 17235;
        private static final int DA = 17473;
        private static final int DS = 17491;
        private static final int DT = 17492;
        private static final int FD = 17988;
        private static final int FL = 17996;
        private static final int IS = 18771;
        private static final int LO = 19535;
        private static final int LT = 19540;
        private static final int PN = 20558;
        private static final int SH = 21320;
        private static final int SL = 21324;
        private static final int SS = 21331;
        private static final int ST = 21332;
        private static final int TM = 21581;
        private static final int UI = 21833;
        private static final int UL = 21836;
        private static final int US = 21843;
        private static final int UT = 21844;
        private static final int OB = 20290;
        private static final int OW = 20311;
        private static final int SQ = 21329;
        private static final int UN = 21838;
        private static final int QQ = 16191;
        private static final int IMPLICIT_VR = 11565;

        private DICOMUtils() {
        }

        private static DICOMTag getNextTag(RandomAccessInputStream stream) throws FormatException, IOException {
            return DICOMUtils.getNextTag(stream, false);
        }

        private static DICOMTag getNextTag(RandomAccessInputStream stream, boolean bigEndianTransferSyntax) throws FormatException, IOException {
            return DICOMUtils.getNextTag(stream, bigEndianTransferSyntax, false);
        }

        private static DICOMTag getNextTag(RandomAccessInputStream stream, boolean bigEndianTransferSyntax, boolean isOddLocations) throws FormatException, IOException {
            long fp = stream.getFilePointer();
            int groupWord = stream.readShort() & 0xFFFF;
            DICOMTag diTag = new DICOMTag();
            boolean littleEndian = true;
            if (groupWord == 2048 && bigEndianTransferSyntax) {
                littleEndian = false;
                groupWord = 8;
                stream.order(false);
            } else if (groupWord == 65279 || groupWord == 65534) {
                stream.skipBytes(6);
                return DICOMUtils.getNextTag(stream, bigEndianTransferSyntax);
            }
            short elementWord = stream.readShort();
            int tag = groupWord << 16 & 0xFFFF0000 | elementWord & 0xFFFF;
            diTag.setElementLength(DICOMUtils.getLength(stream, diTag));
            if ((long)diTag.getElementLength() > stream.length()) {
                stream.seek(fp);
                littleEndian = !littleEndian;
                stream.order(littleEndian);
                groupWord = stream.readShort() & 0xFFFF;
                elementWord = stream.readShort();
                tag = groupWord << 16 & 0xFFFF0000 | elementWord & 0xFFFF;
                diTag.setElementLength(DICOMUtils.getLength(stream, diTag));
                if ((long)diTag.getElementLength() > stream.length()) {
                    throw new FormatException("Invalid tag length " + diTag.getElementLength());
                }
                diTag.setTagValue(tag);
                return diTag;
            }
            if (diTag.getElementLength() < 0 && groupWord == 32736) {
                stream.skipBytes(12);
                diTag.setElementLength(stream.readInt());
                if (diTag.getElementLength() < 0) {
                    diTag.setElementLength(stream.readInt());
                }
            }
            if (diTag.getElementLength() == 0 && (groupWord == 32736 || tag == 2691092)) {
                diTag.setElementLength(DICOMUtils.getLength(stream, diTag));
            } else if (diTag.getElementLength() == 0) {
                stream.seek(stream.getFilePointer() - 4L);
                String v = stream.readString(2);
                if (v.equals("UT")) {
                    stream.skipBytes(2);
                    diTag.setElementLength(stream.readInt());
                } else {
                    stream.skipBytes(2);
                }
            }
            if (!isOddLocations && diTag.getElementLength() % 2 == 1) {
                diTag.incrementElementLength();
            }
            if (diTag.getElementLength() == -1) {
                diTag.setElementLength(0);
                diTag.setInSequence(true);
            }
            diTag.setTagValue(tag);
            diTag.setLittleEndian(littleEndian);
            return diTag;
        }

        private static int getLength(RandomAccessInputStream stream, DICOMTag tag) throws IOException {
            byte[] b = new byte[4];
            stream.read(b);
            int vr = (b[0] & 0xFF) << 8 | b[1] & 0xFF;
            tag.setVR(vr);
            switch (vr) {
                case 20290: 
                case 20311: 
                case 21329: 
                case 21838: {
                    if (b[2] == 0 || b[3] == 0) {
                        return stream.readInt();
                    }
                    tag.setVR(11565);
                    return Bytes.toInt((byte[])b, (boolean)stream.isLittleEndian());
                }
                case 16191: 
                case 16709: 
                case 16723: 
                case 16724: 
                case 17235: 
                case 17473: 
                case 17491: 
                case 17492: 
                case 17988: 
                case 17996: 
                case 18771: 
                case 19535: 
                case 19540: 
                case 20558: 
                case 21320: 
                case 21324: 
                case 21331: 
                case 21332: 
                case 21581: 
                case 21833: 
                case 21836: 
                case 21843: 
                case 21844: {
                    if (tag.get() == 2633734) {
                        return Bytes.toInt((byte[])b, (int)2, (int)2, (boolean)stream.isLittleEndian());
                    }
                    int n1 = Bytes.toShort((byte[])b, (int)2, (int)2, (boolean)stream.isLittleEndian());
                    int n2 = Bytes.toShort((byte[])b, (int)2, (int)2, (!stream.isLittleEndian() ? 1 : 0) != 0);
                    n2 &= 0xFFFF;
                    if ((n1 &= 0xFFFF) < 0 || (long)n1 + stream.getFilePointer() > stream.length()) {
                        return n2;
                    }
                    if (n2 < 0 || (long)n2 + stream.getFilePointer() > stream.length()) {
                        return n1;
                    }
                    return n1;
                }
                case 65535: {
                    tag.setVR(11565);
                    return 8;
                }
            }
            tag.setVR(11565);
            int len = Bytes.toInt((byte[])b, (boolean)stream.isLittleEndian());
            if ((long)len + stream.getFilePointer() > stream.length() || len < 0) {
                len = Bytes.toInt((byte[])b, (int)2, (int)2, (boolean)stream.isLittleEndian());
                len &= 0xFFFF;
            }
            return len;
        }
    }

    public static class Reader
    extends ByteArrayReader<Metadata> {
        @Parameter
        private InitializeService initializeService;
        @Parameter
        private CodecService codecService;

        @Override
        protected String[] createDomainArray() {
            return new String[]{"Medical Imaging"};
        }

        @Override
        public boolean hasCompanionFiles() {
            return true;
        }

        @Override
        public ByteArrayPlane openPlane(int imageIndex, long planeIndex, ByteArrayPlane plane, long[] planeMin, long[] planeMax, SCIFIOConfig config) throws FormatException, IOException {
            block26: {
                int bpp;
                Metadata meta;
                block27: {
                    meta = (Metadata)this.getMetadata();
                    plane.setColorTable(meta.getColorTable(imageIndex, planeIndex));
                    FormatTools.checkPlaneForReading(meta, imageIndex, planeIndex, ((byte[])plane.getData()).length, planeMin, planeMax);
                    int xAxis = meta.get(imageIndex).getAxisIndex(Axes.X);
                    int yAxis = meta.get(imageIndex).getAxisIndex(Axes.Y);
                    int x = (int)planeMin[xAxis];
                    int y = (int)planeMin[yAxis];
                    int w = (int)planeMax[xAxis];
                    int h = (int)planeMax[yAxis];
                    Hashtable<Integer, Vector<String>> fileList = meta.getFileList();
                    Object[] keys = fileList.keySet().toArray(new Integer[0]);
                    Arrays.sort(keys);
                    if (fileList.get(keys[imageIndex]).size() > 1) {
                        int fileNumber = (int)(planeIndex / (long)meta.getImagesPerFile());
                        String file = fileList.get(keys[imageIndex]).get(fileNumber);
                        ReaderFilter r = this.initializeService.initializeReader(file, new SCIFIOConfig().checkerSetOpen(true));
                        return (ByteArrayPlane)r.openPlane(imageIndex, planeIndex %= (long)meta.getImagesPerFile(), plane, planeMin, planeMax, config);
                    }
                    int ec = meta.get(0).isIndexed() ? 1 : (int)meta.get(imageIndex).getAxisLength(Axes.CHANNEL);
                    bpp = FormatTools.getBytesPerPixel(meta.get(imageIndex).getPixelType());
                    int bytes = (int)(meta.get(imageIndex).getAxisLength(Axes.X) * meta.get(imageIndex).getAxisLength(Axes.Y) * (long)bpp * (long)ec);
                    this.getStream().seek(meta.getOffsets()[(int)planeIndex]);
                    if (meta.isRLE()) {
                        CodecOptions options = new CodecOptions();
                        options.maxBytes = (int)(meta.get(imageIndex).getAxisLength(Axes.X) * meta.get(imageIndex).getAxisLength(Axes.Y));
                        PackbitsCodec codec = this.codecService.getCodec(PackbitsCodec.class);
                        block0: for (int c = 0; c < ec; ++c) {
                            byte[] t = null;
                            if (bpp > 1) {
                                int i;
                                byte[][] tmp = new byte[bpp][];
                                for (i = 0; i < bpp; ++i) {
                                    tmp[i] = codec.decompress(this.getStream(), options);
                                    if (planeIndex >= (long)(meta.getImagesPerFile() - 1) && i >= bpp - 1) continue;
                                    while (this.getStream().read() == 0) {
                                    }
                                    this.getStream().seek(this.getStream().getFilePointer() - 1L);
                                }
                                t = new byte[bytes / ec];
                                i = 0;
                                while ((long)i < planeIndex) {
                                    for (int j = 0; j < bpp; ++j) {
                                        int byteIndex;
                                        int n = byteIndex = meta.get(imageIndex).isLittleEndian() ? bpp - j - 1 : j;
                                        if (i >= tmp[byteIndex].length) continue;
                                        t[i * bpp + j] = tmp[byteIndex][i];
                                    }
                                    ++i;
                                }
                            } else {
                                t = codec.decompress(this.getStream(), options);
                                if (t.length < bytes / ec) {
                                    byte[] tmp = t;
                                    t = new byte[bytes / ec];
                                    System.arraycopy(tmp, 0, t, 0, tmp.length);
                                }
                                if (planeIndex < (long)(meta.getImagesPerFile() - 1) || c < ec - 1) {
                                    while (this.getStream().read() == 0) {
                                    }
                                    this.getStream().seek(this.getStream().getFilePointer() - 1L);
                                }
                            }
                            int rowLen = w * bpp;
                            int srcRowLen = (int)meta.get(imageIndex).getAxisLength(Axes.X) * bpp;
                            for (int row = 0; row < h; ++row) {
                                int src = (row + y) * srcRowLen + x * bpp;
                                int dest = (h * c + row) * rowLen;
                                int len = Math.min(rowLen, t.length - src - 1);
                                if (len < 0) continue block0;
                                System.arraycopy(t, src, plane.getBytes(), dest, len);
                            }
                        }
                    } else if (meta.isJPEG() || meta.isJP2K()) {
                        int pt;
                        long end = planeIndex < (long)(meta.getOffsets().length - 1) ? meta.getOffsets()[(int)planeIndex + 1] : this.getStream().length();
                        byte[] b = new byte[(int)(end - this.getStream().getFilePointer())];
                        this.getStream().read(b);
                        if (b[2] != -1) {
                            byte[] tmp = new byte[b.length + 1];
                            tmp[0] = b[0];
                            tmp[1] = b[1];
                            tmp[2] = -1;
                            System.arraycopy(b, 2, tmp, 3, b.length - 2);
                            b = tmp;
                        }
                        if ((b[3] & 0xFF) >= 240) {
                            b[3] = (byte)(b[3] - 48);
                        }
                        for (pt = b.length - 2; pt >= 0 && b[pt] != -1 || b[pt + 1] != -39; --pt) {
                        }
                        if (pt < b.length - 2) {
                            byte[] tmp = b;
                            b = new byte[pt + 2];
                            System.arraycopy(tmp, 0, b, 0, b.length);
                        }
                        CodecOptions options = new CodecOptions();
                        options.littleEndian = meta.get(imageIndex).isLittleEndian();
                        options.interleaved = meta.get(imageIndex).getInterleavedAxisCount() > 0;
                        AbstractCodec codec = meta.isJPEG() ? this.codecService.getCodec(JPEGCodec.class) : this.codecService.getCodec(JPEG2000Codec.class);
                        b = codec.decompress(b, options);
                        int rowLen = w * bpp;
                        int srcRowLen = (int)meta.get(imageIndex).getAxisLength(Axes.X) * bpp;
                        int srcPlane = (int)meta.get(imageIndex).getAxisLength(Axes.Y) * srcRowLen;
                        for (int c = 0; c < ec; ++c) {
                            for (int row = 0; row < h; ++row) {
                                System.arraycopy(b, c * srcPlane + (row + y) * srcRowLen + x * bpp, plane.getBytes(), h * rowLen * c + row * rowLen, rowLen);
                            }
                        }
                    } else {
                        if (meta.isDeflate()) {
                            throw new UnsupportedCompressionException("Deflate data is not supported.");
                        }
                        this.readPlane(this.getStream(), imageIndex, planeMin, planeMax, plane);
                    }
                    if (!meta.isInverted()) break block26;
                    if (bpp != 1) break block27;
                    for (int i = 0; i < plane.getBytes().length; ++i) {
                        plane.getBytes()[i] = (byte)(255 - plane.getBytes()[i]);
                    }
                    break block26;
                }
                if (bpp != 2) break block26;
                if (meta.getMaxPixelValue() == -1) {
                    meta.setMaxPixelValue(65535);
                }
                boolean little = meta.get(imageIndex).isLittleEndian();
                for (int i = 0; i < plane.getBytes().length; i += 2) {
                    short s = Bytes.toShort((byte[])plane.getBytes(), (int)i, (int)2, (boolean)little);
                    Bytes.unpack((long)(meta.getMaxPixelValue() - s), (byte[])plane.getBytes(), (int)i, (int)2, (boolean)little);
                }
            }
            return plane;
        }
    }

    public static class Parser
    extends AbstractParser<Metadata> {
        private static final int PIXEL_REPRESENTATION = 2621699;
        private static final int PIXEL_SIGN = 2625601;
        private static final int TRANSFER_SYNTAX_UID = 131088;
        private static final int SLICE_SPACING = 0x180088;
        private static final int SAMPLES_PER_PIXEL = 0x280002;
        private static final int PHOTOMETRIC_INTERPRETATION = 2621444;
        private static final int PLANAR_CONFIGURATION = 2621446;
        private static final int NUMBER_OF_FRAMES = 0x280008;
        private static final int ROWS = 2621456;
        private static final int COLUMNS = 2621457;
        private static final int PIXEL_SPACING = 2621488;
        private static final int BITS_ALLOCATED = 2621696;
        private static final int WINDOW_CENTER = 2625616;
        private static final int WINDOW_WIDTH = 2625617;
        private static final int RESCALE_INTERCEPT = 2625618;
        private static final int RESCALE_SLOPE = 2625619;
        private static final int ICON_IMAGE_SEQUENCE = 0x880200;
        private static final int ITEM = -73728;
        private static final int ITEM_DELIMINATION = -73715;
        private static final int SEQUENCE_DELIMINATION = -73507;
        private static final int PIXEL_DATA = 2145386512;
        @Parameter
        private CodecService codecService;

        @Override
        public int fileGroupOption(String id) throws FormatException, IOException {
            return 1;
        }

        @Override
        protected void typedParse(RandomAccessInputStream stream, Metadata meta, SCIFIOConfig config) throws IOException, FormatException {
            meta.createImageMetadata(1);
            stream.order(true);
            ImageMetadata iMeta = meta.get(0);
            Vector<String> companionFiles = new Vector<String>();
            this.attachCompanionFiles(companionFiles);
            meta.setCompanionFiles(companionFiles);
            int location = 0;
            boolean isJP2K = false;
            boolean isJPEG = false;
            boolean isRLE = false;
            boolean isDeflate = false;
            boolean oddLocations = false;
            int maxPixelValue = -1;
            int imagesPerFile = 0;
            boolean bigEndianTransferSyntax = false;
            long[] offsets = null;
            int sizeX = 0;
            int sizeY = 0;
            int bitsPerPixel = 0;
            this.log().info((Object)"Verifying DICOM format");
            MetadataLevel level = config.parserGetLevel();
            this.getSource().seek(128L);
            if (this.getSource().readString(4).equals(DICOMFormat.DICOM_MAGIC_STRING)) {
                if (level != MetadataLevel.MINIMUM) {
                    this.getSource().seek(0L);
                    meta.getTable().put("Header information", this.getSource().readString(128));
                    this.getSource().skipBytes(4);
                }
                location = 128;
            } else {
                this.getSource().seek(0L);
            }
            this.log().info((Object)"Reading tags");
            long baseOffset = 0L;
            boolean decodingTags = true;
            boolean signed = false;
            while (decodingTags && this.getSource().getFilePointer() + 4L < this.getSource().length()) {
                this.log().debug((Object)("Reading tag from " + this.getSource().getFilePointer()));
                DICOMTag tag = DICOMUtils.getNextTag(this.getSource(), bigEndianTransferSyntax, oddLocations);
                iMeta.setLittleEndian(tag.isLittleEndian());
                if (tag.getElementLength() <= 0) continue;
                oddLocations = (location & 1) != 0;
                this.log().debug((Object)("  tag=" + tag.get() + " len=" + tag.getElementLength() + " fp=" + this.getSource().getFilePointer()));
                String s = null;
                switch (tag.get()) {
                    case 131088: {
                        s = this.getSource().readString(tag.getElementLength());
                        this.addInfo(meta, tag, s);
                        if (s.startsWith("1.2.840.10008.1.2.4.9")) {
                            isJP2K = true;
                        } else if (s.startsWith("1.2.840.10008.1.2.4")) {
                            isJPEG = true;
                        } else if (s.startsWith("1.2.840.10008.1.2.5")) {
                            isRLE = true;
                        } else if (s.equals("1.2.8.10008.1.2.1.99")) {
                            isDeflate = true;
                        } else if (s.contains("1.2.4") || s.contains("1.2.5")) {
                            throw new UnsupportedCompressionException("Sorry, compression type " + s + " not supported");
                        }
                        if (!s.contains("1.2.840.10008.1.2.2")) break;
                        bigEndianTransferSyntax = true;
                        break;
                    }
                    case 0x280008: {
                        s = this.getSource().readString(tag.getElementLength());
                        this.addInfo(meta, tag, s);
                        double frames = Double.parseDouble(s);
                        if (!(frames > 1.0)) break;
                        imagesPerFile = (int)frames;
                        break;
                    }
                    case 0x280002: {
                        this.addInfo(meta, tag, this.getSource().readShort());
                        break;
                    }
                    case 2621446: {
                        boolean interleaved;
                        short configuration = this.getSource().readShort();
                        boolean bl = interleaved = configuration == 0;
                        if (interleaved) {
                            iMeta.setAxisTypes(Axes.CHANNEL, Axes.X, Axes.Y);
                            iMeta.setPlanarAxisCount(3);
                        }
                        this.addInfo(meta, tag, configuration);
                        break;
                    }
                    case 2621456: {
                        if (sizeY == 0) {
                            sizeY = this.getSource().readShort();
                            iMeta.addAxis(Axes.Y, (long)sizeY);
                        } else {
                            this.getSource().skipBytes(2);
                        }
                        this.addInfo(meta, tag, sizeY);
                        break;
                    }
                    case 2621457: {
                        if (sizeX == 0) {
                            sizeX = this.getSource().readShort();
                            iMeta.addAxis(Axes.X, (long)sizeX);
                        } else {
                            this.getSource().skipBytes(2);
                        }
                        this.addInfo(meta, tag, sizeX);
                        break;
                    }
                    case 0x180088: 
                    case 2621444: 
                    case 2621488: 
                    case 2625616: 
                    case 2625618: 
                    case 2625619: {
                        this.addInfo(meta, tag, this.getSource().readString(tag.getElementLength()));
                        break;
                    }
                    case 2621696: {
                        if (bitsPerPixel == 0) {
                            bitsPerPixel = this.getSource().readShort();
                        } else {
                            this.getSource().skipBytes(2);
                        }
                        this.addInfo(meta, tag, bitsPerPixel);
                        break;
                    }
                    case 2621699: {
                        short ss = this.getSource().readShort();
                        signed = ss == 1;
                        this.addInfo(meta, tag, ss);
                        break;
                    }
                    case 2625601: {
                        short ss = this.getSource().readShort();
                        this.addInfo(meta, tag, ss);
                        break;
                    }
                    case 2625617: 
                    case 537262910: {
                        String t = this.getSource().readString(tag.getElementLength());
                        if (t.trim().length() == 0) {
                            maxPixelValue = -1;
                        } else {
                            try {
                                maxPixelValue = new Double(t.trim()).intValue();
                            }
                            catch (NumberFormatException e) {
                                maxPixelValue = -1;
                            }
                        }
                        this.addInfo(meta, tag, t);
                        break;
                    }
                    case -73728: 
                    case 0xFFEE000: 
                    case 2145386512: {
                        if (tag.getElementLength() != 0) {
                            baseOffset = this.getSource().getFilePointer();
                            this.addInfo(meta, tag, location);
                            decodingTags = false;
                            break;
                        }
                        this.addInfo(meta, tag, null);
                        break;
                    }
                    case 2139619344: {
                        if (tag.getElementLength() == 0) break;
                        baseOffset = location + 4;
                        decodingTags = false;
                        break;
                    }
                    case 2145386496: {
                        this.getSource().skipBytes(tag.getElementLength());
                        break;
                    }
                    case 0: {
                        this.getSource().seek(this.getSource().getFilePointer() - 4L);
                        break;
                    }
                    default: {
                        long oldfp = this.getSource().getFilePointer();
                        this.addInfo(meta, tag, s);
                        this.getSource().seek(oldfp + (long)tag.getElementLength());
                    }
                }
                if (this.getSource().getFilePointer() < this.getSource().length() - 4L) continue;
                decodingTags = false;
            }
            if (imagesPerFile == 0) {
                imagesPerFile = 1;
            }
            int bpp = bitsPerPixel;
            while (bitsPerPixel % 8 != 0) {
                ++bitsPerPixel;
            }
            if (bitsPerPixel == 24 || bitsPerPixel == 48) {
                bitsPerPixel /= 3;
                bpp /= 3;
            }
            int pixelType = FormatTools.pixelTypeFromBytes(bitsPerPixel / 8, signed, false);
            iMeta.setBitsPerPixel(bpp);
            iMeta.setPixelType(pixelType);
            int bytesPerPixel = FormatTools.getBytesPerPixel(pixelType);
            int planeSize = sizeX * sizeY * (int)(meta.getColorTable(0, 0L) == null ? meta.get(0).getAxisLength(Axes.CHANNEL) : 1L) * bytesPerPixel;
            meta.setJP2K(isJP2K);
            meta.setJPEG(isJPEG);
            meta.setImagesPerFile(imagesPerFile);
            meta.setRLE(isRLE);
            meta.setDeflate(isDeflate);
            meta.setMaxPixelValue(maxPixelValue);
            meta.setOddLocations(oddLocations);
            this.log().info((Object)"Calculating image offsets");
            this.getSource().seek(baseOffset - 12L);
            int len = this.getSource().readInt();
            if (len >= 0 && (long)len + this.getSource().getFilePointer() < this.getSource().length()) {
                this.getSource().skipBytes(len);
                int check = this.getSource().readShort() & 0xFFFF;
                if (check == 65534) {
                    baseOffset = this.getSource().getFilePointer() + 2L;
                }
            }
            offsets = new long[imagesPerFile];
            meta.setOffsets(offsets);
            for (int i = 0; i < imagesPerFile; ++i) {
                if (isRLE) {
                    if (i == 0) {
                        this.getSource().seek(baseOffset);
                    } else {
                        this.getSource().seek(offsets[i - 1]);
                        CodecOptions options = new CodecOptions();
                        options.maxBytes = planeSize / bytesPerPixel;
                        for (int q = 0; q < bytesPerPixel; ++q) {
                            PackbitsCodec codec = this.codecService.getCodec(PackbitsCodec.class);
                            codec.decompress(this.getSource(), options);
                            while (this.getSource().read() == 0) {
                            }
                            this.getSource().seek(this.getSource().getFilePointer() - 1L);
                        }
                    }
                    this.getSource().skipBytes(i == 0 ? 64 : 53);
                    while (this.getSource().read() == 0) {
                    }
                    offsets[i] = this.getSource().getFilePointer() - 1L;
                    continue;
                }
                if (isJPEG || isJP2K) {
                    offsets[i] = i == 0 ? baseOffset : offsets[i - 1] + 3L;
                    byte secondCheck = isJPEG ? (byte)-40 : 79;
                    this.getSource().seek(offsets[i]);
                    byte[] buf = new byte[8192];
                    int n = this.getSource().read(buf);
                    boolean found = false;
                    while (!found) {
                        int q;
                        for (q = 0; q < n - 2; ++q) {
                            if (buf[q] != -1 || buf[q + 1] != secondCheck || buf[q + 2] != -1 || !isJPEG && (!isJP2K || buf[q + 3] != 81)) continue;
                            found = true;
                            offsets[i] = this.getSource().getFilePointer() + (long)q - (long)n;
                            break;
                        }
                        if (found) continue;
                        for (q = 0; q < 4; ++q) {
                            buf[q] = buf[buf.length + q - 4];
                        }
                        n = this.getSource().read(buf, 4, buf.length - 4) + 4;
                    }
                    continue;
                }
                offsets[i] = baseOffset + (long)(planeSize * i);
            }
            this.makeFileList(config);
        }

        @Override
        public String[] getImageUsedFiles(int imageIndex, boolean noPixels) {
            FormatTools.assertId(this.getSource(), true, 1);
            if (noPixels || ((Metadata)this.getMetadata()).getFileList() == null) {
                return null;
            }
            Object[] keys = ((Metadata)this.getMetadata()).getFileList().keySet().toArray(new Integer[0]);
            Arrays.sort(keys);
            Vector<String> files = ((Metadata)this.getMetadata()).getFileList().get(keys[imageIndex]);
            for (String f : ((Metadata)this.getMetadata()).getCompanionFiles()) {
                files.add(f);
            }
            return files == null ? null : files.toArray(new String[files.size()]);
        }

        private void makeFileList(SCIFIOConfig config) throws FormatException, IOException {
            this.log().info((Object)"Building file list");
            if (((Metadata)this.getMetadata()).getFileList() == null && ((Metadata)this.getMetadata()).getOriginalInstance() != null && ((Metadata)this.getMetadata()).getOriginalDate() != null && ((Metadata)this.getMetadata()).getOriginalTime() != null && config.groupableIsGroupFiles()) {
                Hashtable<Integer, Vector<String>> fileList = new Hashtable<Integer, Vector<String>>();
                Integer s = new Integer(((Metadata)this.getMetadata()).getOriginalSeries());
                fileList.put(s, new Vector());
                int instanceNumber = Integer.parseInt(((Metadata)this.getMetadata()).getOriginalInstance()) - 1;
                if (instanceNumber == 0) {
                    ((Vector)fileList.get(s)).add(this.getSource().getFileName());
                } else {
                    while (instanceNumber > ((Vector)fileList.get(s)).size()) {
                        ((Vector)fileList.get(s)).add(null);
                    }
                    ((Vector)fileList.get(s)).add(this.getSource().getFileName());
                }
                Location currentFile = new Location(this.getContext(), this.getSource().getFileName()).getAbsoluteFile();
                Location directory = currentFile.getParentFile();
                this.scanDirectory(fileList, directory, false);
                directory = directory.getParentFile();
                String[] subdirs = directory.list(true);
                if (subdirs != null) {
                    for (String subdir : subdirs) {
                        Location f = new Location(this.getContext(), directory, subdir).getAbsoluteFile();
                        if (!f.isDirectory()) continue;
                        this.scanDirectory(fileList, f, true);
                    }
                }
                Object[] keys = fileList.keySet().toArray(new Integer[0]);
                Arrays.sort(keys);
                for (Object key : keys) {
                    for (int j = 0; j < fileList.get(key).size(); ++j) {
                        if (fileList.get(key).get(j) != null) continue;
                        fileList.get(key).remove(j);
                        --j;
                    }
                }
                ((Metadata)this.getMetadata()).setFileList(fileList);
            } else if (((Metadata)this.getMetadata()).getFileList() == null) {
                Hashtable<Integer, Vector<String>> fileList = new Hashtable<Integer, Vector<String>>();
                fileList.put(0, new Vector());
                ((Vector)fileList.get(0)).add(this.getSource().getFileName());
                ((Metadata)this.getMetadata()).setFileList(fileList);
            }
        }

        private void attachCompanionFiles(Vector<String> companionFiles) {
            Location parent = new Location(this.getContext(), this.getSource().getFileName()).getAbsoluteFile().getParentFile();
            Location grandparent = parent.getParentFile();
            if (new Location(this.getContext(), grandparent, parent.getName() + ".mif").exists()) {
                String[] list;
                for (String f : list = grandparent.list(true)) {
                    Location file = new Location(this.getContext(), grandparent, f);
                    if (file.isDirectory()) continue;
                    companionFiles.add(file.getAbsolutePath());
                }
            }
        }

        private void scanDirectory(Hashtable<Integer, Vector<String>> fileList, Location dir, boolean checkSeries) throws FormatException, IOException {
            Location currentFile = new Location(this.getContext(), this.getSource().getFileName()).getAbsoluteFile();
            FilePattern pattern = new FilePattern(this.getContext(), currentFile.getName(), dir.getAbsolutePath());
            Object[] patternFiles = pattern.getFiles();
            if (patternFiles == null) {
                patternFiles = new String[]{};
            }
            Arrays.sort(patternFiles);
            Object[] files = dir.list(true);
            if (files == null) {
                return;
            }
            Arrays.sort(files);
            for (Object f : files) {
                String file = new Location(this.getContext(), dir, (String)f).getAbsolutePath();
                this.log().debug((Object)("Checking file " + file));
                if (((String)f).equals(this.getSource().getFileName()) || file.equals(this.getSource().getFileName()) || !this.getFormat().createChecker().isFormat(file) || Arrays.binarySearch(patternFiles, file.replaceAll("\\\\", "\\\\\\\\")) < 0) continue;
                this.addFileToList(fileList, file, checkSeries);
            }
        }

        private void addFileToList(Hashtable<Integer, Vector<String>> fileList, String file, boolean checkSeries) throws FormatException, IOException {
            long fp;
            RandomAccessInputStream stream = new RandomAccessInputStream(this.getContext(), file);
            if (!this.getFormat().createChecker().isFormat(stream)) {
                stream.close();
                return;
            }
            stream.order(true);
            stream.seek(128L);
            if (!stream.readString(4).equals(DICOMFormat.DICOM_MAGIC_STRING)) {
                stream.seek(0L);
            }
            int fileSeries = -1;
            String date = null;
            String time = null;
            String instance = null;
            while ((date == null || time == null || instance == null || checkSeries && fileSeries < 0) && (fp = stream.getFilePointer()) + 4L < stream.length() && fp >= 0L) {
                DICOMTag tag = DICOMUtils.getNextTag(stream);
                String key = TYPES.name(tag.get());
                if ("Instance Number".equals(key)) {
                    instance = stream.readString(tag.getElementLength()).trim();
                    if (instance.length() != 0) continue;
                    instance = null;
                    continue;
                }
                if ("Acquisition Time".equals(key)) {
                    time = stream.readString(tag.getElementLength());
                    continue;
                }
                if ("Acquisition Date".equals(key)) {
                    date = stream.readString(tag.getElementLength());
                    continue;
                }
                if ("Series Number".equals(key)) {
                    fileSeries = Integer.parseInt(stream.readString(tag.getElementLength()).trim());
                    continue;
                }
                stream.skipBytes(tag.getElementLength());
            }
            stream.close();
            if (date == null || time == null || instance == null || checkSeries && fileSeries == ((Metadata)this.getMetadata()).getOriginalSeries()) {
                return;
            }
            int stamp = 0;
            try {
                stamp = Integer.parseInt(time);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            int timestamp = 0;
            try {
                timestamp = Integer.parseInt(((Metadata)this.getMetadata()).getOriginalTime());
            }
            catch (NumberFormatException tag) {
                // empty catch block
            }
            if (date.equals(((Metadata)this.getMetadata()).getOriginalDate()) && Math.abs(stamp - timestamp) < 150) {
                int position = Integer.parseInt(instance) - 1;
                if (position < 0) {
                    position = 0;
                }
                if (fileList.get(fileSeries) == null) {
                    fileList.put(fileSeries, new Vector());
                }
                if (position < fileList.get(fileSeries).size()) {
                    while (position < fileList.get(fileSeries).size() && fileList.get(fileSeries).get(position) != null) {
                        ++position;
                    }
                    if (position < fileList.get(fileSeries).size()) {
                        fileList.get(fileSeries).setElementAt(file, position);
                    } else {
                        fileList.get(fileSeries).add(file);
                    }
                } else {
                    while (position > fileList.get(fileSeries).size()) {
                        fileList.get(fileSeries).add(null);
                    }
                    fileList.get(fileSeries).add(file);
                }
            }
        }

        private void addInfo(Metadata meta, DICOMTag tag, String value) throws IOException {
            String oldValue = value;
            String info = this.getHeaderInfo(tag, value);
            if (info != null && tag.get() != -73728) {
                String key;
                if ((info = info.trim()).equals("")) {
                    String string = info = oldValue == null ? "" : oldValue.trim();
                }
                if ((key = TYPES.name(tag.get())) == null) {
                    key = this.formatTag(tag.get());
                }
                if (key.equals("Samples per pixel")) {
                    int sizeC = Integer.parseInt(info);
                    if (sizeC > 1) {
                        meta.get(0).setAxisLength(Axes.CHANNEL, (long)sizeC);
                        meta.get(0).setPlanarAxisCount(2);
                    }
                } else if (key.equals("Photometric Interpretation")) {
                    if (info.equals("PALETTE COLOR")) {
                        meta.get(0).setIndexed(true);
                        meta.get(0).setAxisLength(Axes.CHANNEL, 1L);
                        meta.lut = new byte[3][];
                        meta.shortLut = new short[3][];
                    } else if (info.startsWith("MONOCHROME")) {
                        meta.setInverted(info.endsWith("1"));
                    }
                } else if (key.equals("Acquisition Date")) {
                    meta.setOriginalDate(info);
                } else if (key.equals("Acquisition Time")) {
                    meta.setOriginalTime(info);
                } else if (key.equals("Instance Number")) {
                    if (info.trim().length() > 0) {
                        meta.setOriginalInstance(info);
                    }
                } else if (key.equals("Series Number")) {
                    try {
                        meta.setOriginalSeries(Integer.parseInt(info));
                    }
                    catch (NumberFormatException sizeC) {}
                } else if (key.contains("Palette Color LUT Data")) {
                    String color = key.substring(0, key.indexOf(" ")).trim();
                    int ndx = color.equals("Red") ? 0 : (color.equals("Green") ? 1 : 2);
                    long fp = this.getSource().getFilePointer();
                    this.getSource().seek(this.getSource().getFilePointer() - (long)tag.getElementLength() + 1L);
                    meta.shortLut[ndx] = new short[tag.getElementLength() / 2];
                    meta.lut[ndx] = new byte[tag.getElementLength() / 2];
                    for (int i = 0; i < meta.lut[ndx].length; ++i) {
                        meta.shortLut[ndx][i] = this.getSource().readShort();
                        meta.lut[ndx][i] = (byte)(meta.shortLut[ndx][i] & 0xFF);
                    }
                    this.getSource().seek(fp);
                } else if (key.equals("Content Time")) {
                    meta.setTime(info);
                } else if (key.equals("Content Date")) {
                    meta.setDate(info);
                } else if (key.equals("Image Type")) {
                    meta.setImageType(info);
                } else if (key.equals("Rescale Intercept")) {
                    meta.setRescaleIntercept(Double.parseDouble(info));
                } else if (key.equals("Rescale Slope")) {
                    meta.setRescaleSlope(Double.parseDouble(info));
                } else if (key.equals("Pixel Spacing")) {
                    meta.setPixelSizeX(info.substring(0, info.indexOf("\\")));
                    meta.setPixelSizeY(info.substring(info.lastIndexOf("\\") + 1));
                } else if (key.equals("Spacing Between Slices")) {
                    meta.setPixelSizeZ(new Double(info));
                }
                if ((tag.get() & 0xFFFF0000) >> 16 != 32736) {
                    key = this.formatTag(tag.get()) + " " + key;
                    int imageIndex = meta.getImageCount() - 1;
                    Object v = meta.get(imageIndex).getTable().get(key);
                    if (v != null) {
                        meta.get(imageIndex).getTable().remove(key);
                        meta.get(imageIndex).getTable().putList(key, v);
                        meta.get(imageIndex).getTable().putList(key, info);
                    } else {
                        meta.get(imageIndex).getTable().put(key, info);
                    }
                }
            }
        }

        private String formatTag(int tag) {
            String s = Integer.toHexString(tag);
            while (s.length() < 8) {
                s = "0" + s;
            }
            return s.substring(0, 4) + "," + s.substring(4);
        }

        private void addInfo(Metadata meta, DICOMTag tag, int value) throws IOException {
            this.addInfo(meta, tag, Integer.toString(value));
        }

        private String getHeaderInfo(DICOMTag tag, String value) throws IOException {
            if (tag.get() == -73715 || tag.get() == -73507) {
                tag.setInSequence(false);
            }
            String id = TYPES.name(tag.get());
            int vr = tag.getVR();
            if (id != null) {
                if (vr == 11565) {
                    String vrName = TYPES.vr(tag.get());
                    vr = (vrName.charAt(0) << 8) + vrName.charAt(1);
                    tag.setVR(vr);
                }
                if (id.length() > 2) {
                    id = id.substring(2);
                }
            }
            if (tag.get() == -73728) {
                return id != null ? id : null;
            }
            if (value != null) {
                return value;
            }
            boolean skip = false;
            switch (vr) {
                case 16709: 
                case 16723: 
                case 16724: {
                    byte[] bytes = new byte[tag.getElementLength()];
                    this.getSource().readFully(bytes);
                    if (tag.littleEndian) {
                        for (int i = 0; i < bytes.length / 2; ++i) {
                            byte t = bytes[2 * i];
                            bytes[2 * i] = bytes[2 * i + 1];
                            bytes[2 * i + 1] = t;
                        }
                    }
                    value = DigestUtils.hex((byte[])bytes);
                    break;
                }
                case 17235: 
                case 17473: 
                case 17491: 
                case 17492: 
                case 18771: 
                case 19535: 
                case 19540: 
                case 20558: 
                case 21320: 
                case 21332: 
                case 21581: 
                case 21833: {
                    value = this.getSource().readString(tag.getElementLength());
                    break;
                }
                case 21843: {
                    if (tag.getElementLength() == 2) {
                        value = Integer.toString(this.getSource().readShort());
                        break;
                    }
                    value = "";
                    int n = tag.getElementLength() / 2;
                    for (int i = 0; i < n; ++i) {
                        value = value + Integer.toString(this.getSource().readShort()) + " ";
                    }
                    break;
                }
                case 11565: {
                    value = this.getSource().readString(tag.getElementLength());
                    if (tag.getElementLength() > 4 && tag.getElementLength() <= 44) break;
                    value = null;
                    break;
                }
                case 21329: {
                    boolean privateTag;
                    value = "";
                    boolean bl = privateTag = (tag.getElementLength() >> 16 & 1) != 0;
                    if (tag.get() != 0x880200 && !privateTag) break;
                    skip = true;
                    break;
                }
                default: {
                    skip = true;
                }
            }
            if (skip) {
                long skipCount = tag.getElementLength();
                if (this.getSource().getFilePointer() + skipCount <= this.getSource().length()) {
                    this.getSource().skipBytes((int)skipCount);
                }
                tag.addLocation(tag.getElementLength());
                value = "";
            }
            if (value != null && id == null && !value.equals("")) {
                return value;
            }
            if (id == null) {
                return null;
            }
            return value;
        }
    }

    public static class Checker
    extends AbstractChecker {
        private static final String[] DICOM_SUFFIXES = new String[]{"dic", "dcm", "dicom", "j2ki", "j2kr"};

        @Override
        public boolean suffixNecessary() {
            return false;
        }

        @Override
        public boolean suffixSufficient() {
            return false;
        }

        @Override
        public boolean isFormat(String name, SCIFIOConfig config) {
            if (FormatTools.checkSuffix(name, DICOM_SUFFIXES)) {
                return true;
            }
            return super.isFormat(name, config);
        }

        @Override
        public boolean isFormat(RandomAccessInputStream stream) throws IOException {
            int blockLen = 2048;
            if (!FormatTools.validStream(stream, 2048, true)) {
                return false;
            }
            stream.seek(128L);
            if (stream.readString(4).equals(DICOMFormat.DICOM_MAGIC_STRING)) {
                return true;
            }
            stream.seek(0L);
            try {
                int tag = DICOMUtils.getNextTag(stream).get();
                return TYPES.has(tag);
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (FormatException formatException) {
                // empty catch block
            }
            return false;
        }
    }

    public static class Metadata
    extends AbstractMetadata
    implements HasColorTable {
        byte[][] lut = null;
        short[][] shortLut = null;
        private ColorTable8 lut8;
        private ColorTable16 lut16;
        private long[] offsets = null;
        private boolean isJP2K = false;
        private boolean isJPEG = false;
        private boolean isRLE = false;
        private boolean isDeflate = false;
        private boolean oddLocations = false;
        private int maxPixelValue;
        private int imagesPerFile = 0;
        private double rescaleSlope = 1.0;
        private double rescaleIntercept = 0.0;
        private Hashtable<Integer, Vector<String>> fileList;
        private boolean inverted = false;
        private String pixelSizeX;
        private String pixelSizeY;
        private Double pixelSizeZ;
        private String date;
        private String time;
        private String imageType;
        private String originalDate;
        private String originalTime;
        private String originalInstance;
        private int originalSeries;
        private Vector<String> companionFiles = new Vector();

        public long[] getOffsets() {
            return this.offsets;
        }

        public void setOffsets(long[] offsets) {
            this.offsets = offsets;
        }

        public double getRescaleSlope() {
            return this.rescaleSlope;
        }

        public void setRescaleSlope(double rescaleSlope) {
            this.rescaleSlope = rescaleSlope;
        }

        public double getRescaleIntercept() {
            return this.rescaleIntercept;
        }

        public void setRescaleIntercept(double rescaleIntercept) {
            this.rescaleIntercept = rescaleIntercept;
        }

        public String getPixelSizeX() {
            return this.pixelSizeX;
        }

        public void setPixelSizeX(String pixelSizeX) {
            this.pixelSizeX = pixelSizeX;
        }

        public String getPixelSizeY() {
            return this.pixelSizeY;
        }

        public void setPixelSizeY(String pixelSizeY) {
            this.pixelSizeY = pixelSizeY;
        }

        public Double getPixelSizeZ() {
            return this.pixelSizeZ;
        }

        public void setPixelSizeZ(Double pixelSizeZ) {
            this.pixelSizeZ = pixelSizeZ;
        }

        public boolean isInverted() {
            return this.inverted;
        }

        public void setInverted(boolean inverted) {
            this.inverted = inverted;
        }

        public boolean isJP2K() {
            return this.isJP2K;
        }

        public void setJP2K(boolean isJP2K) {
            this.isJP2K = isJP2K;
        }

        public boolean isJPEG() {
            return this.isJPEG;
        }

        public void setJPEG(boolean isJPEG) {
            this.isJPEG = isJPEG;
        }

        public boolean isRLE() {
            return this.isRLE;
        }

        public void setRLE(boolean isRLE) {
            this.isRLE = isRLE;
        }

        public boolean isDeflate() {
            return this.isDeflate;
        }

        public void setDeflate(boolean isDeflate) {
            this.isDeflate = isDeflate;
        }

        public boolean isOddLocations() {
            return this.oddLocations;
        }

        public void setOddLocations(boolean oddLocations) {
            this.oddLocations = oddLocations;
        }

        public int getMaxPixelValue() {
            return this.maxPixelValue;
        }

        public void setMaxPixelValue(int maxPixelValue) {
            this.maxPixelValue = maxPixelValue;
        }

        public int getImagesPerFile() {
            return this.imagesPerFile;
        }

        public void setImagesPerFile(int imagesPerFile) {
            this.imagesPerFile = imagesPerFile;
        }

        public Hashtable<Integer, Vector<String>> getFileList() {
            return this.fileList;
        }

        public void setFileList(Hashtable<Integer, Vector<String>> fileList) {
            this.fileList = fileList;
        }

        public String getDate() {
            return this.date;
        }

        public void setDate(String date) {
            this.date = date;
        }

        public String getTime() {
            return this.time;
        }

        public void setTime(String time) {
            this.time = time;
        }

        public String getImageType() {
            return this.imageType;
        }

        public void setImageType(String imageType) {
            this.imageType = imageType;
        }

        public String getOriginalDate() {
            return this.originalDate;
        }

        public void setOriginalDate(String originalDate) {
            this.originalDate = originalDate;
        }

        public String getOriginalTime() {
            return this.originalTime;
        }

        public void setOriginalTime(String originalTime) {
            this.originalTime = originalTime;
        }

        public String getOriginalInstance() {
            return this.originalInstance;
        }

        public void setOriginalInstance(String originalInstance) {
            this.originalInstance = originalInstance;
        }

        public int getOriginalSeries() {
            return this.originalSeries;
        }

        public void setOriginalSeries(int originalSeries) {
            this.originalSeries = originalSeries;
        }

        public Vector<String> getCompanionFiles() {
            return this.companionFiles;
        }

        public void setCompanionFiles(Vector<String> companionFiles) {
            this.companionFiles = companionFiles;
        }

        @Override
        public ColorTable getColorTable(int imageIndex, long planeIndex) {
            int pixelType = this.get(0).getPixelType();
            switch (pixelType) {
                case 0: 
                case 1: {
                    if (this.lut != null && this.lut8 == null) {
                        this.lut8 = new ColorTable8(this.lut);
                    }
                    return this.lut8;
                }
                case 2: 
                case 3: {
                    if (this.shortLut != null && this.lut16 == null) {
                        this.lut16 = new ColorTable16(this.shortLut);
                    }
                    return this.lut16;
                }
            }
            return null;
        }

        @Override
        public void populateImageMetadata() {
            this.log().info((Object)"Populating metadata");
            int seriesCount = this.fileList.size();
            Object[] keys = this.fileList.keySet().toArray(new Integer[0]);
            Arrays.sort(keys);
            for (int i = 0; i < seriesCount; ++i) {
                this.get(i).setAxisTypes(Axes.X, Axes.Y);
                int sizeZ = 0;
                if (seriesCount == 1) {
                    sizeZ = this.getOffsets().length * this.fileList.get(keys[i]).size();
                    this.get(i).setMetadataComplete(true);
                    this.get(i).setFalseColor(false);
                    if (this.isRLE) {
                        this.get(i).setAxisTypes(Axes.X, Axes.Y, Axes.CHANNEL);
                    }
                    if (this.get(i).getAxisLength(Axes.CHANNEL) > 1L) {
                        this.get(i).setPlanarAxisCount(3);
                    } else {
                        this.get(i).setPlanarAxisCount(2);
                    }
                } else {
                    try {
                        Parser p = (Parser)this.getFormat().createParser();
                        Metadata m = (Metadata)p.parse(this.fileList.get(keys[i]).get(0), new SCIFIOConfig().groupableSetGroupFiles(false));
                        this.add(m.get(0));
                        sizeZ *= this.fileList.get(keys[i]).size();
                    }
                    catch (IOException e) {
                        this.log().error((Object)"Error creating Metadata from DICOM companion files.", (Throwable)e);
                    }
                    catch (FormatException e) {
                        this.log().error((Object)"Error creating Metadata from DICOM companion files.", (Throwable)e);
                    }
                }
                this.get(i).setAxisLength(Axes.Z, (long)sizeZ);
            }
        }

        @Override
        public void close(boolean fileOnly) throws IOException {
            super.close(fileOnly);
            if (!fileOnly) {
                this.oddLocations = false;
                this.isDeflate = false;
                this.isRLE = false;
                this.isJP2K = false;
                this.isJPEG = false;
                this.lut = null;
                this.offsets = null;
                this.shortLut = null;
                this.maxPixelValue = 0;
                this.rescaleSlope = 1.0;
                this.rescaleIntercept = 0.0;
                this.pixelSizeY = null;
                this.pixelSizeX = null;
                this.pixelSizeZ = null;
                this.imagesPerFile = 0;
                this.fileList = null;
                this.inverted = false;
                this.imageType = null;
                this.time = null;
                this.date = null;
                this.originalInstance = null;
                this.originalTime = null;
                this.originalDate = null;
                this.originalSeries = 0;
            }
        }
    }
}

