/*
 * Decompiled with CFR 0.152.
 */
package io.scif.filters;

import io.scif.ByteArrayPlane;
import io.scif.ByteArrayReader;
import io.scif.FilePattern;
import io.scif.FormatException;
import io.scif.Metadata;
import io.scif.Plane;
import io.scif.Reader;
import io.scif.config.SCIFIOConfig;
import io.scif.filters.AbstractReaderFilter;
import io.scif.filters.Filter;
import io.scif.io.Location;
import io.scif.services.FilePatternService;
import io.scif.services.InitializeService;
import io.scif.services.LocationService;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import net.imagej.axis.Axes;
import net.imagej.axis.AxisType;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Filter.class)
public class FileStitcher
extends AbstractReaderFilter {
    @Parameter
    private InitializeService initializeService;
    @Parameter
    private FilePatternService filePatternService;
    @Parameter
    private LocationService locationService;
    private boolean patternIds = false;
    private boolean doNotChangePattern = false;
    private int[] imagesPerFile = null;
    private Reader[] readers = null;
    private String[] files = null;
    private FilePattern pattern;
    private boolean noStitch;

    public FileStitcher() {
        this(false);
    }

    public FileStitcher(boolean patternIds) {
        this.setUsingPatternIds(patternIds);
    }

    public void setUsingPatternIds(boolean patternIds) {
        this.patternIds = patternIds;
    }

    public boolean isUsingPatternIds() {
        return this.patternIds;
    }

    public void setCanChangePattern(boolean doChange) {
        this.doNotChangePattern = !doChange;
    }

    public boolean canChangePattern() {
        return !this.doNotChangePattern;
    }

    public Reader getReader(int imageIndex) throws FormatException, IOException {
        if (this.noStitch) {
            return (Reader)this.getParent();
        }
        int[] fileIndex = this.computeFileIndex(imageIndex);
        Reader r = this.readers[fileIndex[0]];
        if (r == null) {
            this.readers[fileIndex[0]] = r = this.initializeService.initializeReader(this.files[imageIndex]);
        }
        return r;
    }

    public Metadata getMetadata(int imageIndex) throws FormatException, IOException {
        if (this.noStitch) {
            return ((Reader)this.getParent()).getMetadata();
        }
        return this.getReader(imageIndex).getMetadata();
    }

    public FilePattern getFilePattern() {
        return this.pattern;
    }

    public FilePattern findPattern(String id) {
        return new FilePattern(this.getContext(), this.filePatternService.findPattern(id));
    }

    public String[] findPatterns(String id) {
        if (!this.patternIds) {
            HashMap<String, Object> map = this.locationService.getIdMap();
            if (map.containsKey(id)) {
                String[] idList = new String[map.size()];
                map.keySet().toArray(idList);
                return this.filePatternService.findImagePatterns(id, null, idList);
            }
            return this.filePatternService.findImagePatterns(id);
        }
        if (this.doNotChangePattern) {
            return new String[]{id};
        }
        this.patternIds = false;
        String[] patterns = this.findPatterns(new FilePattern(this.getContext(), id).getFiles()[0]);
        if (patterns.length == 0) {
            patterns = new String[]{id};
        } else {
            FilePattern test = new FilePattern(this.getContext(), patterns[0]);
            if (test.getFiles().length == 0) {
                patterns = new String[]{id};
            }
        }
        this.patternIds = true;
        return patterns;
    }

    @Override
    protected void setSourceHelper(String source, SCIFIOConfig config) {
        try {
            String[] patterns;
            this.cleanUp();
            this.log().debug((Object)("initFile: " + source));
            FilePattern fp = new FilePattern(this.getContext(), source);
            this.patternIds = !this.patternIds ? fp.isValid() && fp.getFiles().length > 1 : !new Location(this.getContext(), source).exists() && this.locationService.getMappedId(source).equals(source);
            boolean mustGroup = false;
            if (this.patternIds) {
                mustGroup = fp.isValid() && ((Reader)this.getParent()).fileGroupOption(fp.getFiles()[0]) == 0;
            } else {
                boolean bl = mustGroup = ((Reader)this.getParent()).fileGroupOption(source) == 0;
            }
            if (mustGroup) {
                this.noStitch = true;
                ((Reader)this.getParent()).close();
                if (this.patternIds && fp.isValid()) {
                    ((Reader)this.getParent()).setSource(fp.getFiles()[0], config);
                } else {
                    ((Reader)this.getParent()).setSource(source, config);
                }
                return;
            }
            if (fp.isRegex()) {
                this.setCanChangePattern(false);
            }
            if ((patterns = this.findPatterns(source)).length == 0) {
                patterns = new String[]{source};
            }
            this.readers = new Reader[patterns.length];
            fp = new FilePattern(this.getContext(), patterns[0]);
            ((Reader)this.getParent()).close();
            if (!fp.isValid()) {
                throw new FormatException("Invalid file pattern: " + fp.getPattern());
            }
            ((Reader)this.getParent()).setSource(fp.getFiles()[0], config);
            String msg = " Please rename your files or disable file stitching.";
            boolean nPixelsFiles = true;
            if (fp.getFiles().length == 1) {
                this.noStitch = true;
                return;
            }
            if (!fp.isValid()) {
                throw new FormatException("Invalid " + (this.patternIds ? "file pattern" : "filename") + " (" + source + "): " + fp.getErrorMessage() + " Please rename your files or disable file stitching.");
            }
            String[] files = fp.getFiles();
            if (files == null) {
                throw new FormatException("No files matching pattern (" + fp.getPattern() + "). " + " Please rename your files or disable file stitching.");
            }
            for (int i = 0; i < files.length; ++i) {
                String file = files[i];
                if (file.toLowerCase().endsWith(".fake") || new Location(this.getContext(), file).exists()) continue;
                throw new FormatException("File #" + i + " (" + file + ") does not exist.");
            }
            this.files = files;
            this.pattern = fp;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (FormatException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isCompatible(Class<?> c) {
        return ByteArrayReader.class.isAssignableFrom(c);
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, Plane plane, long[] offsets, long[] lengths, SCIFIOConfig config) throws FormatException, IOException {
        Plane bp;
        if (this.noStitch) {
            return ((Reader)this.getParent()).openPlane(imageIndex, planeIndex, plane, offsets, lengths, new SCIFIOConfig().groupableSetGroupFiles(false));
        }
        if (plane == null || !this.isCompatible(plane.getClass())) {
            bp = new ByteArrayPlane(this.getContext());
            bp.populate(plane);
            ((ByteArrayPlane)bp).setData(new byte[plane.getBytes().length]);
        } else {
            bp = plane;
        }
        int[] adjustedIndex = this.computeFileIndex(imageIndex);
        if (adjustedIndex[0] < this.readers.length && adjustedIndex[1] < this.readers[adjustedIndex[0]].getImageCount()) {
            Reader r = this.readers[adjustedIndex[0]];
            return r.openPlane(adjustedIndex[1], planeIndex, bp, offsets, lengths, config);
        }
        Arrays.fill(bp.getBytes(), (byte)0);
        return bp;
    }

    @Override
    public Plane openThumbPlane(int imageIndex, long planeIndex) throws FormatException, IOException {
        if (this.noStitch) {
            return ((Reader)this.getParent()).openThumbPlane(imageIndex, planeIndex);
        }
        int[] adjustedIndex = this.computeFileIndex(imageIndex);
        if (adjustedIndex[0] < this.readers.length && adjustedIndex[1] < this.readers[adjustedIndex[0]].getImageCount()) {
            Reader r = this.readers[adjustedIndex[0]];
            return r.openThumbPlane(adjustedIndex[1], planeIndex);
        }
        long[] thumbPlaneOffsets = new long[this.getParentMeta().get(0).getAxesPlanar().size()];
        long[] thumbPlaneBounds = this.getParentMeta().get(0).getAxesLengths();
        thumbPlaneBounds[this.getParentMeta().get((int)0).getAxisIndex((AxisType)Axes.X)] = this.getParentMeta().get(0).getThumbSizeX();
        thumbPlaneBounds[this.getParentMeta().get((int)0).getAxisIndex((AxisType)Axes.Y)] = this.getParentMeta().get(0).getThumbSizeY();
        return ((Reader)this.getParent()).createPlane(thumbPlaneOffsets, thumbPlaneBounds);
    }

    @Override
    public Reader[] getUnderlyingReaders() {
        return this.readers;
    }

    public double getPriority() {
        return 3.0;
    }

    private int[] computeFileIndex(int imageIndex) {
        if (this.noStitch) {
            return new int[]{imageIndex, 0};
        }
        int fileIndex = 0;
        while (imageIndex >= this.imagesPerFile[fileIndex]) {
            imageIndex -= this.imagesPerFile[fileIndex++];
        }
        return new int[]{fileIndex, imageIndex};
    }

    @Override
    protected void cleanUp() throws IOException {
        super.cleanUp();
        this.patternIds = false;
        this.doNotChangePattern = false;
        this.imagesPerFile = null;
        for (Reader r : this.readers) {
            if (r == null) continue;
            r.close();
        }
        this.readers = null;
        this.files = null;
        this.pattern = null;
        this.noStitch = false;
    }
}

