/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import ij.ImagePlus;
import ij.process.ByteProcessor;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import mpicbg.models.AbstractModel;
import mpicbg.models.AffineModel2D;
import mpicbg.models.CoordinateTransform;
import mpicbg.models.ErrorStatistic;
import mpicbg.models.IllDefinedDataPointsException;
import mpicbg.models.MovingLeastSquaresMesh;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.Point;
import mpicbg.models.PointMatch;
import mpicbg.models.Tile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElasticMovingLeastSquaresMesh<M extends AbstractModel<M>>
extends MovingLeastSquaresMesh<M> {
    private static final long serialVersionUID = 4370634883524169318L;
    protected final HashSet<Tile<M>> fixedTiles = new HashSet();
    private static final DecimalFormat decimalFormat = new DecimalFormat();
    private static final DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
    protected final double alpha;

    public ElasticMovingLeastSquaresMesh(Class<M> modelClass, int numX, int numY, double width, double height, double alpha) {
        super(modelClass, numX, numY, width, height);
        decimalFormatSymbols.setGroupingSeparator(',');
        decimalFormatSymbols.setDecimalSeparator('.');
        decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        decimalFormat.setMaximumFractionDigits(3);
        decimalFormat.setMinimumFractionDigits(3);
        this.alpha = alpha;
        Set s = this.va.keySet();
        double[] w = new double[2];
        w[0] = 1.0f / (float)s.size();
        for (PointMatch vertex : s) {
            HashSet<PointMatch> connectedVertices = new HashSet<PointMatch>();
            for (AffineModel2D ai : (ArrayList)this.va.get(vertex)) {
                for (PointMatch m : (ArrayList)this.av.get(ai)) {
                    if (vertex == m) continue;
                    connectedVertices.add(m);
                }
            }
            Tile t = (Tile)this.pt.get(vertex);
            for (PointMatch m : connectedVertices) {
                Tile o = (Tile)this.pt.get(m);
                Point p2 = m.getP2();
                Point p1 = new Point((double[])p2.getW().clone());
                w[1] = this.weigh(Point.squareDistance(vertex.getP1(), p2), alpha);
                t.addMatch(new PointMatch(p1, p2, w, 1.0));
                t.addConnectedTile(o);
            }
        }
    }

    public ElasticMovingLeastSquaresMesh(Class<M> modelClass, int numX, double width, double height, double alpha) {
        this(modelClass, numX, ElasticMovingLeastSquaresMesh.numY(numX, width, height), width, height, alpha);
    }

    public final void update(double amount) {
        Set s = this.va.keySet();
        for (PointMatch m : s) {
            Tile t = (Tile)this.pt.get(m);
            m.getP2().apply((CoordinateTransform)t.getModel(), amount);
            t.update(amount);
        }
        double cd = 0.0;
        double min_d = Double.MAX_VALUE;
        double max_d = Double.MIN_VALUE;
        for (PointMatch m : s) {
            double d = ((Tile)this.pt.get(m)).getDistance();
            if (d < min_d) {
                min_d = d;
            }
            if (d > max_d) {
                max_d = d;
            }
            cd += d;
        }
        this.error = cd /= (double)this.pt.size();
    }

    public final void optimizeIteration(ErrorStatistic observer) throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        Set s = this.va.keySet();
        this.error = 0.0;
        for (PointMatch m : s) {
            Tile t = (Tile)this.pt.get(m);
            if (this.fixedTiles.contains(t)) continue;
            t.fitModel();
            t.update();
            m.getP2().apply((CoordinateTransform)t.getModel());
            this.error += t.getDistance();
            this.updateAffine(m);
        }
        this.error /= (double)s.size();
        observer.add(this.error);
    }

    public final void optimizeIteration() throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        Set s = this.va.keySet();
        for (PointMatch m : s) {
            Tile t = (Tile)this.pt.get(m);
            if (this.fixedTiles.contains(t)) continue;
            t.fitModel();
        }
    }

    public void fixTile(Tile<M> t) {
        this.fixedTiles.add(t);
    }

    public final void optimize(double maxError, int maxIterations, int maxPlateauwidth) throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        int i;
        ErrorStatistic observer = new ErrorStatistic(maxPlateauwidth + 1);
        for (i = 0; i < maxIterations; ++i) {
            this.optimizeIteration();
            this.update(0.1f);
            observer.add(this.error);
            if (i >= maxPlateauwidth && this.error < maxError && Math.abs(observer.getWideSlope(maxPlateauwidth)) <= 1.0E-5 && Math.abs(observer.getWideSlope(maxPlateauwidth / 2)) <= 1.0E-5) break;
        }
        this.updateAffines();
        System.out.println("Exiting at iteration " + i + " with error " + decimalFormat.format(observer.mean) + " and slope " + observer.getWideSlope(maxPlateauwidth));
        System.out.println("Successfully optimized configuration of " + this.pt.size() + " tiles:");
        System.out.println("  average displacement: " + decimalFormat.format(observer.mean) + "px");
        System.out.println("  minimal displacement: " + decimalFormat.format(observer.min) + "px");
        System.out.println("  maximal displacement: " + decimalFormat.format(observer.max) + "px");
    }

    public final void optimizeByStrength(double maxError, int maxIterations, int maxPlateauwidth, ByteProcessor ipPlot, ImagePlus impPlot) throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        int i;
        ErrorStatistic observer = new ErrorStatistic(maxPlateauwidth + 1);
        ipPlot.setColor(Color.white);
        ipPlot.fill();
        impPlot.updateAndDraw();
        for (i = 0; i < maxIterations; ++i) {
            this.optimizeIteration();
            this.update(0.75);
            observer.add(this.error);
            ipPlot.set((int)((double)i * (double)ipPlot.getWidth() / (double)maxIterations), Math.min(ipPlot.getHeight() - 1, Math.max(0, ipPlot.getHeight() / 2 - (int)(Math.log(observer.values.get(observer.values.size() - 1)) * 10.0))), 0);
            impPlot.updateAndDraw();
            if (i >= maxPlateauwidth && this.error < maxError && Math.abs(observer.getWideSlope(maxPlateauwidth)) <= 1.0E-4 && Math.abs(observer.getWideSlope(maxPlateauwidth / 2)) <= 1.0E-4) break;
        }
        this.updateAffines();
        System.out.println("Exiting at iteration " + i + " with error " + decimalFormat.format(observer.mean) + " and slope " + decimalFormat.format(observer.getWideSlope(maxPlateauwidth)));
        System.out.println("Successfully optimized configuration of " + this.pt.size() + " vertices:");
        System.out.println("  average displacement: " + decimalFormat.format(observer.mean) + "px");
        System.out.println("  minimal displacement: " + decimalFormat.format(observer.min) + "px");
        System.out.println("  maximal displacement: " + decimalFormat.format(observer.max) + "px");
    }

    public final Shape illustratePointMatches() {
        Set s = this.va.keySet();
        GeneralPath path = new GeneralPath();
        for (PointMatch m : s) {
            Tile t = (Tile)this.pt.get(m);
            for (PointMatch ma : t.getMatches()) {
                double[] l = ma.getP1().getW();
                path.moveTo(l[0] - 1.0, l[1] - 1.0);
                path.lineTo(l[0] + 1.0, l[1] - 1.0);
                path.lineTo(l[0] + 1.0, l[1] + 1.0);
                path.lineTo(l[0] - 1.0, l[1] + 1.0);
                path.closePath();
            }
        }
        return path;
    }

    public final Shape illustratePointMatchDisplacements() {
        Set s = this.va.keySet();
        GeneralPath path = new GeneralPath();
        for (PointMatch m : s) {
            Tile t = (Tile)this.pt.get(m);
            for (PointMatch ma : t.getMatches()) {
                double[] l = ma.getP1().getW();
                double[] k = ma.getP2().getW();
                path.moveTo(l[0], l[1]);
                path.lineTo(k[0], k[1]);
            }
        }
        return path;
    }
}

