/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imagefeatures;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import mpicbg.imagefeatures.Feature;
import mpicbg.imagefeatures.Filter;
import mpicbg.imagefeatures.FloatArray2D;
import mpicbg.imagefeatures.FloatArray2DFeatureTransform;
import mpicbg.imagefeatures.FloatArray2DScaleOctave;
import mpicbg.imagefeatures.FloatArray2DScaleOctaveDoGDetector;
import mpicbg.models.AbstractModel;
import mpicbg.models.Point;
import mpicbg.models.PointMatch;
import mpicbg.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatArray2DSIFT
extends FloatArray2DFeatureTransform<Param> {
    private final int fdWidth;
    private final float fdBinWidth;
    private float[] sigma;
    private float[] sigma_diff;
    private float[][] kernel_diff;
    private final float[][] descriptorMask;
    private static final int ORIENTATION_BINS = 36;
    private static final int ORIENTATION_BINS1 = 35;
    private static final double ORIENTATION_BIN_SIZE = 0.17453292519943295;
    private FloatArray2DScaleOctave[] octaves = null;
    private final FloatArray2DScaleOctaveDoGDetector dog = new FloatArray2DScaleOctaveDoGDetector();

    public FloatArray2DScaleOctave[] getOctaves() {
        return this.octaves;
    }

    public FloatArray2DScaleOctave getOctave(int i) {
        return this.octaves[i];
    }

    public FloatArray2DSIFT(Param p) {
        super(p);
        this.fdWidth = 4 * p.fdSize;
        this.fdBinWidth = (float)Math.PI * 2 / (float)p.fdBins;
        this.descriptorMask = new float[this.fdWidth][this.fdWidth];
        float two_sq_sigma = p.fdSize * p.fdSize * 8;
        for (int y = p.fdSize * 2 - 1; y >= 0; --y) {
            float fy = (float)y + 0.5f;
            for (int x = p.fdSize * 2 - 1; x >= 0; --x) {
                float val;
                float fx = (float)x + 0.5f;
                this.descriptorMask[2 * p.fdSize - 1 - y][2 * p.fdSize - 1 - x] = val = (float)Math.exp(-(fy * fy + fx * fx) / two_sq_sigma);
                this.descriptorMask[2 * p.fdSize + y][2 * p.fdSize - 1 - x] = val;
                this.descriptorMask[2 * p.fdSize - 1 - y][2 * p.fdSize + x] = val;
                this.descriptorMask[2 * p.fdSize + y][2 * p.fdSize + x] = val;
            }
        }
        this.setInitialSigma(p.initialSigma);
    }

    @Override
    public final void init(FloatArray2D src) {
        int o = 0;
        float w = src.width;
        float h = src.height;
        int max_kernel_size = this.kernel_diff[((Param)this.p).steps + 2].length;
        while (w > (float)Math.max(max_kernel_size, ((Param)this.p).minOctaveSize - 1) && h > (float)Math.max(max_kernel_size, ((Param)this.p).minOctaveSize - 1)) {
            w /= 2.0f;
            h /= 2.0f;
            ++o;
        }
        this.octaves = new FloatArray2DScaleOctave[o];
        for (int i = 0; i < this.octaves.length; ++i) {
            this.octaves[i] = new FloatArray2DScaleOctave(src, this.sigma, this.sigma_diff, this.kernel_diff);
            this.octaves[i].buildStub();
            FloatArray2D next = new FloatArray2D(src.width / 2 + src.width % 2, src.height / 2 + src.height % 2);
            FloatArray2DScaleOctave.downsample(this.octaves[i].getL(1), next);
            if (src.width > ((Param)this.p).maxOctaveSize || src.height > ((Param)this.p).maxOctaveSize) {
                this.octaves[i].clear();
            }
            src = next;
        }
    }

    private float[] createDescriptor(double[] c, int o, double octave_sigma, double orientation) {
        int x;
        FloatArray2DScaleOctave octave = this.octaves[o];
        FloatArray2D[] gradients = octave.getL1((int)Math.round(c[2]));
        FloatArray2D[] region = new FloatArray2D[]{new FloatArray2D(this.fdWidth, this.fdWidth), new FloatArray2D(this.fdWidth, this.fdWidth)};
        double cos_o = Math.cos(orientation);
        double sin_o = Math.sin(orientation);
        for (int y = this.fdWidth - 1; y >= 0; --y) {
            double ys = ((double)y - 2.0 * (double)((Param)this.p).fdSize + 0.5) * octave_sigma;
            for (x = this.fdWidth - 1; x >= 0; --x) {
                double xs = ((double)x - 2.0 * (double)((Param)this.p).fdSize + 0.5) * octave_sigma;
                double yr = cos_o * ys + sin_o * xs;
                double xr = cos_o * xs - sin_o * ys;
                int yg = Util.pingPong((int)Math.round(yr + c[1]), gradients[0].height);
                int xg = Util.pingPong((int)Math.round(xr + c[0]), gradients[0].width);
                int region_p = this.fdWidth * y + x;
                int gradient_p = gradients[0].width * yg + xg;
                region[0].data[region_p] = gradients[0].data[gradient_p] * this.descriptorMask[y][x];
                region[1].data[region_p] = (float)((double)gradients[1].data[gradient_p] - orientation);
            }
        }
        float[][][] hist = new float[((Param)this.p).fdSize][((Param)this.p).fdSize][((Param)this.p).fdBins];
        for (int y = ((Param)this.p).fdSize - 1; y >= 0; --y) {
            int yp = ((Param)this.p).fdSize * 16 * y;
            for (x = ((Param)this.p).fdSize - 1; x >= 0; --x) {
                int xp = 4 * x;
                for (int ysr = 3; ysr >= 0; --ysr) {
                    int ysrp = 4 * ((Param)this.p).fdSize * ysr;
                    for (int xsr = 3; xsr >= 0; --xsr) {
                        double bin_location = ((double)region[1].data[yp + xp + ysrp + xsr] + Math.PI) / (double)this.fdBinWidth;
                        int bin_b = (int)bin_location;
                        int bin_t = bin_b + 1;
                        double d = bin_location - (double)bin_b;
                        bin_b = (bin_b + 2 * ((Param)this.p).fdBins) % ((Param)this.p).fdBins;
                        bin_t = (bin_t + 2 * ((Param)this.p).fdBins) % ((Param)this.p).fdBins;
                        double t = region[0].data[yp + xp + ysrp + xsr];
                        float[] fArray = hist[y][x];
                        int n = bin_b;
                        fArray[n] = (float)((double)fArray[n] + t * (1.0 - d));
                        float[] fArray2 = hist[y][x];
                        int n2 = bin_t;
                        fArray2[n2] = (float)((double)fArray2[n2] + t * d);
                    }
                }
            }
        }
        float[] desc = new float[((Param)this.p).fdSize * ((Param)this.p).fdSize * ((Param)this.p).fdBins];
        float max_bin_val = 0.0f;
        int i = 0;
        for (int y = ((Param)this.p).fdSize - 1; y >= 0; --y) {
            for (int x2 = ((Param)this.p).fdSize - 1; x2 >= 0; --x2) {
                for (int b = ((Param)this.p).fdBins - 1; b >= 0; --b) {
                    desc[i] = hist[y][x2][b];
                    if (desc[i] > max_bin_val) {
                        max_bin_val = desc[i];
                    }
                    ++i;
                }
            }
        }
        max_bin_val = (float)((double)max_bin_val / 0.2);
        for (i = 0; i < desc.length; ++i) {
            desc[i] = (float)Math.min(1.0, (double)(desc[i] / max_bin_val));
        }
        return desc;
    }

    protected final void processCandidate(double[] c, int o, List<Feature> features) {
        int i;
        float[] histogram_bins = new float[36];
        int scale = 1 << o;
        FloatArray2DScaleOctave octave = this.octaves[o];
        double octave_sigma = (double)octave.SIGMA[0] * Math.pow(2.0, c[2] / (double)octave.STEPS);
        FloatArray2D gaussianMask = Filter.createGaussianKernelOffset(octave_sigma * 1.5, c[0] - Math.floor(c[0]), c[1] - Math.floor(c[1]), false);
        FloatArray2D[] src = octave.getL1((int)Math.round(c[2]));
        FloatArray2D[] gradientROI = new FloatArray2D[]{new FloatArray2D(gaussianMask.width, gaussianMask.width), new FloatArray2D(gaussianMask.width, gaussianMask.width)};
        int half_size = gaussianMask.width / 2;
        int n = gaussianMask.width * gaussianMask.width - 1;
        for (int yi = gaussianMask.width - 1; yi >= 0; --yi) {
            int ra_y = src[0].width * Math.max(0, Math.min(src[0].height - 1, (int)c[1] + yi - half_size));
            int ra_x = ra_y + Math.min((int)c[0], src[0].width - 1);
            for (int xi = gaussianMask.width - 1; xi >= 0; --xi) {
                int pt = Math.max(ra_y, Math.min(ra_y + src[0].width - 2, ra_x + xi - half_size));
                gradientROI[0].data[n] = src[0].data[pt];
                gradientROI[1].data[n] = src[1].data[pt];
                --n;
            }
        }
        for (i = 0; i < gradientROI[0].data.length; ++i) {
            int n2 = i;
            gradientROI[0].data[n2] = gradientROI[0].data[n2] * gaussianMask.data[i];
        }
        for (i = 0; i < gradientROI[0].data.length; ++i) {
            int bin;
            int n3 = bin = Math.max(0, Math.min(35, (int)(((double)gradientROI[1].data[i] + Math.PI) / 0.17453292519943295)));
            histogram_bins[n3] = histogram_bins[n3] + gradientROI[0].data[i];
        }
        int max_i = 0;
        for (int i2 = 0; i2 < 36; ++i2) {
            if (!(histogram_bins[i2] > histogram_bins[max_i])) continue;
            max_i = i2;
        }
        double e0 = histogram_bins[(max_i + 36 - 1) % 36];
        double e1 = histogram_bins[max_i];
        double e2 = histogram_bins[(max_i + 1) % 36];
        double offset = (e0 - e2) / 2.0 / (e0 - 2.0 * e1 + e2);
        double orientation = ((double)max_i + offset) * 0.17453292519943295 - Math.PI;
        features.add(new Feature(octave_sigma * (double)scale, orientation, new double[]{c[0] * (double)scale, c[1] * (double)scale}, this.createDescriptor(c, o, octave_sigma, orientation)));
        for (int i3 = 0; i3 < 36; ++i3) {
            if (i3 == max_i || (max_i + 1) % 36 == i3 || (max_i - 1 + 36) % 36 == i3 || !((double)histogram_bins[i3] > 0.8 * (double)histogram_bins[max_i])) continue;
            e0 = histogram_bins[(i3 + 36 - 1) % 36];
            e1 = histogram_bins[i3];
            e2 = histogram_bins[(i3 + 1) % 36];
            if (!(e0 < e1) || !(e2 < e1)) continue;
            offset = (e0 - e2) / 2.0 / (e0 - 2.0 * e1 + e2);
            orientation = ((double)i3 + 0.5 + offset) * 0.17453292519943295 - Math.PI;
            features.add(new Feature(octave_sigma * (double)scale, orientation, new double[]{c[0] * (double)scale, c[1] * (double)scale}, this.createDescriptor(c, o, octave_sigma, orientation)));
        }
    }

    private final Vector<Feature> runOctave(int o) {
        Vector<Feature> features = new Vector<Feature>();
        FloatArray2DScaleOctave octave = this.octaves[o];
        octave.build();
        this.dog.run(octave);
        Vector<double[]> candidates = this.dog.getCandidates();
        for (double[] c : candidates) {
            this.processCandidate(c, o, features);
        }
        return features;
    }

    public Vector<Feature> run() {
        Vector<Feature> features = new Vector<Feature>();
        for (int o = 0; o < this.octaves.length; ++o) {
            if (this.octaves[o].state == FloatArray2DScaleOctave.State.EMPTY) continue;
            Vector<Feature> more = this.runOctave(o);
            features.addAll(more);
        }
        return features;
    }

    public Vector<Feature> run(int max_size) {
        Vector<Feature> features = new Vector<Feature>();
        for (int o = 0; o < this.octaves.length; ++o) {
            if (this.octaves[o].width > max_size || this.octaves[o].height > max_size) continue;
            Vector<Feature> more = this.runOctave(o);
            features.addAll(more);
        }
        return features;
    }

    public static Vector<PointMatch> createMatches(List<Feature> fs1, List<Feature> fs2, float rod) {
        Vector<PointMatch> matches = new Vector<PointMatch>();
        for (Feature f1 : fs1) {
            Feature best = null;
            double best_d = Double.MAX_VALUE;
            double second_best_d = Double.MAX_VALUE;
            for (Feature f2 : fs2) {
                double d = f1.descriptorDistance(f2);
                if (d < best_d) {
                    second_best_d = best_d;
                    best_d = d;
                    best = f2;
                    continue;
                }
                if (!(d < second_best_d)) continue;
                second_best_d = d;
            }
            if (best == null || !(second_best_d < Double.MAX_VALUE) || !(best_d / second_best_d < (double)rod)) continue;
            matches.addElement(new PointMatch(new Point(new double[]{f1.location[0], f1.location[1]}), new Point(new double[]{best.location[0], best.location[1]}), (f1.scale + best.scale) / 2.0));
        }
        int i = 0;
        while (i < matches.size()) {
            boolean amb = false;
            PointMatch m = matches.get(i);
            double[] m_p2 = m.getP2().getL();
            int j = i + 1;
            while (j < matches.size()) {
                PointMatch n = matches.get(j);
                double[] n_p2 = n.getP2().getL();
                if (m_p2[0] == n_p2[0] && m_p2[1] == n_p2[1]) {
                    amb = true;
                    matches.removeElementAt(j);
                    continue;
                }
                ++j;
            }
            if (amb) {
                matches.removeElementAt(i);
                continue;
            }
            ++i;
        }
        return matches;
    }

    public static Vector<PointMatch> createMatches(List<Feature> fs1, List<Feature> fs2, double max_sd, AbstractModel<?> model, double max_id, double rod) {
        Vector<PointMatch> matches = new Vector<PointMatch>();
        double min_sd = 1.0 / max_sd;
        int size = fs2.size();
        int size_1 = size - 1;
        for (Feature f1 : fs1) {
            Feature best = null;
            double best_d = Double.MAX_VALUE;
            double second_best_d = Double.MAX_VALUE;
            int first = 0;
            int last = size_1;
            int s = size / 2 + size % 2;
            if (max_sd < Double.MAX_VALUE) {
                while (s > 1) {
                    Feature f2 = fs2.get(last);
                    last = f2.scale / f1.scale < min_sd ? Math.max(0, last - s) : Math.min(size_1, last + s);
                    f2 = fs2.get(first);
                    first = f2.scale / f1.scale < max_sd ? Math.max(0, first - s) : Math.min(size_1, first + s);
                    s = s / 2 + s % 2;
                }
            }
            for (int i = first; i <= last; ++i) {
                Feature f2 = fs2.get(i);
                double d = f1.descriptorDistance(f2);
                if (d < best_d) {
                    second_best_d = best_d;
                    best_d = d;
                    best = f2;
                    continue;
                }
                if (!(d < second_best_d)) continue;
                second_best_d = d;
            }
            if (best == null || !(second_best_d < Double.MAX_VALUE) || !(best_d / second_best_d < rod)) continue;
            matches.addElement(new PointMatch(new Point(new double[]{f1.location[0], f1.location[1]}), new Point(new double[]{best.location[0], best.location[1]}), (f1.scale + best.scale) / 2.0));
        }
        int i = 0;
        while (i < matches.size()) {
            boolean amb = false;
            PointMatch m = matches.get(i);
            double[] m_p2 = m.getP2().getL();
            int j = i + 1;
            while (j < matches.size()) {
                PointMatch n = matches.get(j);
                double[] n_p2 = n.getP2().getL();
                if (m_p2[0] == n_p2[0] && m_p2[1] == n_p2[1]) {
                    amb = true;
                    matches.removeElementAt(j);
                    continue;
                }
                ++j;
            }
            if (amb) {
                matches.removeElementAt(i);
                continue;
            }
            ++i;
        }
        return matches;
    }

    @Override
    public final void extractFeatures(Collection<Feature> features) {
        features.addAll(this.run(((Param)this.p).maxOctaveSize));
    }

    public static double[] featureSizeHistogram(Vector<Feature> features, double min, double max, int bins) {
        System.out.print("estimating feature size histogram ...");
        int num_features = features.size();
        double[] h = new double[bins];
        int[] hb = new int[bins];
        for (Feature f : features) {
            int bin;
            int n = bin = Math.max(0, Math.min(bins - 1, (int)(Math.log(f.scale) / Math.log(2.0) * 28.0)));
            hb[n] = hb[n] + 1;
        }
        for (int i = 0; i < bins; ++i) {
            h[i] = (double)hb[i] / (double)num_features;
        }
        System.out.println(" done");
        return h;
    }

    public final float getInitialSigma() {
        return ((Param)this.p).initialSigma;
    }

    public final void setInitialSigma(float initialSigma) {
        ((Param)this.p).initialSigma = initialSigma;
        this.sigma = new float[((Param)this.p).steps + 3];
        this.sigma[0] = ((Param)this.p).initialSigma;
        this.sigma_diff = new float[((Param)this.p).steps + 3];
        this.sigma_diff[0] = 0.0f;
        this.kernel_diff = new float[((Param)this.p).steps + 3][];
        for (int i = 1; i < ((Param)this.p).steps + 3; ++i) {
            this.sigma[i] = ((Param)this.p).initialSigma * (float)Math.pow(2.0, (float)i / (float)((Param)this.p).steps);
            this.sigma_diff[i] = (float)Math.sqrt(this.sigma[i] * this.sigma[i] - ((Param)this.p).initialSigma * ((Param)this.p).initialSigma);
            this.kernel_diff[i] = Filter.createGaussianKernel(this.sigma_diff[i], true);
        }
    }

    public final int getMaxOctaveSize() {
        return ((Param)this.p).maxOctaveSize;
    }

    public static class Param
    implements Serializable {
        public int fdSize = 4;
        public int fdBins = 8;
        public int maxOctaveSize = 1024;
        public int minOctaveSize = 64;
        public int steps = 3;
        public float initialSigma = 1.6f;

        public boolean equals(Param p) {
            return this.fdSize == p.fdSize && this.fdBins == p.fdBins && this.maxOctaveSize == p.maxOctaveSize && this.minOctaveSize == p.minOctaveSize && this.steps == p.steps && this.initialSigma == p.initialSigma;
        }

        public boolean equals(Object p) {
            if (this.getClass().isInstance(p)) {
                return this.equals((Param)p);
            }
            return false;
        }

        public Param clone() {
            Param s = new Param();
            s.fdBins = this.fdBins;
            s.fdSize = this.fdSize;
            s.initialSigma = this.initialSigma;
            s.maxOctaveSize = this.maxOctaveSize;
            s.minOctaveSize = this.minOctaveSize;
            s.steps = this.steps;
            return s;
        }

        public void set(Param p) {
            this.fdBins = p.fdBins;
            this.fdSize = p.fdSize;
            this.initialSigma = p.initialSigma;
            this.maxOctaveSize = p.maxOctaveSize;
            this.minOctaveSize = p.minOctaveSize;
            this.steps = p.steps;
        }
    }
}

