/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij;

import ij.process.ImageProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.ij.InvertibleTransformMapping;
import mpicbg.models.AffineModel2D;
import mpicbg.models.PointMatch;
import mpicbg.models.TransformMesh;
import mpicbg.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformMeshMapping<T extends TransformMesh>
extends InvertibleTransformMapping<T> {
    public TransformMeshMapping(T t) {
        super(t);
    }

    protected static final void calculateBoundingBox(ArrayList<PointMatch> pm, double[] min, double[] max) {
        double[] first = pm.get(0).getP2().getW();
        min[0] = first[0];
        min[1] = first[1];
        max[0] = first[0];
        max[1] = first[1];
        for (PointMatch p : pm) {
            double[] t = p.getP2().getW();
            if (t[0] < min[0]) {
                min[0] = t[0];
            } else if (t[0] > max[0]) {
                max[0] = t[0];
            }
            if (t[1] < min[1]) {
                min[1] = t[1];
                continue;
            }
            if (!(t[1] > max[1])) continue;
            max[1] = t[1];
        }
    }

    protected static final boolean isInTriangle(double ax, double ay, double bx, double by, double cx, double cy, double tx, double ty) {
        double x1 = bx - ax;
        double y2 = ty - ay;
        double y1 = by - ay;
        double x2 = tx - ax;
        boolean d = x1 * y2 - y1 * x2 < 0.0;
        if (d ^ (x1 = cx - bx) * (y2 = ty - by) - (y1 = cy - by) * (x2 = tx - bx) < 0.0) {
            return false;
        }
        x1 = ax - cx;
        y2 = ty - cy;
        y1 = ay - cy;
        x2 = tx - cx;
        return !(d ^ x1 * y2 - y1 * x2 < 0.0);
    }

    protected static final void mapTriangle(TransformMesh m, AffineModel2D ai, ImageProcessor source, ImageProcessor target) {
        int w = target.getWidth() - 1;
        int h = target.getHeight() - 1;
        ArrayList<PointMatch> pm = m.getAV().get(ai);
        double[] min = new double[2];
        double[] max = new double[2];
        TransformMeshMapping.calculateBoundingBox(pm, min, max);
        int minX = Math.max(0, Util.roundPos(min[0]));
        int minY = Math.max(0, Util.roundPos(min[1]));
        int maxX = Math.min(w, Util.roundPos(max[0]));
        int maxY = Math.min(h, Util.roundPos(max[1]));
        double[] a = pm.get(0).getP2().getW();
        double ax = a[0];
        double ay = a[1];
        double[] b = pm.get(1).getP2().getW();
        double bx = b[0];
        double by = b[1];
        double[] c = pm.get(2).getP2().getW();
        double cx = c[0];
        double cy = c[1];
        double[] t = new double[2];
        for (int y = minY; y <= maxY; ++y) {
            for (int x = minX; x <= maxX; ++x) {
                if (!TransformMeshMapping.isInTriangle(ax, ay, bx, by, cx, cy, x, y)) continue;
                t[0] = x;
                t[1] = y;
                try {
                    ai.applyInverseInPlace(t);
                }
                catch (Exception e) {
                    continue;
                }
                target.putPixel(x, y, source.getPixel((int)(t[0] + 0.5), (int)(t[1] + 0.5)));
            }
        }
    }

    protected static final void mapTriangleInterpolated(TransformMesh m, AffineModel2D ai, ImageProcessor source, ImageProcessor target) {
        int w = target.getWidth() - 1;
        int h = target.getHeight() - 1;
        ArrayList<PointMatch> pm = m.getAV().get(ai);
        double[] min = new double[2];
        double[] max = new double[2];
        TransformMeshMapping.calculateBoundingBox(pm, min, max);
        int minX = Math.max(0, Util.roundPos(min[0]));
        int minY = Math.max(0, Util.roundPos(min[1]));
        int maxX = Math.min(w, Util.roundPos(max[0]));
        int maxY = Math.min(h, Util.roundPos(max[1]));
        double[] a = pm.get(0).getP2().getW();
        double ax = a[0];
        double ay = a[1];
        double[] b = pm.get(1).getP2().getW();
        double bx = b[0];
        double by = b[1];
        double[] c = pm.get(2).getP2().getW();
        double cx = c[0];
        double cy = c[1];
        double[] t = new double[2];
        for (int y = minY; y <= maxY; ++y) {
            for (int x = minX; x <= maxX; ++x) {
                if (!TransformMeshMapping.isInTriangle(ax, ay, bx, by, cx, cy, x, y)) continue;
                t[0] = x;
                t[1] = y;
                try {
                    ai.applyInverseInPlace(t);
                }
                catch (Exception e) {
                    continue;
                }
                target.putPixel(x, y, source.getPixelInterpolated(t[0], t[1]));
            }
        }
    }

    public final void map(ImageProcessor source, ImageProcessor target, int numThreads) {
        if (numThreads == 1) {
            Set<AffineModel2D> s = ((TransformMesh)this.transform).getAV().keySet();
            for (AffineModel2D ai : s) {
                TransformMeshMapping.mapTriangle((TransformMesh)this.transform, ai, source, target);
            }
        } else {
            ArrayList<AffineModel2D> l = new ArrayList<AffineModel2D>();
            l.addAll(((TransformMesh)this.transform).getAV().keySet());
            AtomicInteger i = new AtomicInteger(0);
            ArrayList<Thread> threads = new ArrayList<Thread>(numThreads);
            for (int k = 0; k < numThreads; ++k) {
                Thread mtt = new MapTriangleThread(i, l, (TransformMesh)this.transform, source, target);
                threads.add(mtt);
                mtt.start();
            }
            for (Thread mtt : threads) {
                try {
                    mtt.join();
                }
                catch (InterruptedException e) {}
            }
        }
    }

    @Override
    public final void map(ImageProcessor source, ImageProcessor target) {
        this.map(source, target, Runtime.getRuntime().availableProcessors());
    }

    public final void mapInterpolated(ImageProcessor source, ImageProcessor target, int numThreads) {
        if (numThreads == 1) {
            Set<AffineModel2D> s = ((TransformMesh)this.transform).getAV().keySet();
            for (AffineModel2D ai : s) {
                TransformMeshMapping.mapTriangleInterpolated((TransformMesh)this.transform, ai, source, target);
            }
        } else {
            ArrayList<AffineModel2D> l = new ArrayList<AffineModel2D>();
            l.addAll(((TransformMesh)this.transform).getAV().keySet());
            AtomicInteger i = new AtomicInteger(0);
            ArrayList<Thread> threads = new ArrayList<Thread>(numThreads);
            for (int k = 0; k < numThreads; ++k) {
                Thread mtt = new MapTriangleInterpolatedThread(i, l, (TransformMesh)this.transform, source, target);
                threads.add(mtt);
                mtt.start();
            }
            for (Thread mtt : threads) {
                try {
                    mtt.join();
                }
                catch (InterruptedException e) {}
            }
        }
    }

    @Override
    public final void mapInterpolated(ImageProcessor source, ImageProcessor target) {
        this.mapInterpolated(source, target, Runtime.getRuntime().availableProcessors());
    }

    protected static final void calculateBoundingBoxInverse(ArrayList<PointMatch> pm, double[] min, double[] max) {
        double[] first = pm.get(0).getP1().getL();
        min[0] = first[0];
        min[1] = first[1];
        max[0] = first[0];
        max[1] = first[1];
        for (PointMatch p : pm) {
            double[] t = p.getP1().getL();
            if (t[0] < min[0]) {
                min[0] = t[0];
            } else if (t[0] > max[0]) {
                max[0] = t[0];
            }
            if (t[1] < min[1]) {
                min[1] = t[1];
                continue;
            }
            if (!(t[1] > max[1])) continue;
            max[1] = t[1];
        }
    }

    protected static final void mapTriangleInverse(TransformMesh m, AffineModel2D ai, ImageProcessor source, ImageProcessor target) {
        int w = target.getWidth() - 1;
        int h = target.getHeight() - 1;
        ArrayList<PointMatch> pm = m.getAV().get(ai);
        double[] min = new double[2];
        double[] max = new double[2];
        TransformMeshMapping.calculateBoundingBoxInverse(pm, min, max);
        int minX = Math.max(0, Util.roundPos(min[0]));
        int minY = Math.max(0, Util.roundPos(min[1]));
        int maxX = Math.min(w, Util.roundPos(max[0]));
        int maxY = Math.min(h, Util.roundPos(max[1]));
        double[] a = pm.get(0).getP1().getL();
        double ax = a[0];
        double ay = a[1];
        double[] b = pm.get(1).getP1().getL();
        double bx = b[0];
        double by = b[1];
        double[] c = pm.get(2).getP1().getL();
        double cx = c[0];
        double cy = c[1];
        double[] t = new double[2];
        for (int y = minY; y <= maxY; ++y) {
            for (int x = minX; x <= maxX; ++x) {
                if (!TransformMeshMapping.isInTriangle(ax, ay, bx, by, cx, cy, x, y)) continue;
                t[0] = x;
                t[1] = y;
                ai.applyInPlace(t);
                target.putPixel(x, y, source.getPixel((int)(t[0] + 0.5), (int)(t[1] + 0.5)));
            }
        }
    }

    protected static final void mapTriangleInverseInterpolated(TransformMesh m, AffineModel2D ai, ImageProcessor source, ImageProcessor target) {
        int w = target.getWidth() - 1;
        int h = target.getHeight() - 1;
        ArrayList<PointMatch> pm = m.getAV().get(ai);
        double[] min = new double[2];
        double[] max = new double[2];
        TransformMeshMapping.calculateBoundingBoxInverse(pm, min, max);
        int minX = Math.max(0, Util.roundPos(min[0]));
        int minY = Math.max(0, Util.roundPos(min[1]));
        int maxX = Math.min(w, Util.roundPos(max[0]));
        int maxY = Math.min(h, Util.roundPos(max[1]));
        double[] a = pm.get(0).getP1().getL();
        double ax = a[0];
        double ay = a[1];
        double[] b = pm.get(1).getP1().getL();
        double bx = b[0];
        double by = b[1];
        double[] c = pm.get(2).getP1().getL();
        double cx = c[0];
        double cy = c[1];
        double[] t = new double[2];
        for (int y = minY; y <= maxY; ++y) {
            for (int x = minX; x <= maxX; ++x) {
                if (!TransformMeshMapping.isInTriangle(ax, ay, bx, by, cx, cy, x, y)) continue;
                t[0] = x;
                t[1] = y;
                ai.applyInPlace(t);
                target.putPixel(x, y, source.getPixelInterpolated(t[0], t[1]));
            }
        }
    }

    public final void mapInverse(ImageProcessor source, ImageProcessor target, int numThreads) {
        if (numThreads == 1) {
            Set<AffineModel2D> s = ((TransformMesh)this.transform).getAV().keySet();
            for (AffineModel2D ai : s) {
                TransformMeshMapping.mapTriangleInverse((TransformMesh)this.transform, ai, source, target);
            }
        } else {
            ArrayList<AffineModel2D> l = new ArrayList<AffineModel2D>();
            l.addAll(((TransformMesh)this.transform).getAV().keySet());
            AtomicInteger i = new AtomicInteger(0);
            ArrayList<Thread> threads = new ArrayList<Thread>(numThreads);
            for (int k = 0; k < numThreads; ++k) {
                Thread mtt = new MapTriangleInverseThread(i, l, (TransformMesh)this.transform, source, target);
                threads.add(mtt);
                mtt.start();
            }
            for (Thread mtt : threads) {
                try {
                    mtt.join();
                }
                catch (InterruptedException e) {}
            }
        }
    }

    @Override
    public final void mapInverse(ImageProcessor source, ImageProcessor target) {
        this.mapInverse(source, target, Runtime.getRuntime().availableProcessors());
    }

    public final void mapInverseInterpolated(ImageProcessor source, ImageProcessor target, int numThreads) {
        if (numThreads == 1) {
            Set<AffineModel2D> s = ((TransformMesh)this.transform).getAV().keySet();
            for (AffineModel2D ai : s) {
                TransformMeshMapping.mapTriangleInverseInterpolated((TransformMesh)this.transform, ai, source, target);
            }
        } else {
            ArrayList<AffineModel2D> l = new ArrayList<AffineModel2D>();
            l.addAll(((TransformMesh)this.transform).getAV().keySet());
            AtomicInteger i = new AtomicInteger(0);
            ArrayList<Thread> threads = new ArrayList<Thread>(numThreads);
            for (int k = 0; k < numThreads; ++k) {
                Thread mtt = new MapTriangleInverseInterpolatedThread(i, l, (TransformMesh)this.transform, source, target);
                threads.add(mtt);
                mtt.start();
            }
            for (Thread mtt : threads) {
                try {
                    mtt.join();
                }
                catch (InterruptedException e) {}
            }
        }
    }

    @Override
    public final void mapInverseInterpolated(ImageProcessor source, ImageProcessor target) {
        this.mapInverseInterpolated(source, target, Runtime.getRuntime().availableProcessors());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MapTriangleInverseInterpolatedThread
    extends Thread {
        private final AtomicInteger i;
        private final List<AffineModel2D> triangles;
        private final TransformMesh transform;
        final ImageProcessor source;
        final ImageProcessor target;

        MapTriangleInverseInterpolatedThread(AtomicInteger i, List<AffineModel2D> triangles, TransformMesh transform, ImageProcessor source, ImageProcessor target) {
            this.i = i;
            this.triangles = triangles;
            this.transform = transform;
            this.source = source;
            this.target = target;
        }

        @Override
        public final void run() {
            int k = this.i.getAndIncrement();
            while (!this.isInterrupted() && k < this.triangles.size()) {
                TransformMeshMapping.mapTriangleInverseInterpolated(this.transform, this.triangles.get(k), this.source, this.target);
                k = this.i.getAndIncrement();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MapTriangleInverseThread
    extends Thread {
        private final AtomicInteger i;
        private final List<AffineModel2D> triangles;
        private final TransformMesh transform;
        final ImageProcessor source;
        final ImageProcessor target;

        MapTriangleInverseThread(AtomicInteger i, List<AffineModel2D> triangles, TransformMesh transform, ImageProcessor source, ImageProcessor target) {
            this.i = i;
            this.triangles = triangles;
            this.transform = transform;
            this.source = source;
            this.target = target;
        }

        @Override
        public final void run() {
            int k = this.i.getAndIncrement();
            while (!this.isInterrupted() && k < this.triangles.size()) {
                TransformMeshMapping.mapTriangleInverse(this.transform, this.triangles.get(k), this.source, this.target);
                k = this.i.getAndIncrement();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MapTriangleInterpolatedThread
    extends Thread {
        private final AtomicInteger i;
        private final List<AffineModel2D> triangles;
        private final TransformMesh transform;
        final ImageProcessor source;
        final ImageProcessor target;

        MapTriangleInterpolatedThread(AtomicInteger i, List<AffineModel2D> triangles, TransformMesh transform, ImageProcessor source, ImageProcessor target) {
            this.i = i;
            this.triangles = triangles;
            this.transform = transform;
            this.source = source;
            this.target = target;
        }

        @Override
        public final void run() {
            int k = this.i.getAndIncrement();
            while (!this.isInterrupted() && k < this.triangles.size()) {
                TransformMeshMapping.mapTriangleInterpolated(this.transform, this.triangles.get(k), this.source, this.target);
                k = this.i.getAndIncrement();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MapTriangleThread
    extends Thread {
        private final AtomicInteger i;
        private final List<AffineModel2D> triangles;
        private final TransformMesh transform;
        final ImageProcessor source;
        final ImageProcessor target;

        MapTriangleThread(AtomicInteger i, List<AffineModel2D> triangles, TransformMesh transform, ImageProcessor source, ImageProcessor target) {
            this.i = i;
            this.triangles = triangles;
            this.transform = transform;
            this.source = source;
            this.target = target;
        }

        @Override
        public final void run() {
            int k = this.i.getAndIncrement();
            while (!this.isInterrupted() && k < this.triangles.size()) {
                TransformMeshMapping.mapTriangle(this.transform, this.triangles.get(k), this.source, this.target);
                k = this.i.getAndIncrement();
            }
        }
    }
}

