/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.types;

import java.math.BigDecimal;
import net.imagej.types.BigComplex;
import net.imagej.types.DataType;
import net.imglib2.type.numeric.integer.IntType;
import org.scijava.AbstractContextual;
import org.scijava.plugin.Plugin;

@Plugin(type=DataType.class)
public class DataType32BitSignedInteger
extends AbstractContextual
implements DataType<IntType> {
    private final IntType type = new IntType();

    @Override
    public IntType getType() {
        return this.type;
    }

    @Override
    public String shortName() {
        return "32-bit int";
    }

    @Override
    public String longName() {
        return "32-bit signed integer";
    }

    @Override
    public String description() {
        return "An integer data type ranging between -2147483648 and 2147483647";
    }

    @Override
    public boolean isComplex() {
        return false;
    }

    @Override
    public boolean isFloat() {
        return false;
    }

    @Override
    public boolean isSigned() {
        return true;
    }

    @Override
    public boolean isBounded() {
        return true;
    }

    @Override
    public void lowerBound(IntType dest) {
        dest.set(Integer.MIN_VALUE);
    }

    @Override
    public void upperBound(IntType dest) {
        dest.set(Integer.MAX_VALUE);
    }

    @Override
    public int bitCount() {
        return 32;
    }

    @Override
    public IntType createVariable() {
        return new IntType();
    }

    @Override
    public void cast(IntType val, BigComplex dest) {
        dest.setReal(val.get());
        dest.setImag(BigDecimal.ZERO);
    }

    @Override
    public void cast(BigComplex val, IntType dest) {
        this.setLong(dest, val.getReal().longValue());
    }

    @Override
    public boolean hasDoubleRepresentation() {
        return true;
    }

    @Override
    public boolean hasLongRepresentation() {
        return true;
    }

    @Override
    public double asDouble(IntType val) {
        return val.get();
    }

    @Override
    public long asLong(IntType val) {
        return val.get();
    }

    @Override
    public void setDouble(IntType val, double v) {
        this.setLong(val, (long)v);
    }

    @Override
    public void setLong(IntType val, long v) {
        if (v < Integer.MIN_VALUE) {
            val.set(Integer.MIN_VALUE);
        } else if (v > Integer.MAX_VALUE) {
            val.set(Integer.MAX_VALUE);
        } else {
            val.set((int)v);
        }
    }
}

