/*
 * Decompiled with CFR 0.152.
 */
package net.imagej;

import net.imagej.Dataset;
import net.imagej.DatasetService;
import net.imagej.ImgPlus;
import net.imagej.axis.Axes;
import net.imagej.axis.AxisType;
import net.imagej.display.DatasetView;
import net.imglib2.RandomAccess;
import net.imglib2.display.screenimage.awt.ARGBScreenImage;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.UnsignedByteType;

public class ImageGrabber {
    private final DatasetService service;

    public ImageGrabber(DatasetService service) {
        this.service = service;
    }

    public Dataset grab(DatasetView view, String outputName) {
        ARGBScreenImage screenImage = view.getScreenImage();
        long[] dims = new long[3];
        screenImage.dimensions(dims);
        dims[2] = 3L;
        if (dims[0] * dims[1] > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("image is too big to fit into memory");
        }
        int xSize = (int)dims[0];
        int ySize = (int)dims[1];
        int[] argbPixels = view.getScreenImage().getData();
        Dataset dataset = this.service.create(new UnsignedByteType(), dims, outputName, new AxisType[]{Axes.X, Axes.Y, Axes.CHANNEL});
        ImgPlus<RealType<?>> imgPlus = dataset.getImgPlus();
        RandomAccess<RealType<?>> accessor = imgPlus.randomAccess();
        for (int x = 0; x < xSize; ++x) {
            accessor.setPosition(x, 0);
            for (int y = 0; y < ySize; ++y) {
                accessor.setPosition(y, 1);
                int index = y * xSize + x;
                int pixel = argbPixels[index];
                accessor.setPosition(0, 2);
                ((RealType)accessor.get()).setReal(pixel >> 16 & 0xFF);
                accessor.setPosition(1, 2);
                ((RealType)accessor.get()).setReal(pixel >> 8 & 0xFF);
                accessor.setPosition(2, 2);
                ((RealType)accessor.get()).setReal(pixel >> 0 & 0xFF);
            }
        }
        dataset.setRGBMerged(true);
        return dataset;
    }
}

