/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.numeric.integer;

import java.math.BigInteger;
import net.imglib2.img.NativeImg;
import net.imglib2.img.NativeImgFactory;
import net.imglib2.img.basictypeaccess.LongAccess;
import net.imglib2.type.numeric.integer.GenericLongType;
import net.imglib2.util.Fraction;

public class LongType
extends GenericLongType<LongType> {
    public LongType(NativeImg<?, ? extends LongAccess> longStorage) {
        super(longStorage);
    }

    public LongType(LongAccess access) {
        super(access);
    }

    public LongType(long value) {
        super(value);
    }

    public LongType() {
        super(0L);
    }

    @Override
    public NativeImg<LongType, ? extends LongAccess> createSuitableNativeImg(NativeImgFactory<LongType> storageFactory, long[] dim) {
        NativeImg<LongType, LongAccess> container = storageFactory.createLongInstance(dim, new Fraction());
        LongType linkedType = new LongType(container);
        container.setLinkedType(linkedType);
        return container;
    }

    @Override
    public LongType duplicateTypeOnSameNativeImg() {
        return new LongType(this.img);
    }

    public long get() {
        return this.dataAccess.getValue(this.i);
    }

    @Override
    public void set(long f) {
        this.dataAccess.setValue(this.i, f);
    }

    @Override
    public int getInteger() {
        return (int)this.get();
    }

    @Override
    public long getIntegerLong() {
        return this.get();
    }

    @Override
    public BigInteger getBigInteger() {
        return BigInteger.valueOf(this.get());
    }

    @Override
    public void setInteger(int f) {
        this.set(f);
    }

    @Override
    public void setInteger(long f) {
        this.set(f);
    }

    @Override
    public void setBigInteger(BigInteger b) {
        this.set(b.longValue());
    }

    @Override
    public double getMaxValue() {
        return 9.223372036854776E18;
    }

    @Override
    public double getMinValue() {
        return -9.223372036854776E18;
    }

    @Override
    public int hashCode() {
        long value = this.get();
        return (int)(value ^ value >>> 32);
    }

    @Override
    public int compareTo(LongType c) {
        long b;
        long a = this.get();
        if (a > (b = c.get())) {
            return 1;
        }
        if (a < b) {
            return -1;
        }
        return 0;
    }

    @Override
    public LongType createVariable() {
        return new LongType(0L);
    }

    @Override
    public LongType copy() {
        return new LongType(this.get());
    }
}

