/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.numeric.integer;

import net.imglib2.img.NativeImg;
import net.imglib2.img.basictypeaccess.LongAccess;
import net.imglib2.img.basictypeaccess.array.LongArray;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.integer.AbstractIntegerType;
import net.imglib2.util.Fraction;
import net.imglib2.util.Util;

public abstract class GenericLongType<T extends GenericLongType<T>>
extends AbstractIntegerType<T>
implements NativeType<T> {
    int i = 0;
    protected final NativeImg<?, ? extends LongAccess> img;
    protected LongAccess dataAccess;

    public GenericLongType(NativeImg<?, ? extends LongAccess> longStorage) {
        this.img = longStorage;
    }

    public GenericLongType(long value) {
        this.img = null;
        this.dataAccess = new LongArray(1);
        this.setValue(value);
    }

    public GenericLongType(LongAccess access) {
        this.img = null;
        this.dataAccess = access;
    }

    public GenericLongType() {
        this(0L);
    }

    @Override
    public Fraction getEntitiesPerPixel() {
        return new Fraction();
    }

    @Override
    public void updateContainer(Object c) {
        this.dataAccess = this.img.update(c);
    }

    protected long getValue() {
        return this.dataAccess.getValue(this.i);
    }

    protected void setValue(long f) {
        this.dataAccess.setValue(this.i, f);
    }

    @Override
    public void mul(float c) {
        this.setValue(Util.round((float)this.getValue() * c));
    }

    @Override
    public void mul(double c) {
        this.setValue(Util.round((double)this.getValue() * c));
    }

    @Override
    public void add(T c) {
        this.setValue(this.getValue() + ((GenericLongType)c).getValue());
    }

    @Override
    public void div(T c) {
        this.setValue(this.getValue() / ((GenericLongType)c).getValue());
    }

    @Override
    public void mul(T c) {
        this.setValue(this.getValue() * ((GenericLongType)c).getValue());
    }

    @Override
    public void sub(T c) {
        this.setValue(this.getValue() - ((GenericLongType)c).getValue());
    }

    @Override
    public int hashCode() {
        return Long.valueOf(this.getValue()).hashCode();
    }

    @Override
    public int compareTo(T c) {
        long b;
        long a = this.getValue();
        if (a > (b = ((GenericLongType)c).getValue())) {
            return 1;
        }
        if (a < b) {
            return -1;
        }
        return 0;
    }

    @Override
    public void set(T c) {
        this.setValue(((GenericLongType)c).getValue());
    }

    @Override
    public void setOne() {
        this.setValue(1L);
    }

    @Override
    public void setZero() {
        this.setValue(0L);
    }

    @Override
    public void inc() {
        long a = this.getValue();
        this.setValue(++a);
    }

    @Override
    public void dec() {
        long a = this.getValue();
        this.setValue(--a);
    }

    @Override
    public String toString() {
        return "" + this.getValue();
    }

    @Override
    public void updateIndex(int index) {
        this.i = index;
    }

    @Override
    public int getIndex() {
        return this.i;
    }

    @Override
    public void incIndex() {
        ++this.i;
    }

    @Override
    public void incIndex(int increment) {
        this.i += increment;
    }

    @Override
    public void decIndex() {
        --this.i;
    }

    @Override
    public void decIndex(int decrement) {
        this.i -= decrement;
    }

    @Override
    public int getBitsPerPixel() {
        return 64;
    }

    @Override
    public boolean valueEquals(T t) {
        return this.getValue() == ((GenericLongType)t).getValue();
    }
}

