/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.logic;

import java.math.BigInteger;
import net.imglib2.img.NativeImg;
import net.imglib2.img.NativeImgFactory;
import net.imglib2.img.basictypeaccess.LongAccess;
import net.imglib2.img.basictypeaccess.array.LongArray;
import net.imglib2.type.BooleanType;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.type.numeric.integer.AbstractIntegerType;
import net.imglib2.util.Fraction;

public class BitType
extends AbstractIntegerType<BitType>
implements BooleanType<BitType>,
NativeType<BitType>,
IntegerType<BitType> {
    protected int i = 0;
    protected final NativeImg<BitType, ? extends LongAccess> img;
    protected LongAccess dataAccess;

    public BitType(NativeImg<BitType, ? extends LongAccess> bitStorage) {
        this.img = bitStorage;
    }

    public BitType(boolean value) {
        this((NativeImg<BitType, ? extends LongAccess>)null);
        this.dataAccess = new LongArray(1);
        this.set(value);
    }

    public BitType(LongAccess access) {
        this((NativeImg<BitType, ? extends LongAccess>)null);
        this.dataAccess = access;
    }

    public BitType() {
        this(false);
    }

    @Override
    public NativeImg<BitType, ? extends LongAccess> createSuitableNativeImg(NativeImgFactory<BitType> storageFactory, long[] dim) {
        NativeImg<BitType, LongAccess> container = storageFactory.createLongInstance(dim, new Fraction(1L, 64L));
        BitType linkedType = new BitType(container);
        container.setLinkedType(linkedType);
        return container;
    }

    @Override
    public void updateContainer(Object c) {
        this.dataAccess = this.img.update(c);
    }

    @Override
    public BitType duplicateTypeOnSameNativeImg() {
        return new BitType(this.img);
    }

    @Override
    public boolean get() {
        return 1L == (this.dataAccess.getValue(this.i >>> 6) >>> (this.i & 0x3F) & 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(boolean value) {
        int i1 = this.i >>> 6;
        long bit = 1L << (this.i & 0x3F);
        LongAccess longAccess = this.dataAccess;
        synchronized (longAccess) {
            if (value) {
                this.dataAccess.setValue(i1, this.dataAccess.getValue(i1) | bit);
            } else {
                this.dataAccess.setValue(i1, this.dataAccess.getValue(i1) & (bit ^ 0xFFFFFFFFFFFFFFFFL));
            }
        }
    }

    @Override
    public int getInteger() {
        return this.get() ? 1 : 0;
    }

    @Override
    public long getIntegerLong() {
        return this.get() ? 1L : 0L;
    }

    @Override
    public BigInteger getBigInteger() {
        return this.get() ? BigInteger.ONE : BigInteger.ZERO;
    }

    @Override
    public void setInteger(int f) {
        if (f >= 1) {
            this.set(true);
        } else {
            this.set(false);
        }
    }

    @Override
    public void setInteger(long f) {
        if (f >= 1L) {
            this.set(true);
        } else {
            this.set(false);
        }
    }

    @Override
    public void setBigInteger(BigInteger b) {
        if (b.compareTo(BigInteger.ZERO) > 0) {
            this.set(true);
        } else {
            this.set(false);
        }
    }

    @Override
    public double getMaxValue() {
        return 1.0;
    }

    @Override
    public double getMinValue() {
        return 0.0;
    }

    @Override
    public void set(BitType c) {
        this.set(c.get());
    }

    @Override
    public void and(BitType c) {
        this.set(this.get() && c.get());
    }

    @Override
    public void or(BitType c) {
        this.set(this.get() || c.get());
    }

    @Override
    public void xor(BitType c) {
        this.set(this.get() ^ c.get());
    }

    @Override
    public void not() {
        this.set(!this.get());
    }

    @Override
    public void add(BitType c) {
        this.xor(c);
    }

    @Override
    public void div(BitType c) {
        this.and(c);
    }

    @Override
    public void mul(BitType c) {
        this.and(c);
    }

    @Override
    public void sub(BitType c) {
        this.xor(c);
    }

    @Override
    public void mul(float c) {
        if (c >= 0.5f) {
            this.set(this.get());
        } else {
            this.set(false);
        }
    }

    @Override
    public void mul(double c) {
        if (c >= 0.5) {
            this.set(this.get());
        } else {
            this.set(false);
        }
    }

    @Override
    public void setOne() {
        this.set(true);
    }

    @Override
    public void setZero() {
        this.set(false);
    }

    @Override
    public void inc() {
        this.not();
    }

    @Override
    public void dec() {
        this.not();
    }

    @Override
    public int compareTo(BitType c) {
        boolean b1 = this.get();
        boolean b2 = c.get();
        if (b1 && !b2) {
            return 1;
        }
        if (!b1 && b2) {
            return -1;
        }
        return 0;
    }

    @Override
    public BitType createVariable() {
        return new BitType();
    }

    @Override
    public BitType copy() {
        return new BitType(this.get());
    }

    @Override
    public String toString() {
        boolean value = this.get();
        return value ? "1" : "0";
    }

    @Override
    public Fraction getEntitiesPerPixel() {
        return new Fraction();
    }

    @Override
    public void updateIndex(int index) {
        this.i = index;
    }

    @Override
    public int getIndex() {
        return this.i;
    }

    @Override
    public void incIndex() {
        ++this.i;
    }

    @Override
    public void incIndex(int increment) {
        this.i += increment;
    }

    @Override
    public void decIndex() {
        --this.i;
    }

    @Override
    public void decIndex(int decrement) {
        this.i -= decrement;
    }

    @Override
    public int getBitsPerPixel() {
        return 1;
    }

    @Override
    public boolean valueEquals(BitType t) {
        return this.get() == t.get();
    }
}

