/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.planar;

import net.imglib2.AbstractLocalizableInt;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.img.planar.PlanarImg;
import net.imglib2.type.NativeType;

public class PlanarRandomAccess<T extends NativeType<T>>
extends AbstractLocalizableInt
implements RandomAccess<T>,
PlanarImg.PlanarContainerSampler {
    protected final int[] sliceSteps;
    protected final int width;
    protected final T type;
    protected int sliceIndex;

    protected PlanarRandomAccess(PlanarRandomAccess<T> randomAccess) {
        super(randomAccess.numDimensions());
        this.sliceSteps = randomAccess.sliceSteps;
        this.width = randomAccess.width;
        this.sliceIndex = randomAccess.sliceIndex;
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = randomAccess.position[d];
        }
        this.type = randomAccess.type.duplicateTypeOnSameNativeImg();
        this.type.updateContainer(this);
        this.type.updateIndex(randomAccess.type.getIndex());
    }

    public PlanarRandomAccess(PlanarImg<T, ?> container) {
        super(container.numDimensions());
        this.sliceSteps = container.sliceSteps;
        this.width = (int)container.dimension(0);
        this.type = container.createLinkedType();
        this.type.updateIndex(0);
        this.type.updateContainer(this);
    }

    @Override
    public int getCurrentSliceIndex() {
        return this.sliceIndex;
    }

    @Override
    public T get() {
        return this.type;
    }

    @Override
    public PlanarRandomAccess<T> copy() {
        return new PlanarRandomAccess<T>(this);
    }

    @Override
    public PlanarRandomAccess<T> copyRandomAccess() {
        return this.copy();
    }

    @Override
    public void fwd(int d) {
        int n = d;
        this.position[n] = this.position[n] + 1;
        if (d == 0) {
            this.type.incIndex();
        } else if (d == 1) {
            this.type.incIndex(this.width);
        } else {
            this.sliceIndex += this.sliceSteps[d];
            this.type.updateContainer(this);
        }
    }

    @Override
    public void bck(int d) {
        int n = d;
        this.position[n] = this.position[n] - 1;
        if (d == 0) {
            this.type.decIndex();
        } else if (d == 1) {
            this.type.decIndex(this.width);
        } else {
            this.sliceIndex -= this.sliceSteps[d];
            this.type.updateContainer(this);
        }
    }

    @Override
    public void move(int distance, int d) {
        int n = d;
        this.position[n] = this.position[n] + distance;
        if (d == 0) {
            this.type.incIndex(distance);
        } else if (d == 1) {
            this.type.incIndex(distance * this.width);
        } else {
            this.sliceIndex += this.sliceSteps[d] * distance;
            this.type.updateContainer(this);
        }
    }

    @Override
    public void move(long distance, int d) {
        this.move((int)distance, d);
    }

    @Override
    public void move(Localizable localizable) {
        int d0 = localizable.getIntPosition(0);
        int d1 = localizable.getIntPosition(1);
        this.type.incIndex(d0 + d1 * this.width);
        this.position[0] = this.position[0] + d0;
        this.position[1] = this.position[1] + d1;
        for (int d = 2; d < this.n; ++d) {
            int dist = localizable.getIntPosition(d);
            if (dist == 0) continue;
            this.sliceIndex += dist * this.sliceSteps[d];
            int n = d++;
            this.position[n] = this.position[n] + dist;
            while (d < this.n) {
                if (dist != 0) {
                    this.sliceIndex += dist * this.sliceSteps[d];
                    int n2 = d;
                    this.position[n2] = this.position[n2] + dist;
                }
                ++d;
            }
            this.type.updateContainer(this);
        }
    }

    @Override
    public void move(int[] distance) {
        this.type.incIndex(distance[0] + distance[1] * this.width);
        this.position[0] = this.position[0] + distance[0];
        this.position[1] = this.position[1] + distance[1];
        for (int d = 2; d < this.n; ++d) {
            int dist = distance[d];
            if (dist == 0) continue;
            this.sliceIndex += dist * this.sliceSteps[d];
            int n = d++;
            this.position[n] = this.position[n] + dist;
            while (d < this.n) {
                if (dist != 0) {
                    this.sliceIndex += dist * this.sliceSteps[d];
                    int n2 = d;
                    this.position[n2] = this.position[n2] + dist;
                }
                ++d;
            }
            this.type.updateContainer(this);
        }
    }

    @Override
    public void move(long[] distance) {
        this.type.incIndex((int)distance[0] + (int)distance[1] * this.width);
        this.position[0] = this.position[0] + (int)distance[0];
        this.position[1] = this.position[1] + (int)distance[1];
        for (int d = 2; d < this.n; ++d) {
            int dist = (int)distance[d];
            if (dist == 0) continue;
            this.sliceIndex += dist * this.sliceSteps[d];
            int n = d++;
            this.position[n] = this.position[n] + dist;
            while (d < this.n) {
                if (dist != 0) {
                    this.sliceIndex += dist * this.sliceSteps[d];
                    int n2 = d;
                    this.position[n2] = this.position[n2] + dist;
                }
                ++d;
            }
            this.type.updateContainer(this);
        }
    }

    @Override
    public void setPosition(int pos, int d) {
        if (d == 0) {
            this.type.incIndex(pos - this.position[0]);
        } else if (d == 1) {
            this.type.incIndex((pos - this.position[1]) * this.width);
        } else {
            this.sliceIndex += (pos - this.position[d]) * this.sliceSteps[d];
            this.type.updateContainer(this);
        }
        this.position[d] = pos;
    }

    @Override
    public void setPosition(long pos, int d) {
        this.setPosition((int)pos, d);
    }

    @Override
    public void setPosition(Localizable localizable) {
        int p0 = localizable.getIntPosition(0);
        int p1 = localizable.getIntPosition(1);
        this.type.updateIndex(p0 + p1 * this.width);
        this.position[0] = p0;
        this.position[1] = p1;
        for (int d = 2; d < this.n; ++d) {
            int pos = localizable.getIntPosition(d);
            if (pos == this.position[d]) continue;
            this.sliceIndex += (pos - this.position[d]) * this.sliceSteps[d];
            this.position[d] = pos;
            ++d;
            while (d < this.n) {
                int pos2 = localizable.getIntPosition(d);
                if (pos2 != this.position[d]) {
                    this.sliceIndex += (pos2 - this.position[d]) * this.sliceSteps[d];
                    this.position[d] = pos2;
                }
                ++d;
            }
            this.type.updateContainer(this);
        }
    }

    @Override
    public void setPosition(int[] pos) {
        this.type.updateIndex(pos[0] + pos[1] * this.width);
        this.position[0] = pos[0];
        this.position[1] = pos[1];
        for (int d = 2; d < this.n; ++d) {
            if (pos[d] == this.position[d]) continue;
            this.sliceIndex += (pos[d] - this.position[d]) * this.sliceSteps[d];
            this.position[d] = pos[d];
            ++d;
            while (d < this.n) {
                if (pos[d] != this.position[d]) {
                    this.sliceIndex += (pos[d] - this.position[d]) * this.sliceSteps[d];
                    this.position[d] = pos[d];
                }
                ++d;
            }
            this.type.updateContainer(this);
        }
    }

    @Override
    public void setPosition(long[] pos) {
        this.type.updateIndex((int)pos[0] + (int)pos[1] * this.width);
        this.position[0] = (int)pos[0];
        this.position[1] = (int)pos[1];
        for (int d = 2; d < this.n; ++d) {
            if (pos[d] == (long)this.position[d]) continue;
            this.sliceIndex = (int)((long)this.sliceIndex + (pos[d] - (long)this.position[d]) * (long)this.sliceSteps[d]);
            this.position[d] = (int)pos[d];
            ++d;
            while (d < this.n) {
                if (pos[d] != (long)this.position[d]) {
                    this.sliceIndex = (int)((long)this.sliceIndex + (pos[d] - (long)this.position[d]) * (long)this.sliceSteps[d]);
                    this.position[d] = (int)pos[d];
                }
                ++d;
            }
            this.type.updateContainer(this);
        }
    }
}

