/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.position.transform;

import net.imglib2.Localizable;
import net.imglib2.Positionable;
import net.imglib2.RealLocalizable;
import net.imglib2.position.transform.AbstractPositionableTransform;

public class FloorOffset<LocalizablePositionable extends Localizable & Positionable>
extends AbstractPositionableTransform<LocalizablePositionable> {
    protected final long[] offset;

    public FloorOffset(LocalizablePositionable target, long[] offset) {
        super(target);
        this.offset = (long[])offset.clone();
        for (int d = 0; d < this.n; ++d) {
            this.discrete[d] = offset[d];
            ((Positionable)target).setPosition(offset[d], d);
        }
    }

    public FloorOffset(LocalizablePositionable target, Localizable offset) {
        super(target);
        this.offset = new long[this.n];
        for (int d = 0; d < this.n; ++d) {
            this.offset[d] = this.discrete[d] = offset.getLongPosition(d);
            ((Positionable)target).setPosition(this.discrete[d], d);
        }
    }

    public FloorOffset(RealLocalizable origin, LocalizablePositionable target, long[] offset) {
        super(target);
        this.offset = (long[])offset.clone();
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = origin.getDoublePosition(d);
            this.discrete[d] = FloorOffset.f(this.position[d], offset[d]);
            ((Positionable)target).setPosition(this.discrete[d], d);
        }
    }

    public FloorOffset(RealLocalizable origin, LocalizablePositionable target, Localizable offset) {
        super(target);
        this.offset = new long[this.n];
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = origin.getDoublePosition(d);
            this.offset[d] = offset.getLongPosition(d);
            this.discrete[d] = FloorOffset.f(this.position[d], this.offset[d]);
            ((Positionable)target).setPosition(this.discrete[d], d);
        }
    }

    protected static final long f(double r, long off) {
        return r < 0.0 ? (long)r + off - 1L : (long)r + off;
    }

    protected static final long f(float r, long off) {
        return r < 0.0f ? (long)r + off - 1L : (long)r + off;
    }

    protected void f(double[] r, long[] f) {
        for (int d = 0; d < r.length; ++d) {
            f[d] = FloorOffset.f(r[d], this.offset[d]);
        }
    }

    protected void f(float[] r, long[] f) {
        for (int d = 0; d < r.length; ++d) {
            f[d] = FloorOffset.f(r[d], this.offset[d]);
        }
    }

    protected void f(RealLocalizable r, long[] f) {
        for (int d = 0; d < f.length; ++d) {
            f[d] = FloorOffset.f(r.getDoublePosition(d), this.offset[d]);
        }
    }

    @Override
    public void move(float distance, int d) {
        double realPosition = this.position[d] + (double)distance;
        long floorPosition = FloorOffset.f(realPosition, this.offset[d]);
        this.position[d] = realPosition;
        long floorDistance = floorPosition - this.target.getLongPosition(d);
        if (floorDistance == 0L) {
            return;
        }
        ((Positionable)((Object)this.target)).move(floorDistance, d);
    }

    @Override
    public void move(double distance, int d) {
        double realPosition = this.position[d] + distance;
        long floorPosition = FloorOffset.f(realPosition, this.offset[d]);
        this.position[d] = realPosition;
        long floorDistance = floorPosition - this.target.getLongPosition(d);
        if (floorDistance == 0L) {
            return;
        }
        ((Positionable)((Object)this.target)).move(floorDistance, d);
    }

    @Override
    public void move(RealLocalizable localizable) {
        for (int d = 0; d < this.n; ++d) {
            double realPosition = this.position[d] + localizable.getDoublePosition(d);
            long floorPosition = FloorOffset.f(realPosition, this.offset[d]);
            this.position[d] = realPosition;
            this.discrete[d] = floorPosition - this.target.getLongPosition(d);
        }
        ((Positionable)((Object)this.target)).move(this.discrete);
    }

    @Override
    public void move(float[] distance) {
        for (int d = 0; d < this.n; ++d) {
            double realPosition = this.position[d] + (double)distance[d];
            long floorPosition = FloorOffset.f(realPosition, this.offset[d]);
            this.position[d] = realPosition;
            this.discrete[d] = floorPosition - this.target.getLongPosition(d);
        }
        ((Positionable)((Object)this.target)).move(this.discrete);
    }

    @Override
    public void move(double[] distance) {
        for (int d = 0; d < this.n; ++d) {
            double realPosition = this.position[d] + distance[d];
            long floorPosition = FloorOffset.f(realPosition, this.offset[d]);
            this.position[d] = realPosition;
            this.discrete[d] = floorPosition - this.target.getLongPosition(d);
        }
        ((Positionable)((Object)this.target)).move(this.discrete);
    }

    @Override
    public void setPosition(RealLocalizable localizable) {
        localizable.localize(this.position);
        for (int d = 0; d < this.n; ++d) {
            this.discrete[d] = FloorOffset.f(this.position[d], this.offset[d]);
        }
        ((Positionable)((Object)this.target)).setPosition(this.discrete);
    }

    @Override
    public void setPosition(float[] pos) {
        for (int d = 0; d < this.n; ++d) {
            float realPosition = pos[d];
            this.position[d] = realPosition;
            this.discrete[d] = FloorOffset.f(realPosition, this.offset[d]);
        }
        ((Positionable)((Object)this.target)).setPosition(this.discrete);
    }

    @Override
    public void setPosition(double[] position) {
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = position[d];
            this.discrete[d] = FloorOffset.f(position[d], this.offset[d]);
        }
        ((Positionable)((Object)this.target)).setPosition(this.discrete);
    }

    @Override
    public void setPosition(float position, int d) {
        this.position[d] = position;
        ((Positionable)((Object)this.target)).setPosition(FloorOffset.f(position, this.offset[d]), d);
    }

    @Override
    public void setPosition(double position, int d) {
        this.position[d] = position;
        ((Positionable)((Object)this.target)).setPosition(FloorOffset.f(position, this.offset[d]), d);
    }
}

