/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.cell;

import java.io.Serializable;
import net.imglib2.util.IntervalIndexer;

public abstract class AbstractCell<A>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected int n;
    protected int[] dimensions;
    protected int[] steps;
    protected long[] min;
    protected long[] max;
    protected int numPixels;

    public AbstractCell() {
    }

    public AbstractCell(int[] dimensions, long[] min) {
        this.n = dimensions.length;
        this.dimensions = (int[])dimensions.clone();
        this.steps = new int[this.n];
        IntervalIndexer.createAllocationSteps(dimensions, this.steps);
        this.min = (long[])min.clone();
        this.max = new long[this.n];
        for (int d = 0; d < this.n; ++d) {
            this.max[d] = min[d] + (long)dimensions[d] - 1L;
        }
        int nPixels = dimensions[0];
        for (int d = 1; d < this.n; ++d) {
            nPixels *= dimensions[d];
        }
        this.numPixels = nPixels;
    }

    public abstract A getData();

    public long size() {
        return this.numPixels;
    }

    public long indexToGlobalPosition(int index, int d) {
        return (long)IntervalIndexer.indexToPosition(index, this.dimensions, this.steps, d) + this.min[d];
    }

    public void indexToGlobalPosition(int index, long[] position) {
        IntervalIndexer.indexToPosition(index, this.dimensions, position);
        for (int d = 0; d < position.length; ++d) {
            int n = d;
            position[n] = position[n] + this.min[d];
        }
    }

    public int localPositionToIndex(long[] position) {
        return IntervalIndexer.positionToIndex(position, this.dimensions);
    }

    public long min(int d) {
        return this.min[d];
    }

    public void min(long[] minimum) {
        for (int d = 0; d < this.n; ++d) {
            minimum[d] = this.min[d];
        }
    }

    public int dimension(int d) {
        return this.dimensions[d];
    }

    public void dimensions(int[] dim) {
        for (int d = 0; d < this.n; ++d) {
            dim[d] = this.dimensions[d];
        }
    }
}

