/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.converter.readwrite;

import net.imglib2.Sampler;
import net.imglib2.converter.readwrite.SamplerConverter;
import net.imglib2.img.basictypeaccess.ByteAccess;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.integer.UnsignedByteType;

public final class ARGBChannelSamplerConverter
implements SamplerConverter<ARGBType, UnsignedByteType> {
    private static final int[] masks = new int[]{0xFFFFFF, -16711681, -65281, 0xFFFF00};
    private static final int[] shifts = new int[]{24, 16, 8, 0};
    private final int mask;
    private final int shift;

    public ARGBChannelSamplerConverter(int channel) {
        this.mask = masks[channel];
        this.shift = shifts[channel];
    }

    @Override
    public UnsignedByteType convert(Sampler<? extends ARGBType> sampler) {
        return new UnsignedByteType(new ARGBChannelConvertingAccess(sampler));
    }

    private final class ARGBChannelConvertingAccess
    implements ByteAccess {
        private final Sampler<? extends ARGBType> sampler;

        private ARGBChannelConvertingAccess(Sampler<? extends ARGBType> sampler) {
            this.sampler = sampler;
        }

        @Override
        public byte getValue(int index) {
            return (byte)(this.sampler.get().get() >> ARGBChannelSamplerConverter.this.shift & 0xFF);
        }

        @Override
        public void setValue(int index, byte value) {
            ARGBType t = this.sampler.get();
            t.set(t.get() & ARGBChannelSamplerConverter.this.mask | value << ARGBChannelSamplerConverter.this.shift);
        }
    }
}

