/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2;

import net.imglib2.AbstractEuclideanSpace;
import net.imglib2.RealInterval;
import net.imglib2.RealPositionable;

public class AbstractRealInterval
extends AbstractEuclideanSpace
implements RealInterval {
    protected final double[] min;
    protected final double[] max;

    public AbstractRealInterval(int n) {
        super(n);
        this.min = new double[n];
        this.max = new double[n];
    }

    public AbstractRealInterval(RealInterval interval) {
        this(interval.numDimensions());
        interval.realMin(this.min);
        interval.realMax(this.max);
    }

    public AbstractRealInterval(double[] min, double[] max) {
        super(min.length);
        this.min = (double[])min.clone();
        this.max = (double[])max.clone();
    }

    @Override
    public double realMin(int d) {
        return this.min[d];
    }

    @Override
    public void realMin(double[] realMin) {
        for (int d = 0; d < this.n; ++d) {
            realMin[d] = this.min[d];
        }
    }

    @Override
    public void realMin(RealPositionable realMin) {
        for (int d = 0; d < this.n; ++d) {
            realMin.setPosition(this.min[d], d);
        }
    }

    @Override
    public double realMax(int d) {
        return this.max[d];
    }

    @Override
    public void realMax(double[] realMax) {
        for (int d = 0; d < this.n; ++d) {
            realMax[d] = this.max[d];
        }
    }

    @Override
    public void realMax(RealPositionable realMax) {
        for (int d = 0; d < this.n; ++d) {
            realMax.setPosition(this.max[d], d);
        }
    }
}

