/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.mosaic;

import edu.mines.jtk.awt.ColorMap;
import edu.mines.jtk.mosaic.ContoursView;
import edu.mines.jtk.mosaic.PixelsView;
import edu.mines.jtk.mosaic.PlotFrame;
import edu.mines.jtk.mosaic.PlotPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class ContoursViewTest {
    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ContoursViewTest.go();
            }
        });
    }

    public static void go() {
        float[][] array = new float[50][50];
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[0].length; ++j) {
                array[i][j] = (float)(i + j) * (float)(i - j);
            }
        }
        PlotPanel panel1 = new PlotPanel();
        PlotPanel panel2 = new PlotPanel();
        JPanel topLeftPanel = new JPanel();
        JPanel topRightPanel = new JPanel();
        topLeftPanel.setLayout(new GridLayout(2, 2));
        topRightPanel.setLayout(new GridLayout(2, 2));
        final ContoursView cv1 = panel1.addContours(array);
        cv1.setLineStyleNegative(ContoursView.Line.DASH);
        cv1.setLineColor(Color.BLACK);
        cv1.setContours(50);
        final PixelsView pv2 = panel2.addPixels(array);
        final ContoursView cv2 = panel2.addContours(array);
        String[] cc = new String[]{"JET", "HUE", "GRAY", "SOLID"};
        String[] pc = new String[]{"JET", "HUE", "GRAY"};
        String[] yesno = new String[]{"Yes", "No"};
        final JComboBox<String> combocc = new JComboBox<String>(cc);
        final JComboBox<String> combopc = new JComboBox<String>(pc);
        final JTextField numcontours = new JTextField(4);
        final JComboBox<String> comboneg = new JComboBox<String>(yesno);
        combocc.setSelectedItem("JET");
        combopc.setSelectedItem("GRAY");
        combocc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent action) {
                if (combocc.getSelectedItem() == "JET") {
                    cv2.setColorModel(ColorMap.JET);
                } else if (combocc.getSelectedItem() == "HUE") {
                    cv2.setColorModel(ColorMap.HUE);
                } else if (combocc.getSelectedItem() == "GRAY") {
                    cv2.setColorModel(ColorMap.GRAY);
                } else {
                    cv2.setLineColor(Color.BLACK);
                }
            }
        });
        combopc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent action) {
                if (combopc.getSelectedItem() == "JET") {
                    pv2.setColorModel(ColorMap.JET);
                } else if (combopc.getSelectedItem() == "HUE") {
                    pv2.setColorModel(ColorMap.HUE);
                } else if (combopc.getSelectedItem() == "GRAY") {
                    pv2.setColorModel(ColorMap.GRAY);
                }
            }
        });
        comboneg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent action) {
                if (comboneg.getSelectedItem() == "Yes") {
                    cv1.setLineStyleNegative(ContoursView.Line.DASH);
                } else {
                    cv1.setLineStyleNegative(ContoursView.Line.SOLID);
                }
            }
        });
        numcontours.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int value = Integer.parseInt(numcontours.getText());
                cv1.setContours(value);
                numcontours.setText(Integer.toString(value));
            }
        });
        JSplitPane jsp = new JSplitPane(1, topLeftPanel, topRightPanel);
        jsp.setResizeWeight(0.45);
        topRightPanel.add(new Label("Contours colors:", 2));
        topRightPanel.add(combocc);
        topRightPanel.add(new Label("Pixels colors:", 2));
        topRightPanel.add(combopc);
        topLeftPanel.add(new Label("Desired number of contours:", 2));
        topLeftPanel.add(numcontours);
        topLeftPanel.add(new Label("Show negatives:", 2));
        topLeftPanel.add(comboneg);
        panel2.addColorBar();
        PlotFrame frame = new PlotFrame(panel1, panel2, PlotFrame.Split.HORIZONTAL);
        frame.setTitle("Example Contour Plot");
        frame.setDefaultCloseOperation(3);
        frame.add((Component)jsp, "North");
        frame.pack();
        frame.setVisible(true);
    }
}

