/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.mosaic;

import edu.mines.jtk.awt.ColorMap;
import edu.mines.jtk.dsp.Sampling;
import edu.mines.jtk.mosaic.Projector;
import edu.mines.jtk.mosaic.TiledView;
import edu.mines.jtk.mosaic.Transcaler;
import edu.mines.jtk.util.ArrayMath;
import edu.mines.jtk.util.Check;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.image.IndexColorModel;
import java.util.ArrayList;
import java.util.Collections;

public class BarsView
extends TiledView {
    int _ns;
    ArrayList<Integer> _nx = new ArrayList();
    ArrayList<float[]> _x1 = new ArrayList();
    ArrayList<float[]> _x2 = new ArrayList();
    int _nxmax;
    private Orientation _orientation = Orientation.X1RIGHT_X2UP;
    private Alignment _alignment = Alignment.ALIGN_CENTER;
    private boolean _stackingBars = false;
    private Line _lineStyle = Line.SOLID;
    private float _lineWidth = 0.0f;
    private Color[] _lineColor = null;
    private float _barWidth = 1.0f;
    private String _textFormat = "%1.4G";
    private ColorMap[] _colorMaps = null;

    public BarsView(float[] x2) {
        float[] x1 = ArrayMath.rampfloat(0.0f, 1.0f, x2.length);
        this.set(x1, x2);
    }

    public BarsView(Sampling s1, float[] x2) {
        this.set(s1, x2);
    }

    public BarsView(float[][] x2) {
        this.set((float[][])null, x2);
    }

    public BarsView(Sampling s1, float[][] x2) {
        Check.argument(s1.getCount() == x2[0].length, "s1 count equals x2 length");
        int n1 = x2[0].length;
        int n2 = x2.length;
        float[][] x1 = new float[n2][n1];
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i1 = 0; i1 < n1; ++i1) {
                x1[i2][i1] = (float)s1.getValue(i1);
            }
        }
        this.set(x1, x2);
    }

    public BarsView(float[][] x1, float[][] x2) {
        this.set(x1, x2);
    }

    public BarsView(float[] x1, float[] x2) {
        this.set(x1, x2);
    }

    public void set(Sampling s1, float[] x2) {
        Check.argument(s1.getCount() == x2.length, "s1 count equals x2 length");
        int n1 = x2.length;
        float[] x1 = new float[n1];
        for (int i1 = 0; i1 < n1; ++i1) {
            x1[i1] = (float)s1.getValue(i1);
        }
        this.set(x1, x2);
    }

    public void set(float[] x1, float[] x2) {
        Check.argument(x1.length == x2.length, "x1.length equals x2.length");
        this._ns = 1;
        this._nx.clear();
        this._x1.clear();
        this._x2.clear();
        this._nxmax = x1.length;
        this._nx.add(x1.length);
        this._x1.add(ArrayMath.copy(x1));
        this._x2.add(ArrayMath.copy(x2));
        this._colorMaps = new ColorMap[this._ns];
        for (int i = 0; i < this._ns; ++i) {
            this._colorMaps[i] = new ColorMap(Color.CYAN);
        }
        this._lineColor = new Color[this._ns];
        this.updateBestProjectors();
        this.repaint();
    }

    public void set(float[][] x1, float[][] x2) {
        Check.argument(x1.length == x2.length, "x1.length equals x2.length");
        this._ns = x1.length;
        this._nx.clear();
        this._x1.clear();
        this._x2.clear();
        this._nxmax = 0;
        for (int is = 0; is < this._ns; ++is) {
            Check.argument(x1[is].length == x2[is].length, "x1[i].length equals x2[i].length");
            this._nxmax = ArrayMath.max(this._nxmax, x1[is].length);
            this._nx.add(x1[is].length);
            this._x1.add(ArrayMath.copy(x1[is]));
            this._x2.add(ArrayMath.copy(x2[is]));
        }
        this._colorMaps = new ColorMap[this._ns];
        for (int i = 0; i < this._ns; ++i) {
            this._colorMaps[i] = new ColorMap(Color.CYAN);
        }
        this._lineColor = new Color[this._ns];
        this.updateBestProjectors();
        this.repaint();
    }

    public void setOrientation(Orientation orientation) {
        if (this._orientation != orientation) {
            this._orientation = orientation;
            this.updateBestProjectors();
            this.repaint();
        }
    }

    public Orientation getOrientation() {
        return this._orientation;
    }

    public void setStyle(String style) {
        if (style.contains("r")) {
            this.setLineColor(Color.RED);
        } else if (style.contains("g")) {
            this.setLineColor(Color.GREEN);
        } else if (style.contains("b")) {
            this.setLineColor(Color.BLUE);
        } else if (style.contains("c")) {
            this.setLineColor(Color.CYAN);
        } else if (style.contains("m")) {
            this.setLineColor(Color.MAGENTA);
        } else if (style.contains("y")) {
            this.setLineColor(Color.YELLOW);
        } else if (style.contains("k")) {
            this.setLineColor(Color.BLACK);
        } else if (style.contains("w")) {
            this.setLineColor(Color.WHITE);
        } else {
            this.setLineColor(null);
        }
        if (style.contains("--.")) {
            this.setLineStyle(Line.DASH_DOT);
        } else if (style.contains("--")) {
            this.setLineStyle(Line.DASH);
        } else if (style.contains("-.")) {
            this.setLineStyle(Line.DOT);
        } else if (style.contains("-")) {
            this.setLineStyle(Line.SOLID);
        } else {
            this.setLineStyle(Line.NONE);
        }
    }

    public void setBarWidth(float width) {
        this._barWidth = width;
        this.repaint();
    }

    public void setFillColor(Color color) {
        for (int i = 0; i < this._ns; ++i) {
            this.setFillColor(i, color);
        }
    }

    public void setColorModel(IndexColorModel colorModel) {
        for (int is = 0; is < this._ns; ++is) {
            this.setColorModel(is, colorModel);
        }
    }

    public void setColorModel(int i, IndexColorModel colorModel) {
        this._colorMaps[i].setColorModel(colorModel);
        this.repaint();
    }

    public void setColorMap(ColorMap colorMap) {
        for (int is = 0; is < this._ns; ++is) {
            this.setColorMap(is, colorMap);
        }
    }

    public void setColorMap(int i, ColorMap colorMap) {
        this._colorMaps[i] = colorMap;
        this.repaint();
    }

    public void setFillColor(int i, Color color) {
        this._colorMaps[i] = new ColorMap(color);
        this.repaint();
    }

    public void setAlignment(Alignment alignment) {
        if (this._alignment != alignment) {
            this._alignment = alignment;
            this.updateBestProjectors();
            this.repaint();
        }
    }

    public void setStackBars(boolean stack) {
        this._stackingBars = stack;
        this.updateBestProjectors();
        this.repaint();
    }

    public void setLineStyle(Line style) {
        this._lineStyle = style;
        this.repaint();
    }

    public void setLineWidth(float width) {
        if (this._lineWidth != width) {
            this._lineWidth = width;
            this.updateBestProjectors();
            this.repaint();
        }
    }

    public void setLineColor(Color color) {
        for (int i = 0; i < this._ns; ++i) {
            this.setLineColor(i, color);
        }
    }

    public void setLineColor(int ibar, Color color) {
        this._lineColor[ibar] = color;
        this.repaint();
    }

    public void setTextFormat(String format) {
        this._textFormat = format;
        this.repaint();
    }

    @Override
    public void paint(Graphics2D g2d) {
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Projector hp = this.getHorizontalProjector();
        Projector vp = this.getVerticalProjector();
        Transcaler ts = this.getTranscaler();
        float fontSize = g2d.getFont().getSize2D();
        float lineWidth = 1.0f;
        Stroke stroke = g2d.getStroke();
        if (stroke instanceof BasicStroke) {
            BasicStroke bs = (BasicStroke)stroke;
            lineWidth = bs.getLineWidth();
        }
        Graphics2D gline = null;
        if (this._lineStyle != Line.NONE) {
            BasicStroke bs;
            gline = (Graphics2D)g2d.create();
            float width = lineWidth;
            if (this._lineWidth != 0.0f) {
                width *= this._lineWidth;
            }
            float[] dash = null;
            if (this._lineStyle != Line.SOLID) {
                float dotLength = 0.5f * width;
                float dashLength = 2.0f * width;
                float gapLength = 2.0f * dotLength + dashLength;
                if (this._lineStyle == Line.DASH) {
                    dash = new float[]{dashLength, gapLength};
                } else if (this._lineStyle == Line.DOT) {
                    dash = new float[]{dotLength, gapLength};
                } else if (this._lineStyle == Line.DASH_DOT) {
                    dash = new float[]{dashLength, gapLength, dotLength, gapLength};
                }
            }
            if (dash != null) {
                int cap = 1;
                int join = 1;
                float miter = 10.0f;
                float phase = 0.0f;
                bs = new BasicStroke(width, cap, join, miter, dash, phase);
            } else {
                bs = new BasicStroke(width);
            }
            gline.setStroke(bs);
        }
        Object gtext = null;
        int[] x = new int[this._nxmax];
        int[] y = new int[this._nxmax];
        Graphics2D gbar = (Graphics2D)g2d.create();
        float[] o1 = new float[]{0.0f, 1.0f};
        float[] o2 = new float[]{0.0f, 1.0f};
        int[] ox = new int[2];
        int[] oy = new int[2];
        Color[][] colors = new Color[this._ns][this._nxmax];
        for (int is = 0; is < this._ns; ++is) {
            float[] x2 = this._x2.get(is);
            for (int ix = 0; ix < this._nxmax; ++ix) {
                colors[is][ix] = this._colorMaps[is].getColor(x2[ix]);
            }
        }
        this.computeXY(hp, vp, ts, 1, o1, o2, ox, oy);
        float[] bottom = new float[this._nxmax];
        int[] prevTop = new int[this._nxmax];
        for (int i = 0; i < this._nxmax; ++i) {
            prevTop[i] = this._orientation == Orientation.X1RIGHT_X2UP ? oy[0] : ox[0];
        }
        int shift = 0;
        if (this._alignment == Alignment.ALIGN_BEFORE) {
            shift = -1;
        } else if (this._alignment == Alignment.ALIGN_AFTER) {
            shift = 1;
        }
        for (int is = 0; is < this._ns; ++is) {
            int n = this._nx.get(is);
            float[] x1 = ArrayMath.copy(this._x1.get(is));
            float[] x2 = ArrayMath.copy(this._x2.get(is));
            if (this._stackingBars) {
                for (int i = 0; i < n; ++i) {
                    int n2 = i;
                    x2[n2] = x2[n2] + bottom[i];
                }
            }
            this.computeXY(hp, vp, ts, n, x1, x2, x, y);
            if (this._colorMaps[is] != null) {
                this.paintBars(gbar, this._barWidth, prevTop, n, x, y, shift, is, true, colors[is]);
            }
            if (this._lineColor[is] != null) {
                gbar.setColor(this._lineColor[is]);
            } else {
                gbar.setColor(Color.BLACK);
            }
            this.paintBars(gbar, this._barWidth, prevTop, n, x, y, shift, is, false, null);
            if (!this._stackingBars) continue;
            if (this._orientation == Orientation.X1RIGHT_X2UP) {
                bottom = ArrayMath.copy(x2);
                prevTop = ArrayMath.copy(y);
                continue;
            }
            prevTop = ArrayMath.copy(x);
            bottom = ArrayMath.copy(x2);
        }
    }

    private void updateBestProjectors() {
        int max = Collections.max(this._nx);
        float[] sum = new float[max];
        float x1min = Float.MAX_VALUE;
        float x2min = Float.MAX_VALUE;
        float x1max = -3.4028235E38f;
        float x2max = -3.4028235E38f;
        for (int is = 0; is < this._ns; ++is) {
            int nx = this._nx.get(is);
            float[] x1 = this._x1.get(is);
            float[] x2 = this._x2.get(is);
            for (int ix = 0; ix < nx; ++ix) {
                float x1i = x1[ix];
                float x2i = x2[ix];
                x1min = ArrayMath.min(x1min, x1i);
                x1max = ArrayMath.max(x1max, x1i);
                x2min = ArrayMath.min(x2min, x2i);
                x2max = ArrayMath.max(x2max, x2i);
                int n = ix;
                sum[n] = sum[n] + x2[ix];
            }
        }
        if (this._stackingBars) {
            x2max = ArrayMath.max(0.0f, ArrayMath.max(sum));
            x2min = ArrayMath.min(0.0f, ArrayMath.min(sum));
        }
        if (x1min == x1max) {
            x1min -= ArrayMath.ulp(x1min);
            x1max += ArrayMath.ulp(x1max);
        }
        if (x2min == x2max) {
            x2min -= ArrayMath.ulp(x2min);
            x2max += ArrayMath.ulp(x2max);
        }
        double u0 = 0.0;
        double u1 = 1.0;
        if (this._lineWidth > 1.0f) {
            u0 = 0.01;
            u1 = 0.99;
        }
        float w = this._barWidth / 2.0f;
        if (this._alignment == Alignment.ALIGN_CENTER) {
            x1min -= w;
            x1max += w;
        } else if (this._alignment == Alignment.ALIGN_BEFORE) {
            x1min -= 2.0f * w;
        } else {
            x1max += 2.0f * w;
        }
        Projector bhp = null;
        Projector bvp = null;
        if (this._orientation == Orientation.X1RIGHT_X2UP) {
            bhp = x1min < x1max ? new Projector(x1min, x1max, u0, u1) : null;
            bvp = x2min < x2max ? new Projector(x2max, x2min, u0, u1) : null;
        } else if (this._orientation == Orientation.X1DOWN_X2RIGHT) {
            bhp = x2min < x2max ? new Projector(x2min, x2max, u0, u1) : null;
            bvp = x1min < x1max ? new Projector(x1min, x1max, u0, u1) : null;
        }
        this.setBestProjectors(bhp, bvp);
    }

    private boolean equalColors(Color ca, Color cb) {
        return ca == null ? cb == null : ca.equals(cb);
    }

    private void computeXY(Projector hp, Projector vp, Transcaler ts, int n, float[] x1, float[] x2, int[] x, int[] y) {
        ts = ts.combineWith(hp, vp);
        float[] xv = null;
        float[] yv = null;
        if (this._orientation == Orientation.X1RIGHT_X2UP) {
            xv = x1;
            yv = x2;
        } else if (this._orientation == Orientation.X1DOWN_X2RIGHT) {
            xv = x2;
            yv = x1;
        }
        for (int i = 0; i < n; ++i) {
            x[i] = ts.x(xv[i]);
            y[i] = ts.y(yv[i]);
        }
    }

    private void paintBars(Graphics2D g2d, float wb, int[] bottoms, int n, int[] x, int[] y, int s, int adj, boolean fill, Color[] colors) {
        if (this._orientation == Orientation.X1RIGHT_X2UP) {
            this.paintBarsVertical(g2d, wb, bottoms, n, x, y, s, adj, fill, colors);
        } else {
            this.paintBarsHorizontal(g2d, wb, bottoms, n, x, y, s, adj, fill, colors);
        }
    }

    private void paintBarsHorizontal(Graphics2D g2d, float wb, int[] bottoms, int n, int[] x, int[] y, int s, int adj, boolean fill, Color[] colors) {
        float frac = (float)adj / (float)this._ns;
        int w = n > 1 ? (int)(wb * (float)(y[1] - y[0])) : 1;
        int hw = w / 2;
        int yim1 = y[0] - hw + s * hw;
        for (int i = 0; i < n; ++i) {
            int pw;
            int py;
            int zero = bottoms[i];
            w = i > 1 ? (int)(wb * (float)(y[i] - y[i - 1])) : w;
            hw = w / 2;
            int ypos = ArrayMath.max(yim1, y[i] - hw);
            int xpos = ArrayMath.min(zero, x[i]);
            int h = ArrayMath.abs(zero - x[i]);
            if (!this._stackingBars) {
                py = ypos + (int)((float)w * frac);
                pw = w / this._ns;
            } else {
                py = ypos;
                pw = w;
            }
            if (fill) {
                g2d.setColor(colors[i]);
                g2d.fillRect(xpos, py, h, pw);
            } else {
                g2d.drawRect(xpos, py, h, pw);
            }
            yim1 = ypos + w;
        }
    }

    private void paintBarsVertical(Graphics2D g2d, float wb, int[] bottoms, int n, int[] x, int[] y, int s, int adj, boolean fill, Color[] colors) {
        float frac = (float)adj / (float)this._ns;
        int w = n > 1 ? (int)(wb * (float)(x[1] - x[0])) : 1;
        int hw = w / 2;
        int xim1 = x[0] - hw + s * hw;
        for (int i = 0; i < n; ++i) {
            int pw;
            int px;
            int zero = bottoms[i];
            w = i > 1 ? (int)(wb * (float)(x[i] - x[i - 1])) : w;
            hw = w / 2;
            int xpos = ArrayMath.max(xim1, x[i] - hw);
            int ypos = ArrayMath.min(zero, y[i]);
            int h = ArrayMath.abs(zero - y[i]);
            if (!this._stackingBars) {
                px = xpos + (int)((float)w * frac);
                pw = w / this._ns;
            } else {
                px = xpos;
                pw = w;
            }
            if (fill) {
                g2d.setColor(colors[i]);
                g2d.fillRect(px, ypos, pw, h);
            } else {
                g2d.drawRect(px, ypos, pw, h);
            }
            xim1 = xpos + w;
        }
    }

    private void paintLabel(Graphics2D g2d, int s, int n, int[] x, int[] y, float[] z) {
        s /= 2;
        for (int i = 0; i < n; ++i) {
            int xi = x[i];
            int yi = y[i];
            g2d.drawString(String.format(this._textFormat, Float.valueOf(z[i])), xi + s, yi - s);
        }
    }

    public static enum Alignment {
        ALIGN_CENTER,
        ALIGN_BEFORE,
        ALIGN_AFTER;

    }

    public static enum Line {
        NONE,
        SOLID,
        DASH,
        DOT,
        DASH_DOT;

    }

    public static enum Orientation {
        X1RIGHT_X2UP,
        X1DOWN_X2RIGHT;

    }
}

