/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.mesh;

import edu.mines.jtk.mesh.Geometry;
import edu.mines.jtk.util.Check;
import edu.mines.jtk.util.MathPlus;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import javax.swing.event.EventListenerList;

public class TriMesh
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int NODE_MARK_MAX = 0x7FFFFFFE;
    private static final int TRI_MARK_MAX = 0x7FFFFFFE;
    private long _version;
    private int _nnode;
    private int _ntri;
    private Node _nroot;
    private Tri _troot;
    private HashSet<Node> _sampledNodes;
    private int _triMarkRed;
    private int _triMarkBlue;
    private int _nodeMarkRed;
    private int _nodeMarkBlue;
    private EdgeSet _edgeSet;
    private NodeSet _nodeSet;
    private NodeList _nodeList;
    private Node _nmin;
    private double _dmin;
    private TriList _deadTris;
    private int _nnodeListeners;
    private int _ntriListeners;
    private EventListenerList _listeners;
    private boolean _outerEnabled;
    private double _xminOuter;
    private double _yminOuter;
    private double _xmaxOuter;
    private double _ymaxOuter;
    private int _nnodeValues;
    private int _lnodeValues;
    private Map<String, NodePropertyMap> _nodePropertyMaps;
    static final boolean DEBUG = false;
    static final boolean TRACE = false;

    public synchronized NodePropertyMap getNodePropertyMap(String name) {
        NodePropertyMap map = this._nodePropertyMaps.get(name);
        if (map == null) {
            if (this._nnodeValues == this._lnodeValues) {
                this._lnodeValues = this._lnodeValues == 0 ? 4 : (this._lnodeValues *= 2);
                NodeIterator ni = this.getNodes();
                while (ni.hasNext()) {
                    Node node = ni.next();
                    Object[] valuesOld = node._values;
                    Object[] valuesNew = new Object[this._lnodeValues];
                    for (int i = 0; i < this._nnodeValues; ++i) {
                        valuesNew[i] = valuesOld[i];
                    }
                    Node.access$1102(node, valuesNew);
                }
            }
            int index = this._nnodeValues++;
            map = new NodePropertyMapInternal(index);
            this._nodePropertyMaps.put(name, map);
        }
        return map;
    }

    public synchronized boolean hasNodePropertyMap(String name) {
        return this._nodePropertyMaps.containsKey(name);
    }

    public synchronized String[] getNodePropertyMapNames() {
        Set<String> nameSet = this._nodePropertyMaps.keySet();
        String[] names = new String[nameSet.size()];
        return nameSet.toArray(names);
    }

    public synchronized void addNodeListener(NodeListener nl) {
        this._listeners.add(NodeListener.class, nl);
        ++this._nnodeListeners;
    }

    public synchronized void removeNodeListener(NodeListener nl) {
        this._listeners.remove(NodeListener.class, nl);
        --this._nnodeListeners;
    }

    public synchronized void addTriListener(TriListener tl) {
        this._listeners.add(TriListener.class, tl);
        ++this._ntriListeners;
    }

    public synchronized void removeTriListener(TriListener tl) {
        this._listeners.remove(TriListener.class, tl);
        --this._ntriListeners;
    }

    public TriMesh() {
        this.init();
    }

    public int countNodes() {
        return this._nnode;
    }

    public int countTris() {
        return this._ntri;
    }

    public long getVersion() {
        return this._version;
    }

    public synchronized boolean addNode(Node node) {
        PointLocation pl = this.locatePoint(node._x, node._y);
        if (pl.isOnNode()) {
            return false;
        }
        this.fireNodeWillBeAdded(node);
        if (this._nroot == null) {
            this._nroot = node;
            this._nroot._prev = (this._nroot._next = this._nroot);
        } else {
            node._next = this._nroot;
            node._prev = this._nroot._prev;
            this._nroot._prev._next = node;
            this._nroot._prev = node;
            this._nroot = node;
        }
        ++this._nnode;
        this.updatePropertyValues(node);
        double factor = 0.45 * (double)this._sampledNodes.size();
        if (factor * factor * factor < (double)this._nnode) {
            this._sampledNodes.add(node);
        }
        if (pl.isOutside() && this._nnode <= 3) {
            if (this._nnode == 3) {
                this.createFirstTri();
            }
        } else {
            this.clearTriMarks();
            this._edgeSet.clear();
            if (pl.isInside()) {
                this.getDelaunayEdgesInside(node, pl.tri());
            } else {
                this.getDelaunayEdgesOutside(node, pl.tri());
            }
            this._nodeSet.clear();
            boolean more = this._edgeSet.first();
            while (more) {
                Node a = this._edgeSet.a;
                Node b = this._edgeSet.b;
                Node c = this._edgeSet.c;
                Tri abc = this._edgeSet.abc;
                Tri nba = this.makeTri(node, b, a);
                this.linkTris(nba, node, abc, c);
                if (!this._nodeSet.add(a, b, nba)) {
                    this.linkTris(this._nodeSet.nba, this._nodeSet.b, nba, b);
                }
                if (!this._nodeSet.add(b, a, nba)) {
                    this.linkTris(this._nodeSet.nba, this._nodeSet.b, nba, a);
                }
                more = this._edgeSet.next();
            }
        }
        this.fireNodeAdded(node);
        return true;
    }

    public synchronized boolean removeNode(Node node) {
        Tri tri = node._tri;
        if (tri == null) {
            return false;
        }
        this.fireNodeWillBeRemoved(node);
        this._nroot = node._next;
        this._nmin = node._next;
        if (this._nroot == node) {
            this._nroot = null;
            this._nmin = null;
        }
        node._prev._next = node._next;
        node._next._prev = node._prev;
        node._prev = null;
        node._next = null;
        node._tri = null;
        this._sampledNodes.remove(node);
        --this._nnode;
        if (this._nnode < 3) {
            if (this._nnode == 2) {
                Node n0 = this._nroot;
                Node n1 = n0._next;
                n0._tri = null;
                n1._tri = null;
                this.killTri(this._troot);
                this._troot = null;
            }
            return true;
        }
        this._edgeSet.clear();
        this._nodeList.clear();
        this.clearTriMarks();
        this.clearNodeMarks();
        this.getDelaunayEdgesOpposite(node, tri);
        int nnode = this._nodeList.nnode();
        Node[] nodes = this._nodeList.nodes();
        boolean more = this._edgeSet.remove();
        while (more) {
            Node a = this._edgeSet.a;
            Node b = this._edgeSet.b;
            Node c = this._edgeSet.c;
            Tri abc = this._edgeSet.abc;
            Node n = null;
            for (int inode = 0; inode < nnode; ++inode) {
                Node m = nodes[inode];
                if (m == a || m == b || TriMesh.leftOfLine(a, b, m) || n != null && !TriMesh.inCircle(n, b, a, m)) continue;
                n = m;
            }
            if (n != null) {
                Tri nba = this.makeTri(n, b, a);
                this.linkTris(nba, n, abc, c);
                if (!this._edgeSet.add(nba, a)) {
                    this.linkTris(this._edgeSet.abc, this._edgeSet.c, nba, a);
                }
                if (!this._edgeSet.add(nba, b)) {
                    this.linkTris(this._edgeSet.abc, this._edgeSet.c, nba, b);
                }
            } else {
                this.linkTris(abc, c, null, null);
                a._tri = abc;
                b._tri = abc;
                this._troot = abc;
            }
            more = this._edgeSet.remove();
        }
        this.fireNodeRemoved(node);
        return true;
    }

    public synchronized boolean moveNode(Node node, float x, float y) {
        Node nodeNearest;
        if (!(x == node.x() && y == node.y() || node != (nodeNearest = this.findNodeNearest(x, y)) && x == nodeNearest.x() && y == nodeNearest.y())) {
            boolean nodeInMesh = this.removeNode(node);
            node.setPosition(x, y);
            if (nodeInMesh) {
                boolean addedNode = this.addNode(node);
                assert (addedNode);
            }
            return true;
        }
        return false;
    }

    public synchronized Node findNodeNearest(float x, float y) {
        return this.findNodeNearest((double)x, (double)y);
    }

    public synchronized Edge findEdge(Node na, Node nb) {
        Tri tri = this.findTri(na, nb);
        if (tri != null) {
            return TriMesh.edgeOfTri(tri, na, nb);
        }
        return null;
    }

    public Tri findTri(Node node) {
        return node._tri;
    }

    public synchronized Tri findTri(Node na, Node nb) {
        Tri tri = this.findTri(na);
        if (tri != null) {
            this.clearTriMarks();
            tri = this.findTri(tri, na, nb);
        }
        return tri;
    }

    public synchronized Tri findTri(Node na, Node nb, Node nc) {
        Tri tri = this.findTri(na, nb);
        if (tri != null) {
            this.clearTriMarks();
            tri = this.findTri(tri, na, nb, nc);
        }
        return tri;
    }

    public synchronized PointLocation locatePoint(float x, float y) {
        return this.locatePoint((double)x, (double)y);
    }

    public synchronized NodeIterator getNodes() {
        return new NodeIterator(){
            private Node _nroot;
            private Node _nnext;
            {
                this._nnext = this._nroot = TriMesh.this._nroot;
            }

            @Override
            public boolean hasNext() {
                return this._nnext != null;
            }

            @Override
            public Node next() {
                if (this._nnext == null) {
                    throw new NoSuchElementException();
                }
                Node node = this._nnext;
                this._nnext = node._next;
                if (this._nnext == this._nroot) {
                    this._nnext = null;
                }
                return node;
            }
        };
    }

    public synchronized TriIterator getTris() {
        return new TriIterator(){
            private Iterator<Tri> _i;
            {
                TriMesh.this.clearTriMarks();
                ArrayList<Tri> stack = new ArrayList<Tri>(128);
                ArrayList<Tri> list = new ArrayList<Tri>(TriMesh.this._ntri);
                if (TriMesh.this._troot != null) {
                    stack.add(TriMesh.this._troot);
                    TriMesh.this.mark(TriMesh.this._troot);
                }
                int n = stack.size();
                while (n > 0) {
                    Tri t2;
                    Tri t1;
                    Tri tri = (Tri)stack.remove(n - 1);
                    list.add(tri);
                    Tri t0 = tri._t0;
                    if (t0 != null && !TriMesh.this.isMarked(t0)) {
                        stack.add(t0);
                        TriMesh.this.mark(t0);
                    }
                    if ((t1 = tri._t1) != null && !TriMesh.this.isMarked(t1)) {
                        stack.add(t1);
                        TriMesh.this.mark(t1);
                    }
                    if ((t2 = tri._t2) != null && !TriMesh.this.isMarked(t2)) {
                        stack.add(t2);
                        TriMesh.this.mark(t2);
                    }
                    n = stack.size();
                }
                this._i = list.iterator();
            }

            @Override
            public final boolean hasNext() {
                return this._i.hasNext();
            }

            @Override
            public final Tri next() {
                return this._i.next();
            }
        };
    }

    public synchronized EdgeIterator getEdgesOnHull() {
        this.clearTriMarks();
        Edge edge = this.getEdgeOnHull(this._troot);
        final HashSet<Edge> edges = new HashSet<Edge>(128);
        this.getEdgesOnHull(edge, edges);
        return new EdgeIterator(){
            private Iterator<Edge> i;
            {
                this.i = edges.iterator();
            }

            @Override
            public final boolean hasNext() {
                return this.i.hasNext();
            }

            @Override
            public final Edge next() {
                return this.i.next();
            }
        };
    }

    public synchronized Node[] getNodeNabors(Node node) {
        NodeList nabors = new NodeList();
        this.getNodeNabors(node, nabors);
        return nabors.trim();
    }

    public synchronized void getNodeNabors(Node node, NodeList nabors) {
        this.clearNodeMarks();
        this.clearTriMarks();
        this.getNodeNabors(node, node._tri, nabors);
    }

    public synchronized NodeStepList getNodeNabors(Node node, int stepMax) {
        Check.argument(stepMax <= 256, "stepMax <= 256");
        this.clearNodeMarks();
        this.mark(node);
        NodeStepList list = new NodeStepList();
        int nnabor1 = 0;
        for (int step = 1; step <= stepMax; ++step) {
            if (step == 1) {
                this.getNodeNabors(node, step, list);
                continue;
            }
            int nnabor2 = list.nnode();
            Node[] naborNodes = list.nodes();
            for (int inabor = nnabor1; inabor < nnabor2; ++inabor) {
                node = naborNodes[inabor];
                this.getNodeNabors(node, step, list);
            }
            nnabor1 = nnabor2;
        }
        return list;
    }

    public synchronized Tri[] getTriNabors(Node node) {
        TriList nabors = new TriList();
        this.getTriNabors(node, nabors);
        return nabors.trim();
    }

    public synchronized void getTriNabors(Node node, TriList nabors) {
        this.clearTriMarks();
        this.getTriNabors(node, node._tri, nabors);
    }

    public synchronized Tri[] getTriNabors(Edge edge) {
        TriList nabors = new TriList();
        this.getTriNabors(edge, nabors);
        return nabors.trim();
    }

    public synchronized void getTriNabors(Edge edge, TriList nabors) {
        Tri triLeft = edge.triLeft();
        Tri triRight = edge.triRight();
        if (triLeft == null && triRight == null) {
            Node na = edge.nodeA();
            Node nb = edge.nodeB();
            edge = this.findEdge(na, nb);
            triLeft = edge.triLeft();
            triRight = edge.triRight();
        }
        if (triLeft != null) {
            nabors.add(triLeft);
        }
        if (triRight != null) {
            nabors.add(triRight);
        }
    }

    public synchronized Edge[] getEdgeNabors(Node node) {
        EdgeList nabors = new EdgeList();
        this.getEdgeNabors(node, nabors);
        return nabors.trim();
    }

    public synchronized void getEdgeNabors(Node node, EdgeList nabors) {
        Tri tri = node.tri();
        Node ta = tri.nodeA();
        Node tb = tri.nodeB();
        Node tc = tri.nodeC();
        Edge edge = null;
        if (node == ta) {
            edge = new Edge(tc, ta, tri);
        } else if (node == tb) {
            edge = new Edge(ta, tb, tri);
        } else if (node == tc) {
            edge = new Edge(tb, tc, tri);
        } else assert (false) : "tri references node";
        Edge firstEdge = edge;
        do {
            nabors.add(edge);
            node = edge.nodeA();
            tri = edge.triRight();
            if (tri == null) {
                tri = edge.triLeft();
                Node nodeBack = edge.nodeLeft();
                Tri triBack = tri.triNabor(node);
                while (triBack != null) {
                    node = nodeBack;
                    nodeBack = tri.nodeNabor(triBack);
                    tri = triBack;
                    triBack = tri.triNabor(node);
                }
                edge = new Edge(null, null, tri, node);
                continue;
            }
            edge = new Edge(tri, node);
        } while (!edge.equals(firstEdge));
    }

    public synchronized void setOuterBox(float xmin, float ymin, float xmax, float ymax) {
        Check.argument(xmin < xmax, "outer box is valid");
        Check.argument(ymin < ymax, "outer box is valid");
        if ((double)xmin != this._xminOuter || (double)xmax != this._xmaxOuter || (double)ymin != this._yminOuter || (double)ymax != this._ymaxOuter) {
            this._xminOuter = xmin;
            this._yminOuter = ymin;
            this._xmaxOuter = xmax;
            this._ymaxOuter = ymax;
            TriIterator ti = this.getTris();
            while (ti.hasNext()) {
                Tri tri = ti.next();
                tri.clearInner();
                tri.clearOuter();
            }
        }
        ++this._version;
        this._outerEnabled = true;
    }

    public void enableOuterBox() {
        ++this._version;
        this._outerEnabled = true;
    }

    public void disableOuterBox() {
        ++this._version;
        this._outerEnabled = false;
    }

    public boolean isInner(Node node) {
        Tri tri = node.tri();
        if (tri == null || this.isInner(tri)) {
            return true;
        }
        Tri[] tris = this.getTriNabors(node);
        int ntri = tris.length;
        for (int itri = 0; itri < ntri; ++itri) {
            if (!this.isInner(tris[itri])) continue;
            return true;
        }
        return false;
    }

    public boolean isOuter(Node node) {
        return !this.isInner(node);
    }

    public boolean isInner(Tri tri) {
        if (!this._outerEnabled) {
            return true;
        }
        if (!tri.isInner() && !tri.isOuter()) {
            this.markTriInnerOrOuter(tri);
        }
        return tri.isInner();
    }

    public boolean isOuter(Tri tri) {
        return !this.isInner(tri);
    }

    public boolean isInner(Edge edge) {
        Tri triLeft = edge.triLeft();
        if (triLeft != null && this.isInner(triLeft)) {
            return true;
        }
        Tri triRight = edge.triRight();
        return triRight != null && this.isInner(triRight);
    }

    public boolean isOuter(Edge edge) {
        return !this.isInner(edge);
    }

    public final void mark(Node node) {
        node._mark = this._nodeMarkRed;
    }

    public final void markRed(Node node) {
        node._mark = this._nodeMarkRed;
    }

    public final void markBlue(Node node) {
        node._mark = this._nodeMarkBlue;
    }

    public final boolean isMarked(Node node) {
        return node._mark == this._nodeMarkRed;
    }

    public final boolean isMarkedRed(Node node) {
        return node._mark == this._nodeMarkRed;
    }

    public final boolean isMarkedBlue(Node node) {
        return node._mark == this._nodeMarkBlue;
    }

    public synchronized void clearNodeMarks() {
        if (this._nodeMarkRed == 0x7FFFFFFE) {
            Node node = this._nroot;
            do {
                node._mark = 0;
            } while ((node = node._next) != this._nroot);
            this._nodeMarkRed = 0;
            this._nodeMarkBlue = 0;
        }
        ++this._nodeMarkRed;
        --this._nodeMarkBlue;
    }

    public final void mark(Tri tri) {
        tri._mark = this._triMarkRed;
    }

    public final void markRed(Tri tri) {
        tri._mark = this._triMarkRed;
    }

    public final void markBlue(Tri tri) {
        tri._mark = this._triMarkBlue;
    }

    public final boolean isMarked(Tri tri) {
        return tri._mark == this._triMarkRed;
    }

    public final boolean isMarkedRed(Tri tri) {
        return tri._mark == this._triMarkRed;
    }

    public final boolean isMarkedBlue(Tri tri) {
        return tri._mark == this._triMarkBlue;
    }

    public synchronized void clearTriMarks() {
        if (this._triMarkRed == 0x7FFFFFFE) {
            ++this._triMarkRed;
            --this._triMarkBlue;
            this.markAllTris(this._troot);
            this.zeroTriMarks(this._troot);
            this._triMarkRed = 0;
            this._triMarkBlue = 0;
        }
        ++this._triMarkRed;
        --this._triMarkBlue;
    }

    public synchronized void validate() {
        int nnode = 0;
        NodeIterator ni = this.getNodes();
        while (ni.hasNext()) {
            ++nnode;
            Node node = ni.next();
            this.validate(node);
        }
        assert (nnode == this._nnode);
        int ntri = 0;
        TriIterator ti = this.getTris();
        while (ti.hasNext()) {
            ++ntri;
            Tri tri = ti.next();
            this.validate(tri);
        }
        assert (ntri == this._ntri);
    }

    protected void init() {
        this._version = 0L;
        this._nnode = 0;
        this._ntri = 0;
        this._nroot = null;
        this._troot = null;
        this._sampledNodes = new HashSet(256);
        this._triMarkRed = 0;
        this._triMarkBlue = 0;
        this._nodeMarkRed = 0;
        this._nodeMarkBlue = 0;
        this._edgeSet = new EdgeSet(256, 0.25);
        this._nodeSet = new NodeSet(256, 0.25);
        this._nodeList = new NodeList();
        this._nmin = null;
        this._dmin = 0.0;
        this._deadTris = new TriList();
        this._nnodeListeners = 0;
        this._ntriListeners = 0;
        this._listeners = new EventListenerList();
        this._outerEnabled = false;
        this._xminOuter = 0.0;
        this._yminOuter = 0.0;
        this._xmaxOuter = 0.0;
        this._ymaxOuter = 0.0;
        this._nnodeValues = 0;
        this._lnodeValues = 0;
        this._nodePropertyMaps = new HashMap<String, NodePropertyMap>();
    }

    private synchronized void updatePropertyValues(Node node) {
        if (this._lnodeValues == 0) {
            Node.access$1102(node, null);
        } else if (node._values == null) {
            Node.access$1102(node, new Object[this._lnodeValues]);
        } else if (node._values.length != this._lnodeValues) {
            Object[] valuesOld = node._values;
            Object[] valuesNew = new Object[this._lnodeValues];
            int n = MathPlus.min(valuesOld.length, valuesNew.length);
            for (int i = 0; i < n; ++i) {
                valuesNew[i] = valuesOld[i];
            }
            Node.access$1102(node, valuesNew);
        }
    }

    private Tri makeTri(Node n0, Node n1, Node n2) {
        ++this._ntri;
        int ndead = this._deadTris.ntri();
        if (ndead == 0) {
            this._troot = new Tri(n0, n1, n2);
        } else {
            this._troot = this._deadTris.remove(ndead - 1);
            this._troot.init(n0, n1, n2);
        }
        if (this._ntriListeners > 0) {
            this.fireTriAdded(this._troot);
        }
        return this._troot;
    }

    private void killTri(Tri tri) {
        --this._ntri;
        this.fireTriRemoved(tri);
        int ndead = this._deadTris.ntri();
        if (ndead < 256) {
            this._deadTris.add(tri);
        }
    }

    private static double distanceSquared(Node node, double x, double y) {
        double dx = x - node._x;
        double dy = y - node._y;
        return dx * dx + dy * dy;
    }

    private static boolean leftOfLine(Node a, Node b, Node n) {
        return Geometry.leftOfLine(a._x, a._y, b._x, b._y, n._x, n._y) > 0.0;
    }

    private static boolean leftOfLine(Node a, Node b, double x, double y) {
        return Geometry.leftOfLine(a._x, a._y, b._x, b._y, x, y) > 0.0;
    }

    private static boolean inCircle(Node a, Node b, Node c, Node n) {
        return Geometry.inCircle(a._x, a._y, b._x, b._y, c._x, c._y, n._x, n._y) > 0.0;
    }

    private static boolean inCircle(Node a, Node b, Node c, double x, double y) {
        return Geometry.inCircle(a._x, a._y, b._x, b._y, c._x, c._y, x, y) > 0.0;
    }

    private void createFirstTri() {
        Check.state(this._nnode == 3, "exactly three nodes available for first tri");
        Node n0 = this._nroot;
        Node n1 = n0._next;
        Node n2 = n1._next;
        double orient = Geometry.leftOfLine(n0._x, n0._y, n1._x, n1._y, n2._x, n2._y);
        Check.state(orient != 0.0, "three nodes for first tri are not co-linear");
        if (orient > 0.0) {
            this.makeTri(n0, n1, n2);
        } else {
            this.makeTri(n0, n2, n1);
        }
    }

    private void getNodeNabors(Node node, Tri tri, NodeList nabors) {
        this.mark(tri);
        Node n0 = tri._n0;
        Node n1 = tri._n1;
        Node n2 = tri._n2;
        Tri t0 = tri._t0;
        Tri t1 = tri._t1;
        Tri t2 = tri._t2;
        if (node == n0) {
            if (!this.isMarked(n1)) {
                this.mark(n1);
                nabors.add(n1);
            }
            if (!this.isMarked(n2)) {
                this.mark(n2);
                nabors.add(n2);
            }
            if (t1 != null && !this.isMarked(t1)) {
                this.getNodeNabors(node, t1, nabors);
            }
            if (t2 != null && !this.isMarked(t2)) {
                this.getNodeNabors(node, t2, nabors);
            }
        } else if (node == n1) {
            if (!this.isMarked(n2)) {
                this.mark(n2);
                nabors.add(n2);
            }
            if (!this.isMarked(n0)) {
                this.mark(n0);
                nabors.add(n0);
            }
            if (t2 != null && !this.isMarked(t2)) {
                this.getNodeNabors(node, t2, nabors);
            }
            if (t0 != null && !this.isMarked(t0)) {
                this.getNodeNabors(node, t0, nabors);
            }
        } else if (node == n2) {
            if (!this.isMarked(n0)) {
                this.mark(n0);
                nabors.add(n0);
            }
            if (!this.isMarked(n1)) {
                this.mark(n1);
                nabors.add(n1);
            }
            if (t0 != null && !this.isMarked(t0)) {
                this.getNodeNabors(node, t0, nabors);
            }
            if (t1 != null && !this.isMarked(t1)) {
                this.getNodeNabors(node, t1, nabors);
            }
        } else assert (false) : "node is referenced by tri";
    }

    private void getNodeNabors(Node node, int step, NodeStepList nabors) {
        for (Tri tri : this.getTriNabors(node)) {
            Node n0 = tri._n0;
            Node n1 = tri._n1;
            Node n2 = tri._n2;
            if (node == n0) {
                if (!this.isMarked(n1)) {
                    this.mark(n1);
                    nabors.add(n1, step);
                }
                if (this.isMarked(n2)) continue;
                this.mark(n2);
                nabors.add(n2, step);
                continue;
            }
            if (node == n1) {
                if (!this.isMarked(n0)) {
                    this.mark(n0);
                    nabors.add(n0, step);
                }
                if (this.isMarked(n2)) continue;
                this.mark(n2);
                nabors.add(n2, step);
                continue;
            }
            if (node != n2) continue;
            if (!this.isMarked(n0)) {
                this.mark(n0);
                nabors.add(n0, step);
            }
            if (this.isMarked(n1)) continue;
            this.mark(n1);
            nabors.add(n1, step);
        }
    }

    private void getTriNabors(Node node, Tri tri, TriList nabors) {
        if (tri != null) {
            this.mark(tri);
            nabors.add(tri);
            Node n0 = tri._n0;
            Node n1 = tri._n1;
            Node n2 = tri._n2;
            Tri t0 = tri._t0;
            Tri t1 = tri._t1;
            Tri t2 = tri._t2;
            if (node == n0) {
                if (t1 != null && !this.isMarked(t1)) {
                    this.getTriNabors(node, t1, nabors);
                }
                if (t2 != null && !this.isMarked(t2)) {
                    this.getTriNabors(node, t2, nabors);
                }
            } else if (node == n1) {
                if (t2 != null && !this.isMarked(t2)) {
                    this.getTriNabors(node, t2, nabors);
                }
                if (t0 != null && !this.isMarked(t0)) {
                    this.getTriNabors(node, t0, nabors);
                }
            } else if (node == n2) {
                if (t0 != null && !this.isMarked(t0)) {
                    this.getTriNabors(node, t0, nabors);
                }
                if (t1 != null && !this.isMarked(t1)) {
                    this.getTriNabors(node, t1, nabors);
                }
            } else assert (false) : "node is referenced by tri";
        }
    }

    private Node findNodeNearest(double x, double y) {
        double dmin;
        this._nmin = this._nroot;
        this._dmin = TriMesh.distanceSquared(this._nmin, x, y);
        for (Node n : this._sampledNodes) {
            double d = TriMesh.distanceSquared(n, x, y);
            if (!(d < this._dmin)) continue;
            this._dmin = d;
            this._nmin = n;
        }
        this.clearNodeMarks();
        do {
            this.clearTriMarks();
            dmin = this._dmin;
            this.findNodeNaborNearest(x, y, this._nmin, this._nmin._tri);
        } while (this._dmin < dmin);
        return this._nmin;
    }

    private void findNodeNaborNearest(double x, double y, Node node, Tri tri) {
        this.mark(tri);
        Node n0 = tri._n0;
        Node n1 = tri._n1;
        Node n2 = tri._n2;
        Tri t0 = tri._t0;
        Tri t1 = tri._t1;
        Tri t2 = tri._t2;
        if (node == n0) {
            this.findNodeNaborNearest(x, y, node, n1, n2, t1, t2);
        } else if (node == n1) {
            this.findNodeNaborNearest(x, y, node, n2, n0, t2, t0);
        } else if (node == n2) {
            this.findNodeNaborNearest(x, y, node, n0, n1, t0, t1);
        } else assert (false) : "node is referenced by tri";
    }

    private void findNodeNaborNearest(double x, double y, Node node, Node na, Node nb, Tri ta, Tri tb) {
        if (!this.isMarked(na)) {
            this.mark(na);
            double da = TriMesh.distanceSquared(na, x, y);
            if (da < this._dmin) {
                this._dmin = da;
                this._nmin = na;
            }
        }
        if (!this.isMarked(nb)) {
            this.mark(nb);
            double db = TriMesh.distanceSquared(nb, x, y);
            if (db < this._dmin) {
                this._dmin = db;
                this._nmin = nb;
            }
        }
        if (ta != null && !this.isMarked(ta)) {
            this.findNodeNaborNearest(x, y, node, ta);
        }
        if (tb != null && !this.isMarked(tb)) {
            this.findNodeNaborNearest(x, y, node, tb);
        }
    }

    private Tri findTri(Tri tri, Node na, Node nb) {
        if (tri != null) {
            this.mark(tri);
            Node n0 = tri._n0;
            Node n1 = tri._n1;
            Node n2 = tri._n2;
            Tri t0 = tri._t0;
            Tri t1 = tri._t1;
            Tri t2 = tri._t2;
            if (na == n0) {
                if (nb == n1 || nb == n2 || t1 != null && !this.isMarked(t1) && (tri = this.findTri(t1, na, nb)) != null || t2 != null && !this.isMarked(t2) && (tri = this.findTri(t2, na, nb)) != null) {
                    return tri;
                }
            } else if (na == n1) {
                if (nb == n2 || nb == n0 || t2 != null && !this.isMarked(t2) && (tri = this.findTri(t2, na, nb)) != null || t0 != null && !this.isMarked(t0) && (tri = this.findTri(t0, na, nb)) != null) {
                    return tri;
                }
            } else if (na == n2) {
                if (nb == n0 || nb == n1 || t0 != null && !this.isMarked(t0) && (tri = this.findTri(t0, na, nb)) != null || t1 != null && !this.isMarked(t1) && (tri = this.findTri(t1, na, nb)) != null) {
                    return tri;
                }
            } else assert (false) : "node na is referenced by tri";
        }
        return null;
    }

    private Tri findTri(Tri tri, Node na, Node nb, Node nc) {
        if (tri != null) {
            this.mark(tri);
            Node n0 = tri._n0;
            Node n1 = tri._n1;
            Node n2 = tri._n2;
            Tri t0 = tri._t0;
            Tri t1 = tri._t1;
            Tri t2 = tri._t2;
            if (na == n0) {
                if (nb == n1) {
                    if (nc == n2 || t2 != null && !this.isMarked(t2) && (tri = this.findTri(t2, na, nb, nc)) != null) {
                        return tri;
                    }
                } else if (nb == n2) {
                    if (nc == n1 || t1 != null && !this.isMarked(t1) && (tri = this.findTri(t1, na, nb, nc)) != null) {
                        return tri;
                    }
                } else assert (false) : "node nb is referenced by tri";
            } else if (na == n1) {
                if (nb == n0) {
                    if (nc == n2 || t2 != null && !this.isMarked(t2) && (tri = this.findTri(t2, na, nb, nc)) != null) {
                        return tri;
                    }
                } else if (nb == n2) {
                    if (nc == n0 || t0 != null && !this.isMarked(t0) && (tri = this.findTri(t0, na, nb, nc)) != null) {
                        return tri;
                    }
                } else assert (false) : "node nb is referenced by tri";
            } else if (na == n2) {
                if (nb == n0) {
                    if (nc == n1 || t1 != null && !this.isMarked(t1) && (tri = this.findTri(t1, na, nb, nc)) != null) {
                        return tri;
                    }
                } else if (nb == n1) {
                    if (nc == n0 || t0 != null && !this.isMarked(t0) && (tri = this.findTri(t0, na, nb, nc)) != null) {
                        return tri;
                    }
                } else assert (false) : "node nb is referenced by tri";
            } else assert (false) : "node na is referenced by tri";
        }
        return null;
    }

    private PointLocation locatePoint(double x, double y) {
        if (this._troot == null) {
            if (this._nroot != null) {
                Node node = this._nroot;
                do {
                    if (x != (double)node.x() || y != (double)node.y()) continue;
                    return new PointLocation(node);
                } while ((node = node._next) != this._nroot);
            }
            return new PointLocation(null, false);
        }
        Node nmin = this._nroot;
        double dmin = TriMesh.distanceSquared(nmin, x, y);
        for (Node n : this._sampledNodes) {
            double d = TriMesh.distanceSquared(n, x, y);
            if (!(d < dmin)) continue;
            dmin = d;
            nmin = n;
        }
        Tri tri = nmin._tri;
        return this.locatePoint(tri, x, y);
    }

    private PointLocation locatePoint(Tri tri, double x, double y) {
        this._troot = tri;
        Node n0 = tri._n0;
        Node n1 = tri._n1;
        Node n2 = tri._n2;
        double x0 = n0._x;
        double y0 = n0._y;
        double x1 = n1._x;
        double y1 = n1._y;
        double x2 = n2._x;
        double y2 = n2._y;
        if (x == x0 && y == y0) {
            return new PointLocation(n0);
        }
        if (x == x1 && y == y1) {
            return new PointLocation(n1);
        }
        if (x == x2 && y == y2) {
            return new PointLocation(n2);
        }
        double d0 = Geometry.leftOfLine(x2, y2, x1, y1, x, y);
        if (d0 > 0.0) {
            Tri triNabor = tri.triNabor(n0);
            if (triNabor != null) {
                return this.locatePoint(triNabor, x, y);
            }
            return new PointLocation(tri, false);
        }
        double d1 = Geometry.leftOfLine(x0, y0, x2, y2, x, y);
        if (d1 > 0.0) {
            Tri triNabor = tri.triNabor(n1);
            if (triNabor != null) {
                return this.locatePoint(triNabor, x, y);
            }
            return new PointLocation(tri, false);
        }
        double d2 = Geometry.leftOfLine(x1, y1, x0, y0, x, y);
        if (d2 > 0.0) {
            Tri triNabor = tri.triNabor(n2);
            if (triNabor != null) {
                return this.locatePoint(triNabor, x, y);
            }
            return new PointLocation(tri, false);
        }
        if (d0 < 0.0 && d1 < 0.0 && d2 < 0.0) {
            return new PointLocation(tri);
        }
        if (d0 == 0.0) {
            return new PointLocation(new Edge(tri, n0));
        }
        if (d1 == 0.0) {
            return new PointLocation(new Edge(tri, n1));
        }
        if (d2 == 0.0) {
            return new PointLocation(new Edge(tri, n2));
        }
        assert (false) : "successfully located the point";
        return null;
    }

    private void getDelaunayEdgesInside(Node node, Tri tri) {
        if (tri != null && !this.isMarked(tri)) {
            this.mark(tri);
            Node n0 = tri._n0;
            Node n1 = tri._n1;
            Node n2 = tri._n2;
            if (TriMesh.inCircle(n0, n1, n2, node)) {
                this.killTri(tri);
                Tri t0 = tri._t0;
                Tri t1 = tri._t1;
                Tri t2 = tri._t2;
                this._edgeSet.addMate(tri, n0);
                this._edgeSet.addMate(tri, n1);
                this._edgeSet.addMate(tri, n2);
                this.getDelaunayEdgesInside(node, t0);
                this.getDelaunayEdgesInside(node, t1);
                this.getDelaunayEdgesInside(node, t2);
            }
        }
    }

    private void getDelaunayEdgesOutside(Node node, Tri tri) {
        if (tri != null && !this.isMarked(tri)) {
            this.mark(tri);
            Node n0 = tri._n0;
            Node n1 = tri._n1;
            Node n2 = tri._n2;
            Tri t0 = tri._t0;
            Tri t1 = tri._t1;
            Tri t2 = tri._t2;
            if (t0 == null && TriMesh.leftOfLine(n2, n1, node)) {
                this._edgeSet.add(tri, n0);
                this.getDelaunayEdgesOutside(node, this.getNextTriOnHull(tri, n1, n0));
                this.getDelaunayEdgesOutside(node, this.getNextTriOnHull(tri, n2, n0));
            }
            if (t1 == null && TriMesh.leftOfLine(n0, n2, node)) {
                this._edgeSet.add(tri, n1);
                this.getDelaunayEdgesOutside(node, this.getNextTriOnHull(tri, n2, n1));
                this.getDelaunayEdgesOutside(node, this.getNextTriOnHull(tri, n0, n1));
            }
            if (t2 == null && TriMesh.leftOfLine(n1, n0, node)) {
                this._edgeSet.add(tri, n2);
                this.getDelaunayEdgesOutside(node, this.getNextTriOnHull(tri, n0, n2));
                this.getDelaunayEdgesOutside(node, this.getNextTriOnHull(tri, n1, n2));
            }
            if (TriMesh.inCircle(n0, n1, n2, node)) {
                this.killTri(tri);
                this._edgeSet.addMate(tri, n0);
                this._edgeSet.addMate(tri, n1);
                this._edgeSet.addMate(tri, n2);
                this.getDelaunayEdgesOutside(node, t0);
                this.getDelaunayEdgesOutside(node, t1);
                this.getDelaunayEdgesOutside(node, t2);
            }
        }
    }

    private void getDelaunayEdgesOpposite(Node node, Tri tri) {
        if (tri != null && !this.isMarked(tri)) {
            this.mark(tri);
            this.killTri(tri);
            Node n0 = tri._n0;
            Node n1 = tri._n1;
            Node n2 = tri._n2;
            Tri t0 = tri._t0;
            Tri t1 = tri._t1;
            Tri t2 = tri._t2;
            if (node == n0) {
                this._edgeSet.addMate(tri, n0);
                this.getDelaunayEdgesOpposite(node, n1, n2, t1, t2);
            } else if (node == n1) {
                this._edgeSet.addMate(tri, n1);
                this.getDelaunayEdgesOpposite(node, n2, n0, t2, t0);
            } else if (node == n2) {
                this._edgeSet.addMate(tri, n2);
                this.getDelaunayEdgesOpposite(node, n0, n1, t0, t1);
            } else assert (false) : "node is referenced by tri";
        }
    }

    private void getDelaunayEdgesOpposite(Node node, Node na, Node nb, Tri ta, Tri tb) {
        if (!this.isMarked(na)) {
            this.mark(na);
            this._nodeList.add(na);
        }
        if (!this.isMarked(nb)) {
            this.mark(nb);
            this._nodeList.add(nb);
        }
        this.getDelaunayEdgesOpposite(node, ta);
        this.getDelaunayEdgesOpposite(node, tb);
    }

    private Tri getNextTriOnHull(Tri tri, Node node, Node nodeOther) {
        Tri tnext = tri.triNabor(node);
        while (tnext != null) {
            node = nodeOther;
            nodeOther = tri.nodeNabor(tnext);
            tri = tnext;
            tnext = tri.triNabor(node);
        }
        return tri;
    }

    public synchronized Node findNodeNearestSlow(float x, float y) {
        this.clearTriMarks();
        this.clearNodeMarks();
        this._dmin = Double.MAX_VALUE;
        this._nmin = null;
        if (this._troot == null) {
            if (this._nroot != null) {
                Node node = this._nroot;
                do {
                    this.updateNodeNearest(x, y, node);
                } while ((node = node._next) != this._nroot);
            }
            assert (this._nmin != null);
            return this._nmin;
        }
        PointLocation pl = this.locatePoint(x, y);
        if (pl.isOnNode()) {
            this.updateNodeNearest(x, y, pl.node());
            return this._nmin;
        }
        if (pl.isInside()) {
            this.findNodeNearestInside(x, y, pl.tri());
        } else {
            this.findNodeNearestOutside(x, y, pl.tri());
        }
        return this._nmin;
    }

    private void findNodeNearestInside(double x, double y, Tri tri) {
        if (tri != null && !this.isMarked(tri)) {
            this.mark(tri);
            Node n0 = tri._n0;
            Node n1 = tri._n1;
            Node n2 = tri._n2;
            this.updateNodeNearest(x, y, n0);
            this.updateNodeNearest(x, y, n1);
            this.updateNodeNearest(x, y, n2);
            if (TriMesh.inCircle(n0, n1, n2, x, y)) {
                Tri t0 = tri._t0;
                Tri t1 = tri._t1;
                Tri t2 = tri._t2;
                this.findNodeNearestInside(x, y, t0);
                this.findNodeNearestInside(x, y, t1);
                this.findNodeNearestInside(x, y, t2);
            }
        }
    }

    private void findNodeNearestOutside(double x, double y, Tri tri) {
        if (tri != null && !this.isMarked(tri)) {
            this.mark(tri);
            Node n0 = tri._n0;
            Node n1 = tri._n1;
            Node n2 = tri._n2;
            this.updateNodeNearest(x, y, n0);
            this.updateNodeNearest(x, y, n1);
            this.updateNodeNearest(x, y, n2);
            Tri t0 = tri._t0;
            Tri t1 = tri._t1;
            Tri t2 = tri._t2;
            if (t0 == null && TriMesh.leftOfLine(n2, n1, x, y)) {
                this.findNodeNearestOutside(x, y, this.getNextTriOnHull(tri, n1, n0));
                this.findNodeNearestOutside(x, y, this.getNextTriOnHull(tri, n2, n0));
            }
            if (t1 == null && TriMesh.leftOfLine(n0, n2, x, y)) {
                this.findNodeNearestOutside(x, y, this.getNextTriOnHull(tri, n2, n1));
                this.findNodeNearestOutside(x, y, this.getNextTriOnHull(tri, n0, n1));
            }
            if (t2 == null && TriMesh.leftOfLine(n1, n0, x, y)) {
                this.findNodeNearestOutside(x, y, this.getNextTriOnHull(tri, n0, n2));
                this.findNodeNearestOutside(x, y, this.getNextTriOnHull(tri, n1, n2));
            }
            if (TriMesh.inCircle(n0, n1, n2, x, y)) {
                this.findNodeNearestOutside(x, y, t0);
                this.findNodeNearestOutside(x, y, t1);
                this.findNodeNearestOutside(x, y, t2);
            }
        }
    }

    private void updateNodeNearest(double x, double y, Node n) {
        if (!this.isMarked(n)) {
            this.mark(n);
            double d = TriMesh.distanceSquared(n, x, y);
            if (d < this._dmin) {
                this._dmin = d;
                this._nmin = n;
                this._nroot = n;
            }
        }
    }

    private void linkTris(Tri tri, Node node, Tri triNabor, Node nodeNabor) {
        if (tri != null) {
            if (node == tri._n0) {
                tri._t0 = triNabor;
            } else if (node == tri._n1) {
                tri._t1 = triNabor;
            } else if (node == tri._n2) {
                tri._t2 = triNabor;
            } else assert (false) : "node referenced by tri";
        }
        if (triNabor != null) {
            if (nodeNabor == triNabor._n0) {
                triNabor._t0 = tri;
            } else if (nodeNabor == triNabor._n1) {
                triNabor._t1 = tri;
            } else if (nodeNabor == triNabor._n2) {
                triNabor._t2 = tri;
            } else assert (false) : "nodeNabor referenced by triNabor";
        }
    }

    private void markAllTris(Tri tri) {
        Tri t2;
        Tri t1;
        tri._mark = this._triMarkRed;
        Tri t0 = tri._t0;
        if (t0 != null && t0._mark != this._triMarkRed) {
            this.markAllTris(t0);
        }
        if ((t1 = tri._t1) != null && t1._mark != this._triMarkRed) {
            this.markAllTris(t1);
        }
        if ((t2 = tri._t2) != null && t2._mark != this._triMarkRed) {
            this.markAllTris(t2);
        }
    }

    private void zeroTriMarks(Tri tri) {
        Tri t2;
        Tri t1;
        tri._mark = 0;
        Tri t0 = tri._t0;
        if (t0 != null && t0._mark != 0) {
            this.zeroTriMarks(t0);
        }
        if ((t1 = tri._t1) != null && t1._mark != 0) {
            this.zeroTriMarks(t1);
        }
        if ((t2 = tri._t2) != null && t2._mark != 0) {
            this.zeroTriMarks(t2);
        }
    }

    private Edge getEdgeOnHull(Tri tri) {
        Edge edge;
        this.mark(tri);
        if (tri._t0 == null) {
            return new Edge(tri, tri._n0);
        }
        if (tri._t1 == null) {
            return new Edge(tri, tri._n1);
        }
        if (tri._t2 == null) {
            return new Edge(tri, tri._n2);
        }
        if (!this.isMarked(tri._t0) && (edge = this.getEdgeOnHull(tri._t0)) != null) {
            return edge;
        }
        if (!this.isMarked(tri._t1) && (edge = this.getEdgeOnHull(tri._t1)) != null) {
            return edge;
        }
        if (!this.isMarked(tri._t2) && (edge = this.getEdgeOnHull(tri._t2)) != null) {
            return edge;
        }
        return null;
    }

    private void getEdgesOnHull(Edge edge, HashSet<Edge> edges) {
        if (!edges.contains(edge)) {
            edges.add(edge);
            this.getEdgesOnHull(this.getNextEdgeOnHull(edge.nodeA(), edge), edges);
            this.getEdgesOnHull(this.getNextEdgeOnHull(edge.nodeB(), edge), edges);
        }
    }

    private Edge getNextEdgeOnHull(Node node, Edge edge) {
        Tri tri = edge.triLeft();
        Node next = edge.nodeLeft();
        Tri tnext = tri.triNabor(node);
        while (tnext != null) {
            node = next;
            next = tri.nodeNabor(tnext);
            tri = tnext;
            tnext = tri.triNabor(node);
        }
        return new Edge(tri, node);
    }

    private static Edge edgeOfTri(Tri tri, Node na, Node nb) {
        Node n0 = tri._n0;
        Node n1 = tri._n1;
        Node n2 = tri._n2;
        if (na == n0) {
            if (nb == n1) {
                return new Edge(tri, n2);
            }
            if (nb == n2) {
                return new Edge(tri, n1);
            }
            return null;
        }
        if (na == n1) {
            if (nb == n0) {
                return new Edge(tri, n2);
            }
            if (nb == n2) {
                return new Edge(tri, n0);
            }
            return null;
        }
        if (na == n2) {
            if (nb == n0) {
                return new Edge(tri, n1);
            }
            if (nb == n1) {
                return new Edge(tri, n0);
            }
            return null;
        }
        return null;
    }

    private static boolean nodesInOrder(Tri tri, Node na, Node nb, Node nc) {
        Node n0 = tri._n0;
        Node n1 = tri._n1;
        Node n2 = tri._n2;
        return na == n0 && nb == n1 && nc == n2 || na == n1 && nb == n2 && nc == n0 || na == n2 && nb == n0 && nc == n1;
    }

    private static Node otherNode(Tri tri, Node na, Node nb) {
        Node n0 = tri._n0;
        Node n1 = tri._n1;
        Node n2 = tri._n2;
        if (na == n0) {
            if (nb == n1) {
                return n2;
            }
            if (nb == n2) {
                return n1;
            }
            return null;
        }
        if (na == n1) {
            if (nb == n0) {
                return n2;
            }
            if (nb == n2) {
                return n0;
            }
            return null;
        }
        if (na == n2) {
            if (nb == n0) {
                return n1;
            }
            if (nb == n1) {
                return n0;
            }
            return null;
        }
        return null;
    }

    private synchronized void markTriInnerOrOuter(Tri tri) {
        assert (this._xminOuter < this._xmaxOuter) : "outer box is valid";
        assert (this._yminOuter < this._ymaxOuter) : "outer box is valid";
        double[] po = new double[]{0.0, 0.0};
        double s = tri.centerCircle(po);
        double r = MathPlus.sqrt(s);
        double xo = po[0];
        double yo = po[1];
        if (xo - r >= this._xminOuter && yo - r >= this._yminOuter && xo + r <= this._xmaxOuter && yo + r <= this._ymaxOuter) {
            tri.setInner();
            tri.clearOuter();
        } else {
            tri.setOuter();
            tri.clearInner();
        }
    }

    private void fireNodeWillBeAdded(Node node) {
        ++this._version;
        if (this._nnodeListeners > 0) {
            Object[] list = this._listeners.getListenerList();
            for (int i = list.length - 2; i >= 0; i -= 2) {
                if (list[i] != NodeListener.class) continue;
                ((NodeListener)list[i + 1]).nodeWillBeAdded(this, node);
            }
        }
    }

    private void fireNodeAdded(Node node) {
        ++this._version;
        if (this._nnodeListeners > 0) {
            Object[] list = this._listeners.getListenerList();
            for (int i = list.length - 2; i >= 0; i -= 2) {
                if (list[i] != NodeListener.class) continue;
                ((NodeListener)list[i + 1]).nodeAdded(this, node);
            }
        }
    }

    private void fireNodeWillBeRemoved(Node node) {
        ++this._version;
        if (this._nnodeListeners > 0) {
            Object[] list = this._listeners.getListenerList();
            for (int i = list.length - 2; i >= 0; i -= 2) {
                if (list[i] != NodeListener.class) continue;
                ((NodeListener)list[i + 1]).nodeWillBeRemoved(this, node);
            }
        }
    }

    private void fireNodeRemoved(Node node) {
        ++this._version;
        if (this._nnodeListeners > 0) {
            Object[] list = this._listeners.getListenerList();
            for (int i = list.length - 2; i >= 0; i -= 2) {
                if (list[i] != NodeListener.class) continue;
                ((NodeListener)list[i + 1]).nodeRemoved(this, node);
            }
        }
    }

    private void fireTriAdded(Tri tri) {
        ++this._version;
        if (this._ntriListeners > 0) {
            Object[] list = this._listeners.getListenerList();
            for (int i = list.length - 2; i >= 0; i -= 2) {
                if (list[i] != TriListener.class) continue;
                ((TriListener)list[i + 1]).triAdded(this, tri);
            }
        }
    }

    private void fireTriRemoved(Tri tri) {
        ++this._version;
        if (this._ntriListeners > 0) {
            Object[] list = this._listeners.getListenerList();
            for (int i = list.length - 2; i >= 0; i -= 2) {
                if (list[i] != TriListener.class) continue;
                ((TriListener)list[i + 1]).triRemoved(this, tri);
            }
        }
    }

    private void validate(Node node) {
        Check.state(node == node._prev._next, "node==node._prev._next");
        Check.state(node == node._next._prev, "node==node._next._prev");
        Tri tri = node.tri();
        if (this._troot != null) {
            Check.state(tri != null, "tri!=null");
            Check.state(node == tri.nodeA() || node == tri.nodeB() || node == tri.nodeC(), "node is one of tri nodes");
        }
    }

    private void validate(Tri tri) {
        Check.state(tri != null, "tri not null");
        Node na = tri.nodeA();
        Node nb = tri.nodeB();
        Node nc = tri.nodeC();
        this.validate(na);
        this.validate(nb);
        this.validate(nc);
        Tri ta = tri.triA();
        Tri tb = tri.triB();
        Tri tc = tri.triC();
        if (ta != null) {
            Check.state(ta.triNabor(tri.nodeNabor(ta)) == tri, "a nabors ok");
        }
        if (tb != null) {
            Check.state(tb.triNabor(tri.nodeNabor(tb)) == tri, "b nabors ok");
        }
        if (tc != null) {
            Check.state(tc.triNabor(tri.nodeNabor(tc)) == tri, "c nabors ok");
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.init();
        int format = in.readInt();
        if (format == 1) {
            int itri;
            this._version = in.readLong();
            int nnode = this._nnode = in.readInt();
            Node[] nodes = new Node[nnode];
            for (int inode = 0; inode < nnode; ++inode) {
                Node node = nodes[inode] = (Node)in.readObject();
                node._x = in.readDouble();
                node._y = in.readDouble();
                int nvalue = in.readInt();
                Node.access$1102(node, new Object[nvalue]);
                for (int ivalue = 0; ivalue < nvalue; ++ivalue) {
                    Object value;
                    ((Node)node)._values[ivalue] = value = in.readObject();
                }
            }
            int ntri = this._ntri = in.readInt();
            Tri[] tris = new Tri[ntri];
            for (itri = 0; itri < ntri; ++itri) {
                Tri tri = tris[itri] = (Tri)in.readObject();
                tri._quality = -1.0;
            }
            this._nroot = (Node)in.readObject();
            for (int inode = 0; inode < nnode; ++inode) {
                Node node = nodes[inode];
                node._prev = (Node)in.readObject();
                node._next = (Node)in.readObject();
                node._tri = (Tri)in.readObject();
            }
            this._troot = (Tri)in.readObject();
            for (itri = 0; itri < ntri; ++itri) {
                Tri tri = tris[itri];
                tri._n0 = (Node)in.readObject();
                tri._n1 = (Node)in.readObject();
                tri._n2 = (Node)in.readObject();
                tri._t0 = (Tri)in.readObject();
                tri._t1 = (Tri)in.readObject();
                tri._t2 = (Tri)in.readObject();
            }
        } else {
            throw new InvalidClassException("invalid external format");
        }
        this._outerEnabled = in.readBoolean();
        this._xminOuter = in.readDouble();
        this._yminOuter = in.readDouble();
        this._xmaxOuter = in.readDouble();
        this._ymaxOuter = in.readDouble();
        this._nnodeValues = in.readInt();
        this._lnodeValues = in.readInt();
        this._nodePropertyMaps = (Map)in.readObject();
        this.sampleNodes();
        try {
            this.validate();
        }
        catch (IllegalStateException ise) {
            throw new IOException(ise.getMessage());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        Tri tri;
        int itri;
        out.writeInt(1);
        out.writeLong(this._version);
        int nnode = this._nnode;
        out.writeInt(nnode);
        Node[] nodes = new Node[nnode];
        NodeIterator ni = this.getNodes();
        for (int inode = 0; inode < nnode; ++inode) {
            Node node = nodes[inode] = ni.next();
            out.writeObject(node);
            out.writeDouble(node._x);
            out.writeDouble(node._y);
            int nvalue = node._values.length;
            out.writeInt(nvalue);
            for (int ivalue = 0; ivalue < nvalue; ++ivalue) {
                Object value = node._values[ivalue];
                out.writeObject(value instanceof Serializable ? value : null);
            }
        }
        int ntri = this._ntri;
        out.writeInt(ntri);
        Tri[] tris = new Tri[ntri];
        TriIterator ti = this.getTris();
        for (itri = 0; itri < ntri; ++itri) {
            tri = tris[itri] = ti.next();
            out.writeObject(tri);
        }
        out.writeObject(this._nroot);
        for (int inode = 0; inode < nnode; ++inode) {
            Node node = nodes[inode];
            out.writeObject(node._prev);
            out.writeObject(node._next);
            out.writeObject(node._tri);
        }
        out.writeObject(this._troot);
        for (itri = 0; itri < ntri; ++itri) {
            tri = tris[itri];
            out.writeObject(tri._n0);
            out.writeObject(tri._n1);
            out.writeObject(tri._n2);
            out.writeObject(tri._t0);
            out.writeObject(tri._t1);
            out.writeObject(tri._t2);
        }
        out.writeBoolean(this._outerEnabled);
        out.writeDouble(this._xminOuter);
        out.writeDouble(this._yminOuter);
        out.writeDouble(this._xmaxOuter);
        out.writeDouble(this._ymaxOuter);
        out.writeInt(this._nnodeValues);
        out.writeInt(this._lnodeValues);
        out.writeObject(this._nodePropertyMaps);
    }

    private void sampleNodes() {
        Random random = new Random();
        this._sampledNodes.clear();
        int nsamp = (int)(MathPlus.pow((double)this._nnode, 0.33) / 0.45);
        Node node = this._nroot;
        while (this._sampledNodes.size() < nsamp) {
            int nskip = 1 + random.nextInt(this._nnode / 2);
            while (--nskip > 0) {
                node = node._next;
            }
            this._sampledNodes.add(node);
        }
    }

    private static class NodeSet {
        Node a;
        Node b;
        Tri nba;
        private static final int MAX_SHIFT = 30;
        private static final int MAX_CAPACITY = 0x40000000;
        private Node[] _a;
        private Node[] _b;
        private Tri[] _nba;
        private boolean[] _filled;
        private int _nmax;
        private int _n;
        private double _factor;
        private int _shift;
        private int _mask;
        private int _index;

        NodeSet(int capacity, double factor) {
            if (capacity > 0x40000000) {
                capacity = 0x40000000;
            }
            if (factor <= 0.0) {
                factor = 1.0E-4;
            }
            if (factor >= 1.0) {
                factor = 0.9999;
            }
            this._nmax = 2;
            this._shift = 30;
            while (this._nmax < capacity) {
                --this._shift;
                this._nmax *= 2;
            }
            this._n = 0;
            this._factor = factor;
            this._mask = this._nmax - 1;
            this._a = new Node[this._nmax];
            this._b = new Node[this._nmax];
            this._nba = new Tri[this._nmax];
            this._filled = new boolean[this._nmax];
        }

        void clear() {
            this._n = 0;
            for (int i = 0; i < this._nmax; ++i) {
                this._filled[i] = false;
            }
        }

        boolean add(Node a, Node b, Tri nba) {
            this._index = this.indexOfNode(a);
            if (this._filled[this._index]) {
                this.setCurrent();
                this.remove(this._index);
                return false;
            }
            this._a[this._index] = a;
            this._b[this._index] = b;
            this._nba[this._index] = nba;
            this._filled[this._index] = true;
            ++this._n;
            if ((double)this._n > (double)this._nmax * this._factor && this._nmax < 0x40000000) {
                this.doubleCapacity();
            }
            this.setCurrent();
            return true;
        }

        private int hash(Node a) {
            int key = a._hash;
            return 1327217885 * key >> this._shift & this._mask;
        }

        private int indexOfNode(Node a) {
            int i = this.hash(a);
            while (this._filled[i]) {
                if (a == this._a[i]) {
                    return i;
                }
                i = i - 1 & this._mask;
            }
            return i;
        }

        private void setCurrent() {
            this.a = this._a[this._index];
            this.b = this._b[this._index];
            this.nba = this._nba[this._index];
        }

        private void remove(int i) {
            --this._n;
            while (true) {
                int r;
                this._filled[i] = false;
                int j = i;
                do {
                    if (this._filled[i = i - 1 & this._mask]) continue;
                    return;
                } while (i <= (r = this.hash(this._a[i])) && r < j || r < j && j < i || j < i && i <= r);
                this._a[j] = this._a[i];
                this._b[j] = this._b[i];
                this._nba[j] = this._nba[i];
                this._filled[j] = this._filled[i];
            }
        }

        private void doubleCapacity() {
            NodeSet set = new NodeSet(2 * this._nmax, this._factor);
            if (this._n > 0) {
                for (int i = 0; i < this._nmax; ++i) {
                    if (!this._filled[i]) continue;
                    set.add(this._a[i], this._b[i], this._nba[i]);
                }
            }
            this._a = set._a;
            this._b = set._b;
            this._nba = set._nba;
            this._filled = set._filled;
            this._nmax = set._nmax;
            this._n = set._n;
            this._factor = set._factor;
            this._shift = set._shift;
            this._mask = set._mask;
            this._index = set._index;
        }
    }

    private static class EdgeSet {
        Node a;
        Node b;
        Node c;
        Tri abc;
        private static final int MAX_SHIFT = 30;
        private static final int MAX_CAPACITY = 0x40000000;
        private Node[] _a;
        private Node[] _b;
        private Node[] _c;
        private Tri[] _abc;
        private boolean[] _filled;
        private int _nmax;
        private int _n;
        private double _factor;
        private int _shift;
        private int _mask;
        private int _index;

        EdgeSet(int capacity, double factor) {
            if (capacity > 0x40000000) {
                capacity = 0x40000000;
            }
            if (factor <= 0.0) {
                factor = 1.0E-4;
            }
            if (factor >= 1.0) {
                factor = 0.9999;
            }
            this._nmax = 2;
            this._shift = 30;
            while (this._nmax < capacity) {
                --this._shift;
                this._nmax *= 2;
            }
            this._n = 0;
            this._factor = factor;
            this._mask = this._nmax - 1;
            this._a = new Node[this._nmax];
            this._b = new Node[this._nmax];
            this._c = new Node[this._nmax];
            this._abc = new Tri[this._nmax];
            this._filled = new boolean[this._nmax];
        }

        void clear() {
            this._n = 0;
            for (int i = 0; i < this._nmax; ++i) {
                this._filled[i] = false;
            }
        }

        boolean contains(Tri tri, Node node) {
            if (node == tri._n0) {
                this._index = this.indexOfMate(tri._n2, tri._n1);
            } else if (node == tri._n1) {
                this._index = this.indexOfMate(tri._n0, tri._n2);
            } else if (node == tri._n2) {
                this._index = this.indexOfMate(tri._n1, tri._n0);
            } else {
                assert (false) : "node is referenced by tri";
                return false;
            }
            if (this._filled[this._index]) {
                this.setCurrent();
                return true;
            }
            return false;
        }

        boolean add(Tri tri, Node node) {
            if (node == tri._n0) {
                return this.add(tri._n1, tri._n2, node, tri);
            }
            if (node == tri._n1) {
                return this.add(tri._n2, tri._n0, node, tri);
            }
            if (node == tri._n2) {
                return this.add(tri._n0, tri._n1, node, tri);
            }
            assert (false) : "node is referenced by tri";
            return false;
        }

        boolean addMate(Tri tri, Node node) {
            Node nodeNabor;
            Tri triNabor = tri.triNabor(node);
            Node node2 = nodeNabor = triNabor != null ? tri.nodeNabor(triNabor) : null;
            if (node == tri._n0) {
                return this.add(tri._n2, tri._n1, nodeNabor, triNabor);
            }
            if (node == tri._n1) {
                return this.add(tri._n0, tri._n2, nodeNabor, triNabor);
            }
            if (node == tri._n2) {
                return this.add(tri._n1, tri._n0, nodeNabor, triNabor);
            }
            assert (false) : "node is referenced by tri";
            return false;
        }

        boolean remove() {
            if (this._n > 0) {
                int start = this._index;
                while (this._index < this._nmax) {
                    if (this._filled[this._index]) {
                        this.setCurrent();
                        this.remove(this._index);
                        return true;
                    }
                    ++this._index;
                }
                this._index = 0;
                while (this._index < start) {
                    if (this._filled[this._index]) {
                        this.setCurrent();
                        this.remove(this._index);
                        return true;
                    }
                    ++this._index;
                }
            }
            return false;
        }

        boolean isEmpty() {
            return this._n > 0;
        }

        int count() {
            return this._n;
        }

        boolean first() {
            this._index = -1;
            return this.next();
        }

        boolean next() {
            ++this._index;
            while (this._index < this._nmax) {
                if (this._filled[this._index]) {
                    this.setCurrent();
                    return true;
                }
                ++this._index;
            }
            return false;
        }

        private int hash(Node a, Node b) {
            int key = a._hash ^ b._hash;
            return 1327217885 * key >> this._shift & this._mask;
        }

        private int indexOfMate(Node a, Node b) {
            int i = this.hash(a, b);
            while (this._filled[i]) {
                if (a == this._b[i] && b == this._a[i]) {
                    return i;
                }
                i = i - 1 & this._mask;
            }
            return i;
        }

        private void setCurrent() {
            this.a = this._a[this._index];
            this.b = this._b[this._index];
            this.c = this._c[this._index];
            this.abc = this._abc[this._index];
        }

        private boolean add(Node a, Node b, Node c, Tri abc) {
            this._index = this.indexOfMate(a, b);
            if (this._filled[this._index]) {
                this.setCurrent();
                this.remove(this._index);
                return false;
            }
            this._a[this._index] = a;
            this._b[this._index] = b;
            this._c[this._index] = c;
            this._abc[this._index] = abc;
            this._filled[this._index] = true;
            ++this._n;
            if ((double)this._n > (double)this._nmax * this._factor && this._nmax < 0x40000000) {
                this.doubleCapacity();
            }
            this.setCurrent();
            return true;
        }

        private void remove(int i) {
            --this._n;
            while (true) {
                int r;
                this._filled[i] = false;
                int j = i;
                do {
                    if (this._filled[i = i - 1 & this._mask]) continue;
                    return;
                } while (i <= (r = this.hash(this._a[i], this._b[i])) && r < j || r < j && j < i || j < i && i <= r);
                this._a[j] = this._a[i];
                this._b[j] = this._b[i];
                this._c[j] = this._c[i];
                this._abc[j] = this._abc[i];
                this._filled[j] = this._filled[i];
            }
        }

        private void doubleCapacity() {
            EdgeSet set = new EdgeSet(2 * this._nmax, this._factor);
            if (this._n > 0) {
                for (int i = 0; i < this._nmax; ++i) {
                    if (!this._filled[i]) continue;
                    set.add(this._a[i], this._b[i], this._c[i], this._abc[i]);
                }
            }
            this._a = set._a;
            this._b = set._b;
            this._c = set._c;
            this._abc = set._abc;
            this._filled = set._filled;
            this._nmax = set._nmax;
            this._n = set._n;
            this._factor = set._factor;
            this._shift = set._shift;
            this._mask = set._mask;
            this._index = set._index;
        }
    }

    private static class NodePropertyMapInternal
    implements NodePropertyMap {
        private int _index;

        @Override
        public Object get(Node node) {
            return node._values[this._index];
        }

        @Override
        public void put(Node node, Object value) {
            ((Node)node)._values[this._index] = value;
        }

        NodePropertyMapInternal(int index) {
            this._index = index;
        }
    }

    public static interface TriListener
    extends EventListener {
        public void triAdded(TriMesh var1, Tri var2);

        public void triRemoved(TriMesh var1, Tri var2);
    }

    public static interface NodeListener
    extends EventListener {
        public void nodeWillBeAdded(TriMesh var1, Node var2);

        public void nodeAdded(TriMesh var1, Node var2);

        public void nodeWillBeRemoved(TriMesh var1, Node var2);

        public void nodeRemoved(TriMesh var1, Node var2);
    }

    public static interface NodePropertyMap
    extends Serializable {
        public Object get(Node var1);

        public void put(Node var1, Object var2);
    }

    public static class PointLocation {
        private Node _node;
        private Edge _edge;
        private Tri _tri;
        private boolean _inside;

        public boolean isOnNode() {
            return this._node != null;
        }

        public boolean isOnEdge() {
            return this._edge != null;
        }

        public boolean isInside() {
            return this._inside;
        }

        public boolean isOutside() {
            return !this._inside;
        }

        public Node node() {
            return this._node;
        }

        public Edge edge() {
            return this._edge;
        }

        public Tri tri() {
            return this._tri;
        }

        private PointLocation(Tri tri) {
            this._tri = tri;
            this._inside = true;
        }

        private PointLocation(Tri tri, boolean inside) {
            this._tri = tri;
            this._inside = inside;
        }

        private PointLocation(Node node) {
            this._tri = node._tri;
            this._node = node;
            this._inside = true;
        }

        private PointLocation(Edge edge) {
            this._tri = edge._triLeft;
            this._edge = edge;
            this._inside = true;
        }
    }

    public static class NodeStepList {
        private int _n = 0;
        private Node[] _a = new Node[64];
        private int[] _b = new int[64];

        public final void add(Node node, int step) {
            if (this._n == this._a.length) {
                Node[] s = new Node[this._a.length * 2];
                int[] t = new int[this._a.length * 2];
                System.arraycopy(this._a, 0, s, 0, this._n);
                System.arraycopy(this._b, 0, t, 0, this._n);
                this._a = s;
                this._b = t;
            }
            this._a[this._n] = node;
            this._b[this._n] = step;
            ++this._n;
        }

        public final void trim() {
            if (this._n < this._a.length) {
                Node[] s = new Node[this._n];
                int[] t = new int[this._n];
                System.arraycopy(this._a, 0, s, 0, this._n);
                System.arraycopy(this._b, 0, t, 0, this._n);
                this._a = s;
                this._b = t;
            }
        }

        public final void clear() {
            this._n = 0;
        }

        public final int nnode() {
            return this._n;
        }

        public final Node[] nodes() {
            return this._a;
        }

        public final int[] steps() {
            return this._b;
        }
    }

    public static class EdgeList {
        private int _n = 0;
        private Edge[] _a = new Edge[64];

        public final void add(Edge edge) {
            if (this._n == this._a.length) {
                Edge[] t = new Edge[this._a.length * 2];
                System.arraycopy(this._a, 0, t, 0, this._n);
                this._a = t;
            }
            this._a[this._n++] = edge;
        }

        public final Edge remove(int index) {
            Edge edge = this._a[index];
            --this._n;
            if (this._n > index) {
                System.arraycopy(this._a, index + 1, this._a, index, this._n - index);
            }
            return edge;
        }

        public final Edge[] trim() {
            if (this._n < this._a.length) {
                Edge[] t = new Edge[this._n];
                System.arraycopy(this._a, 0, t, 0, this._n);
                this._a = t;
            }
            return this._a;
        }

        public final void clear() {
            this._n = 0;
        }

        public final int nedge() {
            return this._n;
        }

        public final Edge[] edges() {
            return this._a;
        }
    }

    public static class TriList {
        private int _n = 0;
        private Tri[] _a = new Tri[64];

        public final void add(Tri tri) {
            if (this._n == this._a.length) {
                Tri[] t = new Tri[this._a.length * 2];
                System.arraycopy(this._a, 0, t, 0, this._n);
                this._a = t;
            }
            this._a[this._n++] = tri;
        }

        public final Tri remove(int index) {
            Tri tri = this._a[index];
            --this._n;
            if (this._n > index) {
                System.arraycopy(this._a, index + 1, this._a, index, this._n - index);
            }
            return tri;
        }

        public final Tri[] trim() {
            if (this._n < this._a.length) {
                Tri[] t = new Tri[this._n];
                System.arraycopy(this._a, 0, t, 0, this._n);
                this._a = t;
            }
            return this._a;
        }

        public final void clear() {
            this._n = 0;
        }

        public final int ntri() {
            return this._n;
        }

        public final Tri[] tris() {
            return this._a;
        }
    }

    public static class NodeList {
        private int _n = 0;
        private Node[] _a = new Node[64];

        public final void add(Node node) {
            if (this._n == this._a.length) {
                Node[] t = new Node[this._a.length * 2];
                System.arraycopy(this._a, 0, t, 0, this._n);
                this._a = t;
            }
            this._a[this._n++] = node;
        }

        public final Node remove(int index) {
            Node node = this._a[index];
            --this._n;
            if (this._n > index) {
                System.arraycopy(this._a, index + 1, this._a, index, this._n - index);
            }
            return node;
        }

        public final Node[] trim() {
            if (this._n < this._a.length) {
                Node[] t = new Node[this._n];
                System.arraycopy(this._a, 0, t, 0, this._n);
                this._a = t;
            }
            return this._a;
        }

        public final void clear() {
            this._n = 0;
        }

        public final int nnode() {
            return this._n;
        }

        public final Node[] nodes() {
            return this._a;
        }
    }

    public static interface EdgeIterator {
        public boolean hasNext();

        public Edge next();
    }

    public static class Edge {
        private Node _a;
        private Node _b;
        private Tri _triLeft;
        private Tri _triRight;
        private Node _nodeLeft;
        private Node _nodeRight;

        public Edge(Node a, Node b) {
            this(a, b, null);
        }

        public Edge(Node a, Node b, Tri abc) {
            Node c = abc != null ? TriMesh.otherNode(abc, a, b) : null;
            Check.argument(abc == null || c != null, "tri references nodes");
            this._a = a;
            this._b = b;
            if (c != null) {
                if (TriMesh.nodesInOrder(abc, a, b, c)) {
                    this._triLeft = abc;
                    this._nodeLeft = c;
                    this._triRight = abc.triNabor(c);
                    this._nodeRight = this._triRight != null ? abc.nodeNabor(this._triRight) : null;
                } else {
                    this._triRight = abc;
                    this._nodeRight = c;
                    this._triLeft = abc.triNabor(c);
                    this._nodeLeft = this._triLeft != null ? abc.nodeNabor(this._triLeft) : null;
                }
            }
        }

        public final Node nodeA() {
            return this._a;
        }

        public final Node nodeB() {
            return this._b;
        }

        public Tri triLeft() {
            return this._triLeft;
        }

        public Tri triRight() {
            return this._triRight;
        }

        public Node nodeLeft() {
            return this._nodeLeft;
        }

        public Node nodeRight() {
            return this._nodeRight;
        }

        public final Edge mate() {
            return new Edge(this._b, this._a, this._triRight, this._nodeRight, this._triLeft, this._nodeLeft);
        }

        public boolean isVisibleFromPoint(double x, double y) {
            return Geometry.leftOfLine(this._a._x, this._a._y, this._b._x, this._b._y, x, y) < 0.0;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object != null && object.getClass() == this.getClass()) {
                Edge edge = (Edge)object;
                return this._a == edge._a && this._b == edge._b;
            }
            return false;
        }

        public int hashCode() {
            return this._a._hash ^ this._b._hash;
        }

        private Edge(Node a, Node b, Tri triLeft, Node nodeLeft, Tri triRight, Node nodeRight) {
            this._a = a;
            this._b = b;
            this._triLeft = triLeft;
            this._nodeLeft = nodeLeft;
            this._triRight = triRight;
            this._nodeRight = nodeRight;
        }

        private Edge(Tri triLeft, Node nodeLeft) {
            this.initLeft(triLeft, nodeLeft);
            this._triLeft = triLeft;
            this._nodeLeft = nodeLeft;
            this._triRight = triLeft.triNabor(nodeLeft);
            this._nodeRight = this._triRight != null ? this._triLeft.nodeNabor(this._triRight) : null;
        }

        private Edge(Tri triLeft, Node nodeLeft, Tri triRight, Node nodeRight) {
            if (triLeft != null) {
                this.initLeft(triLeft, nodeLeft);
            } else if (triRight != null) {
                this.initRight(triRight, nodeRight);
            } else assert (false) : "either triLeft or triRight is not null";
            this._triLeft = triLeft;
            this._triRight = triRight;
            this._nodeLeft = nodeLeft;
            this._nodeRight = nodeRight;
        }

        private void initLeft(Tri triLeft, Node nodeLeft) {
            if (nodeLeft == triLeft._n0) {
                this._a = triLeft._n1;
                this._b = triLeft._n2;
            } else if (nodeLeft == triLeft._n1) {
                this._a = triLeft._n2;
                this._b = triLeft._n0;
            } else if (nodeLeft == triLeft._n2) {
                this._a = triLeft._n0;
                this._b = triLeft._n1;
            } else assert (false) : "nodeLeft referenced by triLeft";
        }

        private void initRight(Tri triRight, Node nodeRight) {
            if (nodeRight == triRight._n0) {
                this._a = triRight._n2;
                this._b = triRight._n1;
            } else if (nodeRight == triRight._n1) {
                this._a = triRight._n0;
                this._b = triRight._n2;
            } else if (nodeRight == triRight._n2) {
                this._a = triRight._n1;
                this._b = triRight._n0;
            } else assert (false) : "nodeRight referenced by triRight";
        }
    }

    public static interface TriIterator {
        public boolean hasNext();

        public Tri next();
    }

    public static class Tri
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int index;
        public Object data;
        private static final int INNER_BIT = 1;
        private static final int OUTER_BIT = 2;
        private static final int CENTER_BIT = 4;
        private static double QUALITY_FACTOR = 2.0 / MathPlus.sqrt(3.0);
        private transient Node _n0;
        private transient Node _n1;
        private transient Node _n2;
        private transient Tri _t0;
        private transient Tri _t1;
        private transient Tri _t2;
        private transient int _mark;
        private transient int _bits;
        private transient double _quality = -1.0;
        private transient double _xc;
        private transient double _yc;

        public final Node nodeA() {
            return this._n0;
        }

        public final Node nodeB() {
            return this._n1;
        }

        public final Node nodeC() {
            return this._n2;
        }

        public final Tri triA() {
            return this._t0;
        }

        public final Tri triB() {
            return this._t1;
        }

        public final Tri triC() {
            return this._t2;
        }

        public final Node nodeNearest(float x, float y) {
            double d0 = TriMesh.distanceSquared(this._n0, x, y);
            double d1 = TriMesh.distanceSquared(this._n1, x, y);
            double d2 = TriMesh.distanceSquared(this._n2, x, y);
            double dmin = d0;
            Node nmin = this._n0;
            if (d1 < dmin) {
                dmin = d1;
                nmin = this._n1;
            }
            if (d2 < dmin) {
                nmin = this._n2;
            }
            return nmin;
        }

        public final Tri triNabor(Node node) {
            if (node == this._n0) {
                return this._t0;
            }
            if (node == this._n1) {
                return this._t1;
            }
            if (node == this._n2) {
                return this._t2;
            }
            Check.argument(false, "node is referenced by tri");
            return null;
        }

        public final Node nodeNabor(Tri triNabor) {
            if (triNabor._t0 == this) {
                return triNabor._n0;
            }
            if (triNabor._t1 == this) {
                return triNabor._n1;
            }
            if (triNabor._t2 == this) {
                return triNabor._n2;
            }
            Check.argument(false, "triNabor is a nabor of tri");
            return null;
        }

        public double centerCircle(double[] c) {
            if (this.hasCenter()) {
                c[0] = this._xc;
                c[1] = this._yc;
            } else {
                double x0 = this._n0._x;
                double y0 = this._n0._y;
                double x1 = this._n1._x;
                double y1 = this._n1._y;
                double x2 = this._n2._x;
                double y2 = this._n2._y;
                Geometry.centerCircle(x0, y0, x1, y1, x2, y2, c);
                this.setCenter(c[0], c[1]);
            }
            double dx = this._xc - this._n2._x;
            double dy = this._yc - this._n2._y;
            return dx * dx + dy * dy;
        }

        public double[] centerCircle() {
            double[] c = new double[2];
            this.centerCircle(c);
            return c;
        }

        public double quality() {
            if (this._quality < 0.0) {
                this._quality = Tri.quality(this._n0, this._n1, this._n2);
            }
            return this._quality;
        }

        public boolean references(Node node) {
            return node == this._n0 || node == this._n1 || node == this._n2;
        }

        public boolean references(Node na, Node nb) {
            if (na == this._n0) {
                return nb == this._n1 || nb == this._n2;
            }
            if (na == this._n1) {
                return nb == this._n0 || nb == this._n2;
            }
            if (na == this._n2) {
                return nb == this._n0 || nb == this._n1;
            }
            return false;
        }

        public boolean references(Node na, Node nb, Node nc) {
            if (na == this._n0) {
                if (nb == this._n1) {
                    return nc == this._n2;
                }
                if (nb == this._n2) {
                    return nc == this._n1;
                }
                return false;
            }
            if (na == this._n1) {
                if (nb == this._n0) {
                    return nc == this._n2;
                }
                if (nb == this._n2) {
                    return nc == this._n0;
                }
                return false;
            }
            if (na == this._n2) {
                if (nb == this._n0) {
                    return nc == this._n1;
                }
                if (nb == this._n1) {
                    return nc == this._n0;
                }
                return false;
            }
            return false;
        }

        private Tri(Node n0, Node n1, Node n2) {
            this.init(n0, n1, n2);
        }

        private void init(Node n0, Node n1, Node n2) {
            this._n0 = n0;
            this._n1 = n1;
            this._n2 = n2;
            this._n0._tri = this;
            this._n1._tri = this;
            this._n2._tri = this;
            this._t0 = null;
            this._t1 = null;
            this._t2 = null;
            this._mark = 0;
            this._bits = 0;
            this._quality = -1.0;
        }

        private void setInner() {
            this._bits |= 1;
        }

        private void clearInner() {
            this._bits &= 0xFFFFFFFE;
        }

        private boolean isInner() {
            return (this._bits & 1) != 0;
        }

        private void setOuter() {
            this._bits |= 2;
        }

        private void clearOuter() {
            this._bits &= 0xFFFFFFFD;
        }

        private boolean isOuter() {
            return (this._bits & 2) != 0;
        }

        private void setCenter(double xc, double yc) {
            this._xc = xc;
            this._yc = yc;
            this._bits |= 4;
        }

        private boolean hasCenter() {
            return (this._bits & 4) != 0;
        }

        private static double quality(Node na, Node nb, Node nc) {
            double quality;
            double xa = na._x;
            double ya = na._y;
            double xb = nb._x;
            double yb = nb._y;
            double xc = nc._x;
            double yc = nc._y;
            double xab = xa - xb;
            double yab = ya - yb;
            double xac = xa - xc;
            double yac = ya - yc;
            double xbc = xb - xc;
            double ybc = yb - yc;
            double det = xac * ybc - yac * xbc;
            double dab = xab * xab + yab * yab;
            double dac = xac * xac + yac * yac;
            double dbc = xbc * xbc + ybc * ybc;
            double dmx = dab;
            if (dac > dmx) {
                dmx = dac;
            }
            if (dbc > dmx) {
                dmx = dbc;
            }
            if ((quality = QUALITY_FACTOR * det / dmx) < 0.0) {
                quality = -quality;
            }
            if (quality > 1.0) {
                quality = 1.0;
            }
            return (float)quality;
        }
    }

    public static interface NodeIterator {
        public boolean hasNext();

        public Node next();
    }

    public static class Node
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int index;
        public Object data;
        private transient double _x;
        private transient double _y;
        private transient Node _prev = null;
        private transient Node _next = null;
        private transient int _mark = 0;
        private transient Tri _tri = null;
        private transient int _hash = System.identityHashCode(this);
        private transient Object[] _values;

        public Node(float x, float y) {
            this.setPosition(x, y);
        }

        public final float x() {
            return (float)this._x;
        }

        public final float y() {
            return (float)this._y;
        }

        public final double xp() {
            return this._x;
        }

        public final double yp() {
            return this._y;
        }

        public final Tri tri() {
            return this._tri;
        }

        public String toString() {
            return "(" + this.x() + "," + this.y() + ")";
        }

        private static double perturb(float x, float p) {
            int m = Integer.MAX_VALUE;
            int i = Float.floatToIntBits(p);
            int j = 0;
            int k = 0;
            while (k < 32) {
                j |= i & 1;
                ++k;
                i >>= 1;
                j <<= 1;
            }
            double xp = x != 0.0f ? (double)x : 1.4012984643248171E-46;
            assert ((float)(xp *= 1.0 + (double)j / 2.147483647E9 * 0.1 * 1.1920928955078125E-7) == x);
            return xp;
        }

        private void setPosition(float x, float y) {
            assert (this._tri == null);
            this._x = Node.perturb(x, 0.450599f * y);
            this._y = Node.perturb(y, 0.298721f * x);
        }

        static /* synthetic */ Object[] access$1102(Node x0, Object[] x1) {
            x0._values = x1;
            return x1;
        }
    }
}

