/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.interp;

import edu.mines.jtk.dsp.Sampling;
import edu.mines.jtk.interp.Gridder2;
import edu.mines.jtk.util.ArrayMath;

public class DiscreteSibsonGridder2
implements Gridder2 {
    private int _n;
    private float[] _f;
    private float[] _x1;
    private float[] _x2;
    private int _nsmooth;

    public DiscreteSibsonGridder2(float[] f, float[] x1, float[] x2) {
        this.setScattered(f, x1, x2);
    }

    public void setSmooth(int nsmooth) {
        this._nsmooth = nsmooth;
    }

    @Override
    public void setScattered(float[] f, float[] x1, float[] x2) {
        this._n = f.length;
        this._f = f;
        this._x1 = x1;
        this._x2 = x2;
    }

    @Override
    public float[][] grid(Sampling s1, Sampling s2) {
        int i2;
        int i1;
        int n1 = s1.getCount();
        int n2 = s2.getCount();
        float fx1 = (float)s1.getFirst();
        float fx2 = (float)s2.getFirst();
        float lx1 = (float)s1.getLast();
        float lx2 = (float)s2.getLast();
        float dx1 = (float)s1.getDelta();
        float dx2 = (float)s2.getDelta();
        float od1 = 1.0f / dx1;
        float od2 = 1.0f / dx2;
        int nk = n1 * n2;
        int[] kk = new int[nk];
        float[] ds = new float[nk];
        int k = 0;
        for (int i22 = 0; i22 < n2; ++i22) {
            double x2 = (float)i22 * dx2;
            i1 = 0;
            while (i1 < n1) {
                double x1 = (float)i1 * dx1;
                ds[k] = (float)(x1 * x1 + x2 * x2);
                kk[k] = k;
                ++i1;
                ++k;
            }
        }
        ArrayMath.quickIndexSort(ds, kk);
        ds = null;
        int[] k1 = new int[nk];
        int[] k2 = new int[nk];
        for (int k3 = 0; k3 < nk; ++k3) {
            int ik = kk[k3];
            i1 = ik % n1;
            int i23 = ik / n1;
            k1[k3] = i1;
            k2[k3] = i23;
        }
        kk = null;
        float[][] g = new float[n2][n1];
        float[][] c = new float[n2][n1];
        for (int i = 0; i < this._n; ++i) {
            float x1i = this._x1[i];
            float x2i = this._x2[i];
            if (x1i < fx1 || x1i > lx1 || x2i < fx2 || x2i > lx2) continue;
            int i12 = (int)(0.5f + (x1i - fx1) * od1);
            int i24 = (int)(0.5f + (x2i - fx2) * od2);
            float[] fArray = c[i24];
            int n = i12;
            fArray[n] = fArray[n] + 1.0f;
            float[] fArray2 = g[i24];
            int n3 = i12;
            fArray2[n3] = fArray2[n3] + this._f[i];
        }
        for (i2 = 0; i2 < n2; ++i2) {
            for (int i13 = 0; i13 < n1; ++i13) {
                if (!(c[i2][i13] > 0.0f)) continue;
                float[] fArray = g[i2];
                int n = i13;
                fArray[n] = fArray[n] / c[i2][i13];
                c[i2][i13] = -c[i2][i13];
            }
        }
        for (i2 = 0; i2 < n2; ++i2) {
            for (int i14 = 0; i14 < n1; ++i14) {
                int m1;
                int j1;
                int m2;
                int j2;
                int k2k;
                int k1k;
                int k4;
                int kn = -1;
                float fn = 0.0f;
                for (k4 = 0; k4 < nk && kn < 0; ++k4) {
                    k1k = k1[k4];
                    k2k = k2[k4];
                    j2 = i2 - k2k;
                    for (m2 = 0; m2 < 2; ++m2) {
                        if (j2 >= 0 && j2 < n2) {
                            j1 = i14 - k1k;
                            for (m1 = 0; m1 < 2; ++m1) {
                                if (j1 >= 0 && j1 < n1 && c[j2][j1] < 0.0f) {
                                    kn = k4;
                                    fn = g[j2][j1];
                                }
                                j1 = i14 + k1k;
                            }
                        }
                        j2 = i2 + k2k;
                    }
                }
                if (kn < nk - 1 && k1[kn] == k2[kn + 1] && k2[kn] == k1[kn + 1]) {
                    ++kn;
                }
                for (k4 = 0; k4 <= kn; ++k4) {
                    k1k = k1[k4];
                    k2k = k2[k4];
                    j2 = i2 - k2k;
                    for (m2 = 0; m2 < 2; ++m2) {
                        if (j2 >= 0 && j2 < n2) {
                            j1 = i14 - k1k;
                            for (m1 = 0; m1 < 2; ++m1) {
                                if (j1 >= 0 && j1 < n1 && c[j2][j1] >= 0.0f) {
                                    float[] fArray = g[j2];
                                    int n = j1;
                                    fArray[n] = fArray[n] + fn;
                                    float[] fArray3 = c[j2];
                                    int n4 = j1;
                                    fArray3[n4] = fArray3[n4] + 1.0f;
                                }
                                j1 = i14 + k1k;
                            }
                        }
                        j2 = i2 + k2k;
                    }
                }
            }
        }
        for (i2 = 0; i2 < n2; ++i2) {
            for (int i15 = 0; i15 < n1; ++i15) {
                if (!(c[i2][i15] > 0.0f)) continue;
                float[] fArray = g[i2];
                int n = i15;
                fArray[n] = fArray[n] / c[i2][i15];
            }
        }
        int n1m = n1 - 1;
        int n2m = n2 - 1;
        float a1 = 0.4f;
        float a2 = -0.1f;
        float a3 = -0.05f;
        for (int jsmooth = 0; jsmooth < this._nsmooth; ++jsmooth) {
            for (int i25 = 0; i25 < n2; ++i25) {
                int i2m = i25 == 0 ? i25 : i25 - 1;
                int i2p = i25 == n2m ? i25 : i25 + 1;
                int i2mm = i2m == 0 ? i2m : i2m - 1;
                int i2pp = i2p == n2m ? i2p : i2p + 1;
                for (int i16 = 0; i16 < n1; ++i16) {
                    int i1pp;
                    int i1m = i16 == 0 ? i16 : i16 - 1;
                    int i1p = i16 == n1m ? i16 : i16 + 1;
                    int i1mm = i1m == 0 ? i1m : i1m - 1;
                    int n = i1pp = i1p == n1m ? i1p : i1p + 1;
                    if (!(c[i25][i16] > 0.0f)) continue;
                    float g1 = a1 * (g[i25][i1m] + g[i25][i1p] + g[i2m][i16] + g[i2p][i16]);
                    float g2 = a2 * (g[i2m][i1m] + g[i2m][i1p] + g[i2p][i1m] + g[i2p][i1p]);
                    float g3 = a3 * (g[i25][i1mm] + g[i25][i1pp] + g[i2mm][i16] + g[i2pp][i16]);
                    g[i25][i16] = g1 + g2 + g3;
                }
            }
        }
        return g;
    }
}

