/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.dsp.EigenTensors2;
import edu.mines.jtk.dsp.LocalDiffusionKernel;
import edu.mines.jtk.dsp.Tensors3;
import edu.mines.jtk.util.ArrayMath;
import edu.mines.jtk.util.Parallel;
import edu.mines.jtk.util.Stopwatch;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class LocalDiffusionKernelTest
extends TestCase {
    public static void main(String[] args) {
        if (args.length > 0 && args[0].equals("bench")) {
            boolean parallel = args.length <= 1 || !args[1].equals("serial");
            LocalDiffusionKernelTest.bench(parallel);
        }
        TestSuite suite = new TestSuite(LocalDiffusionKernelTest.class);
        TestRunner.run((Test)suite);
    }

    public void testD21() {
        LocalDiffusionKernel ldk = new LocalDiffusionKernel(LocalDiffusionKernel.Stencil.D21);
        LocalDiffusionKernelTest.testSpd2(ldk);
        LocalDiffusionKernelTest.testSpd3(ldk);
    }

    public void testD22() {
        LocalDiffusionKernel ldk = new LocalDiffusionKernel(LocalDiffusionKernel.Stencil.D22);
        LocalDiffusionKernelTest.testSpd2(ldk);
        LocalDiffusionKernelTest.testSpd3(ldk);
        LocalDiffusionKernelTest.testSpd2RandomTensors(ldk);
    }

    private static void testSpd2(LocalDiffusionKernel ldk) {
        int n1 = 5;
        int n2 = 6;
        for (int iter = 0; iter < 10; ++iter) {
            float[][] s = ArrayMath.randfloat(n1, n2);
            float[][] x = ArrayMath.sub(ArrayMath.randfloat(n1, n2), 0.5f);
            float[][] y = ArrayMath.sub(ArrayMath.randfloat(n1, n2), 0.5f);
            float[][] dx = ArrayMath.zerofloat(n1, n2);
            float[][] dy = ArrayMath.zerofloat(n1, n2);
            ldk.apply(1.0f, s, x, dx);
            ldk.apply(1.0f, s, y, dy);
            float xdx = LocalDiffusionKernelTest.dot(x, dx);
            float ydy = LocalDiffusionKernelTest.dot(y, dy);
            float ydx = LocalDiffusionKernelTest.dot(y, dx);
            float xdy = LocalDiffusionKernelTest.dot(x, dy);
            LocalDiffusionKernelTest.assertTrue((xdx >= 0.0f ? 1 : 0) != 0);
            LocalDiffusionKernelTest.assertTrue((ydy >= 0.0f ? 1 : 0) != 0);
            LocalDiffusionKernelTest.assertEquals((double)xdy, (double)ydx, (double)1.0E-4);
        }
    }

    private static void testSpd2RandomTensors(LocalDiffusionKernel ldk) {
        int n1 = 5;
        int n2 = 6;
        for (int iter = 0; iter < 10; ++iter) {
            float[][] s = ArrayMath.randfloat(n1, n2);
            float[][] x = ArrayMath.sub(ArrayMath.randfloat(n1, n2), 0.5f);
            float[][] y = ArrayMath.sub(ArrayMath.randfloat(n1, n2), 0.5f);
            float[][] dx = ArrayMath.zerofloat(n1, n2);
            float[][] dy = ArrayMath.zerofloat(n1, n2);
            RandomTensors2 t = new RandomTensors2(n1, n2);
            ldk.apply(t, 1.0f, s, x, dx);
            ldk.apply(t, 1.0f, s, y, dy);
            float xdx = LocalDiffusionKernelTest.dot(x, dx);
            float ydy = LocalDiffusionKernelTest.dot(y, dy);
            float ydx = LocalDiffusionKernelTest.dot(y, dx);
            float xdy = LocalDiffusionKernelTest.dot(x, dy);
            LocalDiffusionKernelTest.assertTrue((xdx >= 0.0f ? 1 : 0) != 0);
            LocalDiffusionKernelTest.assertTrue((ydy >= 0.0f ? 1 : 0) != 0);
            LocalDiffusionKernelTest.assertEquals((double)xdy, (double)ydx, (double)1.0E-4);
        }
    }

    private static void testSpd3(LocalDiffusionKernel ldk) {
        int n1 = 5;
        int n2 = 6;
        int n3 = 7;
        for (int iter = 0; iter < 10; ++iter) {
            float[][][] s = ArrayMath.randfloat(n1, n2, n3);
            float[][][] x = ArrayMath.sub(ArrayMath.randfloat(n1, n2, n3), 0.5f);
            float[][][] y = ArrayMath.sub(ArrayMath.randfloat(n1, n2, n3), 0.5f);
            float[][][] dx = ArrayMath.zerofloat(n1, n2, n3);
            float[][][] dy = ArrayMath.zerofloat(n1, n2, n3);
            ldk.apply(null, 1.0f, s, x, dx);
            ldk.apply(null, 1.0f, s, y, dy);
            float xdx = LocalDiffusionKernelTest.dot(x, dx);
            float ydy = LocalDiffusionKernelTest.dot(y, dy);
            float ydx = LocalDiffusionKernelTest.dot(y, dx);
            float xdy = LocalDiffusionKernelTest.dot(x, dy);
            LocalDiffusionKernelTest.assertTrue((xdx >= 0.0f ? 1 : 0) != 0);
            LocalDiffusionKernelTest.assertTrue((ydy >= 0.0f ? 1 : 0) != 0);
            LocalDiffusionKernelTest.assertEquals((double)xdy, (double)ydx, (double)1.0E-4);
        }
    }

    private static float dot(float[][] x, float[][] y) {
        return ArrayMath.sum(ArrayMath.mul(x, y));
    }

    private static float dot(float[][][] x, float[][][] y) {
        return ArrayMath.sum(ArrayMath.mul(x, y));
    }

    private static void bench(boolean parallel) {
        Parallel.setParallel(parallel);
        LocalDiffusionKernelTest.bench3();
    }

    private static void bench2() {
        int n1 = 501;
        int n2 = 502;
        Random r = new Random(314159L);
        float[][] x = ArrayMath.randfloat(r, n1, n2);
        float[][] y = ArrayMath.randfloat(r, n1, n2);
        float[][] s = ArrayMath.randfloat(r, n1, n2);
        RandomTensors2 d = new RandomTensors2(n1, n2);
        String[] stencilNames = new String[]{"D22", "D24", "D71"};
        LocalDiffusionKernel.Stencil[] stencils = new LocalDiffusionKernel.Stencil[]{LocalDiffusionKernel.Stencil.D22, LocalDiffusionKernel.Stencil.D24, LocalDiffusionKernel.Stencil.D71};
        for (int i = 0; i < stencils.length; ++i) {
            System.out.println(stencilNames[i]);
            LocalDiffusionKernel ldf = new LocalDiffusionKernel(stencils[i]);
            double maxtime = 5.0;
            double nsample = (double)n1 * (double)n2;
            Stopwatch sw = new Stopwatch();
            for (int itest = 0; itest < 3; ++itest) {
                sw.restart();
                int niter = 0;
                while (sw.time() < maxtime) {
                    ldf.apply(d, 0.5f, s, x, y);
                    ++niter;
                }
                sw.stop();
                float sum = ArrayMath.sum(y);
                int rate = (int)(1.0E-6 * (double)niter * nsample / sw.time());
                System.out.println("rate = " + rate + "  sum = " + sum);
            }
        }
    }

    private static void bench3() {
        int n1 = 501;
        int n2 = 502;
        int n3 = 503;
        Random r = new Random(314159L);
        float[][][] x = ArrayMath.randfloat(r, n1, n2, n3);
        float[][][] y = ArrayMath.randfloat(r, n1, n2, n3);
        float[][][] s = ArrayMath.randfloat(r, n1, n2, n3);
        IdentityTensors3 d = new IdentityTensors3();
        String[] stencilNames = new String[]{"D22", "D33", "D71"};
        LocalDiffusionKernel.Stencil[] stencils = new LocalDiffusionKernel.Stencil[]{LocalDiffusionKernel.Stencil.D22, LocalDiffusionKernel.Stencil.D33, LocalDiffusionKernel.Stencil.D71};
        for (int i = 0; i < stencils.length; ++i) {
            System.out.println(stencilNames[i]);
            LocalDiffusionKernel ldf = new LocalDiffusionKernel(stencils[i]);
            double maxtime = 5.0;
            double nsample = (double)n1 * (double)n2 * (double)n3;
            Stopwatch sw = new Stopwatch();
            for (int itest = 0; itest < 3; ++itest) {
                sw.restart();
                int niter = 0;
                while (sw.time() < maxtime) {
                    ldf.apply(d, 0.5f, s, x, y);
                    ++niter;
                }
                sw.stop();
                float sum = ArrayMath.sum(y);
                int rate = (int)(1.0E-6 * (double)niter * nsample / sw.time());
                System.out.println("rate = " + rate + "  sum = " + sum);
            }
        }
    }

    private static class IdentityTensors3
    implements Tensors3 {
        private IdentityTensors3() {
        }

        @Override
        public void getTensor(int i1, int i2, int i3, float[] a) {
            a[0] = 1.0f;
            a[1] = 0.0f;
            a[2] = 0.0f;
            a[3] = 1.0f;
            a[4] = 0.0f;
            a[5] = 1.0f;
        }
    }

    private static class RandomTensors2
    extends EigenTensors2 {
        RandomTensors2(int n1, int n2) {
            super(n1, n2);
            Random r = new Random();
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int i1 = 0; i1 < n1; ++i1) {
                    float a = (float)Math.PI * 2 * r.nextFloat();
                    float u1 = ArrayMath.cos(a);
                    float u2 = ArrayMath.sin(a);
                    float du = 0.01f + 0.09f * r.nextFloat();
                    float dv = 0.01f + 0.99f * r.nextFloat();
                    this.setEigenvectorU(i1, i2, u1, u2);
                    this.setEigenvalues(i1, i2, du, dv);
                }
            }
        }
    }
}

