/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi.labeling;

import java.util.Iterator;
import net.imglib2.AbstractWrappedInterval;
import net.imglib2.Cursor;
import net.imglib2.FlatIterationOrder;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.converter.AbstractConvertedCursor;
import net.imglib2.converter.AbstractConvertedRandomAccess;
import net.imglib2.roi.labeling.LabelingMapping;
import net.imglib2.roi.labeling.LabelingType;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.view.Views;
import net.imglib2.view.iteration.SubIntervalIterable;

public class ImgLabeling<T, I extends IntegerType<I>>
extends AbstractWrappedInterval<RandomAccessibleInterval<I>>
implements RandomAccessibleInterval<LabelingType<T>>,
IterableInterval<LabelingType<T>>,
SubIntervalIterable<LabelingType<T>> {
    private final RandomAccessibleInterval<I> indexAccessible;
    private final IterableInterval<I> indexIterable;
    private final boolean subIterable;
    private final LabelingType.ModCount generation;
    private final LabelingMapping<T> mapping;

    public ImgLabeling(RandomAccessibleInterval<I> img) {
        super(img);
        this.indexAccessible = img;
        this.indexIterable = Views.iterable(img);
        this.subIterable = this.indexIterable instanceof SubIntervalIterable;
        this.generation = new LabelingType.ModCount();
        this.mapping = new LabelingMapping((IntegerType)this.indexIterable.firstElement());
    }

    public LabelingMapping<T> getMapping() {
        return this.mapping;
    }

    public RandomAccess<LabelingType<T>> randomAccess() {
        return new LabelingConvertedRandomAccess(this.indexAccessible.randomAccess());
    }

    public RandomAccess<LabelingType<T>> randomAccess(Interval interval) {
        return new LabelingConvertedRandomAccess(this.indexAccessible.randomAccess(interval));
    }

    public Cursor<LabelingType<T>> cursor() {
        return new LabelingConvertedCursor(this.indexIterable.cursor());
    }

    public Cursor<LabelingType<T>> localizingCursor() {
        return new LabelingConvertedCursor(this.indexIterable.localizingCursor());
    }

    public LabelingType<T> firstElement() {
        return (LabelingType)this.cursor().next();
    }

    public Iterator<LabelingType<T>> iterator() {
        return this.cursor();
    }

    public long size() {
        return this.indexIterable.size();
    }

    public Object iterationOrder() {
        return this.indexIterable.iterationOrder();
    }

    public boolean supportsOptimizedCursor(Interval interval) {
        if (this.subIterable) {
            return ((SubIntervalIterable)this.indexIterable).supportsOptimizedCursor(interval);
        }
        return false;
    }

    public Object subIntervalIterationOrder(Interval interval) {
        if (this.subIterable) {
            return ((SubIntervalIterable)this.indexIterable).subIntervalIterationOrder(interval);
        }
        return new FlatIterationOrder(interval);
    }

    public Cursor<LabelingType<T>> cursor(Interval interval) {
        Cursor c = this.subIterable ? ((SubIntervalIterable)this.indexIterable).cursor(interval) : Views.interval(this.indexAccessible, (Interval)interval).cursor();
        return new LabelingConvertedCursor(c);
    }

    public Cursor<LabelingType<T>> localizingCursor(Interval interval) {
        Cursor c = this.subIterable ? ((SubIntervalIterable)this.indexIterable).localizingCursor(interval) : Views.interval(this.indexAccessible, (Interval)interval).localizingCursor();
        return new LabelingConvertedCursor(c);
    }

    public RandomAccessibleInterval<I> getIndexImg() {
        return this.indexAccessible;
    }

    class LabelingConvertedCursor
    extends AbstractConvertedCursor<I, LabelingType<T>> {
        private final LabelingType<T> type;

        public LabelingConvertedCursor(Cursor<I> source) {
            super(source);
            this.type = new LabelingType((IntegerType)source.get(), ImgLabeling.this.mapping, ImgLabeling.this.generation);
        }

        public LabelingType<T> get() {
            return this.type;
        }

        public LabelingConvertedCursor copy() {
            return new LabelingConvertedCursor(this.source.copyCursor());
        }
    }

    class LabelingConvertedRandomAccess
    extends AbstractConvertedRandomAccess<I, LabelingType<T>> {
        private final LabelingType<T> type;

        public LabelingConvertedRandomAccess(RandomAccess<I> source) {
            super(source);
            this.type = new LabelingType((IntegerType)source.get(), ImgLabeling.this.mapping, ImgLabeling.this.generation);
        }

        public LabelingType<T> get() {
            return this.type;
        }

        public LabelingConvertedRandomAccess copy() {
            return new LabelingConvertedRandomAccess(this.source.copyRandomAccess());
        }
    }
}

