/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.space;

import java.util.ArrayList;
import net.imagej.axis.AxisType;
import net.imagej.axis.TypedAxis;
import net.imagej.space.TypedSpace;

public class CombinedSpace<A extends TypedAxis, S extends TypedSpace<A>>
extends ArrayList<S>
implements TypedSpace<A> {
    private final ArrayList<AxisType> axisTypes = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        CombinedSpace combinedSpace = this;
        synchronized (combinedSpace) {
            this.axisTypes.clear();
            for (TypedSpace space : this) {
                for (int d = 0; d < space.numDimensions(); ++d) {
                    AxisType axisType = ((TypedAxis)space.axis(d)).type();
                    if (this.axisTypes.contains(axisType)) continue;
                    this.axisTypes.add(axisType);
                }
            }
        }
    }

    @Override
    public int dimensionIndex(AxisType axis) {
        return this.axisTypes().indexOf(axis);
    }

    @Override
    public A axis(int d) {
        AxisType type = this.axisTypes().get(d);
        for (TypedSpace space : this) {
            int id = space.dimensionIndex(type);
            if (id < 0) continue;
            return (A)((TypedAxis)space.axis(id));
        }
        throw new IllegalStateException("No compatible constituent space");
    }

    @Override
    public void axes(A[] axes) {
        for (int i = 0; i < axes.length; ++i) {
            axes[i] = this.axis(i);
        }
    }

    @Override
    public void setAxis(A axis, int d) {
        AxisType type = this.axisTypes().get(d);
        for (TypedSpace space : this) {
            int id = space.dimensionIndex(type);
            if (id < 0) continue;
            space.setAxis(axis, id);
        }
    }

    @Override
    public int numDimensions() {
        return this.axisTypes().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<AxisType> axisTypes() {
        CombinedSpace combinedSpace = this;
        synchronized (combinedSpace) {
            return this.axisTypes;
        }
    }
}

