/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.notebook;

import net.imagej.Dataset;
import net.imagej.ImageJService;
import net.imagej.axis.Axes;
import net.imagej.notebook.NotebookTable;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;

public interface NotebookService
extends ImageJService {
    default public Object display(Dataset source) {
        return this.display((RandomAccessibleInterval)source, source.dimensionIndex(Axes.X), source.dimensionIndex(Axes.Y), source.dimensionIndex(Axes.CHANNEL), ValueScaling.AUTO, new long[0]);
    }

    default public <T extends RealType<T>> Object display(RandomAccessibleInterval<T> source) {
        int cAxis = source.numDimensions() > 2 && source.dimension(2) <= 3L ? 2 : -1;
        return this.display(source, 0, 1, cAxis, ValueScaling.AUTO, new long[0]);
    }

    public <T extends RealType<T>> Object display(RandomAccessibleInterval<T> var1, int var2, int var3, int var4, ValueScaling var5, long ... var6);

    public <T extends RealType<T> & NativeType<T>> RandomAccessibleInterval<T> mosaic(int[] var1, RandomAccessibleInterval<T> ... var2);

    default public NotebookTable methods(Object o) {
        if (o == null) {
            return null;
        }
        return this.methods(o.getClass());
    }

    default public NotebookTable methods(Object o, String prefix) {
        if (o == null) {
            return null;
        }
        return this.methods(o.getClass(), prefix);
    }

    default public NotebookTable methods(Class<?> type) {
        return this.methods(type, "");
    }

    public NotebookTable methods(Class<?> var1, String var2);

    public static enum ValueScaling {
        AUTO,
        FULL,
        DATA;

    }
}

