/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.internals.distributions;

import org.renjin.eval.Session;
import org.renjin.sexp.DoubleVector;
import org.renjin.stats.internals.distributions.Binom;
import org.renjin.stats.internals.distributions.Exponantial;
import org.renjin.stats.internals.distributions.Poisson;
import org.renjin.stats.internals.distributions.SignRank;

public class Geometric {
    public static double rgeom(Session context, double p) {
        if (p <= 0.0 || p > 1.0) {
            return Double.NaN;
        }
        return Poisson.rpois(context, Exponantial.exp_rand(context) * ((1.0 - p) / p));
    }

    public static double pgeom(double x, double p, boolean lower_tail, boolean log_p) {
        if (DoubleVector.isNaN(x) || DoubleVector.isNaN(p)) {
            return x + p;
        }
        if (p <= 0.0 || p > 1.0) {
            return Double.NaN;
        }
        if (x < 0.0) {
            return SignRank.R_DT_0(lower_tail, log_p);
        }
        if (!DoubleVector.isFinite(x)) {
            return SignRank.R_DT_1(lower_tail, log_p);
        }
        x = Math.floor(x + 1.0E-7);
        if (p == 1.0) {
            x = lower_tail ? 1.0 : 0.0;
            return log_p ? Math.log(x) : x;
        }
        x = Math.log1p(-p) * (x + 1.0);
        if (log_p) {
            return SignRank.R_DT_Clog(x, lower_tail, log_p);
        }
        return lower_tail ? -Math.expm1(x) : Math.exp(x);
    }

    public static double dgeom(double x, double p, boolean give_log) {
        if (DoubleVector.isNaN(x) || DoubleVector.isNaN(p)) {
            return x + p;
        }
        if (p <= 0.0 || p > 1.0) {
            return Double.NaN;
        }
        if (SignRank.R_D_nonint(x, true, give_log)) {
            return SignRank.R_D__0(true, give_log);
        }
        if (x < 0.0 || !DoubleVector.isFinite(x) || p == 0.0) {
            return SignRank.R_D__0(true, give_log);
        }
        x = SignRank.R_D_forceint(x);
        double prob = Binom.dbinom_raw(0.0, x, p, 1.0 - p, give_log);
        return give_log ? Math.log(p) + prob : p * prob;
    }

    public static double qgeom(double p, double prob, boolean lower_tail, boolean log_p) {
        if (prob <= 0.0 || prob > 1.0) {
            return Double.NaN;
        }
        if (log_p) {
            if (p > 0.0) {
                return Double.NaN;
            }
            if (p == 0.0) {
                return lower_tail ? Double.POSITIVE_INFINITY : 0.0;
            }
            if (p == Double.NEGATIVE_INFINITY) {
                // empty if block
            }
            return lower_tail ? 0.0 : Double.POSITIVE_INFINITY;
        }
        if (p < 0.0 || p > 1.0) {
            return Double.NaN;
        }
        if (p == 0.0) {
            return lower_tail ? 0.0 : Double.POSITIVE_INFINITY;
        }
        if (p == 1.0) {
            return lower_tail ? Double.POSITIVE_INFINITY : 0.0;
        }
        if (DoubleVector.isNaN(p) || DoubleVector.isNaN(prob)) {
            return p + prob;
        }
        if (prob == 1.0) {
            return 0.0;
        }
        return Math.ceil(SignRank.R_DT_Clog(p, lower_tail, log_p) / Math.log1p(-prob) - 1.0 - 1.0E-7);
    }
}

