/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.jupyter.kernel.handler;

import com.twosigma.beaker.jupyter.msg.JupyterMessages;
import com.twosigma.jupyter.KernelFunctionality;
import com.twosigma.jupyter.handler.KernelHandler;
import com.twosigma.jupyter.message.Header;
import com.twosigma.jupyter.message.Message;
import java.util.ArrayList;
import java.util.HashMap;
import org.scijava.script.ScriptLanguage;

public class ScijavaKernelInfoHandler
extends KernelHandler<Message> {
    private final ScriptLanguage scriptLanguage;

    public ScijavaKernelInfoHandler(KernelFunctionality kernel, ScriptLanguage scriptLanguage) {
        super(kernel);
        this.scriptLanguage = scriptLanguage;
    }

    public void handle(Message message) {
        Message reply = new Message();
        HashMap<String, Object> map = new HashMap<String, Object>(6);
        map.put("protocol_version", "5.0");
        map.put("implementation", this.scriptLanguage.getEngineName());
        map.put("implementation_version", this.scriptLanguage.getEngineVersion());
        HashMap<String, String> map1 = new HashMap<String, String>(7);
        map1.put("name", this.scriptLanguage.getLanguageName());
        map1.put("version", this.scriptLanguage.getLanguageVersion());
        map1.put("mimetype", this.scriptLanguage.getMimeTypes().toString());
        map1.put("file_extension", this.scriptLanguage.getExtensions().toString());
        map1.put("pygments_lexer", this.scriptLanguage.getLanguageName());
        map1.put("codemirror_mode", this.scriptLanguage.getLanguageName());
        map1.put("nbconverter_exporter", "");
        map.put("language_info", map1);
        String banner = "SciJava Jupyter Kernel v" + ((Object)((Object)this)).getClass().getPackage().getSpecificationVersion() + " | ";
        banner = banner + "Language : " + this.scriptLanguage.getLanguageName();
        banner = banner + " " + this.scriptLanguage.getLanguageVersion() + "\n";
        map.put("banner", banner);
        map.put("beakerx", true);
        ArrayList<String> helpLinks = new ArrayList<String>();
        helpLinks.add("https://imagej.net/Jupyter");
        helpLinks.add("https://github.com/hadim/scijava-jupyter-kernel");
        map.put("help_links", helpLinks);
        reply.setContent(map);
        reply.setHeader(new Header(JupyterMessages.KERNEL_INFO_REPLY, message.getHeader().getSession()));
        reply.setParentHeader(message.getHeader());
        reply.setIdentities(message.getIdentities());
        this.send(reply);
    }
}

