/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.jupyter.kernel.evaluator;

import com.twosigma.beaker.jvm.object.SimpleEvaluationObject;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.script.ScriptEngine;
import org.scijava.Context;
import org.scijava.convert.ConvertService;
import org.scijava.event.EventService;
import org.scijava.log.LogService;
import org.scijava.module.Module;
import org.scijava.module.ModuleException;
import org.scijava.module.ModuleItem;
import org.scijava.module.event.ModulePostprocessEvent;
import org.scijava.module.event.ModulePreprocessEvent;
import org.scijava.module.process.ModulePostprocessor;
import org.scijava.module.process.ModulePreprocessor;
import org.scijava.module.process.PostprocessorPlugin;
import org.scijava.module.process.PreprocessorPlugin;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.PluginService;
import org.scijava.script.ScriptInfo;
import org.scijava.script.ScriptLanguage;
import org.scijava.script.ScriptModule;

public class Worker
implements Runnable {
    @Parameter
    private LogService log;
    @Parameter
    private Context context;
    @Parameter
    private PluginService pluginService;
    @Parameter
    private EventService eventService;
    @Parameter
    private ConvertService convertService;
    ScriptLanguage scriptLanguage;
    ScriptEngine engine;
    SimpleEvaluationObject seo = null;
    String code = null;

    Worker(Context context, ScriptEngine engine, ScriptLanguage scriptLanguage) {
        context.inject(this);
        this.engine = engine;
        this.scriptLanguage = scriptLanguage;
    }

    public void setup(SimpleEvaluationObject seo, String code) {
        this.seo = seo;
        this.code = code;
    }

    @Override
    public void run() {
        StringReader input = new StringReader(this.code);
        ScriptInfo info = new ScriptInfo(this.context, "dummy.py", input);
        this.seo.setOutputHandler();
        try {
            ScriptModule module = info.createModule();
            this.context.inject(module);
            module.setLanguage(this.scriptLanguage);
            this.preProcess(module);
            for (ModuleItem<?> item : info.inputs()) {
                String name = item.getName();
                this.engine.put(name, module.getInput(name));
            }
            Object returnValue = null;
            try {
                returnValue = this.engine.eval(info.getReader());
                returnValue = this.scriptLanguage.decode(returnValue);
                this.seo.finished(returnValue);
            }
            catch (Throwable e) {
                if (e instanceof InvocationTargetException) {
                    e = ((InvocationTargetException)e).getTargetException();
                }
                if (e instanceof InterruptedException || e instanceof InvocationTargetException || e instanceof ThreadDeath) {
                    this.seo.error((Object)"Excecution canceled.");
                }
                this.seo.error((Object)e.getMessage());
            }
            for (ModuleItem<?> item : info.outputs()) {
                String name = item.getName();
                Object value = "result".equals(name) && info.isReturnValueAppended() ? returnValue : this.engine.get(name);
                Object decoded = this.scriptLanguage.decode(value);
                Object typed = this.convertService.convert(decoded, item.getType());
                module.setOutput(name, typed);
            }
            this.postProcess(module);
        }
        catch (ModuleException ex) {
            this.log.error(ex);
        }
        this.seo.clrOutputHandler();
    }

    public ModulePreprocessor preProcess(ScriptModule module) {
        List<PreprocessorPlugin> pre = this.pluginService.createInstancesOfType(PreprocessorPlugin.class);
        for (ModulePreprocessor modulePreprocessor : pre) {
            modulePreprocessor.process(module);
            if (this.eventService != null) {
                this.eventService.publish(new ModulePreprocessEvent((Module)module, modulePreprocessor));
            }
            if (!modulePreprocessor.isCanceled()) continue;
            return modulePreprocessor;
        }
        return null;
    }

    public void postProcess(ScriptModule module) {
        List<PostprocessorPlugin> post = this.pluginService.createInstancesOfType(PostprocessorPlugin.class);
        for (ModulePostprocessor modulePostprocessor : post) {
            modulePostprocessor.process(module);
            if (this.eventService == null) continue;
            this.eventService.publish(new ModulePostprocessEvent((Module)module, modulePostprocessor));
        }
    }
}

