/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.handle;

import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.event.TransformRestoreEdit;
import org.jhotdraw.draw.handle.BoundsOutlineHandle;
import org.jhotdraw.draw.handle.Handle;
import org.jhotdraw.draw.handle.HandleAttributeKeys;
import org.jhotdraw.draw.handle.LocatorHandle;
import org.jhotdraw.draw.locator.Locator;
import org.jhotdraw.draw.locator.RelativeLocator;
import org.jhotdraw.util.ResourceBundleUtil;

public class ResizeHandleKit {
    private static final boolean DEBUG = false;

    public static void addCornerResizeHandles(Figure f, Collection<Handle> handles) {
        if (f.isTransformable()) {
            handles.add(ResizeHandleKit.southEast(f));
            handles.add(ResizeHandleKit.southWest(f));
            handles.add(ResizeHandleKit.northEast(f));
            handles.add(ResizeHandleKit.northWest(f));
        }
    }

    public static void addEdgeResizeHandles(Figure f, Collection<Handle> handles) {
        if (f.isTransformable()) {
            handles.add(ResizeHandleKit.south(f));
            handles.add(ResizeHandleKit.north(f));
            handles.add(ResizeHandleKit.east(f));
            handles.add(ResizeHandleKit.west(f));
        }
    }

    public static void addResizeHandles(Figure f, Collection<Handle> handles) {
        handles.add(new BoundsOutlineHandle(f));
        if (f.isTransformable()) {
            ResizeHandleKit.addCornerResizeHandles(f, handles);
            ResizeHandleKit.addEdgeResizeHandles(f, handles);
        }
    }

    public static Handle south(Figure owner) {
        return new SouthHandle(owner);
    }

    public static Handle southEast(Figure owner) {
        return new SouthEastHandle(owner);
    }

    public static Handle southWest(Figure owner) {
        return new SouthWestHandle(owner);
    }

    public static Handle north(Figure owner) {
        return new NorthHandle(owner);
    }

    public static Handle northEast(Figure owner) {
        return new NorthEastHandle(owner);
    }

    public static Handle northWest(Figure owner) {
        return new NorthWestHandle(owner);
    }

    public static Handle east(Figure owner) {
        return new EastHandle(owner);
    }

    public static Handle west(Figure owner) {
        return new WestHandle(owner);
    }

    private static class WestHandle
    extends ResizeHandle {
        WestHandle(Figure owner) {
            super(owner, RelativeLocator.west(true));
        }

        @Override
        protected void trackStepNormalized(Point2D.Double p, boolean keepAspect) {
            this.setBounds(new Point2D.Double(Math.min(this.sb.x + this.sb.width - 1.0, p.x), this.sb.y), new Point2D.Double(this.sb.x + this.sb.width, this.sb.y + this.sb.height));
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            if (!this.getOwner().isTransformable()) {
                evt.consume();
                return;
            }
            Rectangle2D.Double r = this.getOwner().getBounds();
            switch (evt.getKeyCode()) {
                case 38: 
                case 40: {
                    evt.consume();
                    break;
                }
                case 37: {
                    this.setBounds(new Point2D.Double(r.x - 1.0, r.y), new Point2D.Double(r.x + r.width, r.y + r.height));
                    evt.consume();
                    break;
                }
                case 39: {
                    if (r.width > 1.0) {
                        this.setBounds(new Point2D.Double(r.x + 1.0, r.y), new Point2D.Double(r.x + r.width, r.y + r.height));
                    }
                    evt.consume();
                }
            }
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(this.getOwner().isTransformable() ? 10 : 0);
        }
    }

    private static class SouthWestHandle
    extends ResizeHandle {
        SouthWestHandle(Figure owner) {
            super(owner, RelativeLocator.southWest(true));
        }

        @Override
        protected void trackStepNormalized(Point2D.Double p, boolean keepAspect) {
            double nx = Math.min(this.sb.x + this.sb.width - 1.0, p.x);
            double ny = Math.max(this.sb.y + 1.0, p.y);
            if (keepAspect) {
                double nxx = this.sb.x + this.sb.width - Math.max(1.0, (p.y - this.sb.y) / this.aspectRatio);
                if (nxx <= p.x) {
                    nx = nxx;
                } else {
                    ny = this.sb.y + Math.max(1.0, (this.sb.x + this.sb.width - 1.0 - p.x) * this.aspectRatio);
                }
            }
            this.setBounds(new Point2D.Double(nx, this.sb.y), new Point2D.Double(this.sb.x + this.sb.width, ny));
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            if (!this.getOwner().isTransformable()) {
                evt.consume();
                return;
            }
            Rectangle2D.Double r = this.getOwner().getBounds();
            switch (evt.getKeyCode()) {
                case 38: {
                    if (r.height > 1.0) {
                        this.setBounds(new Point2D.Double(r.x, r.y), new Point2D.Double(r.x + r.width, r.y + r.height - 1.0));
                    }
                    evt.consume();
                    break;
                }
                case 40: {
                    this.setBounds(new Point2D.Double(r.x, r.y), new Point2D.Double(r.x + r.width, r.y + r.height + 1.0));
                    evt.consume();
                    break;
                }
                case 37: {
                    this.setBounds(new Point2D.Double(r.x - 1.0, r.y), new Point2D.Double(r.x + r.width, r.y + r.height));
                    evt.consume();
                    break;
                }
                case 39: {
                    if (r.width > 1.0) {
                        this.setBounds(new Point2D.Double(r.x + 1.0, r.y), new Point2D.Double(r.x + r.width, r.y + r.height));
                    }
                    evt.consume();
                }
            }
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(this.getOwner().isTransformable() ? 4 : 0);
        }
    }

    private static class SouthHandle
    extends ResizeHandle {
        SouthHandle(Figure owner) {
            super(owner, RelativeLocator.south(true));
        }

        @Override
        protected void trackStepNormalized(Point2D.Double p, boolean keepAspect) {
            this.setBounds(new Point2D.Double(this.sb.x, this.sb.y), new Point2D.Double(this.sb.x + this.sb.width, Math.max(this.sb.y + 1.0, p.y)));
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            if (!this.getOwner().isTransformable()) {
                evt.consume();
                return;
            }
            Rectangle2D.Double r = this.getOwner().getBounds();
            switch (evt.getKeyCode()) {
                case 38: {
                    if (r.height > 1.0) {
                        this.setBounds(new Point2D.Double(r.x, r.y), new Point2D.Double(r.x + r.width, r.y + r.height - 1.0));
                    }
                    evt.consume();
                    break;
                }
                case 40: {
                    this.setBounds(new Point2D.Double(r.x, r.y), new Point2D.Double(r.x + r.width, r.y + r.height + 1.0));
                    evt.consume();
                    break;
                }
                case 37: {
                    evt.consume();
                    break;
                }
                case 39: {
                    evt.consume();
                }
            }
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(this.getOwner().isTransformable() ? 9 : 0);
        }
    }

    private static class SouthEastHandle
    extends ResizeHandle {
        SouthEastHandle(Figure owner) {
            super(owner, RelativeLocator.southEast(true));
        }

        @Override
        protected void trackStepNormalized(Point2D.Double p, boolean keepAspect) {
            double nx = Math.max(this.sb.x + 1.0, p.x);
            double ny = Math.max(this.sb.y + 1.0, p.y);
            if (keepAspect) {
                double nxx = this.sb.x + Math.max(1.0, (p.y - this.sb.y) / this.aspectRatio);
                if (nxx >= p.x) {
                    nx = nxx;
                } else {
                    ny = this.sb.y + Math.max(1.0, (p.x - this.sb.x) * this.aspectRatio);
                }
            }
            this.setBounds(new Point2D.Double(this.sb.x, this.sb.y), new Point2D.Double(nx, ny));
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            if (!this.getOwner().isTransformable()) {
                evt.consume();
                return;
            }
            Rectangle2D.Double r = this.getOwner().getBounds();
            switch (evt.getKeyCode()) {
                case 38: {
                    if (r.height > 1.0) {
                        this.setBounds(new Point2D.Double(r.x, r.y), new Point2D.Double(r.x + r.width, r.y + r.height - 1.0));
                    }
                    evt.consume();
                    break;
                }
                case 40: {
                    this.setBounds(new Point2D.Double(r.x, r.y), new Point2D.Double(r.x + r.width, r.y + r.height + 1.0));
                    evt.consume();
                    break;
                }
                case 37: {
                    if (r.width > 1.0) {
                        this.setBounds(new Point2D.Double(r.x, r.y), new Point2D.Double(r.x + r.width - 1.0, r.y + r.height));
                    }
                    evt.consume();
                    break;
                }
                case 39: {
                    this.setBounds(new Point2D.Double(r.x, r.y), new Point2D.Double(r.x + r.width + 1.0, r.y + r.height));
                    evt.consume();
                }
            }
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(this.getOwner().isTransformable() ? 5 : 0);
        }
    }

    private static class NorthWestHandle
    extends ResizeHandle {
        NorthWestHandle(Figure owner) {
            super(owner, RelativeLocator.northWest(true));
        }

        @Override
        protected void trackStepNormalized(Point2D.Double p, boolean keepAspect) {
            double nx = Math.min(this.sb.x + this.sb.width - 1.0, p.x);
            double ny = Math.min(this.sb.y + this.sb.height - 1.0, p.y);
            if (keepAspect) {
                double nxx = this.sb.x - Math.max(1.0, (this.sb.y - p.y) / this.aspectRatio);
                if (nxx <= p.x) {
                    nx = nxx;
                } else {
                    ny = this.sb.y - Math.max(1.0, (this.sb.x - p.x) * this.aspectRatio);
                }
            }
            this.setBounds(new Point2D.Double(nx, ny), new Point2D.Double(this.sb.x + this.sb.width, this.sb.y + this.sb.height));
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            if (!this.getOwner().isTransformable()) {
                evt.consume();
                return;
            }
            Rectangle2D.Double r = this.getOwner().getBounds();
            switch (evt.getKeyCode()) {
                case 38: {
                    this.setBounds(new Point2D.Double(r.x, r.y - 1.0), new Point2D.Double(r.x + r.width, r.y + r.height));
                    evt.consume();
                    break;
                }
                case 40: {
                    if (r.height > 1.0) {
                        this.setBounds(new Point2D.Double(r.x, r.y + 1.0), new Point2D.Double(r.x + r.width, r.y + r.height));
                    }
                    evt.consume();
                    break;
                }
                case 37: {
                    this.setBounds(new Point2D.Double(r.x - 1.0, r.y), new Point2D.Double(r.x + r.width, r.y + r.height));
                    evt.consume();
                    break;
                }
                case 39: {
                    if (r.width > 1.0) {
                        this.setBounds(new Point2D.Double(r.x + 1.0, r.y), new Point2D.Double(r.x + r.width, r.y + r.height));
                    }
                    evt.consume();
                }
            }
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(this.getOwner().isTransformable() ? 6 : 0);
        }
    }

    private static class NorthHandle
    extends ResizeHandle {
        NorthHandle(Figure owner) {
            super(owner, RelativeLocator.north(true));
        }

        @Override
        protected void trackStepNormalized(Point2D.Double p, boolean keepAspect) {
            this.setBounds(new Point2D.Double(this.sb.x, Math.min(this.sb.y + this.sb.height - 1.0, p.y)), new Point2D.Double(this.sb.x + this.sb.width, this.sb.y + this.sb.height));
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            if (!this.getOwner().isTransformable()) {
                evt.consume();
                return;
            }
            Rectangle2D.Double r = this.getOwner().getBounds();
            switch (evt.getKeyCode()) {
                case 38: {
                    this.setBounds(new Point2D.Double(r.x, r.y - 1.0), new Point2D.Double(r.x + r.width, r.y + r.height));
                    evt.consume();
                    break;
                }
                case 40: {
                    if (r.height > 1.0) {
                        this.setBounds(new Point2D.Double(r.x, r.y + 1.0), new Point2D.Double(r.x + r.width, r.y + r.height));
                    }
                    evt.consume();
                    break;
                }
                case 37: 
                case 39: {
                    evt.consume();
                }
            }
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(this.getOwner().isTransformable() ? 8 : 0);
        }
    }

    private static class EastHandle
    extends ResizeHandle {
        EastHandle(Figure owner) {
            super(owner, RelativeLocator.east(true));
        }

        @Override
        protected void trackStepNormalized(Point2D.Double p, boolean keepAspect) {
            this.setBounds(new Point2D.Double(this.sb.x, this.sb.y), new Point2D.Double(Math.max(this.sb.x + 1.0, p.x), this.sb.y + this.sb.height));
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            if (!this.getOwner().isTransformable()) {
                evt.consume();
                return;
            }
            Rectangle2D.Double r = this.getOwner().getBounds();
            switch (evt.getKeyCode()) {
                case 38: 
                case 40: {
                    evt.consume();
                    break;
                }
                case 37: {
                    if (r.width > 1.0) {
                        this.setBounds(new Point2D.Double(r.x, r.y), new Point2D.Double(r.x + r.width - 1.0, r.y + r.height));
                    }
                    evt.consume();
                    break;
                }
                case 39: {
                    this.setBounds(new Point2D.Double(r.x, r.y), new Point2D.Double(r.x + r.width + 1.0, r.y + r.height));
                    evt.consume();
                }
            }
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(this.getOwner().isTransformable() ? 11 : 0);
        }
    }

    private static class NorthEastHandle
    extends ResizeHandle {
        NorthEastHandle(Figure owner) {
            super(owner, RelativeLocator.northEast(true));
        }

        @Override
        protected void trackStepNormalized(Point2D.Double p, boolean keepAspect) {
            double nx = Math.max(this.sb.x + 1.0, p.x);
            double ny = Math.min(this.sb.y + this.sb.height - 1.0, p.y);
            if (keepAspect) {
                double nxx = this.sb.x + this.sb.width - 1.0 + Math.max(1.0, (this.sb.y - p.y) / this.aspectRatio);
                if (nxx >= p.x) {
                    nx = nxx;
                } else {
                    ny = this.sb.y + this.sb.height - Math.max(1.0, (p.x - this.sb.x) * this.aspectRatio);
                }
            }
            this.setBounds(new Point2D.Double(this.sb.x, ny), new Point2D.Double(nx, this.sb.y + this.sb.height));
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            if (!this.getOwner().isTransformable()) {
                evt.consume();
                return;
            }
            Rectangle2D.Double r = this.getOwner().getBounds();
            switch (evt.getKeyCode()) {
                case 38: {
                    this.setBounds(new Point2D.Double(r.x, r.y - 1.0), new Point2D.Double(r.x + r.width, r.y + r.height));
                    evt.consume();
                    break;
                }
                case 40: {
                    if (r.height > 1.0) {
                        this.setBounds(new Point2D.Double(r.x, r.y + 1.0), new Point2D.Double(r.x + r.width, r.y + r.height));
                    }
                    evt.consume();
                    break;
                }
                case 37: {
                    if (r.width > 1.0) {
                        this.setBounds(new Point2D.Double(r.x, r.y), new Point2D.Double(r.x + r.width - 1.0, r.y + r.height));
                    }
                    evt.consume();
                    break;
                }
                case 39: {
                    this.setBounds(new Point2D.Double(r.x, r.y), new Point2D.Double(r.x + r.width + 1.0, r.y + r.height));
                    evt.consume();
                }
            }
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(this.getOwner().isTransformable() ? 7 : 0);
        }
    }

    private static class ResizeHandle
    extends LocatorHandle {
        private int sx;
        private int sy;
        private Object geometry;
        protected Rectangle2D.Double sb;
        double aspectRatio;
        private boolean isTransformableCache;

        ResizeHandle(Figure owner, Locator loc) {
            super(owner, loc);
        }

        @Override
        public String getToolTipText(Point p) {
            ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
            return labels.getString("handle.resize.toolTipText");
        }

        @Override
        public void draw(Graphics2D g) {
            if (this.getEditor().getTool().supportsHandleInteraction()) {
                if (this.getOwner().isTransformable()) {
                    this.drawRectangle(g, this.getEditor().getHandleAttribute(HandleAttributeKeys.RESIZE_HANDLE_FILL_COLOR), this.getEditor().getHandleAttribute(HandleAttributeKeys.RESIZE_HANDLE_STROKE_COLOR));
                } else {
                    this.drawRectangle(g, this.getEditor().getHandleAttribute(HandleAttributeKeys.NULL_HANDLE_FILL_COLOR), this.getEditor().getHandleAttribute(HandleAttributeKeys.NULL_HANDLE_STROKE_COLOR));
                }
            } else {
                this.drawRectangle(g, this.getEditor().getHandleAttribute(HandleAttributeKeys.HANDLE_FILL_COLOR_DISABLED), this.getEditor().getHandleAttribute(HandleAttributeKeys.HANDLE_STROKE_COLOR_DISABLED));
            }
        }

        @Override
        public void trackStart(Point anchor, int modifiersEx) {
            this.isTransformableCache = this.getOwner().isTransformable();
            if (!this.isTransformableCache) {
                return;
            }
            this.geometry = this.getOwner().getTransformRestoreData();
            Point location = this.getLocation();
            this.sx = -anchor.x + location.x;
            this.sy = -anchor.y + location.y;
            this.sb = this.getOwner().getBounds();
            this.aspectRatio = this.sb.height / this.sb.width;
        }

        @Override
        public void trackStep(Point anchor, Point lead, int modifiersEx) {
            if (!this.isTransformableCache) {
                return;
            }
            Point2D.Double p = this.view.viewToDrawing(new Point(lead.x + this.sx, lead.y + this.sy));
            this.view.getConstrainer().constrainPoint(p);
            if (this.getOwner().get(AttributeKeys.TRANSFORM) != null) {
                try {
                    this.getOwner().get(AttributeKeys.TRANSFORM).inverseTransform(p, p);
                }
                catch (NoninvertibleTransformException ex) {
                    // empty catch block
                }
            }
            this.trackStepNormalized(p, (modifiersEx & 0x2C0) != 0);
        }

        @Override
        public void trackEnd(Point anchor, Point lead, int modifiersEx) {
            if (!this.isTransformableCache) {
                return;
            }
            this.fireUndoableEditHappened(new TransformRestoreEdit(this.getOwner(), this.geometry, this.getOwner().getTransformRestoreData()));
        }

        protected void trackStepNormalized(Point2D.Double p, boolean keepAspect) {
        }

        protected void setBounds(Point2D.Double anchor, Point2D.Double lead) {
            Figure f = this.getOwner();
            f.willChange();
            f.setBounds(anchor, lead);
            f.changed();
        }
    }
}

