/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.color;

import java.awt.Point;
import java.awt.color.ColorSpace;
import org.jhotdraw.color.AbstractColorWheelImageProducer;
import org.jhotdraw.color.ColorUtil;

public class ComplexColorWheelImageProducer
extends AbstractColorWheelImageProducer {
    protected float[] angulars;
    protected float[] radials;
    protected int[] alphas;
    private boolean flipX;
    private boolean flipY;

    public ComplexColorWheelImageProducer(ColorSpace sys, int w, int h) {
        this(sys, w, h, false, false);
    }

    public ComplexColorWheelImageProducer(ColorSpace sys, int w, int h, boolean flipX, boolean flipY) {
        super(sys, w, h);
        this.flipX = flipX;
        this.flipY = flipY;
    }

    protected void generateLookupTables1() {
        float extentX;
        this.radials = new float[this.w * this.h];
        this.angulars = new float[this.w * this.h];
        this.alphas = new int[this.w * this.h];
        float maxR = this.colorSpace.getMaxValue(this.radialIndex);
        float minR = this.colorSpace.getMinValue(this.radialIndex);
        float extentR = maxR - minR;
        float maxA = this.colorSpace.getMaxValue(this.angularIndex);
        float minA = this.colorSpace.getMinValue(this.angularIndex);
        float extentA = maxA - minA;
        int side = Math.min(this.w - 1, this.h - 1);
        int xOffset = (this.w - side) / 2;
        int yOffset = (this.h - side) / 2 * this.w;
        float extentY = extentX = (float)(side - 1);
        for (int x = 0; x < side; ++x) {
            float xRatio = this.flipX ? 1.0f - (float)x / extentX : (float)x / extentX;
            for (int y = 0; y < side; ++y) {
                float yRatio = this.flipY ? 1.0f - (float)y / extentY : (float)y / extentY;
                int index = x + y * this.w + xOffset + yOffset;
                this.alphas[index] = -16777216;
                this.radials[index] = xRatio * extentR + minR;
                this.angulars[index] = yRatio * extentA + minA;
            }
        }
        this.isLookupValid = true;
    }

    protected void generateLookupTables() {
        float extentX;
        this.radials = new float[this.w * this.h];
        this.angulars = new float[this.w * this.h];
        this.alphas = new int[this.w * this.h];
        float radius = this.getRadius();
        float blend = (radius + 2.0f) / radius - 1.0f;
        float maxR = this.colorSpace.getMaxValue(this.radialIndex);
        float minR = this.colorSpace.getMinValue(this.radialIndex);
        float extentR = maxR - minR;
        float maxA = this.colorSpace.getMaxValue(this.angularIndex);
        float minA = this.colorSpace.getMinValue(this.angularIndex);
        float extentA = maxA - minA;
        int side = Math.min(this.w, this.h);
        int cx = side / 2;
        int cy = side / 2;
        int xOffset = (this.w - side) / 2;
        int yOffset = (this.h - side) / 2 * this.w;
        float extentY = extentX = (float)(side - 1);
        for (int x = 0; x < side; ++x) {
            float kx = (float)(x - cx) / radius;
            float squarekx = kx * kx;
            for (int y = 0; y < side; ++y) {
                float ky = (float)(cy - y) / radius;
                int index = x + y * this.w + xOffset + yOffset;
                float radiusRatio = (float)Math.sqrt(squarekx + ky * ky);
                this.alphas[index] = radiusRatio <= 1.0f ? -16777216 : (int)((blend - Math.min(blend, radiusRatio - 1.0f)) * 255.0f / blend) << 24;
                if (this.alphas[index] != 0) {
                    // empty if block
                }
                float angle = (float)Math.atan2(ky, kx);
                float scale = (float)Math.max(Math.abs(Math.sin(angle)), Math.abs(Math.cos(angle))) + 0.1f;
                this.radials[index] = (kx / scale + 1.0f) / 2.0f * extentR + minR;
                this.angulars[index] = (ky / scale + 1.0f) / 2.0f * extentA + minA;
            }
        }
        this.isLookupValid = true;
    }

    @Override
    public boolean needsGeneration() {
        return !this.isPixelsValid;
    }

    @Override
    public void regenerateColorWheel() {
        if (!this.isPixelsValid) {
            this.generateColorWheel();
        }
    }

    @Override
    public void generateColorWheel() {
        if (!this.isLookupValid) {
            this.generateLookupTables();
        }
        float[] components = new float[this.colorSpace.getNumComponents()];
        for (int index = 0; index < this.pixels.length; ++index) {
            if (this.alphas[index] == 0) continue;
            components[this.angularIndex] = this.angulars[index];
            components[this.radialIndex] = this.radials[index];
            components[this.verticalIndex] = this.verticalValue;
            this.pixels[index] = this.alphas[index] | 0xFFFFFF & ColorUtil.toRGB(this.colorSpace, components);
        }
        this.newPixels();
        this.isPixelsValid = true;
    }

    @Override
    public Point getColorLocation(float[] components) {
        float radial = (components[this.radialIndex] - this.colorSpace.getMinValue(this.radialIndex)) / (this.colorSpace.getMaxValue(this.radialIndex) - this.colorSpace.getMinValue(this.radialIndex));
        float angular = (components[this.angularIndex] - this.colorSpace.getMinValue(this.angularIndex)) / (this.colorSpace.getMaxValue(this.angularIndex) - this.colorSpace.getMinValue(this.angularIndex));
        if (this.flipX) {
            radial = 1.0f - radial;
        }
        if (!this.flipY) {
            angular = 1.0f - angular;
        }
        float angle = (float)Math.atan2(radial - 0.5f, angular - 0.5f);
        float scale = (float)Math.max(Math.abs(Math.sin(angle)), Math.abs(Math.cos(angle))) + 0.01f;
        int side = Math.min(this.w - 1, this.h - 1);
        Point p = new Point((int)((float)side * (radial - 0.5f) * scale) + this.w / 2, (int)((float)side * (angular - 0.5f) * scale) + this.h / 2);
        return p;
    }

    @Override
    public float[] getColorAt(int x, int y) {
        int side = Math.min(this.w - 1, this.h - 1);
        int xOffset = (this.w - side) / 2;
        int yOffset = (this.h - side) / 2;
        float radial = (float)(x - xOffset) / (float)side;
        float angular = (float)(y - yOffset) / (float)side;
        if (this.flipX) {
            radial = 1.0f - radial;
        }
        if (!this.flipY) {
            angular = 1.0f - angular;
        }
        float[] hsb = new float[3];
        hsb[this.angularIndex] = angular * (this.colorSpace.getMaxValue(this.angularIndex) - this.colorSpace.getMinValue(this.angularIndex)) + this.colorSpace.getMinValue(this.angularIndex);
        hsb[this.radialIndex] = radial * (this.colorSpace.getMaxValue(this.radialIndex) - this.colorSpace.getMinValue(this.radialIndex)) + this.colorSpace.getMinValue(this.radialIndex);
        hsb[this.verticalIndex] = this.verticalValue;
        return hsb;
    }
}

