/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.updater.util;

import net.imagej.updater.util.Progress;

public class StderrProgress
implements Progress {
    protected static final boolean redirected = System.console() == null;
    protected static final String end = redirected ? "\n" : "\u001b[K\r";
    protected String label;
    protected Object item;
    protected long lastShown;
    protected long minShowDelay = 500L;
    protected int lineWidth = -1;
    protected int dotCounter = 0;
    private boolean skipProgress;

    public StderrProgress() {
    }

    public StderrProgress(int lineWidth) {
        this.lineWidth = lineWidth;
    }

    protected void print(String label, String rest) {
        if (this.lineWidth < 0) {
            System.err.print(label + " " + rest + end);
        } else {
            int diff;
            label = label.length() >= this.lineWidth - 3 ? label.substring(0, this.lineWidth - 3) + "..." : ((diff = label.length() + 1 + rest.length() - this.lineWidth) < 0 ? label + " " + rest : label + (" " + rest).substring(0, rest.length() - diff - 3) + "...");
            System.err.print(label + end);
        }
    }

    protected boolean skipShow() {
        long now = System.currentTimeMillis();
        if (now - this.lastShown < this.minShowDelay) {
            return true;
        }
        this.lastShown = now;
        return false;
    }

    @Override
    public void setTitle(String title) {
        this.label = title;
        this.skipProgress = redirected && "Checksummer".equals(title);
    }

    @Override
    public void setCount(int count, int total) {
        if (this.skipProgress || this.skipShow()) {
            return;
        }
        this.print(this.label, "" + count + "/" + total);
    }

    @Override
    public void addItem(Object item) {
        this.item = item;
        if (this.skipProgress || this.skipShow()) {
            return;
        }
        this.print(this.label, "(" + item + ") ");
    }

    @Override
    public void setItemCount(int count, int total) {
        if (this.skipProgress || redirected || this.skipShow()) {
            return;
        }
        this.print(this.label, "(" + this.item + ") [" + count + "/" + total + "]");
    }

    @Override
    public void itemDone(Object item) {
        if (this.skipProgress) {
            if (++this.dotCounter % 80 == 1 && this.dotCounter > 1) {
                System.err.print("\n");
            }
            System.err.print(".");
        } else {
            this.print(item.toString(), "done");
        }
    }

    @Override
    public void done() {
        if (this.skipProgress) {
            System.err.print("\n");
        }
        this.print("Done:", this.label);
        System.err.println("");
    }
}

