/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.updater;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.imagej.updater.util.ByteCodeAnalyzer;
import net.imagej.updater.util.UpdaterUtil;
import org.scijava.util.FileUtils;
import org.scijava.util.IteratorPlus;
import org.scijava.util.ProcessUtils;

public class Diff {
    private final PrintStream out;
    private final UpdaterUtil util;

    @Deprecated
    public Diff(PrintStream out) {
        this(out, null);
    }

    public Diff(PrintStream out, UpdaterUtil util) {
        this.out = out;
        this.util = util != null ? util : new UpdaterUtil(null);
    }

    public void showDiff(String name, URL remote, URL local, Mode mode) throws IOException, MalformedURLException {
        block38: {
            float localVersion;
            float remoteVersion;
            File remoteFile = this.cacheFile(remote, false);
            File localFile = this.cacheFile(local, false);
            if (local.getFile().endsWith(".jar")) {
                this.out.println("\n" + remote.getFile());
                JarFile remoteJar = new JarFile(remoteFile);
                JarFile localJar = new JarFile(localFile);
                List<JarEntry> remoteEntries = Diff.getSortedEntries(remoteJar);
                List<JarEntry> localEntries = Diff.getSortedEntries(localJar);
                int remoteIndex = 0;
                int localIndex = 0;
                while (true) {
                    if (remoteIndex >= remoteEntries.size()) {
                        if (localIndex >= localEntries.size()) break;
                        this.out.println("Local entry: " + localEntries.get(localIndex++).getName());
                        continue;
                    }
                    if (localIndex >= localEntries.size()) {
                        this.out.println("Remote entry: " + remoteEntries.get(remoteIndex++).getName());
                        continue;
                    }
                    JarEntry remoteEntry = remoteEntries.get(remoteIndex);
                    JarEntry localEntry = localEntries.get(localIndex);
                    int nameDiff = remoteEntry.getName().compareTo(localEntry.getName());
                    if (nameDiff < 0) {
                        this.out.println("Remote entry: " + remoteEntry.getName());
                        ++remoteIndex;
                        continue;
                    }
                    if (nameDiff > 0) {
                        this.out.println("Local entry: " + localEntry.getName());
                        ++localIndex;
                        continue;
                    }
                    if (remoteEntry.getCrc() != localEntry.getCrc() || remoteEntry.getSize() != localEntry.getSize()) {
                        if (mode == Mode.LIST_FILES) {
                            this.out.println("Entry " + remoteEntry.getName() + " is different from local one");
                        } else if (localEntry.getName().endsWith(".class") && (mode == Mode.JAVAP || mode == Mode.CLASS_FILE_DIFF)) {
                            File local2;
                            File remote2;
                            String className = remoteEntry.getName();
                            className = className.substring(0, className.length() - 6).replace('/', '.').replace('$', '.');
                            if (mode == Mode.CLASS_FILE_DIFF) {
                                remote2 = File.createTempFile("class-", "");
                                Diff.analyzeByteCode(remoteJar.getInputStream(remoteEntry), remote2);
                                local2 = File.createTempFile("class-", "");
                                Diff.analyzeByteCode(localJar.getInputStream(localEntry), local2);
                            } else {
                                remote2 = this.javap(remoteFile, className);
                                local2 = this.javap(localFile, className);
                            }
                            if (Diff.offsetOfFirstDiff(remote2, local2) >= 0L) {
                                this.out.println("Entry " + remoteEntry.getName() + " is different from local one");
                                this.showDiff(className, remote2.toURI().toURL(), local2.toURI().toURL(), mode);
                            }
                        } else {
                            this.showDiff(remoteEntry.getName(), new URL("jar:file:" + remoteFile.getAbsolutePath() + "!/" + remoteEntry.getName()), new URL("jar:file:" + localFile.getAbsolutePath() + "!/" + localEntry.getName()), mode);
                        }
                    }
                    ++remoteIndex;
                    ++localIndex;
                }
                localJar.close();
                remoteJar.close();
                return;
            }
            boolean isClass = local.getFile().endsWith(".class");
            if (isClass && (remoteVersion = Diff.getClassVersion(remoteFile)) != (localVersion = Diff.getClassVersion(localFile))) {
                this.out.println("class versions differ! remote: " + remoteVersion + ", local: " + localVersion);
            }
            if (mode == Mode.LIST_FILES) {
                if (remoteFile.length() != localFile.length()) {
                    this.out.println("Size differs: " + remote.getPath() + " (remote: " + remoteFile.length() + ", local: " + localFile.length());
                    return;
                }
                try {
                    long compare = Diff.offsetOfFirstDiff(remoteFile, localFile);
                    if (compare >= 0L) {
                        this.out.println("Offset of first difference in " + remote.getPath() + ": " + compare);
                    }
                }
                catch (IOException e) {
                    this.out.println("IOException while comparing " + remote.getPath() + " to local version");
                }
                return;
            }
            if (Diff.isLocal(remote)) {
                remoteFile = this.cacheFile(remote, true);
            }
            if (Diff.isLocal(local)) {
                localFile = this.cacheFile(local, true);
            }
            if (mode == Mode.HEX_DIFF) {
                try {
                    this.hexdump(remoteFile, remoteFile);
                }
                catch (Exception e) {
                    this.out.println("Could not make a hexdump of " + remote);
                }
                try {
                    this.hexdump(localFile, localFile);
                }
                catch (Exception e) {
                    this.out.println("Could not make a hexdump of " + local);
                }
            } else if (isClass) {
                if (mode == Mode.CLASS_FILE_DIFF) {
                    try {
                        Diff.analyzeByteCode((InputStream)new FileInputStream(remoteFile), remoteFile);
                    }
                    catch (Exception e) {
                        this.out.println("Could not analyze bytecode of " + remote);
                    }
                    try {
                        Diff.analyzeByteCode((InputStream)new FileInputStream(localFile), localFile);
                    }
                    catch (Exception e) {
                        this.out.println("Could not analyze bytecode of " + local);
                    }
                } else {
                    this.javap(remoteFile);
                    this.javap(localFile);
                }
            }
            try {
                boolean color = false;
                ProcessUtils.exec(null, (PrintStream)this.out, (PrintStream)this.out, (String[])new String[]{"git", "diff", "--color=" + (color ? "always" : "auto"), "--no-index", "--src-prefix=remote/" + name + "/", "--dst-prefix=local/" + name + "/", remoteFile.getAbsolutePath(), localFile.getAbsolutePath()});
            }
            catch (RuntimeException e) {
                if (e.getCause() != null && e.getCause() instanceof InterruptedException) {
                    throw e;
                }
                if (e.getMessage().startsWith("exit status 1")) break block38;
                e.printStackTrace(this.out);
            }
        }
    }

    protected static List<JarEntry> getSortedEntries(JarFile jar) {
        ArrayList<JarEntry> result = new ArrayList<JarEntry>();
        for (JarEntry entry : new IteratorPlus(jar.entries())) {
            result.add(entry);
        }
        Collections.sort(result, new Comparator<JarEntry>(){

            @Override
            public int compare(JarEntry a, JarEntry b) {
                return a.getName().compareTo(b.getName());
            }
        });
        return result;
    }

    protected void hexdump(File inputFile, File outputFile) throws FileNotFoundException, IOException {
        String result = ProcessUtils.exec(null, (PrintStream)this.out, null, (String[])new String[]{"hexdump", "-C", inputFile.getAbsolutePath()});
        Diff.copy(new ByteArrayInputStream(result.getBytes()), new FileOutputStream(outputFile), true, true);
    }

    protected static void analyzeByteCode(InputStream in, File outputFile) throws FileNotFoundException, IOException {
        ByteCodeAnalyzer analyzer = Diff.analyzeByteCode(in, true);
        ByteArrayInputStream inStream = new ByteArrayInputStream(analyzer.toString().getBytes());
        Diff.copy(inStream, new FileOutputStream(outputFile), true, true);
    }

    public static ByteCodeAnalyzer analyzeByteCode(InputStream in, boolean closeStream) throws IOException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        Diff.copy(in, outStream, closeStream, true);
        return new ByteCodeAnalyzer(outStream.toByteArray(), ByteCodeAnalyzer.Mode.ALL);
    }

    protected File javap(File jarFile, String className) throws IOException {
        File file = File.createTempFile("javap-", "");
        try {
            String result = ProcessUtils.exec(null, (PrintStream)this.out, null, (String[])new String[]{"javap", "-classpath", jarFile.getAbsolutePath(), "-c", className});
            Diff.copy(new ByteArrayInputStream(result.getBytes()), new FileOutputStream(file), true, true);
        }
        catch (RuntimeException e) {
            if (e.getCause() != null && e.getCause() instanceof InterruptedException) {
                throw e;
            }
            e.printStackTrace();
            this.out.println("class " + className + " misses dependencies");
        }
        return file;
    }

    protected void javap(File file) throws IOException {
        byte[] buffer = UpdaterUtil.readStreamAsBytes(new FileInputStream(file));
        ByteCodeAnalyzer analyzer = new ByteCodeAnalyzer(buffer, ByteCodeAnalyzer.Mode.CONSTANTS);
        String path = analyzer.getPathForClass();
        file.delete();
        File classFile = new File(file, path);
        classFile.getParentFile().mkdirs();
        Diff.copy(new ByteArrayInputStream(buffer), new FileOutputStream(classFile), true, true);
        String result = ProcessUtils.exec(null, (PrintStream)this.out, null, (String[])new String[]{"javap", "-classpath", file.getAbsolutePath(), "-c", path.replace('/', '.')});
        while (!classFile.equals(file)) {
            classFile.delete();
            classFile = classFile.getParentFile();
        }
        Diff.copy(new ByteArrayInputStream(result.getBytes()), new FileOutputStream(file), true, true);
    }

    protected static float getClassVersion(File file) throws IOException {
        return Diff.getClassVersion(new FileInputStream(file));
    }

    protected static float getClassVersion(InputStream stream) throws IOException {
        DataInputStream data = new DataInputStream(stream);
        if (data.readInt() != -889275714) {
            throw new IOException("Not a class");
        }
        short minor = data.readShort();
        short major = data.readShort();
        data.close();
        return (float)major + (float)minor / 100000.0f;
    }

    protected File cacheFile(URL url, boolean evenLocal) throws IOException {
        if (!evenLocal && Diff.isLocal(url)) {
            return new File(url.getPath());
        }
        String extension = FileUtils.getExtension((String)url.getFile());
        if (extension.startsWith("jar-")) {
            extension = "jar";
        }
        File result = File.createTempFile("diff-", "".equals(extension) ? "" : "." + extension);
        result.deleteOnExit();
        Diff.copy(this.util.openStream(url), new FileOutputStream(result), true, true);
        return result;
    }

    protected static boolean isLocal(URL url) {
        return url.getProtocol().equals("file");
    }

    protected static long offsetOfFirstDiff(File file1, File file2) throws IOException {
        int b;
        int a;
        BufferedInputStream in1 = new BufferedInputStream(new FileInputStream(file1));
        BufferedInputStream in2 = new BufferedInputStream(new FileInputStream(file2));
        long counter = 0L;
        while ((a = in1.read()) == (b = in2.read())) {
            if (a >= 0) continue;
            counter = -1L;
            break;
        }
        in1.close();
        in2.close();
        return counter;
    }

    protected static void copy(InputStream in, OutputStream out, boolean closeIn, boolean closeOut) throws IOException {
        int count;
        byte[] buffer = new byte[16384];
        while ((count = in.read(buffer)) >= 0) {
            out.write(buffer, 0, count);
        }
        if (closeIn) {
            in.close();
        }
        if (closeOut) {
            out.flush();
        }
        out.close();
    }

    public static enum Mode {
        LIST_FILES,
        JAVAP,
        CLASS_FILE_DIFF,
        HEX_DIFF;


        public String toString() {
            StringBuilder builder = new StringBuilder();
            boolean upperCase = true;
            block3: for (char c : this.name().toCharArray()) {
                switch (c) {
                    case '_': {
                        builder.append(' ');
                        upperCase = true;
                        continue block3;
                    }
                    default: {
                        builder.append(upperCase ? Character.toUpperCase(c) : Character.toLowerCase(c));
                        upperCase = false;
                    }
                }
            }
            return builder.toString();
        }
    }
}

