/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.updater;

import net.imagej.updater.PromptUserToUpdate;
import net.imagej.updater.UpToDate;
import org.scijava.app.StatusService;
import org.scijava.command.Command;
import org.scijava.command.CommandService;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, label="Up-to-date check")
public class CheckForUpdates
implements Command {
    @Parameter
    private CommandService commandService;
    @Parameter(required=false)
    private StatusService statusService;
    @Parameter(required=false)
    private LogService log;

    public void run() {
        block14: {
            try {
                UpToDate.Result result = UpToDate.check();
                switch (result) {
                    case UP_TO_DATE: 
                    case OFFLINE: 
                    case REMIND_LATER: 
                    case CHECK_TURNED_OFF: 
                    case UPDATES_MANAGED_DIFFERENTLY: 
                    case DEVELOPER: {
                        return;
                    }
                    case UPDATEABLE: {
                        this.commandService.run(PromptUserToUpdate.class, true, new Object[0]);
                        break;
                    }
                    case PROXY_NEEDS_AUTHENTICATION: {
                        throw new RuntimeException("TODO: authenticate proxy with the configured user/pass pair");
                    }
                    case PROTECTED_LOCATION: {
                        String protectedMessage = "Your ImageJ installation cannot be updated because it is in a protected location (e.g., \"C:\\Program Files\").\nPlease move your installation to a directory with write permission";
                        if (this.log != null) {
                            this.log.warn((Object)"Your ImageJ installation cannot be updated because it is in a protected location (e.g., \"C:\\Program Files\").\nPlease move your installation to a directory with write permission");
                        }
                        if (this.statusService != null) {
                            this.statusService.showStatus("Your ImageJ installation cannot be updated because it is in a protected location (e.g., \"C:\\Program Files\").\nPlease move your installation to a directory with write permission");
                        }
                        break;
                    }
                    case READ_ONLY: {
                        String message = "Your ImageJ installation cannot be updated because it is read-only";
                        if (this.log != null) {
                            this.log.warn((Object)"Your ImageJ installation cannot be updated because it is read-only");
                        }
                        if (this.statusService != null) {
                            this.statusService.showStatus("Your ImageJ installation cannot be updated because it is read-only");
                        }
                        break;
                    }
                    default: {
                        if (this.log != null) {
                            this.log.error((Object)("Unhandled UpToDate case: " + (Object)((Object)result)));
                        }
                        break;
                    }
                }
            }
            catch (Exception e) {
                if (this.log == null) break block14;
                this.log.error((Throwable)e);
            }
        }
    }
}

