/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beaker.jvm.serialization;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twosigma.beaker.jvm.serialization.BeakerObjectConverter;
import com.twosigma.beaker.jvm.serialization.ObjectDeserializer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapDeserializer
implements ObjectDeserializer {
    private static final Logger logger = LoggerFactory.getLogger((String)MapDeserializer.class.getName());
    private final BeakerObjectConverter parent;

    public MapDeserializer(BeakerObjectConverter p) {
        this.parent = p;
    }

    @Override
    public boolean canBeUsed(JsonNode n) {
        return n.isObject() && (!n.has("type") || !this.parent.isKnownBeakerType(n.get("type").asText()));
    }

    @Override
    public Object deserialize(JsonNode n, ObjectMapper mapper) {
        HashMap o = new HashMap();
        try {
            logger.debug("using custom map deserializer");
            Iterator e = n.fields();
            while (e.hasNext()) {
                Map.Entry ee = (Map.Entry)e.next();
                o.put(ee.getKey(), this.parent.deserialize((JsonNode)ee.getValue(), mapper));
            }
        }
        catch (Exception e) {
            logger.error("exception deserializing Map ", (Throwable)e);
            o = null;
        }
        return o;
    }
}

