/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beaker.jupyter.comm;

import com.twosigma.beaker.jupyter.comm.BaseHandler;
import com.twosigma.jupyter.Kernel;
import com.twosigma.jupyter.KernelFunctionality;
import com.twosigma.jupyter.message.Message;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KernelControlInterrupt
extends BaseHandler<Boolean> {
    public static final String KERNEL_INTERRUPT = "kernel_interrupt";
    public static final String KERNEL_CONTROL_RESPONSE = "kernel_control_response";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    private static final Logger logger = LoggerFactory.getLogger(KernelControlInterrupt.class);

    public KernelControlInterrupt(KernelFunctionality kernel) {
        super(kernel);
    }

    @Override
    public void handle(Message message) {
        logger.debug("Handing comm message content");
        Boolean value = (Boolean)this.getValueFromData(message, this.getHandlerCommand());
        if (value != null && value.booleanValue()) {
            boolean ok = Kernel.isWindows();
            if (ok) {
                this.kernel.cancelExecution();
            } else {
                logger.debug("Cell execution interrupt not performed, done by SIGINT");
            }
            HashMap data = new HashMap();
            HashMap<String, String> body = new HashMap<String, String>();
            body.put(KERNEL_INTERRUPT, ok ? TRUE : FALSE);
            data.put(KERNEL_CONTROL_RESPONSE, body);
            logger.info("Response " + ok);
            this.publish(this.createReplyMessage(message, data));
        }
    }

    @Override
    public String getHandlerCommand() {
        return KERNEL_INTERRUPT;
    }
}

