/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beaker;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.twosigma.beaker.jvm.serialization.BeakerObjectConverter;
import com.twosigma.beaker.jvm.serialization.ObjectDeserializer;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeakerCodeCell {
    private static final Logger logger = LoggerFactory.getLogger((String)BeakerCodeCell.class.getName());
    @JsonProperty(value="execution_count")
    private String executionCount;
    @JsonProperty(value="cell_type")
    private String cellType;
    private Object outputs;
    private Object metadata;
    private String source;

    public String getExecutionCount() {
        return this.executionCount;
    }

    public void setExecutionCount(String executionCount) {
        this.executionCount = executionCount;
    }

    public String getCellType() {
        return this.cellType;
    }

    public void setCellType(String cellType) {
        this.cellType = cellType;
    }

    public Object getOutputs() {
        return this.outputs;
    }

    public void setOutputs(Object outputs) {
        this.outputs = outputs;
    }

    public Object getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Object metadata) {
        this.metadata = metadata;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public static class DeSerializer
    implements ObjectDeserializer {
        private final BeakerObjectConverter parent;

        public DeSerializer(BeakerObjectConverter p) {
            this.parent = p;
            this.parent.addKnownBeakerType("BeakerCodeCell");
        }

        @Override
        public Object deserialize(JsonNode n, ObjectMapper mapper) {
            BeakerCodeCell o = null;
            try {
                String executionCount = null;
                String cellType = null;
                String source = null;
                Object outputs = null;
                Object metadata = null;
                System.out.println(n);
                if (n.has("execution_count")) {
                    executionCount = n.get("execution_count").asText();
                }
                if (n.has("cell_type")) {
                    cellType = n.get("cell_type").asText();
                }
                if (n.has("source")) {
                    source = n.get("source").asText();
                }
                if (n.has("outputs")) {
                    outputs = this.parent.deserialize(n.get("outputs"), mapper);
                }
                if (n.has("metadata")) {
                    metadata = this.parent.deserialize(n.get("metadata"), mapper);
                }
                o = new BeakerCodeCell();
                o.setExecutionCount(executionCount);
                o.setCellType(cellType);
                o.setSource(source);
                o.setOutputs(outputs);
                o.setMetadata(metadata);
            }
            catch (Exception e) {
                logger.error("exception deserializing BeakerCodeCell ", (Throwable)e);
                e.printStackTrace();
            }
            return o;
        }

        @Override
        public boolean canBeUsed(JsonNode n) {
            return n.has("type") && n.get("type").asText().equals("BeakerCodeCell");
        }
    }

    public static class Serializer
    extends JsonSerializer<BeakerCodeCell> {
        private final Provider<BeakerObjectConverter> objectSerializerProvider;

        @Inject
        public Serializer(Provider<BeakerObjectConverter> osp) {
            this.objectSerializerProvider = osp;
        }

        private BeakerObjectConverter getObjectSerializer() {
            return (BeakerObjectConverter)this.objectSerializerProvider.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serialize(BeakerCodeCell value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            BeakerCodeCell beakerCodeCell = value;
            synchronized (beakerCodeCell) {
                jgen.writeStartObject();
                jgen.writeStringField("type", "BeakerCodeCell");
                jgen.writeStringField("execution_count", value.executionCount);
                jgen.writeStringField("cell_type", value.cellType);
                jgen.writeFieldName("outputs");
                if (!this.getObjectSerializer().writeObject(value.outputs, jgen, true)) {
                    jgen.writeString(value.outputs.toString());
                }
                jgen.writeFieldName("metadata");
                if (!this.getObjectSerializer().writeObject(value.metadata, jgen, true)) {
                    jgen.writeString(value.metadata.toString());
                }
                jgen.writeStringField("source", value.source);
                jgen.writeEndObject();
            }
        }
    }
}

