/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.transform.crop;

import net.imagej.ops.Ops;
import net.imagej.ops.special.function.AbstractBinaryFunctionOp;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.util.Intervals;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Transform.Crop.class, priority=-100.0)
public class CropRAI<T>
extends AbstractBinaryFunctionOp<RandomAccessibleInterval<T>, Interval, RandomAccessibleInterval<T>>
implements Ops.Transform.Crop {
    @Parameter(required=false)
    private boolean dropSingleDimensions = true;

    @Override
    public RandomAccessibleInterval<T> calculate(RandomAccessibleInterval<T> input, Interval interval) {
        boolean oneSizedDims = false;
        if (this.dropSingleDimensions) {
            for (int d = 0; d < interval.numDimensions(); ++d) {
                if (interval.dimension(d) != 1L) continue;
                oneSizedDims = true;
                break;
            }
        }
        if (Intervals.equals(input, (Interval)interval) && !oneSizedDims) {
            return input;
        }
        if (!Intervals.contains(input, (Interval)interval)) {
            throw new RuntimeException("Intervals don't match!");
        }
        IntervalView res = Views.offsetInterval(input, (Interval)interval);
        return oneSizedDims ? Views.dropSingletonDimensions((RandomAccessibleInterval)res) : res;
    }
}

