/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.slice;

import java.util.Iterator;
import net.imglib2.AbstractInterval;
import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.FinalInterval;
import net.imglib2.FlatIterationOrder;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.Sampler;
import net.imglib2.iterator.IntervalIterator;
import net.imglib2.util.Intervals;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;

public class SlicesII<T>
extends AbstractInterval
implements IterableInterval<RandomAccessibleInterval<T>> {
    private final Interval slice;
    private final RandomAccessibleInterval<T> source;
    private boolean dropSingltonDimensions;

    public SlicesII(RandomAccessibleInterval<T> source, int[] axesOfInterest, boolean dropSingletonDimensions) {
        super(SlicesII.initIntervals(source, axesOfInterest));
        long[] sliceMin = new long[source.numDimensions()];
        long[] sliceMax = new long[source.numDimensions()];
        for (int d = 0; d < source.numDimensions(); ++d) {
            if (this.dimension(d) != 1L) continue;
            sliceMin[d] = source.min(d);
            sliceMax[d] = source.max(d);
        }
        this.dropSingltonDimensions = dropSingletonDimensions;
        this.slice = new FinalInterval(sliceMin, sliceMax);
        this.source = source;
    }

    public SlicesII(RandomAccessibleInterval<T> source, int[] axesOfInterest) {
        this(source, axesOfInterest, true);
    }

    private static Interval initIntervals(Interval src, int[] axesOfInterest) {
        long[] dimensionsToIterate = new long[src.numDimensions()];
        src.dimensions(dimensionsToIterate);
        block0: for (int i = 0; i < src.numDimensions(); ++i) {
            for (int j = 0; j < axesOfInterest.length; ++j) {
                if (axesOfInterest[j] != i) continue;
                dimensionsToIterate[i] = 1L;
                continue block0;
            }
        }
        return new FinalInterval(dimensionsToIterate);
    }

    public Cursor<RandomAccessibleInterval<T>> cursor() {
        return new SlicesIICursor(this.source, (Interval)this, this.slice);
    }

    public Cursor<RandomAccessibleInterval<T>> localizingCursor() {
        return this.cursor();
    }

    public long size() {
        return Intervals.numElements((Dimensions)this);
    }

    public RandomAccessibleInterval<T> firstElement() {
        return (RandomAccessibleInterval)this.cursor().next();
    }

    public Object iterationOrder() {
        return new FlatIterationOrder((Interval)this);
    }

    public Iterator<RandomAccessibleInterval<T>> iterator() {
        return this.cursor();
    }

    private class SlicesIICursor
    extends IntervalIterator
    implements Cursor<RandomAccessibleInterval<T>> {
        private final long[] tmpPosition;
        private final RandomAccessibleInterval<T> src;
        private final long[] sliceDims;
        private final long[] sliceOffset;

        public SlicesIICursor(RandomAccessibleInterval<T> src, Interval fixedAxes, Interval slice) {
            super(fixedAxes);
            this.src = src;
            this.tmpPosition = new long[fixedAxes.numDimensions()];
            this.sliceDims = new long[slice.numDimensions()];
            this.sliceOffset = new long[slice.numDimensions()];
            slice.dimensions(this.sliceDims);
            slice.min(this.sliceOffset);
        }

        private SlicesIICursor(SlicesIICursor cursor) {
            super((Interval)cursor);
            this.src = cursor.src;
            this.sliceDims = cursor.sliceDims;
            this.sliceOffset = cursor.sliceOffset;
            this.tmpPosition = cursor.tmpPosition;
            this.jumpFwd(cursor.index);
        }

        public RandomAccessibleInterval<T> get() {
            this.localize(this.tmpPosition);
            long[] offset = (long[])this.tmpPosition.clone();
            for (int d = 0; d < this.max.length; ++d) {
                int n = d;
                offset[n] = offset[n] + this.sliceOffset[d];
            }
            IntervalView res = Views.offsetInterval(this.src, (long[])offset, (long[])this.sliceDims);
            return SlicesII.this.dropSingltonDimensions ? Views.dropSingletonDimensions((RandomAccessibleInterval)res) : res;
        }

        public Sampler<RandomAccessibleInterval<T>> copy() {
            return this.copyCursor();
        }

        public RandomAccessibleInterval<T> next() {
            this.fwd();
            return this.get();
        }

        public void remove() {
            throw new UnsupportedOperationException("Not supported");
        }

        public Cursor<RandomAccessibleInterval<T>> copyCursor() {
            return new SlicesIICursor(this);
        }
    }
}

