/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.features.haralick;

import net.imagej.ops.Ops;
import net.imagej.ops.features.haralick.AbstractHaralickFeature;
import net.imagej.ops.features.haralick.helper.CoocPXPlusY;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imglib2.IterableInterval;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Haralick.SumVariance.class, label="Haralick: Sum Variance")
public class DefaultSumVariance<T extends RealType<T>>
extends AbstractHaralickFeature<T>
implements Ops.Haralick.SumVariance {
    private UnaryFunctionOp<double[][], double[]> coocPXPlusYFunc;
    private UnaryFunctionOp<IterableInterval<T>, RealType> sumEntropyFunc;

    @Override
    public void initialize() {
        super.initialize();
        this.coocPXPlusYFunc = Functions.unary(this.ops(), CoocPXPlusY.class, double[].class, double[][].class, new Object[0]);
        this.sumEntropyFunc = Functions.unary(this.ops(), Ops.Haralick.SumEntropy.class, RealType.class, this.in(), this.numGreyLevels, this.distance, this.orientation);
    }

    @Override
    public void compute(IterableInterval<T> input, DoubleType output) {
        double[][] matrix = this.getCooccurrenceMatrix(input);
        double[] pxplusy = this.coocPXPlusYFunc.calculate(matrix);
        int nrGrayLevels = matrix.length;
        double sumEntropy = this.sumEntropyFunc.calculate(input).getRealDouble();
        double res = 0.0;
        for (int i = 2; i <= 2 * nrGrayLevels; ++i) {
            res += ((double)i - sumEntropy) * ((double)i - sumEntropy) * pxplusy[i];
        }
        output.set(res);
    }
}

