/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.minimaven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.scijava.minimaven.AbstractPOMHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SnapshotPOMHandler
extends AbstractPOMHandler {
    protected String snapshotVersion;
    protected String timestamp;
    protected String buildNumber;
    private static Pattern versionPattern = Pattern.compile("(.*)-(\\d+\\.\\d+)-(\\d+)");

    @Override
    protected void processCharacters(StringBuilder sb) throws SAXException {
        if (this.qName == null) {
            return;
        }
        if (this.qName.equals("version")) {
            String version = sb.toString().trim();
            if (version.endsWith("-SNAPSHOT")) {
                this.snapshotVersion = version.substring(0, version.length() - "-SNAPSHOT".length());
            } else {
                Matcher matcher = versionPattern.matcher(version);
                if (!matcher.matches()) {
                    throw new SAXException("Unhandled version: " + version);
                }
                this.snapshotVersion = matcher.group(1);
                this.timestamp = matcher.group(2);
                this.buildNumber = matcher.group(3);
            }
        } else if (this.qName.equals("timestamp")) {
            this.timestamp = sb.toString().trim();
        } else if (this.qName.equals("buildNumber")) {
            this.buildNumber = sb.toString().trim();
        }
    }

    public static String parse(File xml) throws IOException, ParserConfigurationException, SAXException {
        try {
            return SnapshotPOMHandler.parse(xml.getAbsolutePath(), new FileInputStream(xml));
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw new IOException("Error parsing " + xml, e);
        }
        catch (SAXException e) {
            throw new SAXException("Error parsing " + xml, e);
        }
    }

    public static String parse(InputStream in) throws IOException, ParserConfigurationException, SAXException {
        return SnapshotPOMHandler.parse(null, in);
    }

    private static String parse(String systemId, InputStream in) throws IOException, ParserConfigurationException, SAXException {
        SnapshotPOMHandler handler = new SnapshotPOMHandler();
        XMLReader reader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
        reader.setContentHandler(handler);
        InputSource source = new InputSource(in);
        if (systemId != null) {
            source.setSystemId(systemId);
        }
        reader.parse(source);
        if (handler.snapshotVersion != null && handler.timestamp != null && handler.buildNumber != null) {
            return handler.snapshotVersion + "-" + handler.timestamp + "-" + handler.buildNumber;
        }
        throw new IOException("Missing timestamp/build number: " + handler.timestamp + ", " + handler.buildNumber);
    }
}

