/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ui.swing.overlay;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.imagej.Data;
import net.imagej.ImageJService;
import net.imagej.display.DataView;
import net.imagej.display.ImageDisplay;
import net.imagej.display.ImageDisplayService;
import net.imagej.display.OverlayView;
import net.imagej.overlay.Overlay;
import net.imagej.ui.swing.overlay.FigureCreatedEvent;
import net.imagej.ui.swing.overlay.JHotDrawAdapter;
import org.jhotdraw.draw.Figure;
import org.scijava.event.EventService;
import org.scijava.event.SciJavaEvent;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.plugin.PluginService;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;
import org.scijava.tool.Tool;

@Plugin(type=Service.class)
public class JHotDrawService
extends AbstractService
implements ImageJService {
    @Parameter
    private PluginService pluginService;
    @Parameter
    private EventService eventService;
    @Parameter
    private ImageDisplayService imageDisplayService;
    @Parameter
    private LogService log;
    private List<JHotDrawAdapter<?>> adapters;

    public JHotDrawAdapter<?> getAdapter(Tool tool) {
        for (JHotDrawAdapter<?> adapter : this.adapters()) {
            if (!adapter.supports(tool)) continue;
            return adapter;
        }
        return null;
    }

    public JHotDrawAdapter<?> getAdapter(Overlay overlay) {
        return this.getAdapter(overlay, null);
    }

    public JHotDrawAdapter<?> getAdapter(Overlay overlay, Figure figure) {
        for (JHotDrawAdapter<?> adapter : this.adapters()) {
            if (!adapter.supports(overlay, figure)) continue;
            return adapter;
        }
        return null;
    }

    public ArrayList<JHotDrawAdapter<?>> getAdapters(Overlay overlay) {
        return this.getAdapters(overlay, null);
    }

    public ArrayList<JHotDrawAdapter<?>> getAdapters(Overlay overlay, Figure figure) {
        ArrayList result = new ArrayList();
        for (JHotDrawAdapter<?> adapter : this.adapters()) {
            if (!adapter.supports(overlay, figure)) continue;
            result.add(adapter);
        }
        return result;
    }

    public Collection<JHotDrawAdapter<?>> getAllAdapters() {
        return Collections.unmodifiableCollection(this.adapters());
    }

    public <F extends Figure> void linkOverlay(F figure, JHotDrawAdapter<F> adapter, ImageDisplay display) {
        Overlay overlay = adapter.createNewOverlay();
        DataView view = this.imageDisplayService.createDataView((Data)overlay);
        if (!(view instanceof OverlayView)) {
            throw new IllegalStateException("Unexpected data view: " + view);
        }
        OverlayView overlayView = (OverlayView)view;
        adapter.updateOverlay(figure, overlayView);
        this.eventService.publish((SciJavaEvent)new FigureCreatedEvent(overlayView, figure, display));
    }

    private List<JHotDrawAdapter<?>> adapters() {
        if (this.adapters == null) {
            List instances;
            this.adapters = instances = this.pluginService.createInstancesOfType(JHotDrawAdapter.class);
            this.log.info((Object)("Found " + this.adapters.size() + " JHotDraw adapters."));
        }
        return this.adapters;
    }
}

